/**************************
 A program used to send commands to running GnomeICU
 (c) 1999 Jeremy Wise
 (c) 2001 drJeckyll@hotmail.com
 GnomeICU
***************************/

#include <config.h>

#include <bonobo/bonobo-i18n.h>
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <netinet/in.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/un.h>
#include <unistd.h>
#include "userserver.h"

int socket_fd;

int connectme( char *uinstr );
void usage( void );

int main(int ac,char **av)
{
	char c = USERSERVER_CMD_DO;
	unsigned long u;
	char *buffer;
	int i;
	char *uinstr = NULL;
	int readv = 0;

	setlocale(LC_ALL, "");
	
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

	if( ac <= 1 || !strcmp( av[1], "-h" ) || !strcmp( av[1], "--help" ) )
		usage();

	buffer = malloc( 8192 );

	for(i=1;i<ac;i++) {
		if(!strcmp(av[i],"-u"))
		{
			i++;
			if(i == ac)
				usage();
			uinstr = av[i++];
			if(i == ac)
				break;
		}
		if(!strcmp(av[i], "readmsg")) {
			readv = i;
			c = USERSERVER_CMD_READMSG;
		}
		else if (!strcmp (av[i], "msgcount")) {
			readv = i;
			c = USERSERVER_CMD_MSGCOUNT;
		}
		else if (!strcmp (av[i], "getstatus") || !strcmp (av[i], "getcoords")) {
			readv = i;
			c = USERSERVER_CMD_GETSTATUS;
		}
		else if (!strcmp (av[i], "icuask")) {
			readv = i;
			c = USERSERVER_ICUKRELL_ASK;
		}
		else if (!strcmp (av[i], "contactlist") || !strcmp (av[i], "onlinelist")) {
			readv = 1;
			c = USERSERVER_CMD_DO;
		}

		strcat(buffer,av[i]);
		strcat(buffer," ");
	}

	buffer[strlen(buffer)-1]=0;

	if ( uinstr != NULL && atol(uinstr)==0 )
	{
		printf("%s", _("UIN must be a number.\n"));
		return(1);
	}

	if (connectme(uinstr)) {
		printf("%s", 
		       _("Unable to connect to running GnomeICU client.\n"));
		return(1);
	}

	u=htonl(strlen(buffer)+1);

	write(socket_fd,&c,1);
	write(socket_fd,&u,sizeof(unsigned long));
	write(socket_fd,buffer,strlen(buffer)+1);

	free( buffer );

	if (readv && (
	!strcmp(av[readv], "readmsg") || 
	!strcmp(av[readv], "msgcount") || 
	!strcmp(av[readv], "getstatus") || 
	!strcmp(av[readv], "icuask") || 
	!strcmp(av[readv], "contactlist") ||
	!strcmp(av[readv], "onlinelist")))
	{
		read(socket_fd,&u,sizeof(unsigned long));
		u = ntohl( u );
		if( u < 16384 )
		{
			buffer = malloc( u + 1 );
			read(socket_fd,buffer,u);
			printf( "%s\n\n", buffer );
			free( buffer );
		}
	}

	close(socket_fd);
	return(0);
}

int connectme( char *uinstr )
{
	struct sockaddr_un addr;
	struct passwd *pw;

	pw = getpwuid(getuid());

	if (!pw) {
		fprintf(stderr, "%s", _("Unable to get current login name, naming service down?\n"));
		return(-1);
	}

	sprintf(addr.sun_path, "/tmp/.gnomeicu-%s/ctl%s%s",
	        pw->pw_name,
	        (uinstr == NULL) ? "" : "-",
	        (uinstr == NULL) ? "" : uinstr );

	addr.sun_family = AF_UNIX;

	if(access(addr.sun_path, R_OK) != 0)
		return 1;

	socket_fd = socket(AF_UNIX, SOCK_STREAM, 0);

	if(socket_fd >= 0) {

		if(connect(socket_fd, (struct sockaddr *)&addr,
			   sizeof(addr.sun_family) + strlen(addr.sun_path) + 1) == 0)
			return 0;
		else
			return 1;
	}
	else
		perror ("socket");
	return -1;
}

void usage (void)
{
	printf ("%s", _("Usage: gnomeicu-client [-u YourUIN] command [DestinationUIN] [Data]\n\n"));
	printf ("%s", _("Commands are as follows:\n"));
	printf ("%s\t\t%s\n", "contactlist", _("show all contact list entries"));
	printf ("%s\t\t%s\n", "onlinelist", _("show online contact list entries"));
	printf ("%s\t\t%s\n", "msgcount", _("show number of incoming messages"));
	printf ("%s\t\t\t%s\n", "icuask", _("what IcuKrell ask GnomeICU"));
	printf ("%s\t\t\t%s\n", "readmsg", _("read message"));
	printf ("%s\t\t%s\n", "getstatus", _("get GnomeICU status"));
	printf ("%s\t\t\t%s\n", "quit", _("close GnomeICU"));
	printf ("%s\t\t\t%s\n", "hide", _("hide GnomeICU main window"));
	printf ("%s\t\t\t%s\n", "show", _("show GnomeICU main window"));
	printf ("%s\t\t%s\n", "showhide", _("show|hide GnomeICU main window"));
	printf ("%s\t\t%s\n", "addcontact", _("popup GnomeICU useradd dialog"));
	printf ("%s\t\t%s\n", "showprefs", _("popup GnomeICU preferences dialog"));
	printf ("%s\t\t%s\n", "changeinfo", _("popup GnomeICU user info dialog"));
	printf ("%s\t\t%s\n", "ignorelist", _("popup GnomeICU ignore list"));
	printf ("%s\t\t%s\n", "visiblelist",_("popup GnomeICU visible list"));
	printf ("%s\t\t%s\n", "invisiblelist", _("popup GnomeICU invisible list"));
	printf ("%s\t\t%s\n", "notifylist", _("popup GnomeICU notify list"));
	printf ("%s\t\t%s\n", "away \"msg\"", _("set away message"));
	printf ("%s\t%s\n", "adduser|useradd UIN", _("add user with UIN to the list"));
	// onlinelist
	printf ("%s\t\t%s\n", "msg UIN \"msg\"", _("send message to UIN"));
	printf ("%s\t\t%s\n", "status <status>",
		_("set status: online offline away na invisible freechat occupied dnd"));
	printf ("%s\t%s\n", "status_noask <status>",
		_("set status without asking the reason: online offline away na invisible freechat occupied dnd"));
	printf ("%s\t\t%s\n", "readevent", _("popup GnomeICU current event window"));
	exit (1);
}
