/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class RangeMenu
extends JComboBox
implements ActionListener {
    private final int[][] UNICODE_RANGES = new int[][]{{0, 127}, {128, 255}, {256, 383}, {384, 591}, {592, 687}, {688, 767}, {768, 879}, {880, 1023}, {1024, 1279}, {1328, 1423}, {1424, 1535}, {1536, 1791}, {1792, 1871}, {1920, 1983}, {2304, 2431}, {2432, 2559}, {2560, 2687}, {2688, 2815}, {2816, 2943}, {2944, 3071}, {3072, 3199}, {3200, 3327}, {3328, 3455}, {3456, 3583}, {3584, 3711}, {3712, 3839}, {3840, 4031}, {4096, 4255}, {4256, 4351}, {4352, 4607}, {4608, 4991}, {5024, 5119}, {5120, 5759}, {5760, 5791}, {5792, 5872}, {6016, 6143}, {6144, 6319}, {7680, 7935}, {7936, 8191}, {8192, 8303}, {8304, 8351}, {8352, 8399}, {8400, 8447}, {8448, 8527}, {8528, 8591}, {8592, 8703}, {8704, 8959}, {8960, 9215}, {9216, 9279}, {9280, 9311}, {9312, 9471}, {9472, 9599}, {9600, 9631}, {9632, 9727}, {9728, 9983}, {9984, 10175}, {10240, 10495}, {11904, 12255}, {12272, 12287}, {12288, 12351}, {12352, 12447}, {12448, 12543}, {12544, 12591}, {12592, 12687}, {12688, 12703}, {12704, 12735}, {12800, 13055}, {13056, 13311}, {13312, 19903}, {19968, 40879}, {40960, 42191}, {44032, 55215}, {57344, 63743}, {63744, 64255}, {64256, 64335}, {64336, 65023}, {65056, 65071}, {65072, 65103}, {65104, 65135}, {65136, 65279}, {65280, 65519}, {65520, 65535}};
    private final String[] UNICODE_RANGE_NAMES = new String[]{"Basic Latin", "Latin-1 Supplement", "Latin Extended-A", "Latin Extended-B", "IPA Extensions", "Spacing Modifier Letters", "Combining Diacritical Marks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "Hangul Jamo", "Ethiopic", "Cherokee", "Canadian Aboriginal Syllabics", "Ogham", "Runic", "Khmer", "Mongolian", "Latin Extended Additional", "Greek Extended", "General Punctuation", "Superscripts and Supscripts", "Currency Symbols", "Combining Marks for Symbols", "Letterlike Symbols", "Number Forms", "Arrows", "Mathematical Operators", "Miscellaneous Technical", "Control Pictures", "Optical Character Recognition", "Enclosed Alphanumerics", "Box Drawing", "Block Elements", "Geometric Shapes", "Miscellaneous Symbols", "Dingbats", "Braille", "CJK and KangXi Radicals", "Ideographic Description", "CJK Symbols and Punctuation", "Hiragana", "Katakana", "Bopomofo", "Hangul Compatibility Jamo", "Kanbun", "Bopomofo Extended", "Enclosed CJK Letters and Months", "CJK Compatibility", "CJK Unified Ideographs Extension A", "CJK Unified Ideographs", "Yi", "Hangul Syllables", "Private Use Area", "CJK Compatibility Ideographs", "Alphabetic Presentation Forms", "Arabic Presentation Forms-A", "CJK Compatibility Forms", "Small Form Variants", "Combining Half-Marks", "Arabic Presentation Forms-B", "Halfwidth and Fullwidth Forms", "Specials", "Other..."};
    private boolean useCustomRange = false;
    private int[] customRange = new int[]{0, 127};
    private final JDialog customRangeDialog;
    private final JTextField customRangeStart = new JTextField("0000", 4);
    private final JTextField customRangeEnd = new JTextField("007F", 4);
    private final int CUSTOM_RANGE_INDEX = this.UNICODE_RANGE_NAMES.length - 1;
    private final Font2DTest parent;

    public RangeMenu(Font2DTest font2DTest, JFrame jFrame) {
        this.parent = font2DTest;
        for (int i = 0; i < this.UNICODE_RANGE_NAMES.length; ++i) {
            this.addItem(this.UNICODE_RANGE_NAMES[i]);
        }
        this.setSelectedIndex(0);
        this.addActionListener(this);
        this.customRangeDialog = new JDialog(jFrame, "Custom Unicode Range", true);
        this.customRangeDialog.setResizable(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        JLabel jLabel = new JLabel("From");
        JLabel jLabel2 = new JLabel("To:");
        Font font = new Font("dialog", 1, 12);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        jButton.setFont(font);
        jPanel.add(jLabel);
        jPanel.add(this.customRangeStart);
        jPanel.add(jLabel2);
        jPanel.add(this.customRangeEnd);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.customRangeDialog.getContentPane().setLayout(new BorderLayout());
        this.customRangeDialog.getContentPane().add("North", jPanel);
        this.customRangeDialog.getContentPane().add("South", jPanel2);
        this.customRangeDialog.pack();
    }

    public int[] getSelectedRange() {
        if (this.useCustomRange) {
            int n;
            int n2;
            String string = "";
            try {
                String string2 = this.customRangeStart.getText().trim();
                String string3 = this.customRangeEnd.getText().trim();
                if (string2.equals(string) && !string3.equals(string)) {
                    n2 = Integer.parseInt(string3, 16);
                    n = n2 - 175;
                } else if (!string2.equals(string) && string3.equals(string)) {
                    n = Integer.parseInt(string2, 16);
                    n2 = n + 175;
                } else {
                    n = Integer.parseInt(this.customRangeStart.getText(), 16);
                    n2 = Integer.parseInt(this.customRangeEnd.getText(), 16);
                }
            }
            catch (Exception exception) {
                this.customRangeStart.setText(Integer.toString(this.customRange[0], 16));
                this.customRangeEnd.setText(Integer.toString(this.customRange[1], 16));
                return this.customRange;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 > 65535) {
                n2 = 65535;
            }
            if (n > n2) {
                n = n2;
            }
            this.customRange[0] = n;
            this.customRange[1] = n2;
            return this.customRange;
        }
        return this.UNICODE_RANGES[this.getSelectedIndex()];
    }

    public void setSelectedRange(String string, int n, int n2) {
        this.setSelectedItem(string);
        this.customRange[0] = n;
        this.customRange[1] = n2;
        this.parent.fireRangeChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            String string = (String)((JComboBox)object).getSelectedItem();
            if (string.equals("Other...")) {
                this.useCustomRange = true;
                this.customRangeDialog.show();
            } else {
                this.useCustomRange = false;
            }
            this.parent.fireRangeChanged();
        } else if (object instanceof JButton) {
            this.customRangeDialog.hide();
        }
    }
}

