/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskBlit;
import sun.java2d.pipe.CompositePipe;

public class AlphaPaintPipe
implements CompositePipe {
    static WeakReference cachedLastRaster;
    static WeakReference cachedLastColorModel;
    static WeakReference cachedLastData;
    private static final int TILE_SIZE = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSequence(Object object) {
        TileContext tileContext = (TileContext)object;
        if (tileContext.paintCtxt != null) {
            tileContext.paintCtxt.dispose();
        }
        Class clazz = AlphaPaintPipe.class;
        synchronized (clazz) {
            if (tileContext.lastData != null) {
                cachedLastRaster = tileContext.lastRaster;
                if (cachedLastColorModel == null || cachedLastColorModel.get() != tileContext.paintModel) {
                    cachedLastColorModel = new WeakReference(tileContext.paintModel);
                }
                cachedLastData = tileContext.lastData;
            }
        }
    }

    public void skipTile(Object object, int n2, int n3) {
    }

    public boolean needTile(Object object, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void renderPathTile(Object object, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        TileContext tileContext = (TileContext)object;
        PaintContext paintContext = tileContext.paintCtxt;
        SunGraphics2D sunGraphics2D = tileContext.sunG2D;
        SurfaceData surfaceData = tileContext.dstData;
        SurfaceData surfaceData2 = null;
        Raster raster = null;
        if (tileContext.lastData != null && tileContext.lastRaster != null) {
            surfaceData2 = (SurfaceData)tileContext.lastData.get();
            raster = (Raster)tileContext.lastRaster.get();
            if (surfaceData2 == null || raster == null) {
                surfaceData2 = null;
                raster = null;
            }
        }
        ColorModel colorModel = tileContext.paintModel;
        for (int i2 = 0; i2 < n7; i2 += 32) {
            int n8 = n5 + i2;
            int n9 = Math.min(n7 - i2, 32);
            for (int i3 = 0; i3 < n6; i3 += 32) {
                Object object2;
                int n10 = n4 + i3;
                int n11 = Math.min(n6 - i3, 32);
                Raster raster2 = paintContext.getRaster(n10, n8, n11, n9);
                if (raster2.getMinX() != 0 || raster2.getMinY() != 0) {
                    raster2 = raster2.createTranslatedChild(0, 0);
                }
                if (raster != raster2) {
                    raster = raster2;
                    tileContext.lastRaster = new WeakReference(raster);
                    object2 = new BufferedImage(colorModel, (WritableRaster)raster2, colorModel.isAlphaPremultiplied(), null);
                    surfaceData2 = BufImgSurfaceData.createData((BufferedImage)object2);
                    tileContext.lastData = new WeakReference(surfaceData2);
                    tileContext.lastMask = null;
                    tileContext.lastBlit = null;
                }
                if (byArray == null) {
                    if (tileContext.lastBlit == null) {
                        object2 = sunGraphics2D.imageComp;
                        if (CompositeType.SrcOverNoEa.equals(object2) && colorModel.getTransparency() == 1) {
                            object2 = CompositeType.SrcNoEa;
                        }
                        tileContext.lastBlit = Blit.getFromCache(surfaceData2.getSurfaceType(), (CompositeType)object2, surfaceData.getSurfaceType());
                    }
                    tileContext.lastBlit.Blit(surfaceData2, surfaceData, sunGraphics2D.composite, null, 0, 0, n10, n8, n11, n9);
                    continue;
                }
                if (tileContext.lastMask == null) {
                    object2 = sunGraphics2D.imageComp;
                    if (CompositeType.SrcOverNoEa.equals(object2) && colorModel.getTransparency() == 1) {
                        object2 = CompositeType.SrcNoEa;
                    }
                    tileContext.lastMask = MaskBlit.getFromCache(surfaceData2.getSurfaceType(), (CompositeType)object2, surfaceData.getSurfaceType());
                }
                int n12 = n2 + i2 * n3 + i3;
                tileContext.lastMask.MaskBlit(surfaceData2, surfaceData, sunGraphics2D.composite, null, 0, 0, n10, n8, n11, n9, byArray, n12, n3);
            }
        }
    }

    public Object startSequence(SunGraphics2D sunGraphics2D, Shape shape, Rectangle rectangle, int[] nArray) {
        PaintContext paintContext = sunGraphics2D.paint.createContext(sunGraphics2D.getDeviceColorModel(), rectangle, shape.getBounds2D(), sunGraphics2D.cloneTransform(), sunGraphics2D.getRenderingHints());
        return new TileContext(sunGraphics2D, paintContext);
    }

    static class TileContext {
        SunGraphics2D sunG2D;
        PaintContext paintCtxt;
        ColorModel paintModel;
        WeakReference lastRaster;
        WeakReference lastData;
        MaskBlit lastMask;
        Blit lastBlit;
        SurfaceData dstData;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileContext(SunGraphics2D sunGraphics2D, PaintContext paintContext) {
            this.sunG2D = sunGraphics2D;
            this.paintCtxt = paintContext;
            this.paintModel = paintContext.getColorModel();
            this.dstData = sunGraphics2D.getSurfaceData();
            Class clazz = class$sun$java2d$pipe$AlphaPaintPipe == null ? (class$sun$java2d$pipe$AlphaPaintPipe = AlphaPaintPipe.class$("sun.java2d.pipe.AlphaPaintPipe")) : class$sun$java2d$pipe$AlphaPaintPipe;
            synchronized (clazz) {
                if (cachedLastColorModel != null && cachedLastColorModel.get() == this.paintModel) {
                    this.lastRaster = cachedLastRaster;
                    this.lastData = cachedLastData;
                }
            }
        }
    }
}

