/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public class X11OffScreenImage
extends AcceleratedOffScreenImage
implements DisposerTarget {
    private long drawable;
    private Hashtable cachedHWSD = new Hashtable();
    private Hashtable bitmasks;
    private boolean transparent;
    private boolean bitmasksUpdateNeeded;
    private Object disposerReferent = new Object();

    static {
        accelerationEnabled = X11SurfaceData.isAccelerationEnabled();
    }

    protected void copyBackupToAccelerated() {
        super.copyBackupToAccelerated();
        if (this.transparent && this.surfaceDataHw != null && this.bitmasksUpdateNeeded) {
            this.updateBitmasks();
        }
        this.bitmasksUpdateNeeded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBitmasks() {
        Hashtable hashtable = this.bitmasks;
        synchronized (hashtable) {
            Enumeration enumeration = this.bitmasks.keys();
            while (enumeration.hasMoreElements()) {
                X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)enumeration.nextElement();
                int n2 = (Integer)this.bitmasks.get(x11GraphicsDevice);
                this.updateBitmask(this.surfaceDataSw, n2, x11GraphicsDevice.getScreen(), this.getWidth(), this.getHeight());
            }
        }
    }

    protected boolean isTransparent() {
        return this.transparent;
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        if (this.c != null) {
            return super.createGraphics();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    protected boolean isValidHWSD(GraphicsConfiguration graphicsConfiguration) {
        return this.surfaceDataHw != null && this.surfaceDataHw == this.cachedHWSD.get(graphicsConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        try {
            this.bitmasksUpdateNeeded = this.surfaceDataSw.needsBackup();
            this.surfaceDataHw = (SurfaceData)this.cachedHWSD.get(graphicsConfiguration);
            if (this.surfaceDataHw == null) {
                int n4 = 0;
                if (this.transparent) {
                    Integer n5 = (Integer)this.bitmasks.get(graphicsConfiguration.getDevice());
                    if (n5 == null) {
                        n4 = this.updateBitmask(this.surfaceDataSw, 0, ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen(), this.getWidth(), this.getHeight());
                        if (n4 != 0) {
                            Hashtable hashtable = this.bitmasks;
                            synchronized (hashtable) {
                                this.bitmasks.put(graphicsConfiguration.getDevice(), new Integer(n4));
                            }
                        }
                    } else {
                        n4 = n5;
                    }
                }
                this.surfaceDataHw = X11SurfaceData.X11PixmapSurfaceData.createData((X11GraphicsConfig)graphicsConfiguration, this.getWidth(), this.getHeight(), graphicsConfiguration.getColorModel(), this, this.drawable, n4);
                if (this.surfaceDataHw != null) {
                    this.cachedHWSD.put(graphicsConfiguration, this.surfaceDataHw);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.surfaceDataHw = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.surfaceDataHw = null;
        }
    }

    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    public void setDisposerRecord(DisposerRecord disposerRecord) {
    }

    protected boolean destSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof X11SurfaceData;
    }

    private native int updateBitmask(SurfaceData var1, int var2, int var3, int var4, int var5);

    protected boolean operationSupported(CompositeType compositeType, Color color, boolean bl2) {
        return !bl2 && (!this.transparent ? CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) : CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) && color != null);
    }

    public X11OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl2, long l2, boolean bl3) {
        super(component, colorModel, writableRaster, bl2);
        this.surfaceDataSw = this.surfaceData;
        this.drawable = l2;
        this.transparent = bl3;
        if (bl3) {
            this.bitmasks = new Hashtable();
        }
        this.bitmasksUpdateNeeded = bl3;
    }

    public X11OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl2, boolean bl3) {
        this(component, colorModel, writableRaster, bl2, 0L, bl3);
    }
}

