/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MChoicePeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MDragSourceContextPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MFileDialogPeer;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MMouseDragGestureRecognizer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MPopupMenuPeer;
import sun.awt.motif.MRobotPeer;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11CustomCursor;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11InputMethod;
import sun.awt.motif.X11InputMethodDescriptor;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;

public class MToolkit
extends SunToolkit
implements Runnable {
    private static final DebugHelper dbg = DebugHelper.create(MToolkit.class);
    X11Clipboard clipboard;
    X11Clipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettingsParser xSettingsParser;
    public static final X11GraphicsConfig config = GraphicsEnvironment.isHeadless() ? null : (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.motif.MDataTransferer";
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";

    public int getMaximumCursorColors() {
        return 2;
    }

    private native int getMulticlickTime();

    protected native int getScreenHeight();

    public native int getScreenResolution();

    protected native int getScreenWidth();

    public MToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("MToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n2 = stackTraceElementArray.length - 1;
            if (n2 >= 0) {
                string = stackTraceElementArray[n2].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            this.init(string);
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            Thread thread = new Thread(this, "AWT-Motif");
            thread.setPriority(6);
            thread.setDaemon(true);
            ThreadGroup threadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(threadGroup, new Runnable(){

                public void run() {
                    MToolkit.this.shutdown();
                }
            }, "Shutdown-Thread"));
            AWTAutoShutdown.notifyToolkitThreadBusy();
            thread.start();
        }
    }

    public native void beep();

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", new Integer(this.getMulticlickTime()));
        }
    }

    private native void loadXSettings();

    public native void run();

    private native void shutdown();

    public native void sync();

    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupportedNative();
    }

    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    public boolean getLockingKeyState(int n2) {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n2);
    }

    public native boolean getLockingKeyStateNative(int var1);

    public native boolean isFrameStateSupported(int var1);

    public void setDynamicLayout(boolean bl2) {
        dynamicLayoutSetting = bl2;
    }

    private void parseXSettings(byte[] byArray) {
        if (this.xSettingsParser == null) {
            this.xSettingsParser = new XSettingsParser();
        }
        this.xSettingsParser.parseXSettings(byArray);
    }

    public native void loadSystemColors(int[] var1);

    public Dimension getBestCursorSize(int n2, int n3) {
        return X11CustomCursor.getBestCursorSize(Math.max(1, n2), Math.max(1, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        MToolkit mToolkit = this;
        synchronized (mToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new X11Clipboard("System", "CLIPBOARD");
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        MToolkit mToolkit = this;
        synchronized (mToolkit) {
            if (this.selection == null) {
                this.selection = new X11Clipboard("Selection", "PRIMARY");
            }
        }
        return this.selection;
    }

    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new X11InputMethodDescriptor();
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    static native ColorModel makeColorModel();

    public native void init(String var1);

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public FontMetrics getFontMetrics(Font font) {
        return super.getFontMetrics(font);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return new Insets(0, 0, 0, 0);
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return MDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n2, n3, imageObserver);
    }

    static int checkScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (!(image instanceof X11Image)) {
            return 32;
        }
        X11Image x11Image = (X11Image)image;
        int n4 = n2 == 0 || n3 == 0 ? 32 : x11Image.getImageRep().check(imageObserver);
        return x11Image.check(imageObserver) | n4;
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n2, n3, imageObserver);
    }

    static boolean prepareScrImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (n2 == 0 || n3 == 0) {
            return true;
        }
        if (!(image instanceof X11Image)) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        MToolkit.targetCreatedPeer(button, mButtonPeer);
        return mButtonPeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        MToolkit.targetCreatedPeer(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        MToolkit.targetCreatedPeer(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        MToolkit.targetCreatedPeer(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = new MChoicePeer(choice);
        MToolkit.targetCreatedPeer(choice, mChoicePeer);
        return mChoicePeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        MToolkit.targetCreatedPeer(dialog, mDialogPeer);
        return mDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        MToolkit.targetCreatedPeer(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    public FontPeer getFontPeer(String string, int n2) {
        return new MFontPeer(string, n2);
    }

    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        MToolkit.targetCreatedPeer(frame, mFramePeer);
        return mFramePeer;
    }

    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        MToolkit.targetCreatedPeer(label, mLabelPeer);
        return mLabelPeer;
    }

    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        MToolkit.targetCreatedPeer(list, mListPeer);
        return mListPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        MToolkit.targetCreatedPeer(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        MToolkit.targetCreatedPeer(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        MToolkit.targetCreatedPeer(menu, mMenuPeer);
        return mMenuPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        MToolkit.targetCreatedPeer(panel, mPanelPeer);
        return mPanelPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        MToolkit.targetCreatedPeer(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        MToolkit.targetCreatedPeer(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        MToolkit.targetCreatedPeer(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        MToolkit.targetCreatedPeer(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        MToolkit.targetCreatedPeer(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        MToolkit.targetCreatedPeer(window, mWindowPeer);
        return mWindowPeer;
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl2 = this.isDynamicLayoutSupportedNative();
        return new Boolean(bl2);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.lazilyLoadDynamicLayoutSupportedProperty(string);
        }
        if (!this.loadedXSettings && string.startsWith("gnome.")) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                return this.desktopProperties.get(string);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return X11InputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    public MEmbeddedFramePeer createEmbeddedFrame(MEmbeddedFrame mEmbeddedFrame) {
        MEmbeddedFramePeer mEmbeddedFramePeer = new MEmbeddedFramePeer(mEmbeddedFrame);
        MToolkit.targetCreatedPeer(mEmbeddedFrame, mEmbeddedFramePeer);
        return mEmbeddedFramePeer;
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new MRobotPeer(graphicsDevice.getDefaultConfiguration());
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new X11CustomCursor(image, point, string);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return new MMouseDragGestureRecognizer(dragSource, component, n2, dragGestureListener);
        }
        return null;
    }

    private class XSettingsParser {
        private void parseXSettings(byte[] byArray) {
            int n2 = byArray.length;
            if (n2 > 12) {
                int[] nArray = new int[]{0};
                boolean bl2 = this.getXSettingsUnsignedByte(byArray, nArray, 1) == 0;
                nArray[0] = 8;
                int n3 = (int)this.getXSettingsUnsignedInt(byArray, nArray, 12, bl2);
                for (long i2 = 0L; i2 < (long)n3 && nArray[0] < n2; ++i2) {
                    this.parseXSetting(byArray, nArray, n2, bl2);
                }
            }
        }

        private int getXSettingsUnsignedByte(byte[] byArray, int[] nArray, int n2) throws IndexOutOfBoundsException {
            if (nArray[0] >= n2) {
                throw new IndexOutOfBoundsException("getXSettingsUnsignedByte at " + nArray[0] + " max " + n2);
            }
            int n3 = 0xFF & byArray[nArray[0]];
            nArray[0] = nArray[0] + 1;
            return n3;
        }

        private int getXSettingsUnsignedShort(byte[] byArray, int[] nArray, int n2, boolean bl2) throws IndexOutOfBoundsException {
            if (nArray[0] + 2 > n2) {
                throw new IndexOutOfBoundsException("getXSettingsUnsignedShort at " + nArray[0] + " max " + n2);
            }
            int n3 = bl2 ? 0xFF & byArray[nArray[0]] | (0xFF & byArray[nArray[0] + 1]) << 8 : (0xFF & byArray[nArray[0]]) << 8 | 0xFF & byArray[nArray[0] + 1];
            nArray[0] = nArray[0] + 2;
            return n3;
        }

        private long getXSettingsUnsignedInt(byte[] byArray, int[] nArray, int n2, boolean bl2) throws IndexOutOfBoundsException {
            int n3 = nArray[0];
            if (n3 + 4 > n2) {
                throw new IndexOutOfBoundsException("getXSettingsUnsignedInt at " + nArray[0] + " max " + n2);
            }
            long l2 = bl2 ? (long)(0xFF & byArray[n3++] | (0xFF & byArray[n3++]) << 8 | (0xFF & byArray[n3++]) << 16 | (0xFF & byArray[n3++]) << 24) : (long)((0xFF & byArray[n3++]) << 24 | (0xFF & byArray[n3++]) << 16 | (0xFF & byArray[n3++]) << 8 | 0xFF & byArray[n3++]);
            nArray[0] = nArray[0] + 4;
            return l2;
        }

        private void parseXSetting(byte[] byArray, int[] nArray, int n2, boolean bl2) throws IndexOutOfBoundsException {
            int n3 = this.getXSettingsUnsignedByte(byArray, nArray, n2);
            nArray[0] = nArray[0] + 1;
            String string = this.getXSettingsString(byArray, nArray, n2, bl2, false);
            long l2 = this.getXSettingsUnsignedInt(byArray, nArray, n2, bl2);
            Object object = null;
            if (n3 == 0) {
                long l3 = this.getXSettingsUnsignedInt(byArray, nArray, n2, bl2);
                object = new Integer((int)l3);
            } else if (n3 == 1) {
                object = this.getXSettingsString(byArray, nArray, n2, bl2, true);
            } else if (n3 == 2) {
                int n4 = this.getXSettingsUnsignedShort(byArray, nArray, n2, bl2);
                int n5 = this.getXSettingsUnsignedShort(byArray, nArray, n2, bl2);
                int n6 = this.getXSettingsUnsignedShort(byArray, nArray, n2, bl2);
                int n7 = this.getXSettingsUnsignedShort(byArray, nArray, n2, bl2);
                object = new Color((float)n4 / 65535.0f, (float)n5 / 65535.0f, (float)n6 / 65535.0f, (float)n7 / 65535.0f);
            } else {
                throw new IndexOutOfBoundsException("Unknown type: " + n3);
            }
            if (string != null) {
                string = "gnome." + string;
                MToolkit.this.setDesktopProperty(string, object);
            }
        }

        private String getXSettingsString(byte[] byArray, int[] nArray, int n2, boolean bl2, boolean bl3) throws IndexOutOfBoundsException {
            int n3 = bl3 ? (int)this.getXSettingsUnsignedInt(byArray, nArray, n2, bl2) : this.getXSettingsUnsignedShort(byArray, nArray, n2, bl2);
            if (nArray[0] + n3 > n2) {
                throw new IndexOutOfBoundsException("getXSettingsString " + nArray[0] + " " + n2);
            }
            String string = new String(byArray, 0, nArray[0], n3);
            nArray[0] = nArray[0] + n3;
            nArray[0] = (nArray[0] + 3) / 4 * 4;
            return string;
        }

        private XSettingsParser() {
        }
    }
}

