/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.List;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.peer.PanelPeer;
import sun.awt.SunGraphicsCallback;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MPanelPeer
extends MCanvasPeer
implements PanelPeer {
    MPanelPeer() {
    }

    protected boolean shouldFocusOnClick() {
        return ((Container)this.target).getComponentCount() == 0;
    }

    public void displayChanged(int n2) {
        Component[] componentArray = ((Container)this.target).getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            this.recursiveDisplayChanged(componentArray[i2], n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        Container container = (Container)this.target;
        Object object = this.target.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
                if (mComponentPeer == null) continue;
                Color color2 = component.getBackground();
                if (color2 == null || color2.equals(color)) {
                    mComponentPeer.setBackground(color);
                    mComponentPeer.pSetBackground(color);
                }
                if (!(component instanceof List) && !(component instanceof TextArea) && !(component instanceof ScrollPane)) continue;
                mComponentPeer.pSetScrollbarBackground(color);
            }
        }
        this.pSetBackground(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        Container container = (Container)this.target;
        Object object = this.target.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
                if (mComponentPeer == null) continue;
                Color color2 = component.getForeground();
                if (color2 == null || color2.equals(color)) {
                    mComponentPeer.setForeground(color);
                    mComponentPeer.pSetForeground(color);
                }
                if (!(component instanceof List) && !(component instanceof TextArea) && !(component instanceof ScrollPane)) continue;
                mComponentPeer.pSetInnerForeground(color);
            }
        }
        this.pSetForeground(color);
    }

    MPanelPeer(Component component) {
        super(component);
    }

    private void recursiveDisplayChanged(Component component, int n2) {
        Component[] componentArray;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                this.recursiveDisplayChanged(componentArray[i2], n2);
            }
        }
        if ((componentArray = component.getPeer()) != null && componentArray instanceof MCanvasPeer) {
            MCanvasPeer mCanvasPeer = (MCanvasPeer)componentArray;
            mCanvasPeer.displayChanged(n2);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        SunGraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets insets() {
        return this.getInsets();
    }

    MPanelPeer(Component component, Object object) {
        super(component, object);
    }
}

