/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;

class AccessibleHTML
implements Accessible {
    private JEditorPane editor;
    private Document model;
    private DocumentListener docListener;
    private PropertyChangeListener propChangeListener;
    private ElementInfo rootElementInfo;
    private RootHTMLAccessibleContext rootHTMLAccessibleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildInfo() {
        Object object = this.lock();
        try {
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            this.rootElementInfo = new ElementInfo(element);
            this.rootElementInfo.validate();
        }
        finally {
            this.unlock(object);
        }
    }

    private Rectangle getRootEditorRect() {
        Rectangle rectangle = this.getTextComponent().getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    private Object lock() {
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
            return document;
        }
        return null;
    }

    private void unlock(Object object) {
        if (object != null) {
            ((AbstractDocument)object).readUnlock();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.rootHTMLAccessibleContext == null) {
            this.rootHTMLAccessibleContext = new RootHTMLAccessibleContext(this.rootElementInfo);
        }
        return this.rootHTMLAccessibleContext;
    }

    private JEditorPane getTextComponent() {
        return this.editor;
    }

    public AccessibleHTML(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.propChangeListener = new PropertyChangeHandler();
        this.setDocument(this.editor.getDocument());
        this.docListener = new DocumentHandler();
    }

    private Document getDocument() {
        return this.model;
    }

    private void setDocument(Document document) {
        if (this.model != null) {
            this.model.removeDocumentListener(this.docListener);
        }
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propChangeListener);
        }
        this.model = document;
        if (this.model != null) {
            if (this.rootElementInfo != null) {
                this.rootElementInfo.invalidate(false);
            }
            this.buildInfo();
            this.model.addDocumentListener(this.docListener);
        } else {
            this.rootElementInfo = null;
        }
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propChangeListener);
        }
    }

    private View getRootView() {
        return this.getTextComponent().getUI().getRootView(this.getTextComponent());
    }

    private ElementInfo getRootInfo() {
        return this.rootElementInfo;
    }

    ElementInfo createElementInfo(Element element, ElementInfo elementInfo) {
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object == HTML.Tag.IMG) {
                return new IconElementInfo(element, elementInfo);
            }
            if (object == HTML.Tag.CONTENT || object == HTML.Tag.CAPTION) {
                return new TextElementInfo(element, elementInfo);
            }
            if (object == HTML.Tag.TABLE) {
                return new TableElementInfo(element, elementInfo);
            }
        }
        return null;
    }

    private class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AccessibleHTML.this.getRootInfo().update(documentEvent);
        }

        private DocumentHandler() {
        }
    }

    private class ElementInfo {
        private ArrayList children;
        private Element element;
        private ElementInfo parent;
        private boolean isValid;
        private boolean canBeValid;

        public int getChildCount() {
            this.validateIfNecessary();
            return this.children == null ? 0 : this.children.size();
        }

        public int getIndexInParent() {
            if (this.parent == null || !this.parent.isValid()) {
                return -1;
            }
            return this.parent.indexOf(this);
        }

        protected void validate() {
            this.isValid = true;
            this.loadChildren(this.getElement());
        }

        protected boolean isValid() {
            return this.isValid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean validateIfNecessary() {
            if (!this.isValid() && this.canBeValid) {
                this.children = null;
                Object object = AccessibleHTML.this.lock();
                try {
                    this.validate();
                }
                finally {
                    AccessibleHTML.this.unlock(object);
                }
            }
            return this.isValid();
        }

        private int getClosestInfoIndex(int n2) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ElementInfo elementInfo = this.getChild(i2);
                if (n2 >= elementInfo.getElement().getEndOffset() && n2 != elementInfo.getElement().getStartOffset()) continue;
                return i2;
            }
            return -1;
        }

        protected void invalidate(boolean bl2) {
            if (!this.isValid()) {
                if (this.canBeValid && !bl2) {
                    this.canBeValid = false;
                }
                return;
            }
            this.isValid = false;
            this.canBeValid = bl2;
            if (this.children != null) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    ((ElementInfo)this.children.get(i2)).invalidate(false);
                }
                this.children = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle getBounds() {
            if (!this.validateIfNecessary()) {
                return null;
            }
            Object object = AccessibleHTML.this.lock();
            try {
                Rectangle rectangle = AccessibleHTML.this.getRootEditorRect();
                View view = AccessibleHTML.this.getRootView();
                Element element = this.getElement();
                if (rectangle != null && view != null) {
                    try {
                        Rectangle rectangle2 = view.modelToView(element.getStartOffset(), Position.Bias.Forward, element.getEndOffset(), Position.Bias.Backward, rectangle).getBounds();
                        return rectangle2;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            finally {
                AccessibleHTML.this.unlock(object);
            }
            return null;
        }

        private void update(DocumentEvent documentEvent) {
            Object object;
            if (!this.isValid()) {
                return;
            }
            ElementInfo elementInfo = this.getParent();
            Element element = this.getElement();
            do {
                if ((object = documentEvent.getChange(element)) != null) {
                    if (element == this.getElement()) {
                        this.invalidate(true);
                    } else if (elementInfo != null) {
                        elementInfo.invalidate(elementInfo == AccessibleHTML.this.getRootInfo());
                    }
                    return;
                }
                element = element.getParentElement();
            } while (elementInfo != null && element != null && element != elementInfo.getElement());
            if (this.getChildCount() > 0) {
                int n2;
                ElementInfo elementInfo2;
                object = this.getElement();
                int n3 = documentEvent.getOffset();
                int n4 = this.getClosestInfoIndex(n3);
                if (n4 == -1 && documentEvent.getType() == DocumentEvent.EventType.REMOVE && n3 >= object.getEndOffset()) {
                    n4 = this.getChildCount() - 1;
                }
                ElementInfo elementInfo3 = elementInfo2 = n4 >= 0 ? this.getChild(n4) : null;
                if (elementInfo2 != null && elementInfo2.getElement().getStartOffset() == n3 && n3 > 0) {
                    n4 = Math.max(n4 - 1, 0);
                }
                if (documentEvent.getType() != DocumentEvent.EventType.REMOVE) {
                    n2 = this.getClosestInfoIndex(n3 + documentEvent.getLength());
                    if (n2 < 0) {
                        n2 = this.getChildCount() - 1;
                    }
                } else {
                    n2 = n4;
                    while (n2 + 1 < this.getChildCount() && this.getChild(n2 + 1).getElement().getEndOffset() == this.getChild(n2 + 1).getElement().getStartOffset()) {
                        ++n2;
                    }
                }
                for (int i2 = n4 = Math.max(n4, 0); i2 <= n2 && this.isValid(); ++i2) {
                    this.getChild(i2).update(documentEvent);
                }
            }
        }

        protected AttributeSet getAttributes() {
            if (this.validateIfNecessary()) {
                return this.getElement().getAttributes();
            }
            return null;
        }

        protected AttributeSet getViewAttributes() {
            if (this.validateIfNecessary()) {
                View view = this.getView();
                if (view != null) {
                    return view.getElement().getAttributes();
                }
                return this.getElement().getAttributes();
            }
            return null;
        }

        public Element getElement() {
            return this.element;
        }

        protected void loadChildren(Element element) {
            if (!element.isLeaf()) {
                int n2 = element.getElementCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Element element2 = element.getElement(i2);
                    ElementInfo elementInfo = AccessibleHTML.this.createElementInfo(element2, this);
                    if (elementInfo != null) {
                        this.addChild(elementInfo);
                        continue;
                    }
                    this.loadChildren(element2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected View getView() {
            if (!this.validateIfNecessary()) {
                return null;
            }
            Object object = AccessibleHTML.this.lock();
            try {
                View view = AccessibleHTML.this.getRootView();
                Element element = this.getElement();
                int n2 = element.getStartOffset();
                if (view != null) {
                    View view2 = this.getView(view, element, n2);
                    return view2;
                }
                View view3 = null;
                return view3;
            }
            finally {
                AccessibleHTML.this.unlock(object);
            }
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public ElementInfo getChild(int n2) {
            ArrayList arrayList;
            if (this.validateIfNecessary() && (arrayList = this.children) != null && n2 >= 0 && n2 < arrayList.size()) {
                return (ElementInfo)arrayList.get(n2);
            }
            return null;
        }

        public int indexOf(ElementInfo elementInfo) {
            ArrayList arrayList = this.children;
            if (arrayList != null) {
                return arrayList.indexOf(elementInfo);
            }
            return -1;
        }

        protected void addChild(ElementInfo elementInfo) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(elementInfo);
        }

        protected int getIntAttr(AttributeSet attributeSet, Object object, int n2) {
            if (attributeSet != null && attributeSet.isDefined(object)) {
                int n3;
                String string = (String)attributeSet.getAttribute(object);
                if (string == null) {
                    n3 = n2;
                } else {
                    try {
                        n3 = Math.max(0, Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = n2;
                    }
                }
                return n3;
            }
            return n2;
        }

        ElementInfo(Element element) {
            this(element, null);
        }

        private View getView(View view, Element element, int n2) {
            if (view.getElement() == element) {
                return view;
            }
            int n3 = view.getViewIndex(n2, Position.Bias.Forward);
            if (n3 != -1 && n3 < view.getViewCount()) {
                return this.getView(view.getView(n3), element, n2);
            }
            return null;
        }

        ElementInfo(Element element, ElementInfo elementInfo) {
            this.element = element;
            this.parent = elementInfo;
            this.isValid = false;
            this.canBeValid = true;
        }
    }

    protected abstract class HTMLAccessibleContext
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        protected ElementInfo elementInfo;

        public int getAccessibleChildrenCount() {
            return this.elementInfo.getChildCount();
        }

        public int getAccessibleIndexInParent() {
            return this.elementInfo.getIndexInParent();
        }

        public void requestFocus() {
            AccessibleHTML.this.getTextComponent().requestFocus();
        }

        public boolean isEnabled() {
            return AccessibleHTML.this.getTextComponent().isEnabled();
        }

        public boolean isFocusTraversable() {
            return AccessibleHTML.this.getTextComponent().isFocusTraversable();
        }

        public boolean isShowing() {
            return AccessibleHTML.this.getTextComponent().isShowing();
        }

        public boolean isVisible() {
            return AccessibleHTML.this.getTextComponent().isVisible();
        }

        public void setEnabled(boolean bl2) {
            AccessibleHTML.this.getTextComponent().setEnabled(bl2);
        }

        public void setVisible(boolean bl2) {
            AccessibleHTML.this.getTextComponent().setVisible(bl2);
        }

        public Color getBackground() {
            return AccessibleHTML.this.getTextComponent().getBackground();
        }

        public Color getForeground() {
            return AccessibleHTML.this.getTextComponent().getForeground();
        }

        public void setBackground(Color color) {
            AccessibleHTML.this.getTextComponent().setBackground(color);
        }

        public void setForeground(Color color) {
            AccessibleHTML.this.getTextComponent().setForeground(color);
        }

        public Cursor getCursor() {
            return AccessibleHTML.this.getTextComponent().getCursor();
        }

        public void setCursor(Cursor cursor) {
            AccessibleHTML.this.getTextComponent().setCursor(cursor);
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Dimension(rectangle.width, rectangle.height);
            }
            return null;
        }

        public void setSize(Dimension dimension) {
            AccessibleHTML.this.getTextComponent().setSize(dimension);
        }

        public Font getFont() {
            return AccessibleHTML.this.getTextComponent().getFont();
        }

        public void setFont(Font font) {
            AccessibleHTML.this.getTextComponent().setFont(font);
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Point(rectangle.x, rectangle.y);
            }
            return null;
        }

        public Point getLocationOnScreen() {
            Point point = AccessibleHTML.this.getTextComponent().getLocationOnScreen();
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return new Point(point.x + rectangle.x, point.y + rectangle.y);
            }
            return null;
        }

        public void setLocation(Point point) {
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return rectangle.contains(point.x, point.y);
            }
            return false;
        }

        public Rectangle getBounds() {
            return this.elementInfo.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            AccessibleHTML.this.getTextComponent().setBounds(rectangle);
        }

        public void addFocusListener(FocusListener focusListener) {
            AccessibleHTML.this.getTextComponent().addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            AccessibleHTML.this.getTextComponent().removeFocusListener(focusListener);
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return AccessibleHTML.this.editor.getLocale();
        }

        public Accessible getAccessibleChild(int n2) {
            ElementInfo elementInfo = this.elementInfo.getChild(n2);
            if (elementInfo != null && elementInfo instanceof Accessible) {
                return (Accessible)((Object)elementInfo);
            }
            return null;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            JEditorPane jEditorPane = AccessibleHTML.this.getTextComponent();
            if (jEditorPane != null && jEditorPane.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (jEditorPane != null && jEditorPane.isFocusTraversable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (jEditorPane != null && jEditorPane.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            if (jEditorPane != null && jEditorPane.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            return accessibleStateSet;
        }

        public FontMetrics getFontMetrics(Font font) {
            return AccessibleHTML.this.getTextComponent().getFontMetrics(font);
        }

        public Accessible getAccessibleAt(Point point) {
            ElementInfo elementInfo = this.getElementInfoAt(AccessibleHTML.this.rootElementInfo, point);
            if (elementInfo instanceof Accessible) {
                return (Accessible)((Object)elementInfo);
            }
            return null;
        }

        public HTMLAccessibleContext(ElementInfo elementInfo) {
            this.elementInfo = elementInfo;
        }

        private ElementInfo getElementInfoAt(ElementInfo elementInfo, Point point) {
            Object object;
            ElementInfo elementInfo2;
            if (elementInfo.getBounds() == null) {
                return null;
            }
            if (elementInfo.getChildCount() == 0 && elementInfo.getBounds().contains(point)) {
                return elementInfo;
            }
            if (elementInfo instanceof TableElementInfo && (elementInfo2 = ((TableElementInfo)elementInfo).getCaptionInfo()) != null && (object = elementInfo2.getBounds()) != null && ((Rectangle)object).contains(point)) {
                return elementInfo2;
            }
            for (int i2 = 0; i2 < elementInfo.getChildCount(); ++i2) {
                object = elementInfo.getChild(i2);
                ElementInfo elementInfo3 = this.getElementInfoAt((ElementInfo)object, point);
                if (elementInfo3 == null) continue;
                return elementInfo3;
            }
            return null;
        }
    }

    private class IconElementInfo
    extends ElementInfo
    implements Accessible {
        private int width;
        private int height;
        private AccessibleContext accessibleContext;

        protected void invalidate(boolean bl2) {
            super.invalidate(bl2);
            this.height = -1;
            this.width = -1;
        }

        private int getImageSize(Object object) {
            if (this.validateIfNecessary()) {
                int n2 = this.getIntAttr(this.getAttributes(), object, -1);
                if (n2 == -1) {
                    Image image;
                    View view = this.getView();
                    n2 = 0;
                    if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
                        n2 = object == HTML.Attribute.WIDTH ? image.getWidth(null) : image.getHeight(null);
                    }
                }
                return n2;
            }
            return 0;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new IconAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        IconElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
            this.width = -1;
            this.height = -1;
        }

        protected class IconAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleIcon {
            public int getAccessibleIconHeight() {
                if (IconElementInfo.this.height == -1) {
                    IconElementInfo.this.height = IconElementInfo.this.getImageSize(HTML.Attribute.HEIGHT);
                }
                return IconElementInfo.this.height;
            }

            public int getAccessibleIconWidth() {
                if (IconElementInfo.this.width == -1) {
                    IconElementInfo.this.width = IconElementInfo.this.getImageSize(HTML.Attribute.WIDTH);
                }
                return IconElementInfo.this.width;
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public String getAccessibleIconDescription() {
                return ((ImageView)IconElementInfo.this.getView()).getAltText();
            }

            public String getAccessibleName() {
                if (AccessibleHTML.this.model != null) {
                    return (String)AccessibleHTML.this.model.getProperty("title");
                }
                return null;
            }

            public void setAccessibleIconDescription(String string) {
            }

            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{this};
                return accessibleIconArray;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.ICON;
            }

            public IconAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                AccessibleHTML.this.setDocument(AccessibleHTML.this.editor.getDocument());
            }
        }

        private PropertyChangeHandler() {
        }
    }

    private class RootHTMLAccessibleContext
    extends HTMLAccessibleContext {
        public String getAccessibleDescription() {
            return AccessibleHTML.this.editor.getContentType();
        }

        public String getAccessibleName() {
            if (AccessibleHTML.this.model != null) {
                return (String)AccessibleHTML.this.model.getProperty("title");
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public RootHTMLAccessibleContext(ElementInfo elementInfo) {
            super(elementInfo);
        }
    }

    private class TableElementInfo
    extends ElementInfo
    implements Accessible {
        protected ElementInfo caption;
        private TableCellElementInfo[][] grid;
        private AccessibleContext accessibleContext;

        public int getColumnCount() {
            if (this.validateIfNecessary() && this.grid.length > 0) {
                return this.grid[0].length;
            }
            return 0;
        }

        public int getRowCount() {
            if (this.validateIfNecessary()) {
                return this.grid.length;
            }
            return 0;
        }

        private void updateGrid() {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < this.getChildCount(); ++n2) {
                TableRowElementInfo tableRowElementInfo = this.getRow(n2);
                int n6 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    n6 = Math.max(n6, this.getRow(n2 - i2 - 1).getColumnCount(i2 + 2));
                }
                n3 = Math.max(tableRowElementInfo.getRowCount(), n3);
                --n3;
                n4 = Math.max(n4, tableRowElementInfo.getColumnCount() + n6);
            }
            n5 = this.getChildCount() + n3;
            this.grid = new TableCellElementInfo[n5][];
            for (n2 = 0; n2 < n5; ++n2) {
                this.grid[n2] = new TableCellElementInfo[n4];
            }
            for (n2 = 0; n2 < n5; ++n2) {
                this.getRow(n2).updateGrid(n2);
            }
        }

        protected void validate() {
            super.validate();
            this.updateGrid();
        }

        public int getColumnExtentAt(int n2, int n3) {
            TableCellElementInfo tableCellElementInfo = this.getCell(n2, n3);
            if (tableCellElementInfo != null) {
                int n4 = tableCellElementInfo.getColumnCount();
                int n5 = 1;
                while (n3 - n5 >= 0 && this.grid[n2][n3 - n5] == tableCellElementInfo) {
                    ++n5;
                }
                return n4 - n5 + 1;
            }
            return 0;
        }

        public int getRowExtentAt(int n2, int n3) {
            TableCellElementInfo tableCellElementInfo = this.getCell(n2, n3);
            if (tableCellElementInfo != null) {
                int n4 = tableCellElementInfo.getRowCount();
                int n5 = 1;
                while (n2 - n5 >= 0 && this.grid[n2 - n5][n3] == tableCellElementInfo) {
                    ++n5;
                }
                return n4 - n5 + 1;
            }
            return 0;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TableAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        protected void loadChildren(Element element) {
            for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
                Element element2 = element.getElement(i2);
                AttributeSet attributeSet = element2.getAttributes();
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TR) {
                    this.addChild(new TableRowElementInfo(element2, this, i2));
                    continue;
                }
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CAPTION) continue;
                this.caption = AccessibleHTML.this.createElementInfo(element2, this);
            }
        }

        public ElementInfo getCaptionInfo() {
            return this.caption;
        }

        public TableCellElementInfo getCell(int n2, int n3) {
            if (this.validateIfNecessary() && n2 < this.grid.length && n3 < this.grid[0].length) {
                return this.grid[n2][n3];
            }
            return null;
        }

        public TableRowElementInfo getRow(int n2) {
            return (TableRowElementInfo)this.getChild(n2);
        }

        TableElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
        }

        public class TableAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleTable {
            private AccessibleHeadersTable rowHeadersTable;

            public int getAccessibleChildrenCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount() * ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            public int getAccessibleColumnCount() {
                return ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            public int getAccessibleIndexInParent() {
                return this.elementInfo.getIndexInParent();
            }

            public int getAccessibleRowCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount();
            }

            public int[] getSelectedAccessibleColumns() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n2 = this.getAccessibleRowCount();
                    Vector vector = new Vector();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!this.isAccessibleColumnSelected(i2)) continue;
                        vector.addElement(new Integer(i2));
                    }
                    int[] nArray = new int[vector.size()];
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        nArray[i3] = (Integer)vector.elementAt(i3);
                    }
                    return nArray;
                }
                return new int[0];
            }

            public int[] getSelectedAccessibleRows() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n2 = this.getAccessibleRowCount();
                    Vector vector = new Vector();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!this.isAccessibleRowSelected(i2)) continue;
                        vector.addElement(new Integer(i2));
                    }
                    int[] nArray = new int[vector.size()];
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        nArray[i3] = (Integer)vector.elementAt(i3);
                    }
                    return nArray;
                }
                return new int[0];
            }

            public int getAccessibleColumn(int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n3 = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (n2 >= n3) {
                        return -1;
                    }
                    return n2 % this.getAccessibleColumnCount();
                }
                return -1;
            }

            public int getAccessibleRow(int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int n3 = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (n2 >= n3) {
                        return -1;
                    }
                    return n2 / this.getAccessibleColumnCount();
                }
                return -1;
            }

            public boolean isAccessibleColumnSelected(int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    int n3 = this.getAccessibleRowCount();
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(0, n2);
                    if (tableCellElementInfo == null) {
                        return false;
                    }
                    int n4 = tableCellElementInfo.getElement().getStartOffset();
                    TableCellElementInfo tableCellElementInfo2 = TableElementInfo.this.getCell(n3 - 1, n2);
                    if (tableCellElementInfo2 == null) {
                        return false;
                    }
                    int n5 = tableCellElementInfo2.getElement().getEndOffset();
                    return n4 >= AccessibleHTML.this.editor.getSelectionStart() && n5 <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            public boolean isAccessibleRowSelected(int n2) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n2 < 0 || n2 >= this.getAccessibleRowCount()) {
                        return false;
                    }
                    int n3 = this.getAccessibleColumnCount();
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n2, 0);
                    if (tableCellElementInfo == null) {
                        return false;
                    }
                    int n4 = tableCellElementInfo.getElement().getStartOffset();
                    TableCellElementInfo tableCellElementInfo2 = TableElementInfo.this.getCell(n2, n3 - 1);
                    if (tableCellElementInfo2 == null) {
                        return false;
                    }
                    int n5 = tableCellElementInfo2.getElement().getEndOffset();
                    return n4 >= AccessibleHTML.this.editor.getSelectionStart() && n5 <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            public int getAccessibleColumnExtentAt(int n2, int n3) {
                return ((TableElementInfo)this.elementInfo).getColumnExtentAt(n2, n3);
            }

            public int getAccessibleIndex(int n2, int n3) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n2 >= this.getAccessibleRowCount() || n3 >= this.getAccessibleColumnCount()) {
                        return -1;
                    }
                    return n2 * this.getAccessibleColumnCount() + n3;
                }
                return -1;
            }

            public int getAccessibleRowExtentAt(int n2, int n3) {
                return ((TableElementInfo)this.elementInfo).getRowExtentAt(n2, n3);
            }

            public boolean isAccessibleSelected(int n2, int n3) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (n2 < 0 || n2 >= this.getAccessibleRowCount() || n3 < 0 || n3 >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n2, n3);
                    if (tableCellElementInfo != null) {
                        Element element = tableCellElementInfo.getElement();
                        int n4 = element.getStartOffset();
                        int n5 = element.getEndOffset();
                        return n4 >= AccessibleHTML.this.editor.getSelectionStart() && n5 <= AccessibleHTML.this.editor.getSelectionEnd();
                    }
                }
                return false;
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public String getAccessibleName() {
                return this.getAccessibleRole().toString();
            }

            public String getAccessibleColumnHeader(int n2) {
                View view;
                TableCellElementInfo tableCellElementInfo;
                if (TableElementInfo.this.validateIfNecessary() && (tableCellElementInfo = TableElementInfo.this.getCell(0, n2)).isHeaderCell() && (view = tableCellElementInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(view.getStartOffset(), view.getEndOffset() - view.getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public String getAccessibleRowHeader(int n2) {
                View view;
                TableCellElementInfo tableCellElementInfo;
                if (TableElementInfo.this.validateIfNecessary() && (tableCellElementInfo = TableElementInfo.this.getCell(n2, 0)).isHeaderCell() && (view = tableCellElementInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(view.getStartOffset(), view.getEndOffset() - view.getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public Accessible getAccessibleCaption() {
                ElementInfo elementInfo = TableElementInfo.this.getCaptionInfo();
                if (elementInfo instanceof Accessible) {
                    return (Accessible)((Object)TableElementInfo.this.caption);
                }
                return null;
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public Accessible getAccessibleChild(int n2) {
                int n3 = ((TableElementInfo)this.elementInfo).getRowCount();
                int n4 = ((TableElementInfo)this.elementInfo).getColumnCount();
                int n5 = n2 / n3;
                int n6 = n2 % n4;
                if (n5 < 0 || n5 >= n3 || n6 < 0 || n6 >= n4) {
                    return null;
                }
                return this.getAccessibleAt(n5, n6);
            }

            public Accessible getAccessibleColumnDescription(int n2) {
                return null;
            }

            public Accessible getAccessibleRowDescription(int n2) {
                return null;
            }

            public Accessible getAccessibleAt(int n2, int n3) {
                TableCellElementInfo tableCellElementInfo = TableElementInfo.this.getCell(n2, n3);
                if (tableCellElementInfo != null) {
                    return tableCellElementInfo.getAccessible();
                }
                return null;
            }

            public void setAccessibleColumnDescription(int n2, Accessible accessible) {
            }

            public void setAccessibleRowDescription(int n2, Accessible accessible) {
            }

            public void setAccessibleCaption(Accessible accessible) {
            }

            public void setAccessibleSummary(Accessible accessible) {
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TABLE;
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public AccessibleTable getAccessibleRowHeader() {
                return this.rowHeadersTable;
            }

            public AccessibleTable getAccessibleTable() {
                return this;
            }

            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            public void addRowHeader(TableCellElementInfo tableCellElementInfo, int n2) {
                if (this.rowHeadersTable == null) {
                    this.rowHeadersTable = new AccessibleHeadersTable();
                }
                this.rowHeadersTable.addHeader(tableCellElementInfo, n2);
            }

            public TableAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            protected class AccessibleHeadersTable
            implements AccessibleTable {
                private Hashtable headers = new Hashtable();
                private int rowCount = 0;
                private int columnCount = 0;

                public int getAccessibleColumnCount() {
                    return this.columnCount;
                }

                public int getAccessibleRowCount() {
                    return this.rowCount;
                }

                public int[] getSelectedAccessibleColumns() {
                    return new int[0];
                }

                public int[] getSelectedAccessibleRows() {
                    return new int[0];
                }

                public boolean isAccessibleColumnSelected(int n2) {
                    return false;
                }

                public boolean isAccessibleRowSelected(int n2) {
                    return false;
                }

                public int getAccessibleColumnExtentAt(int n2, int n3) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n2, n3);
                    if (tableCellElementInfo != null) {
                        return tableCellElementInfo.getRowCount();
                    }
                    return 0;
                }

                public int getAccessibleRowExtentAt(int n2, int n3) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n2, n3);
                    if (tableCellElementInfo != null) {
                        return tableCellElementInfo.getRowCount();
                    }
                    return 0;
                }

                public boolean isAccessibleSelected(int n2, int n3) {
                    return false;
                }

                public Accessible getAccessibleCaption() {
                    return null;
                }

                public Accessible getAccessibleSummary() {
                    return null;
                }

                public Accessible getAccessibleColumnDescription(int n2) {
                    return null;
                }

                public Accessible getAccessibleRowDescription(int n2) {
                    return null;
                }

                public Accessible getAccessibleAt(int n2, int n3) {
                    TableCellElementInfo tableCellElementInfo = this.getElementInfoAt(n2, n3);
                    if (tableCellElementInfo instanceof Accessible) {
                        return (Accessible)((Object)tableCellElementInfo);
                    }
                    return null;
                }

                public void setAccessibleColumnDescription(int n2, Accessible accessible) {
                }

                public void setAccessibleRowDescription(int n2, Accessible accessible) {
                }

                public void setAccessibleCaption(Accessible accessible) {
                }

                public void setAccessibleSummary(Accessible accessible) {
                }

                public AccessibleTable getAccessibleColumnHeader() {
                    return null;
                }

                public AccessibleTable getAccessibleRowHeader() {
                    return null;
                }

                public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
                }

                public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
                }

                protected AccessibleHeadersTable() {
                }

                private TableCellElementInfo getElementInfoAt(int n2, int n3) {
                    ArrayList arrayList = (ArrayList)this.headers.get(new Integer(n2));
                    if (arrayList != null) {
                        return (TableCellElementInfo)arrayList.get(n3);
                    }
                    return null;
                }

                public void addHeader(TableCellElementInfo tableCellElementInfo, int n2) {
                    Integer n3 = new Integer(n2);
                    ArrayList arrayList = (ArrayList)this.headers.get(n3);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        this.headers.put(n3, arrayList);
                    }
                    arrayList.add(tableCellElementInfo);
                }
            }
        }

        private class TableCellElementInfo
        extends ElementInfo {
            private Accessible accessible;
            private boolean isHeaderCell;

            public int getColumnCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.COLSPAN, 1));
                }
                return 0;
            }

            public int getRowCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.ROWSPAN, 1));
                }
                return 0;
            }

            public boolean isHeaderCell() {
                return this.isHeaderCell;
            }

            protected void invalidate(boolean bl2) {
                super.invalidate(bl2);
                this.getParent().invalidate(true);
            }

            public Accessible getAccessible() {
                this.accessible = null;
                this.getAccessible(this);
                return this.accessible;
            }

            private void getAccessible(ElementInfo elementInfo) {
                if (elementInfo instanceof Accessible) {
                    this.accessible = (Accessible)((Object)elementInfo);
                    return;
                }
                for (int i2 = 0; i2 < elementInfo.getChildCount(); ++i2) {
                    this.getAccessible(elementInfo.getChild(i2));
                }
            }

            TableCellElementInfo(Element element, ElementInfo elementInfo) {
                super(element, elementInfo);
                this.isHeaderCell = false;
            }

            TableCellElementInfo(Element element, ElementInfo elementInfo, boolean bl2) {
                super(element, elementInfo);
                this.isHeaderCell = bl2;
            }
        }

        private class TableRowElementInfo
        extends ElementInfo {
            private TableElementInfo parent;
            private int rowNumber;

            public int getColumnCount() {
                int n2 = 0;
                if (this.validateIfNecessary()) {
                    for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(i2);
                        if (!tableCellElementInfo.validateIfNecessary()) continue;
                        n2 += tableCellElementInfo.getColumnCount();
                    }
                }
                return n2;
            }

            public int getRowCount() {
                int n2 = 1;
                if (this.validateIfNecessary()) {
                    for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(i2);
                        if (!tableCellElementInfo.validateIfNecessary()) continue;
                        n2 = Math.max(n2, tableCellElementInfo.getRowCount());
                    }
                }
                return n2;
            }

            private int getColumnCount(int n2) {
                if (this.validateIfNecessary()) {
                    int n3 = 0;
                    for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(i2);
                        if (tableCellElementInfo.getRowCount() < n2) continue;
                        n3 += tableCellElementInfo.getColumnCount();
                    }
                    return n3;
                }
                return 0;
            }

            private void updateGrid(int n2) {
                if (this.validateIfNecessary()) {
                    int n3;
                    boolean bl2 = false;
                    while (!bl2) {
                        for (n3 = 0; n3 < TableElementInfo.this.grid[n2].length; ++n3) {
                            if (TableElementInfo.this.grid[n2][n3] != null) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        ++n2;
                    }
                    n3 = 0;
                    for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                        TableCellElementInfo tableCellElementInfo = (TableCellElementInfo)this.getChild(i2);
                        while (TableElementInfo.this.grid[n2][n3] != null) {
                            ++n3;
                        }
                        for (int i3 = tableCellElementInfo.getRowCount() - 1; i3 >= 0; --i3) {
                            for (int i4 = tableCellElementInfo.getColumnCount() - 1; i4 >= 0; --i4) {
                                ((TableElementInfo)TableElementInfo.this).grid[n2 + i3][n3 + i4] = tableCellElementInfo;
                            }
                        }
                        n3 += tableCellElementInfo.getColumnCount();
                    }
                }
            }

            protected void invalidate(boolean bl2) {
                super.invalidate(bl2);
                this.getParent().invalidate(true);
            }

            protected void loadChildren(Element element) {
                for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
                    AttributeSet attributeSet = element.getElement(i2).getAttributes();
                    if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TH) {
                        TableCellElementInfo tableCellElementInfo = new TableCellElementInfo(element.getElement(i2), this, true);
                        this.addChild(tableCellElementInfo);
                        AccessibleTable accessibleTable = this.parent.getAccessibleContext().getAccessibleTable();
                        TableAccessibleContext tableAccessibleContext = (TableAccessibleContext)accessibleTable;
                        tableAccessibleContext.addRowHeader(tableCellElementInfo, this.rowNumber);
                        continue;
                    }
                    if (attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.TD) continue;
                    this.addChild(new TableCellElementInfo(element.getElement(i2), this, false));
                }
            }

            TableRowElementInfo(Element element, TableElementInfo tableElementInfo2, int n2) {
                super(element, tableElementInfo2);
                this.parent = tableElementInfo2;
                this.rowNumber = n2;
            }
        }
    }

    class TextElementInfo
    extends ElementInfo
    implements Accessible {
        private AccessibleContext accessibleContext;

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TextAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        TextElementInfo(Element element, ElementInfo elementInfo) {
            super(element, elementInfo);
        }

        public class TextAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleText {
            public int getCaretPosition() {
                View view = TextElementInfo.this.getView();
                if (view == null) {
                    return -1;
                }
                Container container = view.getContainer();
                if (container == null) {
                    return -1;
                }
                if (container instanceof JTextComponent) {
                    return ((JTextComponent)container).getCaretPosition();
                }
                return -1;
            }

            public int getCharCount() {
                if (TextElementInfo.this.validateIfNecessary()) {
                    Element element = this.elementInfo.getElement();
                    return element.getEndOffset() - element.getStartOffset();
                }
                return 0;
            }

            public int getSelectionEnd() {
                return AccessibleHTML.this.editor.getSelectionEnd();
            }

            public int getSelectionStart() {
                return AccessibleHTML.this.editor.getSelectionStart();
            }

            public int getIndexAtPoint(Point point) {
                View view = TextElementInfo.this.getView();
                if (view != null) {
                    return view.viewToModel(point.x, point.y, this.getBounds());
                }
                return -1;
            }

            public Rectangle getCharacterBounds(int n2) {
                try {
                    return AccessibleHTML.this.editor.getUI().modelToView(AccessibleHTML.this.editor, n2);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }

            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            public String getAccessibleName() {
                if (AccessibleHTML.this.model != null) {
                    return (String)AccessibleHTML.this.model.getProperty("title");
                }
                return null;
            }

            public String getSelectedText() {
                return AccessibleHTML.this.editor.getSelectedText();
            }

            public String getAfterIndex(int n2, int n3) {
                return this.getAtIndex(n2, n3, 1);
            }

            public String getAtIndex(int n2, int n3) {
                return this.getAtIndex(n2, n3, 0);
            }

            public String getBeforeIndex(int n2, int n3) {
                return this.getAtIndex(n2, n3, -1);
            }

            private String getText(int n2, int n3) throws BadLocationException {
                if (AccessibleHTML.this.model != null && AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)AccessibleHTML.this.model;
                    return AccessibleHTML.this.model.getText(n2, n3);
                }
                return null;
            }

            /*
             * Exception decompiling
             */
            private String getAtIndex(int var1_1, int var2_2, int var3_3) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TEXT;
            }

            public AccessibleText getAccessibleText() {
                return this;
            }

            public AttributeSet getCharacterAttribute(int n2) {
                StyledDocument styledDocument;
                Element element;
                if (AccessibleHTML.this.model instanceof StyledDocument && (element = (styledDocument = (StyledDocument)AccessibleHTML.this.model).getCharacterElement(n2)) != null) {
                    return element.getAttributes();
                }
                return null;
            }

            private Element getParagraphElement(int n2) {
                if (AccessibleHTML.this.model instanceof PlainDocument) {
                    PlainDocument plainDocument = (PlainDocument)AccessibleHTML.this.model;
                    return plainDocument.getParagraphElement(n2);
                }
                if (AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)AccessibleHTML.this.model;
                    return styledDocument.getParagraphElement(n2);
                }
                Element element = null;
                element = AccessibleHTML.this.model.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n3 = element.getElementIndex(n2);
                    element = element.getElement(n3);
                }
                if (element == null) {
                    return null;
                }
                return element.getParentElement();
            }

            private IndexedSegment getParagraphElementText(int n2) throws BadLocationException {
                Element element = this.getParagraphElement(n2);
                if (element != null) {
                    IndexedSegment indexedSegment = new IndexedSegment();
                    try {
                        int n3 = element.getEndOffset() - element.getStartOffset();
                        AccessibleHTML.this.model.getText(element.getStartOffset(), n3, indexedSegment);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                    indexedSegment.modelOffset = element.getStartOffset();
                    return indexedSegment;
                }
                return null;
            }

            private IndexedSegment getSegmentAt(int n2, int n3) throws BadLocationException {
                BreakIterator breakIterator;
                IndexedSegment indexedSegment = this.getParagraphElementText(n3);
                if (indexedSegment == null) {
                    return null;
                }
                switch (n2) {
                    case 2: {
                        breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        break;
                    }
                    case 3: {
                        breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                indexedSegment.first();
                breakIterator.setText(indexedSegment);
                int n4 = breakIterator.following(n3 - indexedSegment.modelOffset + indexedSegment.offset);
                if (n4 == -1) {
                    return null;
                }
                if (n4 > indexedSegment.offset + indexedSegment.count) {
                    return null;
                }
                int n5 = breakIterator.previous();
                if (n5 == -1 || n5 >= indexedSegment.offset + indexedSegment.count) {
                    return null;
                }
                indexedSegment.modelOffset = indexedSegment.modelOffset + n5 - indexedSegment.offset;
                indexedSegment.offset = n5;
                indexedSegment.count = n4 - n5;
                return indexedSegment;
            }

            public TextAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            private class IndexedSegment
            extends Segment {
                public int modelOffset;

                private IndexedSegment() {
                }
            }
        }
    }
}

