/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocksConsts;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.prefs.Preferences;
import sun.security.action.GetPropertyAction;

class SocksSocketImpl
extends PlainSocketImpl
implements SocksConsts {
    private String server = null;
    private int port = 1080;
    private InetSocketAddress external_address;
    private boolean useV4 = false;
    private Socket cmdsock = null;
    private InputStream cmdIn = null;
    private OutputStream cmdOut = null;

    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    protected void close() throws IOException {
        if (this.cmdsock != null) {
            this.cmdsock.close();
        }
        this.cmdsock = null;
        super.close();
    }

    void setV4() {
        this.useV4 = true;
    }

    private int readSocksReply(InputStream inputStream, byte[] byArray) throws IOException {
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        for (int i2 = 0; n4 < n3 && i2 < 3; n4 += n2, ++i2) {
            n2 = inputStream.read(byArray, n4, n3 - n4);
            if (n2 >= 0) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return n4;
    }

    SocksSocketImpl(String string, int n2) {
        this.server = string;
        this.port = n2 == -1 ? 1080 : n2;
    }

    private synchronized void privilegedConnect(final String string, final int n2, final int n3) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    SocksSocketImpl.this.superConnectServer(string, n2, n3);
                    SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.getInputStream();
                    SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.getOutputStream();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superConnectServer(String string, int n2, int n3) throws IOException {
        super.connect(new InetSocketAddress(string, n2), n3);
    }

    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    protected synchronized void bind(InetAddress inetAddress, int n2) throws IOException {
        if (this.socket != null) {
            super.bind(inetAddress, n2);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    SocksSocketImpl.this.cmdsock = new Socket(new PlainSocketImpl());
                    SocksSocketImpl.this.cmdsock.connect(new InetSocketAddress(SocksSocketImpl.this.server, SocksSocketImpl.this.port));
                    SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.cmdsock.getInputStream();
                    SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.cmdsock.getOutputStream();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new SocketException(exception.getMessage());
        }
        DataOutputStream dataOutputStream = new DataOutputStream(this.cmdOut);
        InputStream inputStream = this.cmdIn;
        if (this.useV4) {
            this.bindV4(inputStream, dataOutputStream, inetAddress, n2);
            return;
        }
        dataOutputStream.write(5);
        dataOutputStream.write(2);
        dataOutputStream.write(0);
        dataOutputStream.write(2);
        dataOutputStream.flush();
        byte[] byArray = new byte[2];
        int n3 = this.readSocksReply(inputStream, byArray);
        if (n3 != 2 || byArray[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(byArray[1], inputStream, dataOutputStream)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        super.bind(inetAddress, n2);
        dataOutputStream.write(5);
        dataOutputStream.write(2);
        dataOutputStream.write(0);
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2.isAnyLocalAddress()) {
            inetAddress2 = this.cmdsock.getLocalAddress();
        }
        byte[] byArray2 = inetAddress2.getAddress();
        if (inetAddress2.family == 1) {
            dataOutputStream.write(1);
            dataOutputStream.write(byArray2);
            dataOutputStream.write(super.getLocalPort() >> 8 & 0xFF);
            dataOutputStream.write(super.getLocalPort() >> 0 & 0xFF);
            dataOutputStream.flush();
        } else if (inetAddress2.family == 2) {
            dataOutputStream.write(4);
            dataOutputStream.write(byArray2);
            dataOutputStream.write(super.getLocalPort() >> 8 & 0xFF);
            dataOutputStream.write(super.getLocalPort() >> 0 & 0xFF);
            dataOutputStream.flush();
        } else {
            this.cmdsock.close();
            throw new SocketException("unsupported address type : " + inetAddress2);
        }
        byArray = new byte[4];
        n3 = this.readSocksReply(inputStream, byArray);
        SocketException socketException = null;
        switch (byArray[1]) {
            case 0: {
                Object var13_11 = null;
                switch (byArray[3]) {
                    case 1: {
                        byte[] byArray3 = new byte[4];
                        n3 = this.readSocksReply(inputStream, byArray3);
                        if (n3 != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n4 = (byArray[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet4Address("", byArray3), n4 += byArray[1] & 0xFF);
                        break;
                    }
                    case 3: {
                        byte by = byArray[1];
                        byte[] byArray4 = new byte[by];
                        n3 = this.readSocksReply(inputStream, byArray4);
                        if (n3 != by) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n5 = (byArray[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new String(byArray4), n5 += byArray[1] & 0xFF);
                        break;
                    }
                    case 4: {
                        byte by = byArray[1];
                        byte[] byArray5 = new byte[by];
                        n3 = this.readSocksReply(inputStream, byArray5);
                        if (n3 != by) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n6 = (byArray[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet6Address("", byArray5), n6 += byArray[1] & 0xFF);
                    }
                }
                break;
            }
            case 1: {
                socketException = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                socketException = new SocketException("SOCKS: Bind not allowed by ruleset");
                break;
            }
            case 3: {
                socketException = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                socketException = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                socketException = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                socketException = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                socketException = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                socketException = new SocketException("SOCKS: address type not supported");
            }
        }
        if (socketException != null) {
            inputStream.close();
            dataOutputStream.close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw socketException;
        }
        this.cmdIn = inputStream;
        this.cmdOut = dataOutputStream;
    }

    protected void connect(SocketAddress socketAddress, int n2) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            } else {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
        }
        try {
            this.privilegedConnect(this.server, this.port, n2);
        }
        catch (Exception exception) {
            throw new SocketException(exception.getMessage());
        }
        DataOutputStream dataOutputStream = new DataOutputStream(this.cmdOut);
        InputStream inputStream = this.cmdIn;
        if (this.useV4) {
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.toString());
            }
            this.connectV4(inputStream, dataOutputStream, inetSocketAddress);
            return;
        }
        dataOutputStream.write(5);
        dataOutputStream.write(2);
        dataOutputStream.write(0);
        dataOutputStream.write(2);
        dataOutputStream.flush();
        byte[] byArray = new byte[2];
        int n3 = this.readSocksReply(inputStream, byArray);
        if (n3 != 2 || byArray[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(byArray[1], inputStream, dataOutputStream)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        dataOutputStream.write(5);
        dataOutputStream.write(1);
        dataOutputStream.write(0);
        if (inetSocketAddress.isUnresolved()) {
            dataOutputStream.write(3);
            dataOutputStream.write(inetSocketAddress.getHostName().length());
            dataOutputStream.write(inetSocketAddress.getHostName().getBytes());
            dataOutputStream.write(inetSocketAddress.getPort() >> 8 & 0xFF);
            dataOutputStream.write(inetSocketAddress.getPort() >> 0 & 0xFF);
        } else if (inetSocketAddress.getAddress() instanceof Inet6Address) {
            dataOutputStream.write(4);
            dataOutputStream.write(inetSocketAddress.getAddress().getAddress());
            dataOutputStream.write(inetSocketAddress.getPort() >> 8 & 0xFF);
            dataOutputStream.write(inetSocketAddress.getPort() >> 0 & 0xFF);
        } else {
            dataOutputStream.write(1);
            dataOutputStream.write(inetSocketAddress.getAddress().getAddress());
            dataOutputStream.write(inetSocketAddress.getPort() >> 8 & 0xFF);
            dataOutputStream.write(inetSocketAddress.getPort() >> 0 & 0xFF);
        }
        dataOutputStream.flush();
        byArray = new byte[4];
        n3 = this.readSocksReply(inputStream, byArray);
        if (n3 != 4) {
            throw new SocketException("Reply from SOCKS server has bad length");
        }
        SocketException socketException = null;
        block1 : switch (byArray[1]) {
            case 0: {
                switch (byArray[3]) {
                    case 1: {
                        byte[] byArray2 = new byte[4];
                        n3 = this.readSocksReply(inputStream, byArray2);
                        if (n3 != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n4 = (byArray[0] & 0xFF) << 8;
                        n4 += byArray[1] & 0xFF;
                        break block1;
                    }
                    case 3: {
                        byte by = byArray[1];
                        byte[] byArray3 = new byte[by];
                        n3 = this.readSocksReply(inputStream, byArray3);
                        if (n3 != by) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n5 = (byArray[0] & 0xFF) << 8;
                        n5 += byArray[1] & 0xFF;
                        break block1;
                    }
                    case 4: {
                        byte by = byArray[1];
                        byte[] byArray4 = new byte[by];
                        n3 = this.readSocksReply(inputStream, byArray4);
                        if (n3 != by) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        byArray = new byte[2];
                        n3 = this.readSocksReply(inputStream, byArray);
                        if (n3 != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int n6 = (byArray[0] & 0xFF) << 8;
                        n6 += byArray[1] & 0xFF;
                        break block1;
                    }
                }
                socketException = new SocketException("Reply from SOCKS server contains wrong code");
                break;
            }
            case 1: {
                socketException = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                socketException = new SocketException("SOCKS: Connection not allowed by ruleset");
                break;
            }
            case 3: {
                socketException = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                socketException = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                socketException = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                socketException = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                socketException = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                socketException = new SocketException("SOCKS: address type not supported");
            }
        }
        if (socketException != null) {
            inputStream.close();
            dataOutputStream.close();
            throw socketException;
        }
        this.external_address = inetSocketAddress;
    }

    protected void accept(SocketImpl socketImpl) throws IOException {
        if (this.cmdsock == null) {
            throw new SocketException("Socks channel closed");
        }
        InputStream inputStream = this.cmdIn;
        inputStream.read();
        int n2 = inputStream.read();
        inputStream.read();
        SocketException socketException = null;
        InetSocketAddress inetSocketAddress = null;
        switch (n2) {
            case 0: {
                n2 = inputStream.read();
                switch (n2) {
                    case 1: {
                        byte[] byArray = new byte[4];
                        this.readSocksReply(inputStream, byArray);
                        int n3 = inputStream.read() << 8;
                        inetSocketAddress = new InetSocketAddress(new Inet4Address("", byArray), n3 += inputStream.read());
                        break;
                    }
                    case 3: {
                        int n4 = inputStream.read();
                        byte[] byArray = new byte[n4];
                        this.readSocksReply(inputStream, byArray);
                        int n5 = inputStream.read() << 8;
                        inetSocketAddress = new InetSocketAddress(new String(byArray), n5 += inputStream.read());
                        break;
                    }
                    case 4: {
                        byte[] byArray = new byte[16];
                        this.readSocksReply(inputStream, byArray);
                        int n6 = inputStream.read() << 8;
                        inetSocketAddress = new InetSocketAddress(new Inet6Address("", byArray), n6 += inputStream.read());
                    }
                }
                break;
            }
            case 1: {
                socketException = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                socketException = new SocketException("SOCKS: Accept not allowed by ruleset");
                break;
            }
            case 3: {
                socketException = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                socketException = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                socketException = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                socketException = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                socketException = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                socketException = new SocketException("SOCKS: address type not supported");
            }
        }
        if (socketException != null) {
            this.cmdIn.close();
            this.cmdOut.close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw socketException;
        }
        if (socketImpl instanceof SocksSocketImpl) {
            ((SocksSocketImpl)socketImpl).external_address = inetSocketAddress;
        }
        if (socketImpl instanceof PlainSocketImpl) {
            ((PlainSocketImpl)socketImpl).setInputStream((SocketInputStream)inputStream);
        }
        socketImpl.fd = this.cmdsock.getImpl().fd;
        socketImpl.address = this.cmdsock.getImpl().address;
        socketImpl.port = this.cmdsock.getImpl().port;
        socketImpl.localport = this.cmdsock.getImpl().localport;
        this.cmdsock = null;
    }

    private boolean authenticate(byte by, InputStream inputStream, DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = null;
        if (by == 0) {
            return true;
        }
        if (by == 2) {
            String string;
            String string2 = null;
            final InetAddress inetAddress = InetAddress.getByName(this.server);
            PasswordAuthentication passwordAuthentication = (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Authenticator.requestPasswordAuthentication(SocksSocketImpl.this.server, inetAddress, SocksSocketImpl.this.port, "SOCKS5", "SOCKS authentication", null);
                }
            });
            if (passwordAuthentication != null) {
                string = passwordAuthentication.getUserName();
                string2 = new String(passwordAuthentication.getPassword());
            } else {
                final Preferences preferences = Preferences.userRoot().node("/java/net/socks");
                try {
                    string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return preferences.get("username", null);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (string != null) {
                    try {
                        string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return preferences.get("password", null);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                } else {
                    string = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
                }
            }
            if (string == null) {
                return false;
            }
            dataOutputStream.write(1);
            dataOutputStream.write(string.length());
            dataOutputStream.write(string.getBytes());
            if (string2 != null) {
                dataOutputStream.write(string2.length());
                dataOutputStream.write(string2.getBytes());
            } else {
                dataOutputStream.write(0);
            }
            dataOutputStream.flush();
            byArray = new byte[2];
            int n2 = this.readSocksReply(inputStream, byArray);
            if (n2 != 2 || byArray[1] != 0) {
                dataOutputStream.close();
                inputStream.close();
                return false;
            }
            return true;
        }
        return false;
    }

    private void bindV4(InputStream inputStream, OutputStream outputStream, InetAddress inetAddress, int n2) throws IOException {
        super.bind(inetAddress, n2);
        byte[] byArray = inetAddress.getAddress();
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2.isAnyLocalAddress()) {
            inetAddress2 = this.cmdsock.getLocalAddress();
            byArray = inetAddress2.getAddress();
        }
        outputStream.write(4);
        outputStream.write(2);
        outputStream.write(super.getLocalPort() >> 8 & 0xFF);
        outputStream.write(super.getLocalPort() >> 0 & 0xFF);
        outputStream.write(byArray);
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
        outputStream.write(string.getBytes());
        outputStream.write(0);
        outputStream.flush();
        byte[] byArray2 = new byte[8];
        int n3 = this.readSocksReply(inputStream, byArray2);
        if (n3 != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n3);
        }
        if (byArray2[0] != 0 && byArray2[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException socketException = null;
        switch (byArray2[1]) {
            case 90: {
                this.external_address = new InetSocketAddress(inetAddress, n2);
                break;
            }
            case 91: {
                socketException = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                socketException = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                socketException = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                socketException = new SocketException("Replay from SOCKS server contains bad status");
            }
        }
        if (socketException != null) {
            inputStream.close();
            outputStream.close();
            throw socketException;
        }
    }

    private void connectV4(InputStream inputStream, OutputStream outputStream, InetSocketAddress inetSocketAddress) throws IOException {
        outputStream.write(4);
        outputStream.write(1);
        outputStream.write(inetSocketAddress.getPort() >> 8 & 0xFF);
        outputStream.write(inetSocketAddress.getPort() >> 0 & 0xFF);
        outputStream.write(inetSocketAddress.getAddress().getAddress());
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
        outputStream.write(string.getBytes());
        outputStream.write(0);
        outputStream.flush();
        byte[] byArray = new byte[8];
        int n2 = this.readSocksReply(inputStream, byArray);
        if (n2 != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n2);
        }
        if (byArray[0] != 0 && byArray[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException socketException = null;
        switch (byArray[1]) {
            case 90: {
                this.external_address = inetSocketAddress;
                break;
            }
            case 91: {
                socketException = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                socketException = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                socketException = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                socketException = new SocketException("Replay from SOCKS server contains bad status");
            }
        }
        if (socketException != null) {
            inputStream.close();
            outputStream.close();
            throw socketException;
        }
    }
}

