/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.SynthButtonUI;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthEventListener;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicHTML;

class SynthButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener,
SynthEventListener,
LazyActionMap.Loader {
    private static long lastPressedTimestamp = -1L;
    private static boolean shouldDiscardRelease = false;

    protected boolean defaultButtonFollowsFocus() {
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
        JButton jButton;
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (this.defaultButtonFollowsFocus() && abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null && (jButton = jRootPane.getDefaultButton()) != null) {
            jRootPane.putClientProperty("temporaryDefaultButton", abstractButton);
            jRootPane.setDefaultButton((JButton)abstractButton);
            jRootPane.putClientProperty("temporaryDefaultButton", null);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        JButton jButton;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        JRootPane jRootPane = abstractButton.getRootPane();
        if (jRootPane != null && (jButton = (JButton)jRootPane.getClientProperty("initialDefaultButton")) != null && abstractButton != jButton) {
            jRootPane.setDefaultButton(jButton);
        }
        abstractButton.getModel().setArmed(false);
        abstractButton.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            long l2 = abstractButton.getMultiClickThreshhold();
            long l3 = lastPressedTimestamp;
            long l4 = lastPressedTimestamp = mouseEvent.getWhen();
            if (l3 != -1L && l4 - l3 < l2) {
                shouldDiscardRelease = true;
                return;
            }
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!buttonModel.isArmed()) {
                buttonModel.setArmed(true);
            }
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                abstractButton.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (shouldDiscardRelease) {
            shouldDiscardRelease = false;
            return;
        }
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setPressed(false);
        buttonModel.setArmed(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ButtonUI buttonUI;
        String string = propertyChangeEvent.getPropertyName();
        AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
        if ("mnemonic".equals(string)) {
            this.updateMnemonicBinding(abstractButton);
        } else if ("contentAreaFilled".equals(string)) {
            this.checkOpacity(abstractButton);
        } else if ("text".equals(string) || "font".equals(string) || "foreground".equals(string)) {
            BasicHTML.updateRenderer(abstractButton, abstractButton.getText());
        }
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent) && (buttonUI = abstractButton.getUI()) != null && buttonUI instanceof SynthButtonUI) {
            ((SynthButtonUI)buttonUI).fetchStyle(abstractButton);
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
        abstractButton.setOpaque(abstractButton.isContentAreaFilled());
    }

    void updateMnemonicBinding(AbstractButton abstractButton) {
        int n2 = abstractButton.getMnemonic();
        if (n2 != 0) {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(abstractButton);
                SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n2, SynthLookAndFeel.getAcceleratorModifier(), false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(n2, SynthLookAndFeel.getAcceleratorModifier(), true), "released");
            inputMap.put(KeyStroke.getKeyStroke(n2, 0, true), "released");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    public void installKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.updateMnemonicBinding(abstractButton);
        LazyActionMap.installLazyActionMap(jComponent, this);
        InputMap inputMap = this.getInputMap(0, jComponent);
        SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        SwingUtilities.replaceUIInputMap(jComponent, 2, null);
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
        SwingUtilities.replaceUIActionMap(jComponent, null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("pressed", new PressedAction((AbstractButton)jComponent));
        actionMap.put("released", new ReleasedAction((AbstractButton)jComponent));
    }

    InputMap getInputMap(int n2, JComponent jComponent) {
        ButtonUI buttonUI;
        if (n2 == 0 && (buttonUI = ((AbstractButton)jComponent).getUI()) != null && buttonUI instanceof SynthButtonUI) {
            SynthButtonUI synthButtonUI = (SynthButtonUI)buttonUI;
            SynthContext synthContext = synthButtonUI.getContext(jComponent, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, synthButtonUI.getPropertyPrefix() + "focusInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    static class PressedAction
    extends AbstractAction {
        AbstractButton b = null;

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!this.b.hasFocus()) {
                this.b.requestFocus();
            }
        }

        PressedAction(AbstractButton abstractButton) {
            this.b = abstractButton;
        }
    }

    static class ReleasedAction
    extends AbstractAction {
        AbstractButton b = null;

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }

        ReleasedAction(AbstractButton abstractButton) {
            this.b = abstractButton;
        }
    }
}

