/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

public abstract class DeploymentConfig {
    private Properties configFileProps = this.loadConfigProperties();

    public DeploymentConfig() {
        new File(this.getUserHome()).mkdirs();
        new File(this.getSystemHome()).mkdirs();
        new File(this.getCacheDirectory()).mkdirs();
        new File(this.getTempDirectory()).mkdirs();
        new File(this.getLogDirectory()).mkdirs();
        new File(this.getSecurityDirectory()).mkdirs();
        new File(this.getExtensionDirectory()).mkdirs();
        new File(new File(this.getPropertiesFile()).getParent()).mkdirs();
    }

    private Properties loadConfigProperties() {
        InputStream inputStream;
        Object object;
        Properties properties = new Properties();
        try {
            object = new FileInputStream(this.getUserHome() + File.separator + "deployment.config");
            inputStream = new BufferedInputStream((InputStream)object);
            properties.load(inputStream);
            ((BufferedInputStream)inputStream).close();
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            String string;
            object = new Properties();
            inputStream = new FileInputStream(this.getPropertiesFile());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ((Properties)object).load(bufferedInputStream);
            bufferedInputStream.close();
            ((FileInputStream)inputStream).close();
            String string2 = ((Properties)object).getProperty("deployment.user.cachedir");
            if (string2 != null) {
                properties.setProperty("deployment.user.cachedir", string2);
            }
            if ((string = ((Properties)object).getProperty("deployment.user.logdir")) != null) {
                properties.setProperty("deployment.user.logdir", string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public String getJavaHome() {
        return AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    protected abstract String getInfrastructurePath();

    public String getUserHome() {
        return this.getUserProfilePath() + File.separator + this.getInfrastructurePath();
    }

    protected abstract String getUserProfilePath();

    public String getSystemHome() {
        return this.getSystemProfilePath() + File.separator + this.getInfrastructurePath();
    }

    protected abstract String getSystemProfilePath();

    public String getPropertiesFile() {
        return this.getUserHome() + File.separator + this.getPropertiesFilename();
    }

    protected String getPropertiesFilename() {
        return "deployment.properties";
    }

    public String getTempDirectory() {
        return this.getCacheDirectory() + File.separator + "tmp";
    }

    public String getCacheDirectory() {
        String string = this.configFileProps.getProperty("deployment.user.cachedir");
        if (string != null && string.startsWith("file:")) {
            try {
                return new File(URI.create(string)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getUserHome() + File.separator + "cache";
    }

    public String getLogDirectory() {
        String string = this.configFileProps.getProperty("deployment.user.logdir");
        if (string != null && string.startsWith("file:")) {
            try {
                return new File(URI.create(string)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getUserHome() + File.separator + "log";
    }

    public String getExtensionDirectory() {
        String string = this.configFileProps.getProperty("deployment.user.extdir");
        if (string != null && string.startsWith("file:")) {
            try {
                return new File(URI.create(string)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getUserHome() + File.separator + "ext";
    }

    public String getSecurityDirectory() {
        return this.getUserHome() + File.separator + "security";
    }

    public URL getUserSecurityPolicyURL() {
        String string = this.configFileProps.getProperty("deployment.user.security.policy");
        if (string != null) {
            try {
                return URI.create(string).toURL();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            return new File(this.getUserHome() + File.separator + "security" + File.separator + "java.policy").toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getSystemSecurityPolicyURL() {
        String string = this.configFileProps.getProperty("deployment.system.security.policy");
        if (string != null) {
            try {
                return URI.create(string).toURL();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            return new File(this.getSystemHome() + File.separator + "security" + File.separator + "java.policy").toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getRootCACertStore() {
        String string;
        String string2 = this.configFileProps.getProperty("deployment.system.cacerts");
        if (string2 != null && string2.startsWith("file:")) {
            try {
                return new File(URI.create(string2)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!new File(string = this.getSystemHome() + File.separator + "security" + File.separator + "cacerts").exists()) {
            string = this.getJavaHome() + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        return string;
    }

    public String getJsseCACertStore() {
        String string;
        String string2 = this.configFileProps.getProperty("deployment.system.jssecacerts");
        if (string2 != null && string2.startsWith("file:")) {
            try {
                return new File(URI.create(string2)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!(new File(string = this.getSystemHome() + File.separator + "security" + File.separator + "jssecacerts").exists() || new File(string = this.getSystemHome() + File.separator + "security" + File.separator + "cacerts").exists() || new File(string = this.getJavaHome() + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts").exists())) {
            string = this.getJavaHome() + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        return string;
    }

    public String getTrustedSigningCertStore() {
        String string = this.configFileProps.getProperty("deployment.user.certs");
        if (string != null && string.startsWith("file:")) {
            try {
                return new File(URI.create(string)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getUserHome() + File.separator + "security" + File.separator + "deployment.certs";
    }

    public String getTrustedJsseCertStore() {
        String string = this.configFileProps.getProperty("deployment.user.jssecerts");
        if (string != null && string.startsWith("file:")) {
            try {
                return new File(URI.create(string)).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getUserHome() + File.separator + "security" + File.separator + "deployment.jssecerts";
    }

    public Properties getConfigProperties() {
        Properties properties = new Properties();
        properties.setProperty("deployment.user.profile", this.getUserProfilePath());
        properties.setProperty("deployment.system.profile", this.getSystemProfilePath());
        properties.setProperty("deployment.user.home", this.getUserHome());
        properties.setProperty("deployment.system.home", this.getSystemHome());
        properties.setProperty("deployment.user.cachedir", this.getCacheDirectory());
        properties.setProperty("deployment.user.logdir", this.getLogDirectory());
        properties.setProperty("deployment.user.extdir", this.getExtensionDirectory());
        properties.setProperty("deployment.user.tmpdir", this.getTempDirectory());
        properties.setProperty("deployment.user.security.policy", this.getUserSecurityPolicyURL().toString());
        properties.setProperty("deployment.system.security.policy", this.getSystemSecurityPolicyURL().toString());
        properties.setProperty("deployment.user.certs", this.getTrustedSigningCertStore());
        properties.setProperty("deployment.user.jssecerts", this.getTrustedJsseCertStore());
        properties.setProperty("deployment.system.cacerts", this.getRootCACertStore());
        properties.setProperty("deployment.system.jssecacerts", this.getJsseCACertStore());
        return properties;
    }
}

