#ifndef _DOWNLOADER_H
#define _DOWNLOADER_H

#include <kurl.h>
#include <qobject.h>
#include <qptrlist.h>

class QFile;
class QTimer;
class Downloader;


namespace KIO
{
	class TransferJob;
	class Job;
}

class DownloadItem
{
	friend class Downloader;
public:
	DownloadItem();
	virtual ~DownloadItem();
	
	bool isDownloaded() const;

	QString localFilename() const;

	virtual void setLocalFilename(const QString &filename);

	virtual void downloadFinished();
	virtual void downloaded(int percent);
	virtual void downloadTimeout();
	/**
	 * returns true if the download was scheduled,
	 * or false if the file is local
	 **/
	bool enqueue(const KURL &url);
	void dequeue();

private:
	QString mLocalFilename;
};

/**
 * download playlistitems, in a queue based fasion
 **/
class Downloader : public QObject
{
Q_OBJECT
	struct QueueItem
	{
		DownloadItem *notifier;
		KURL file;
		QString local;
	};

public:
	Downloader(QObject *parent=0);
	virtual ~Downloader();


public slots:
	QString enqueue(DownloadItem *notifier, const KURL &file);
	void dequeue(DownloadItem *notifier);

	/**
	 * @internal
	 **/
	void start();

signals:
	void enqueued(DownloadItem *notifier, const KURL &file);
	void dequeued(DownloadItem *notifier);
	
private slots:
	void getNext();
	
	void data( KIO::Job *, const QByteArray &data);
	void percent( KIO::Job *, unsigned long percent);
	void jobDone( KIO::Job *);
	void giveUpWithThisDownloadServerIsRunningNT();
	
private:
	QPtrList<Downloader::QueueItem> mQueue;
	QPtrList<Downloader::QueueItem> *mUnstartedQueue;
	QFile *localfile;
	Downloader::QueueItem *current;	
	KIO::TransferJob *mJob;
	QTimer *mTimeout;
	bool mStarted;
};

#endif

