/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_menu.c - menu creation
 */

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#include "callbacks_menu.h"
#include "interface.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "log.h"

#if WANT_HAMLIB
#	include <hamlib/rig.h>
#endif

GtkWidget *printdialog;
GtkWidget *preferencesdialog;

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern GList *searchhistory;
extern GList *logwindowlist;

#if WANT_HAMLIB
	extern GList *riglist;
#endif

void on_menu_print_activate (GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *printallradiobutton, *printrangeradiobutton, *printlowentry,
		*printhighentry, *printrangelabel, *sizecomboentry, *pointcomboentry,
		*conteststyleradiobutton, *normalstyleradiobutton,
		*filedestinationradiobutton, *printerdestinationradiobutton;
	gchar *temp;
	logtype *logwindow;

	printdialog = create_printdialog();
	printallradiobutton = lookup_widget(printdialog, "printallradiobutton");
	printrangeradiobutton = lookup_widget(printdialog, "printrangeradiobutton");
	printlowentry = lookup_widget(printdialog, "printlowentry");
	printhighentry = lookup_widget(printdialog, "printhighentry");
	printrangelabel = lookup_widget(printdialog, "printrangelabel");
	sizecomboentry = lookup_widget(printdialog, "sizecomboentry");
	pointcomboentry = lookup_widget(printdialog, "pointcomboentry");
	filedestinationradiobutton = lookup_widget(printdialog, "filedestinationradiobutton");
	printerdestinationradiobutton = lookup_widget(printdialog, "printerdestinationradiobutton");
	normalstyleradiobutton = lookup_widget(printdialog, "normalstyleradiobutton");
	conteststyleradiobutton = lookup_widget(printdialog, "conteststyleradiobutton");

	if (preferences.printall == 0){
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printallradiobutton), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printrangeradiobutton), FALSE);
		gtk_widget_set_sensitive(printlowentry, 0);
		gtk_widget_set_sensitive(printhighentry, 0);
		gtk_widget_set_sensitive(printrangelabel, 0);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printallradiobutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printrangeradiobutton), TRUE);
		gtk_widget_set_sensitive(printlowentry, 1);
		gtk_widget_set_sensitive(printhighentry, 1);
		gtk_widget_set_sensitive(printrangelabel, 1);
	}

	if (preferences.printstyle == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(normalstyleradiobutton), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(conteststyleradiobutton), FALSE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(normalstyleradiobutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(conteststyleradiobutton), TRUE);
	}

	if (preferences.printdestination == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printerdestinationradiobutton), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(filedestinationradiobutton), FALSE);
	}
	else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printerdestinationradiobutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(filedestinationradiobutton), TRUE);
	}

	logwindow = g_list_nth_data(logwindowlist,
		gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));

	temp = g_strdup_printf("1");
	gtk_entry_set_text(GTK_ENTRY(printlowentry), temp);
	temp = g_strdup_printf("%d", logwindow->qsos);
	gtk_entry_set_text(GTK_ENTRY(printhighentry), temp);
	g_free(temp);

	if (preferences.printsize == 0)
		gtk_entry_set_text(GTK_ENTRY(sizecomboentry), "a4");
	else
		gtk_entry_set_text(GTK_ENTRY(sizecomboentry), "letter");

	if (preferences.printpoint == 0)
		gtk_entry_set_text(GTK_ENTRY(pointcomboentry), "10");
	else if (preferences.printpoint == 1)
		gtk_entry_set_text(GTK_ENTRY(pointcomboentry), "11");
	else if (preferences.printpoint == 2)
		gtk_entry_set_text(GTK_ENTRY(pointcomboentry), "12");

	gtk_widget_set_sensitive(mainwindow, 0);
	gtk_widget_show(printdialog);
}

void on_menu_exit_activate (GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *savedialog;
	gint i;
	logtype *logwindow;
	gboolean logchanged = FALSE;

	for (i = 0; i < g_list_length(logwindowlist); i++)
	{
		logwindow = g_list_nth_data(logwindowlist, i);
		if (logwindow->logchanged) logchanged = TRUE;
	}

	if (logchanged) {
		savedialog = create_savedialog();
		gtk_widget_set_sensitive(mainwindow, 0);
		gtk_widget_show(savedialog);
	}
	else {
		save_windowsize_and_cleanup();
		gtk_exit(0);
	}
}

void on_menu_save_activate (GtkMenuItem *menuitem, gpointer user_data) {
	gchar *temp;
	logtype *logwindow;
	gchar *xlogfile;

	logwindow =  g_list_nth_data(logwindowlist, 
		gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));
	xlogfile = g_strconcat(preferences.savedir, G_DIR_SEPARATOR_S, logwindow->logname, ".xlog", NULL);
	savelog(logwindow->clist, xlogfile);
	temp = g_strdup_printf(_("Log saved to %s"), xlogfile);
	update_statusbar(temp);
	g_free(temp);
	g_free(xlogfile);
	logwindow->logchanged = FALSE;
	gtk_label_set_text(GTK_LABEL(logwindow->label), logwindow->logname);
}


void on_menu_preferences_activate (GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *latentry, *longentry, *NScomboentry,
		*EWcomboentry, *unitscomboentry, *modesentry, *bandsentry,
		*modesradiobutton1, *modesradiobutton2, *bandsradiobutton1, *bandsradiobutton2,
		*modeslabel, *bandslabel, *clockcheckbutton, *exampleframe, *examplelabel,
		*autosavecomboentry, *notebook, *themecheckbutton, *pathentry, *logsentry;
	gchar *temp;
#if WANT_HAMLIB
	GtkWidget *hamlibcheckbutton, *radiocombo, *hamlibframe, *radiocomboentry,
		*devicecomboentry, *frequencycheckbutton, *digitscomboentry, *smetercheckbutton;
	GList *combolist = NULL;
	gint i, numrigs;
	struct rig_caps *rcaps;
#endif

	preferencesdialog = create_preferencesdialog();

	/* path for the logs */
	pathentry =lookup_widget(preferencesdialog, "pathentry");
	temp = g_strconcat(preferences.savedir, G_DIR_SEPARATOR_S, NULL);
	gtk_entry_set_text(GTK_ENTRY(pathentry), temp);

	/* logs to load at startup */
	logsentry =lookup_widget(preferencesdialog, "logsentry");
	gtk_entry_set_text(GTK_ENTRY(logsentry), preferences.logstoload);

	/* autosave */
	temp = g_strdup_printf("%d", preferences.autosave);
	autosavecomboentry = lookup_widget(preferencesdialog, "autosavecomboentry");
	gtk_entry_set_text(GTK_ENTRY(autosavecomboentry), temp);

	/* theme */
	exampleframe = lookup_widget(preferencesdialog, "exampleframe");
	setframestyle(exampleframe, preferences.themecolor);
	examplelabel = lookup_widget(preferencesdialog, "examplelabel");
	setlabelstyle(examplelabel, preferences.themecolor);
	themecheckbutton =lookup_widget(preferencesdialog, "themecheckbutton");
	if (preferences.logcolor == 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(themecheckbutton), FALSE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(themecheckbutton), TRUE);

	/* clock */
	clockcheckbutton = lookup_widget(preferencesdialog, "clockcheckbutton");
	if (preferences.clock == 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(clockcheckbutton), FALSE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(clockcheckbutton), TRUE);

#if WANT_HAMLIB
	hamlibcheckbutton = lookup_widget(preferencesdialog, "hamlibcheckbutton");
	hamlibframe = lookup_widget(preferencesdialog, "hamlibframe");
	frequencycheckbutton = lookup_widget(preferencesdialog, "frequencycheckbutton");
	smetercheckbutton = lookup_widget(preferencesdialog, "smetercheckbutton");
	if (preferences.hamlib == 0)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hamlibcheckbutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frequencycheckbutton), FALSE);
		gtk_widget_set_sensitive(hamlibframe, 0);
	}
	else
	{
		/* hide logging page if hamlib is enabled */
		notebook = lookup_widget(preferencesdialog, "preferencesnotebook");
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook), 1);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hamlibcheckbutton), TRUE);
		if (preferences.hamlib == 2)
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frequencycheckbutton), TRUE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(smetercheckbutton), FALSE);
		}
		else if (preferences.hamlib == 3)
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frequencycheckbutton), FALSE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(smetercheckbutton), TRUE);
		}
		else if (preferences.hamlib == 4)
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frequencycheckbutton), TRUE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(smetercheckbutton), TRUE);
		}
		gtk_widget_set_sensitive(hamlibframe, 1);
	}
	numrigs = g_list_length(riglist);
	if (numrigs > 0)
	{
		for (i = 0; i < numrigs; i++)
		{
			rcaps = (struct rig_caps *)g_list_nth_data(riglist, i);
			combolist = g_list_append(combolist, (gchar *)rcaps->model_name);
		}
	}
	else 
		combolist = g_list_append(combolist, "");

	radiocombo = lookup_widget(preferencesdialog, "radiocombo");
	gtk_combo_set_popdown_strings(GTK_COMBO(radiocombo), combolist);
	g_list_free(combolist);

	devicecomboentry = lookup_widget(preferencesdialog, "devicecomboentry");
	gtk_entry_set_text(GTK_ENTRY(devicecomboentry), preferences.device);
	radiocomboentry = lookup_widget(preferencesdialog, "radiocomboentry");
	gtk_entry_set_text(GTK_ENTRY(radiocomboentry), preferences.radio);
	temp = g_strdup_printf("%d", preferences.round);
	digitscomboentry = lookup_widget(preferencesdialog, "digitscomboentry");
	gtk_entry_set_text(GTK_ENTRY(digitscomboentry), temp);

#else /* hide hamlib page in notebook if no hamlib support */
	notebook = lookup_widget(preferencesdialog, "preferencesnotebook");
	gtk_notebook_remove_page(GTK_NOTEBOOK(notebook), 3);
#endif

	/* location */	
	temp = g_strdup_printf("%3.2f", preferences.latitude);
	latentry = lookup_widget(preferencesdialog, "latentry");
	gtk_entry_set_text(GTK_ENTRY(latentry), temp);
	NScomboentry = lookup_widget(preferencesdialog, "NScomboentry");
	if (preferences.NS == 1) gtk_entry_set_text(GTK_ENTRY(NScomboentry), "N");
	else gtk_entry_set_text(GTK_ENTRY(NScomboentry), "S");
	temp = g_strdup_printf("%3.2f", preferences.longitude);
	longentry = lookup_widget(preferencesdialog, "longentry");
	gtk_entry_set_text(GTK_ENTRY(longentry), temp);
	EWcomboentry = lookup_widget(preferencesdialog, "EWcomboentry");
	if (preferences.EW == 1) gtk_entry_set_text(GTK_ENTRY(EWcomboentry), "E");
	else gtk_entry_set_text(GTK_ENTRY(EWcomboentry), "W");
	unitscomboentry = lookup_widget(preferencesdialog, "unitscomboentry");
	if (preferences.units == 1) gtk_entry_set_text(GTK_ENTRY(unitscomboentry), _("Kilometers"));
	else gtk_entry_set_text(GTK_ENTRY(unitscomboentry), _("Miles"));
	g_free(temp);

	/* modes and bands */
	modesentry = lookup_widget(preferencesdialog, "modesentry");
	gtk_entry_set_text(GTK_ENTRY(modesentry), preferences.modes);
	bandsentry = lookup_widget(preferencesdialog, "bandsentry");
	gtk_entry_set_text(GTK_ENTRY(bandsentry), preferences.bands);
	/* set state of radio buttons and sensitivity of associated widgets */
	modesradiobutton1 = lookup_widget(preferencesdialog, "modesradiobutton1");
	modesradiobutton2 = lookup_widget(preferencesdialog, "modesradiobutton2");
	modeslabel = lookup_widget(preferencesdialog, "modeslabel");
	if (preferences.modeseditbox == 0){
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(modesradiobutton1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(modesradiobutton2), TRUE);
		gtk_widget_set_sensitive(modeslabel, 1);
		gtk_widget_set_sensitive(modesentry, 1);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(modesradiobutton1), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(modesradiobutton2), FALSE);
		gtk_widget_set_sensitive(modeslabel, 0);
		gtk_widget_set_sensitive(modesentry, 0);
	}
	bandsradiobutton1 = lookup_widget(preferencesdialog, "bandsradiobutton1");
	bandsradiobutton2 = lookup_widget(preferencesdialog, "bandsradiobutton2");
	bandslabel = lookup_widget(preferencesdialog, "bandslabel");
	if (preferences.bandseditbox == 0){
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bandsradiobutton1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bandsradiobutton2), TRUE);
		gtk_widget_set_sensitive(bandslabel, 1);
		gtk_widget_set_sensitive(bandsentry, 1);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bandsradiobutton1), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bandsradiobutton2), FALSE);
		gtk_widget_set_sensitive(bandslabel, 0);
		gtk_widget_set_sensitive(bandsentry, 0);
	}

	gtk_widget_set_sensitive(mainwindow, 0);
	gtk_widget_show(preferencesdialog);
}


void on_menu_about_activate (GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *aboutdialog, *aboutlabel;
	gchar *labeltext;

	if (betaversion == 0) labeltext = g_strdup_printf(_("%s version %s\n"), PACKAGE, VERSION);
	else labeltext = g_strdup_printf(_("%s version %s beta %d\n"), PACKAGE, VERSION, betaversion);
	labeltext = g_strconcat(labeltext, _("Logging Program for Shortwave Hams\n"),
		"Copyright 2001-2002 Joop Stakenborg\n<pa4tu@amsat.org>\n", 
		"http://people.debian.org/~pa3aba/xlog.html", NULL);

	aboutdialog = create_aboutdialog();
	aboutlabel = lookup_widget(aboutdialog, "aboutlabel");
	gtk_label_set_text(GTK_LABEL(aboutlabel), labeltext);
	setlabelstyle(aboutlabel, preferences.themecolor);
	g_free(labeltext);
	gtk_widget_show(aboutdialog);
}


void on_menu_search_activate(GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *searchdialog, *searchcombo;

	searchdialog = create_searchdialog();
	searchcombo = lookup_widget(searchdialog, "searchcombo");
	if (searchhistory)
		gtk_combo_set_popdown_strings(GTK_COMBO(searchcombo), searchhistory);
	gtk_widget_set_sensitive(mainwindow, 0);
	gtk_widget_show(searchdialog);
}

void on_menu_new_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *newlogdialog;

	newlogdialog = create_newlogdialog();
	gtk_widget_set_sensitive(mainwindow, 0);
	gtk_widget_show(newlogdialog);
}

void on_menu_close_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *closedialog;
	logtype *logwindow;
	gint page;

	page = gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{
		logwindow = g_list_nth_data(logwindowlist, page);
		if (logwindow->logchanged)
		{
			closedialog = create_closedialog();
			gtk_widget_set_sensitive(mainwindow, 0);
			gtk_widget_show(closedialog);
		}
		else 
		{
		logwindowlist = g_list_remove(logwindowlist, logwindow);
		g_free(logwindow->logname);
		g_free(logwindow);
		gtk_notebook_remove_page(GTK_NOTEBOOK(mainnotebook), page);
		state.logwindows--;
		}
	}
}

void on_menu_open_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *fileselection;
	gchar *selection;
	GString *logs;
	gchar **loglist = NULL;
	gchar *log[1];
	gint i;

	fileselection = create_fileselection();
	selection = g_strconcat(preferences.savedir, G_DIR_SEPARATOR_S, "*.xlog", NULL);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(fileselection), selection);

	log[0] = g_new0(gchar, 100);
	logs = getlogs(preferences.savedir);
	if ((logs->len) > 0)
		loglist = g_strsplit(logs->str, "\n", 0);

	/* fill in the file_list of the file selection dialog */
	gtk_clist_clear(GTK_CLIST(GTK_FILE_SELECTION(fileselection)->file_list));
	for (i = 0;; i++)
	{
		if (!loglist || (loglist[i] == NULL)) break;
		log[0] = g_strdup(loglist[i]);
		gtk_clist_append(GTK_CLIST(GTK_FILE_SELECTION(fileselection)->file_list), log);
	}

	if ((logs->len) > 0) 
	{
		g_string_free(logs, TRUE);
		g_strfreev(loglist);
	}
	g_free(selection);
	g_free(log[0]);
	gtk_widget_set_sensitive(mainwindow, 0);
	gtk_widget_show(fileselection);
}


void on_menu_dupecheck_activate(GtkMenuItem *menuitem, gpointer user_data)
{

}
