#ifndef __bugdetailsjob_h__
#define __bugdetailsjob_h__

#include "htmlbugjob.h"
#include "bug.h"
#include "bugdetails.h"
#include "bugdetailspart.h"

class BugDetailsJob : public HTMLBugJob
{
    Q_OBJECT
public:
    BugDetailsJob();
    virtual ~BugDetailsJob();

    void start( const Bug &bug );

signals:
    void bugDetailsAvailable( const Bug &bug, const BugDetails &details );

protected:
    virtual void process();
    virtual void processNode( const DOM::Node &n );

private:
    QString parseAttribute( QString &text, const QString &attr );

    Bug m_bug;
    BugDetails m_bugDetails;

    BugDetailsPart::List m_parts;
    
    QString mSender;
    QString mDate;
};

#endif

/*
 * vim:ts=4:sw=4:et
 */
