#ifndef MATRIX_H
#define MATRIX_H

#include <qmemarray.h>


class Coord
{
 public:
    enum DirCode { Left = 1, Right = 2, Down = 4, Up = 8 };
    struct Direction {
        int     di, dj;
        DirCode code;
    };
    static const Direction DIRECTIONS[4];

    Coord() {}
    Coord(uint _i, uint _j) : i(_i), j(_j) {}

    bool operator ==(const Coord &c) const { return ( c.i==i && c.j==j ); }
    Coord neighbour(uint k) const {
        Q_ASSERT( k<4 );
        return Coord(i + DIRECTIONS[k].di, j + DIRECTIONS[k].dj);
    }

    uint i, j;
};

template <class Type>
class Matrix
{
 public:
	Matrix(uint width, uint height)	: w(width), h(height), a(w*h) {}

	uint width() const { return w; }
	uint height() const { return h; }
	const Type &operator [](const Coord &c) const { return a[c.i + c.j*w]; }
	Type &operator [](const Coord &c)             { return a[c.i + c.j*w]; }
	Matrix<Type> &operator =(const Matrix<Type> &m) {
			w = m.w;
			h = m.h;
			a = m.a.copy(); // deep copy
			return *this;
	}
	void fill(const Type &t) { a.fill(t); }
    bool neighbour(const Coord &c, uint direction, Coord &neighbour) const {
        neighbour = c.neighbour(direction);
        switch ( Coord::DIRECTIONS[direction].code ) {
            case Coord::Left:  return c.i>0;
            case Coord::Right: return c.i<w-1;
            case Coord::Down:  return c.j>0;
            case Coord::Up:    return c.j<h-1;
        }
        Q_ASSERT(false);
        return false;
    }

 private:
	uint            w, h;
	QMemArray<Type> a;

	Matrix(const Matrix<Type> &); // disabled
};

#endif








