/***************************************************************************
                            kde_KShared.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSHARED
#define KDE_KSHARED

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Reference counting for shared objects.  If you derive your object
 from this class, then you may use it in conjunction with
 @ref KSharedPtr to control the lifetime of your object.

 Specifically, all classes that derive from KShared have an internal
 counter keeping track of how many other objects have a reference to
 their object.  If used with @ref KSharedPtr, then your object will
 not be deleted until all references to the object have been
 released.

 You should probably not ever use any of the methods in this class
 directly -- let the @ref KSharedPtr take care of that.  Just derive
 your class from KShared and forget about it.

 @author Waldo Bastian <bastian@kde.org>

 @version $Id: kde_KShared.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short 
 Reference counting for shared objects.
*/

/** 
 Standard constructor.  This will initialize the reference count
 on this object to 0
    
*/
kde_KShared * kde_new_KShared();

/** 
 Copy constructor.  This will @em not actually copy the objects
 but it will initialize the reference count on this object to 0
    
*/
kde_KShared * kde_new_KShared1(kde_KShared* arg1);

/** 
 Increases the reference count by one
    
*/
void kde_KShared__KShared_ref(kde_KShared* instPointer);

/** 
 Releases a reference (decreases the reference count by one).  If
 the count goes to 0, this object will delete itself
    
*/
void kde_KShared__KShared_unref(kde_KShared* instPointer);

/** 
 Return the current number of references held

*/
int kde_KShared__KShared_count(kde_KShared* instPointer);
void kde_del_KShared( kde_KShared* p );

#endif
