/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>

#include <kdebug.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kpanelapplet.h>

#include "global.h"
#include "panel.h"
// TODO: Martijn Klingens
// #include "buttonop_mnu.h"
#include "appletop_mnu.h"
#include "popupposition.h"

#include "panelbutton.h"
#include "bookmarksbutton.h"
#include "browserbutton.h"
#include "desktopbutton.h"
#include "extensionbutton.h"
#include "kbutton.h"
#include "konsolebutton.h"
#include "nonkdeappbutton.h"
#include "recentdocumentsbutton.h"
#include "servicebutton.h"
#include "servicemenubutton.h"
#include "urlbutton.h"
#include "windowlistbutton.h"

#include "container_button.h"
#include "container_button.moc"

ButtonContainer::ButtonContainer(QWidget* parent)
  : BaseContainer(parent)
  , _button(0)
  , _layout(0)
  , _oldpos(0,0)
{
}

void ButtonContainer::configure()
{
    if(_button) _button->configure();
}

void ButtonContainer::doSaveConfiguration( KConfigGroup& config, bool layoutOnly) const
{
    if(_button && !layoutOnly) _button->saveConfig( config );
}

void ButtonContainer::slotSetPopupDirection(Direction d)
{
    BaseContainer::slotSetPopupDirection(d);

    if(_button)
        _button->slotSetPopupDirection(d);
}

void ButtonContainer::slotSetOrientation(Orientation o)
{
    BaseContainer::slotSetOrientation(o);

    if(_button)
        _button->slotSetOrientation(o);
}

void ButtonContainer::embedButton(PanelButton* b)
{
    if (!b) return;

    delete _layout;
    _layout = new QVBoxLayout(this);
    _button = b;

    _button->installEventFilter(this);
    _layout->add(_button);
    connect(_button, SIGNAL(requestSave()), SIGNAL(requestSave()));
}

bool ButtonContainer::eventFilter (QObject *, QEvent *e)
{
    if (e->type() == QEvent::MouseButtonPress)
    {
        QMouseEvent* me = static_cast<QMouseEvent*>(e);
        switch (me->button())
        {
        case MidButton:
            if (_button) 
                _button->setDown(true);
            _moveOffset = me->pos();
            emit moveme(this);
            return true;
            
        case RightButton:
        {
            if (!_opMnu) 
            {
                // TODO: Martijn Klingens
                // _opMnu = new PanelButtonOpMenu(_actions, _button->title(), 
                //                                _button->icon());
                _opMnu = new PanelAppletOpMenu(_actions, _button->title(), 
                                           _button->icon());
            }
            QPopupMenu *menu = reduceMenu(_opMnu);

            _button->setZoomEnabled(false);
            qApp->syncX();
            qApp->processEvents();

            switch(menu->exec( popupPosition( popupDirection(), menu, this, me->pos() )))
            {
            case PanelAppletOpMenu::Move:
                _moveOffset = QPoint(width()/2, height()/2);
                emit moveme(this);
                break;
            case PanelAppletOpMenu::Remove:
                emit removeme(this);
                break;
            case PanelAppletOpMenu::Help:
                help();
                break;
            case PanelAppletOpMenu::About:
                about();
                break;
            case PanelAppletOpMenu::Preferences:
                if (_button) 
                    _button->properties();
                break;
            default:
                break;
            }

            _button->setZoomEnabled(true);
            return true;
        }
        
        default:
            break;
        }
    }
    return false;
}

void ButtonContainer::completeMoveOperation()
{
    if(_button)
        _button->setDown(false);
}

// KMenuButton containerpan
KMenuButtonContainer::KMenuButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
    KButton *b = new KButton(this);
    _actions = PanelAppletOpMenu::KMenuEditor;
    embedButton(b);
}

int KMenuButtonContainer::widthForHeight( int height ) const
{
    if ( height < 32 )
        return height + 10;
    else
        return height;
}

int KMenuButtonContainer::heightForWidth( int width ) const
{
    if ( width < 32 )
        return width + 10;
    else
        return width;
}

// DesktopButton container
DesktopButtonContainer::DesktopButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
    DesktopButton *b = new DesktopButton(this);
    embedButton(b);
}

// ServiceButton container
ServiceButtonContainer::ServiceButtonContainer( QWidget* parent, const QString& desktopFile )
  : ButtonContainer(parent)
{
    ServiceButton *b = new ServiceButton( desktopFile, this );
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

ServiceButtonContainer::ServiceButtonContainer( const KConfigGroup& config, QWidget* parent)
  : ButtonContainer(parent)
{
    ServiceButton *b = new ServiceButton( config, this );
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

// URLButton container
URLButtonContainer::URLButtonContainer( QWidget* parent, const QString& url )
  : ButtonContainer(parent)
{
    URLButton *b = new URLButton( url, this );
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

URLButtonContainer::URLButtonContainer( const KConfigGroup& config, QWidget* parent)
  : ButtonContainer(parent)
{
    URLButton *b = new URLButton( config, this );
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

// BrowserButton container
BrowserButtonContainer::BrowserButtonContainer(QWidget* parent, const QString &startDir, const QString& icon)
  : ButtonContainer(parent)
{
    BrowserButton *b = new BrowserButton(icon, startDir, this);
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

BrowserButtonContainer::BrowserButtonContainer( const KConfigGroup& config, QWidget* parent)
  : ButtonContainer(parent)
{
    BrowserButton *b = new BrowserButton(config, this);
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

// ServiceMenuButton container
ServiceMenuButtonContainer::ServiceMenuButtonContainer(QWidget* parent, const QString &label, const QString& relPath)
  : ButtonContainer(parent)
{
    ServiceMenuButton *b = new ServiceMenuButton(label, relPath, this);
    embedButton(b);
}

ServiceMenuButtonContainer::ServiceMenuButtonContainer( const KConfigGroup& config, QWidget* parent)
  : ButtonContainer(parent)
{
    ServiceMenuButton *b = new ServiceMenuButton(config, this);
    embedButton(b);
}

// WindowListButton container
WindowListButtonContainer::WindowListButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
    WindowListButton *b = new WindowListButton(this);
    embedButton(b);
}

// BookmarkButton container
BookmarksButtonContainer::BookmarksButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
    BookmarksButton *b = new BookmarksButton(this);
    embedButton(b);
}

// RecentDocumentsButton container
RecentDocumentsButtonContainer::RecentDocumentsButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
    RecentDocumentsButton *b = new RecentDocumentsButton(this);
    embedButton(b);
}

NonKDEAppButtonContainer::NonKDEAppButtonContainer(QWidget *parent, const QString &filePath, const QString &icon,
                                       const QString &cmdLine, bool inTerm)
  : ButtonContainer(parent)
{
    NonKDEAppButton *b = new NonKDEAppButton(filePath, icon, cmdLine, inTerm, this);
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

NonKDEAppButtonContainer::NonKDEAppButtonContainer( const KConfigGroup& config, QWidget *parent)
  : ButtonContainer(parent)
{
    NonKDEAppButton *b = new NonKDEAppButton(config, this);
    _actions = KPanelApplet::Preferences;
    embedButton(b);
}

// KonsoleButton container
KonsoleButtonContainer::KonsoleButtonContainer(QWidget *parent)
  : ButtonContainer(parent)
{
    KonsoleButton *b = new KonsoleButton(this);
    embedButton(b);
}

// ExtensionButton container
ExtensionButtonContainer::ExtensionButtonContainer(const QString& df, QWidget *parent)
  : ButtonContainer(parent)
{
    ExtensionButton *b = new ExtensionButton(df, this);
    embedButton(b);
}

ExtensionButtonContainer::ExtensionButtonContainer( const KConfigGroup& config, QWidget *parent)
  : ButtonContainer(parent)
{
    ExtensionButton *b = new ExtensionButton(config, this);
    embedButton(b);
}
