#ifndef _VIRTUAL_H_
#define _VIRTUAL_H_

#include "ftpaccess.h"
#include "InputFileCtl.h"
#include "InputCtl.h"
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>

class Virtual : public QWidget {
	Q_OBJECT
public:
	Virtual(QWidget *parent=0, const char *name=0);
public slots:
	void	ftpaccessLoaded(ftpaccess *xs);
	void	update();
	void	vHostSelected(int host);
	void	addPressed();
	void	removePressed();
	void	VHostAdded(QString const &IP);
private:
	void	redraw();
	ftpaccess *	ftpxs;
	QListBox *	hosts;
	QPushButton *	add;
	QPushButton *	remove;
	InputFileCtl *	root;
	InputFileCtl *	banner;
	InputFileCtl *	logfile;
	InputFileCtl *	passwdfile;
	InputFileCtl *	shadowfile;
	InputCtl *	hostname;
	InputCtl *	email;
	QCheckBox *	allowAnon;
	QButtonGroup *	real;
	QRadioButton *	allowNone;
	QRadioButton *	allowAll;
	QRadioButton *	allowSpecified;
	QRadioButton *	denySpecified;
	QListBox *	allow;
	int		curHost;
};

#endif
