/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Pan - A Newsreader for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#include <pan/base/acache.h>

#include <pan/filters/filter-read.h>

const gchar * FILTER_READ_CLASS_ID = "PanObject::Filter::FilterRead";

/************
*************  PROTECTED
************/

static Filter*
filter_read_dup (const Filter * f_old)
{
	Filter * f_new = filter_read_new ();
	filter_class_dup (f_old, f_new);
	return f_new;
}

static gchar*
filter_read_to_string (const Filter * filter)
{
	return filter->negate
		? g_strdup_printf (_("Article is unread"))
		: g_strdup_printf (_("Article is read"));
}

static void
filter_read_test_articles (Filter          * filter,
                           const Article  ** articles,
                           gint              article_qty,
                           gboolean        * passfail)
{
	gint i;

	for (i=0; i<article_qty; ++i)
		passfail[i] = article_is_read (articles[i]);
}

/************
*************  PUBLIC
************/

Filter*
filter_read_new (void)
{
	FilterRead * f = g_new0 (FilterRead, 1);
	filter_constructor ((Filter*)f,
	                    filter_destructor,
	                    filter_read_test_articles,
	                    filter_read_to_string,
	                    filter_read_dup,
	                    FILTER_READ_CLASS_ID);
	return FILTER(f);
}
