/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 2001 Lars Clausen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/** This file contains user_data structures for creating the non-trivial 
    standard objects (polylines & polygons).
*/

#ifndef STANDARD_OBJECT_CREATE_H
#define STANDARD_OBJECT_CREATE_H

struct _MultipointCreateData {
  int num_points;
  Point *points;
};

typedef struct _MultipointCreateData PolylineCreateData;
typedef struct _MultipointCreateData PolygonCreateData;

struct _BezierCreateData {
  int num_points;
  BezPoint *points;
};

#endif
