#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command
# this file is copied to SDL-devel.post_install and SDL-devel.post_upgrade
# inside the .pkg bundle
echo "Running post-install script"
umask 022

ROOT=/Developer/Documentation/SDL

echo "Moving SDL.framework to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
mkdir -p ~/Library/Frameworks
/Developer/Tools/CpMac -r $ROOT/SDL.framework ~/Library/Frameworks
rm -rf $ROOT/SDL.framework

echo "Precompiling Headers"
# precompile header for speedier compiles
/usr/bin/cc -precomp ~/Library/Frameworks/SDL.framework/Headers/SDL.h -o ~/Library/Frameworks/SDL.framework/Headers/SDL.p

echo "Installing Stationary"
# move stationary to its proper home
mkdir -p "/Developer/ProjectBuilder Extras/Project Templates/Application"
mkdir -p "/Developer/ProjectBuilder Extras/Target Templates"

cp -r "$ROOT/Project Stationary/Developer/ProjectBuilder Extras/Project Templates/Application/SDL Application" "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp -r "$ROOT/Project Stationary/Developer/ProjectBuilder Extras/Target Templates/SDL" "/Developer/ProjectBuilder Extras/Target Templates/"

rm -rf "$ROOT/Project Stationary"

echo "Installing Man Pages"
# remove old man pages
rm -rf "/Developer/Documentation/ManPages/man3/SDL"*
# rebuild appropos database?

# install man pages
mkdir -p "/Developer/Documentation/ManPages/man3"
cp "$ROOT/docs/man3/SDL"* "/Developer/Documentation/ManPages/man3/"
rm -rf "$ROOT/docs/man3"

# copy README file to your home directory
mv "$ROOT/Readme SDL Developer.txt" ~/

# open up the README file
open ~/"Readme SDL Developer.txt"
