/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SecureKey;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class SSLSessionImpl
implements SSLSession {
    static final SSLSessionImpl a = new SSLSessionImpl();
    private static final byte b = 0;
    private SessionId c;
    private java.security.cert.X509Certificate[] d;
    private byte e;
    private CipherSpec f;
    private byte[] g;
    private final long h = System.currentTimeMillis();
    private long i = 0L;
    private String j;
    private int k;
    private SSLSessionContextImpl l;
    private int m;
    private boolean n;
    private boolean o;
    private java.security.cert.X509Certificate[] p;
    private static int q = 0;
    private static boolean r = true;
    private static final Debug s = Debug.getInstance("ssl");
    private Hashtable t = new Hashtable();

    SSLSessionImpl() {
        this(new CipherSpec(), new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(CipherSpec cipherSpec, SecureRandom secureRandom, String string, int n) {
        this(cipherSpec, new SessionId(r, secureRandom), string, n);
    }

    SSLSessionImpl(CipherSpec cipherSpec, SessionId sessionId, String string, int n) {
        this.c = sessionId;
        this.d = null;
        this.e = 0;
        this.f = cipherSpec;
        this.g = null;
        this.j = string;
        this.k = n;
        this.m = ++q;
        if (s != null && Debug.isOn("session")) {
            System.out.println("%% Created:  " + this);
        }
    }

    void a(byte[] byArray) {
        if (this.g == null) {
            this.g = byArray;
        }
    }

    byte[] a() {
        return this.g;
    }

    void a(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.d == null) {
            this.d = x509CertificateArray;
        }
    }

    void b(java.security.cert.X509Certificate[] x509CertificateArray) {
        this.p = x509CertificateArray;
    }

    boolean b() {
        return this.c != null && this.c.a() != 0 && !this.o;
    }

    public byte[] getId() {
        return this.c.b();
    }

    boolean c() {
        return this.n;
    }

    void a(boolean bl) {
        this.n = bl;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.l;
    }

    SessionId d() {
        return this.c;
    }

    CipherSpec e() {
        return this.f;
    }

    public String getCipherSuite() {
        return this.f.toString();
    }

    public String getProtocol() {
        String string = null;
        if (this.f.a == 3 && this.f.b == 1) {
            string = "TLSv1";
        } else if (this.f.a == 3 && this.f.b == 0) {
            string = "SSLv3";
        } else if (this.f.a == 0) {
            string = "NONE";
        } else {
            throw new RuntimeException("Internal Error: Unknown Protocol " + this.f.a + "." + this.f.b);
        }
        return string;
    }

    byte f() {
        return this.e;
    }

    boolean a(SessionId sessionId) {
        return this.c != null && this.c.equals(sessionId);
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.d == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.d.clone();
    }

    public Certificate[] getLocalCertificates() {
        return this.p == null ? null : (Certificate[])this.p.clone();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.d.length];
        int n = 0;
        while (n < this.d.length) {
            byte[] byArray = null;
            try {
                byArray = this.d[n].getEncoded();
                x509CertificateArray[n] = X509Certificate.getInstance(byArray);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
            ++n;
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d != null) {
            return (java.security.cert.X509Certificate[])this.d.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    public long getCreationTime() {
        return this.h;
    }

    public long getLastAccessedTime() {
        return this.i != 0L ? this.i : this.h;
    }

    void a(long l) {
        this.i = l;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.j);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String getPeerHost() {
        return this.j;
    }

    int g() {
        return this.k;
    }

    void a(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.l == null) {
            this.l = sSLSessionContextImpl;
        }
    }

    public synchronized void invalidate() {
        if (this == a) {
            return;
        }
        this.o = true;
        if (s != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.l != null) {
            this.l.a(this.c);
            this.l = null;
        }
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        if (string == null || object == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.t.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        return this.t.get(secureKey);
    }

    public void removeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object v = this.t.remove(secureKey);
        if (v instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v).valueUnbound(sSLSessionBindingEvent);
        }
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.a();
        Enumeration enumeration = this.t.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = (SecureKey)enumeration.nextElement();
            if (!object.equals(secureKey.c())) continue;
            vector.addElement(secureKey.b());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return "[Session-" + this.m + ", " + this.getCipherSuite() + "]";
    }

    public void finalize() {
        String[] stringArray = this.getValueNames();
        int n = 0;
        while (n < stringArray.length) {
            this.removeValue(stringArray[n]);
            ++n;
        }
    }
}

