/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import com.sun.net.ssl.internal.ssl.SunJSSE_au;
import com.sun.net.ssl.internal.ssl.SunJSSE_p;
import com.sun.net.ssl.internal.ssl.SunJSSE_v;
import com.sun.net.ssl.internal.ssl.SunJSSE_z;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;

abstract class HandshakeMessage {
    static final byte a = 0;
    static final byte b = 1;
    static final byte c = 2;
    static final byte d = 11;
    static final byte e = 12;
    static final byte f = 13;
    static final byte g = 14;
    static final byte h = 15;
    static final byte i = 16;
    static final byte j = 20;
    static final Debug k = Debug.getInstance("ssl");

    HandshakeMessage() {
    }

    public final void write(SSLOutputStream sSLOutputStream) throws IOException {
        int n = this.messageLength();
        if (n > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n);
        }
        sSLOutputStream.write(this.messageType());
        sSLOutputStream.c(this.messageLength());
        this.send(sSLOutputStream);
    }

    abstract int messageType();

    abstract int messageLength();

    abstract void send(SSLOutputStream var1) throws IOException;

    abstract void a(PrintStream var1) throws IOException;

    static final class Finished
    extends HandshakeMessage {
        byte a;
        byte b;
        static final byte[] c = new byte[]{67, 76, 78, 84};
        static final byte[] d = new byte[]{83, 82, 86, 82};
        static final String e = "client finished";
        static final String f = "server finished";
        byte[] g;
        byte[] h;
        byte[] i;

        int messageType() {
            return 20;
        }

        private byte[] a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray5 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            return messageDigest.digest();
        }

        Finished(byte by, byte by2, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, byte[] byArray2) {
            this.a = by;
            this.b = by2;
            this.g = this.a(messageDigest, byArray, byArray2, MAC.MD5_pad1, MAC.MD5_pad2);
            this.h = this.a(messageDigest2, byArray, byArray2, MAC.SHA_pad1, MAC.SHA_pad2);
        }

        Finished(byte by, byte by2, MessageDigest messageDigest, MessageDigest messageDigest2, String string, byte[] byArray) {
            this.a = by;
            this.b = by2;
            this.i = new byte[12];
            try {
                SunJSSE_v.a(byArray, string, messageDigest.digest(), messageDigest2.digest(), this.i);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("missing support for MD5/SHA-1");
            }
        }

        Finished(byte by, byte by2, SSLInputStream sSLInputStream) throws IOException {
            this.a = by;
            this.b = by2;
            if (by == 3 && by2 == 1) {
                this.i = new byte[12];
                sSLInputStream.read(this.i);
            } else {
                this.g = new byte[16];
                this.h = new byte[20];
                sSLInputStream.read(this.g);
                sSLInputStream.read(this.h);
            }
        }

        public boolean verify(MessageDigest messageDigest, MessageDigest messageDigest2, Object object, byte[] byArray) {
            if (object instanceof String) {
                if (this.i == null) {
                    return false;
                }
                byte[] byArray2 = new byte[12];
                try {
                    SunJSSE_v.a(byArray, (String)object, messageDigest.digest(), messageDigest2.digest(), byArray2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("missing support for MD5/SHA-1");
                }
                int n = 0;
                while (n < 12) {
                    if (this.i[n] != byArray2[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            if (this.g == null || this.h == null) {
                return false;
            }
            byte[] byArray3 = this.a(messageDigest, (byte[])object, byArray, MAC.MD5_pad1, MAC.MD5_pad2);
            byte[] byArray4 = this.a(messageDigest2, (byte[])object, byArray, MAC.SHA_pad1, MAC.SHA_pad2);
            int n = 0;
            while (n < 16) {
                if (this.g[n] != byArray3[n]) {
                    return false;
                }
                ++n;
            }
            n = 0;
            while (n < 20) {
                if (this.h[n] != byArray4[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        int messageLength() {
            if (this.a == 3 && this.b == 1) {
                return 12;
            }
            return 36;
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            if (this.a == 3 && this.b == 1) {
                sSLOutputStream.write(this.i);
            } else {
                sSLOutputStream.write(this.g);
                sSLOutputStream.write(this.h);
            }
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Finished, v" + this.a + "." + this.b);
            if (k != null && Debug.isOn("verbose")) {
                if (this.a == 3 && this.b == 1) {
                    printStream.print("verify_data:  { ");
                    int n = 0;
                    while (n < this.i.length) {
                        if (n != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.i[n] & 0xFF);
                        ++n;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                } else {
                    printStream.print("MD5 Hash:  { ");
                    int n = 0;
                    while (n < this.g.length) {
                        if (n != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.g[n] & 0xFF);
                        ++n;
                    }
                    printStream.println(" }");
                    printStream.print("SHA1 Hash:  { ");
                    n = 0;
                    while (n < this.h.length) {
                        if (n != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.h[n] & 0xFF);
                        ++n;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                }
            }
        }
    }

    static final class DH_ServerKeyExchange
    extends SunJSSE_p {
        private static boolean a = true;
        private byte[] b;
        private byte[] c;
        private byte[] d;
        private byte[] e;

        public BigInteger getModulus() {
            return new BigInteger(1, this.b);
        }

        public BigInteger getBase() {
            return new BigInteger(1, this.c);
        }

        public BigInteger getServerPublicKey() {
            return new BigInteger(1, this.d);
        }

        private void a(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n = this.b.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.b);
            n = this.c.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.c);
            n = this.d.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.d);
        }

        private void a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            int n = this.b.length;
            messageDigest.update((byte)(n >> 8));
            messageDigest.update((byte)(n & 0xFF));
            messageDigest.update(this.b);
            n = this.c.length;
            messageDigest.update((byte)(n >> 8));
            messageDigest.update((byte)(n & 0xFF));
            messageDigest.update(this.c);
            n = this.d.length;
            messageDigest.update((byte)(n >> 8));
            messageDigest.update((byte)(n & 0xFF));
            messageDigest.update(this.d);
        }

        DH_ServerKeyExchange(SunJSSE_au sunJSSE_au) {
            this.a(sunJSSE_au);
            this.e = null;
        }

        DH_ServerKeyExchange(SunJSSE_au sunJSSE_au, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            this.a(sunJSSE_au);
            if (privateKey instanceof DSAPrivateKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initSign(privateKey, secureRandom);
                this.a(signature, byArray, byArray2);
                this.e = signature.sign();
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                SunJSSE_z sunJSSE_z = new SunJSSE_z(messageDigest.digest(), messageDigest2.digest(), privateKey, secureRandom);
                this.e = sunJSSE_z.a();
            }
        }

        private void a(SunJSSE_au sunJSSE_au) {
            this.b = sunJSSE_au.a().toByteArray();
            this.c = sunJSSE_au.b().toByteArray();
            this.d = sunJSSE_au.c().toByteArray();
        }

        DH_ServerKeyExchange(SSLInputStream sSLInputStream) throws IOException {
            this.b = sSLInputStream.g();
            this.c = sSLInputStream.g();
            this.d = sSLInputStream.g();
            this.e = null;
        }

        DH_ServerKeyExchange(SSLInputStream sSLInputStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
            boolean bl;
            this.b = sSLInputStream.g();
            this.c = sSLInputStream.g();
            this.d = sSLInputStream.g();
            if (a) {
                this.e = sSLInputStream.g();
            } else {
                n -= this.b.length + 2;
                n -= this.c.length + 2;
                this.e = new byte[n -= this.d.length + 2];
                sSLInputStream.read(this.e);
            }
            if (publicKey instanceof DSAKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initVerify(publicKey);
                this.a(signature, byArray, byArray2);
                bl = signature.verify(this.e);
            } else if (publicKey instanceof RSAPublicKey) {
                SunJSSE_z sunJSSE_z = new SunJSSE_z(this.e);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                bl = sunJSSE_z.a((RSAPublicKey)publicKey, messageDigest.digest(), messageDigest2.digest());
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            if (!bl) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        int messageLength() {
            int n = 6;
            n += this.b.length;
            n += this.c.length;
            n += this.d.length;
            if (this.e != null) {
                n += this.e.length;
                if (a) {
                    n += 2;
                }
            }
            return n;
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.b(this.b);
            sSLOutputStream.b(this.c);
            sSLOutputStream.b(this.d);
            if (this.e != null) {
                if (a) {
                    sSLOutputStream.b(this.e);
                } else {
                    sSLOutputStream.write(this.e);
                }
            }
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (k != null && Debug.isOn("verbose")) {
                printStream.print("DH Modulus = { ");
                int n = 0;
                while (n < this.b.length) {
                    if (n != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.b[n] & 0xFF);
                    ++n;
                }
                printStream.println(" }");
                printStream.print("DH Base = { ");
                int n2 = 0;
                while (n2 < this.c.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.c[n2] & 0xFF);
                    ++n2;
                }
                printStream.println(" }");
                printStream.print("Server DH Public Key = { ");
                int n3 = 0;
                while (n3 < this.d.length) {
                    if (n3 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.d[n3] & 0xFF);
                    ++n3;
                }
                printStream.println(" }");
                if (this.e == null) {
                    printStream.println("Anonymous");
                } else {
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }

        static {
            try {
                String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("com.sun.net.ssl.dhKeyExchangeFix");
                    }
                });
                if (string != null && string.equalsIgnoreCase("false")) {
                    a = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] a;

        int messageType() {
            return 11;
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.a = x509CertificateArray;
        }

        CertificateMsg(SSLInputStream sSLInputStream) throws IOException {
            int n;
            int n2 = sSLInputStream.d();
            Vector<Certificate> vector = new Vector<Certificate>(3);
            while (n2 > 0) {
                n = sSLInputStream.d();
                byte[] byArray = new byte[n];
                int n3 = 0;
                n2 -= 3 + n;
                while (n3 != n) {
                    int n4 = sSLInputStream.read(byArray, n3, n - n3);
                    if (n4 < 0) {
                        throw new IOException("short read of certificates");
                    }
                    n3 += n4;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    vector.addElement(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.getMessage());
                }
            }
            this.a = new X509Certificate[vector.size()];
            n = 0;
            while (n < this.a.length) {
                this.a[n] = (X509Certificate)vector.elementAt(n);
                ++n;
            }
        }

        int messageLength() {
            int n = 3;
            try {
                int n2 = this.a.length - 1;
                while (n2 >= 0) {
                    n += 3 + this.a[n2].getEncoded().length;
                    --n2;
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            return n;
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            try {
                sSLOutputStream.c(this.messageLength() - 3);
                int n = 0;
                while (n < this.a.length) {
                    sSLOutputStream.c(this.a[n].getEncoded());
                    ++n;
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (k != null && Debug.isOn("verbose")) {
                int n = 0;
                while (n < this.a.length) {
                    printStream.println("chain [" + n + "] = " + this.a[n]);
                    ++n;
                }
                printStream.println("***");
            }
        }

        public X509Certificate[] getCertificateChain() {
            return this.a;
        }
    }
}

