/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;

public class BitArray {
    private byte[] repn;
    private int length;
    private static final int BITS_PER_UNIT = 8;
    private static final byte[][] NYBBLE = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int BYTES_PER_LINE = 8;

    private static int subscript(int n2) {
        return n2 / 8;
    }

    private static int position(int n2) {
        return 1 << 7 - n2 % 8;
    }

    public BitArray(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.length = n2;
        this.repn = new byte[(n2 + 8 - 1) / 8];
    }

    public BitArray(int n2, byte[] byArray) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if (byArray.length * 8 < n2) {
            throw new IllegalArgumentException("Byte array too short to represent bit array of given length");
        }
        this.length = n2;
        int n3 = (n2 + 8 - 1) / 8;
        int n4 = n3 * 8 - n2;
        byte by = (byte)(255 << n4);
        this.repn = new byte[n3];
        System.arraycopy(byArray, 0, this.repn, 0, n3);
        this.repn[this.repn.length - 1] = (byte)(this.repn[this.repn.length - 1] & by);
    }

    public BitArray(boolean[] blArray) {
        this.length = blArray.length;
        this.repn = new byte[(this.length + 7) / 8];
        int n2 = 0;
        while (n2 < this.length) {
            this.set(n2, blArray[n2]);
            ++n2;
        }
    }

    private BitArray(BitArray bitArray) {
        this.length = bitArray.length;
        this.repn = (byte[])bitArray.repn.clone();
    }

    public boolean get(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        return (this.repn[BitArray.subscript(n2)] & BitArray.position(n2)) != 0;
    }

    public void set(int n2, boolean bl2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        int n3 = BitArray.subscript(n2);
        int n4 = BitArray.position(n2);
        if (bl2) {
            int n5 = n3;
            this.repn[n5] = (byte)(this.repn[n5] | n4);
        } else {
            int n6 = n3;
            this.repn[n6] = (byte)(this.repn[n6] & ~n4);
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.repn.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        if (bitArray.length != this.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.repn.length) {
            if (this.repn[n2] != bitArray.repn[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            blArray[n2] = this.get(n2);
            ++n2;
        }
        return blArray;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.repn.length) {
            n2 = 31 * n2 + this.repn[n3];
            ++n3;
        }
        return n2 ^ this.length;
    }

    public Object clone() {
        return new BitArray(this);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < this.repn.length - 1) {
            byteArrayOutputStream.write(NYBBLE[this.repn[n2] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(NYBBLE[this.repn[n2] & 0xF], 0, 4);
            if (n2 % 8 == 7) {
                byteArrayOutputStream.write(10);
            } else {
                byteArrayOutputStream.write(32);
            }
            ++n2;
        }
        int n3 = 8 * (this.repn.length - 1);
        while (n3 < this.length) {
            byteArrayOutputStream.write(this.get(n3) ? 49 : 48);
            ++n3;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }
}

