/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import sun.rmi.transport.proxy.CGIClientException;
import sun.rmi.transport.proxy.CGICommandHandler;
import sun.rmi.transport.proxy.CGIHandler;
import sun.rmi.transport.proxy.CGIServerException;

final class CGIForwardCommand
implements CGICommandHandler {
    CGIForwardCommand() {
    }

    public String getName() {
        return "forward";
    }

    public void execute(String string) throws CGIClientException, CGIServerException {
        String string2;
        Object object;
        Socket socket;
        int n2;
        if (!CGIHandler.RequestMethod.equals("POST")) {
            throw new CGIClientException("can only forward POST requests");
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CGIClientException("invalid port number: " + string);
        }
        if (n2 <= 0 || n2 > 65535) {
            throw new CGIClientException("invalid port: " + n2);
        }
        if (n2 < 1024) {
            throw new CGIClientException("permission denied for port: " + n2);
        }
        try {
            socket = new Socket(InetAddress.getLocalHost(), n2);
        }
        catch (IOException iOException) {
            throw new CGIServerException("could not connect to local port");
        }
        DataInputStream dataInputStream = new DataInputStream(System.in);
        byte[] byArray = new byte[CGIHandler.ContentLength];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new CGIClientException("unexpected EOF reading request body");
        }
        catch (IOException iOException) {
            throw new CGIClientException("error reading request body");
        }
        try {
            object = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)object).writeBytes("POST / HTTP/1.0\r\n");
            ((DataOutputStream)object).writeBytes("Content-length: " + CGIHandler.ContentLength + "\r\n\r\n");
            ((FilterOutputStream)object).write(byArray);
            ((DataOutputStream)object).flush();
        }
        catch (IOException iOException) {
            throw new CGIServerException("error writing to server");
        }
        try {
            object = new DataInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            throw new CGIServerException("error reading from server");
        }
        String string3 = "Content-length:".toLowerCase();
        boolean bl2 = false;
        int n3 = -1;
        do {
            try {
                string2 = ((DataInputStream)object).readLine();
            }
            catch (IOException iOException) {
                throw new CGIServerException("error reading from server");
            }
            if (string2 == null) {
                throw new CGIServerException("unexpected EOF reading server response");
            }
            if (!string2.toLowerCase().startsWith(string3)) continue;
            if (bl2) {
                // empty if block
            }
            n3 = Integer.parseInt(string2.substring(string3.length()).trim());
            bl2 = true;
        } while (string2.length() != 0 && string2.charAt(0) != '\r' && string2.charAt(0) != '\n');
        if (!bl2 || n3 < 0) {
            throw new CGIServerException("missing or invalid content length in server response");
        }
        byArray = new byte[n3];
        try {
            ((DataInputStream)object).readFully(byArray);
        }
        catch (EOFException eOFException) {
            throw new CGIServerException("unexpected EOF reading server response");
        }
        catch (IOException iOException) {
            throw new CGIServerException("error reading from server");
        }
        System.out.println("Status: 200 OK");
        System.out.println("Content-type: application/octet-stream");
        System.out.println("");
        try {
            System.out.write(byArray);
        }
        catch (IOException iOException) {
            throw new CGIServerException("error writing response");
        }
        System.out.flush();
    }
}

