/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import sun.rmi.runtime.Log;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Connection;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPEndpoint;

public class StreamRemoteCall
implements RemoteCall {
    private ConnectionInputStream in = null;
    private ConnectionOutputStream out = null;
    private Connection conn;
    private boolean resultStarted = false;
    private Exception serverException = null;

    public StreamRemoteCall(Connection connection) {
        this.conn = connection;
    }

    public StreamRemoteCall(Connection connection, ObjID objID, int n2, long l2) throws RemoteException {
        try {
            this.conn = connection;
            Transport.transportLog.log(Log.VERBOSE, "write remote call header...");
            this.conn.getOutputStream().write(80);
            this.getOutputStream();
            objID.write(this.out);
            this.out.writeInt(n2);
            this.out.writeLong(l2);
        }
        catch (IOException iOException) {
            throw new MarshalException("Error marshaling call header", iOException);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public ObjectOutput getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    private ObjectOutput getOutputStream(boolean bl2) throws IOException {
        if (this.out == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting output stream");
            this.out = new ConnectionOutputStream(this.conn, bl2);
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputStream() throws IOException {
        try {
            if (this.out != null) {
                try {
                    this.out.flush();
                    Object var2_1 = null;
                    this.out.done();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.out.done();
                    throw throwable;
                }
            }
            this.conn.releaseOutputStream();
            Object var4_4 = null;
            this.out = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.out = null;
            throw throwable;
        }
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.in == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting input stream");
            this.in = new ConnectionInputStream(this.conn.getInputStream());
        }
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInputStream() throws IOException {
        try {
            if (this.in != null) {
                try {
                    this.in.done();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.in.registerRefs();
                this.in.done(this.conn);
            }
            this.conn.releaseInputStream();
            Object var3_2 = null;
            this.in = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.in = null;
            throw throwable;
        }
    }

    public ObjectOutput getResultStream(boolean bl2) throws IOException, StreamCorruptedException {
        if (this.resultStarted) {
            throw new StreamCorruptedException("result already in progress");
        }
        this.resultStarted = true;
        DataOutputStream dataOutputStream = new DataOutputStream(this.conn.getOutputStream());
        dataOutputStream.writeByte(81);
        this.getOutputStream(true);
        if (bl2) {
            this.out.writeByte(1);
        } else {
            this.out.writeByte(2);
        }
        this.out.writeID();
        return this.out;
    }

    public void executeCall() throws Exception {
        byte by;
        Object object;
        try {
            this.releaseOutputStream();
            object = new DataInputStream(this.conn.getInputStream());
            byte by2 = ((DataInputStream)object).readByte();
            if (by2 != 81) {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "transport return code invalid: " + by2);
                }
                throw new UnmarshalException("Transport return code invalid");
            }
            this.getInputStream();
            by = this.in.readByte();
            this.in.readID();
        }
        catch (UnmarshalException unmarshalException) {
            throw unmarshalException;
        }
        catch (IOException iOException) {
            throw new UnmarshalException("Error unmarshaling return header", iOException);
        }
        switch (by) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    object = this.in.readObject();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("Error unmarshaling return", exception);
                }
                if (object instanceof Exception) {
                    this.exceptionReceivedFromServer((Exception)object);
                } else {
                    throw new UnmarshalException("Return type not Exception");
                }
            }
            default: {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "return code invalid: " + by);
                }
                throw new UnmarshalException("Return code invalid");
            }
        }
    }

    protected void exceptionReceivedFromServer(Exception exception) throws Exception {
        this.serverException = exception;
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
        exception.setStackTrace(stackTraceElementArray3);
        if (UnicastRef.clientCallLog.isLoggable(Log.BRIEF)) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)this.conn.getChannel().getEndpoint();
            UnicastRef.clientCallLog.log(Log.BRIEF, "outbound call received exception: [" + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort() + "] exception: ", exception);
        }
        throw exception;
    }

    public Exception getServerException() {
        return this.serverException;
    }

    public void done() throws IOException {
        this.releaseInputStream();
    }
}

