/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import com.sun.rmi.rmid.ExecOptionPermission;
import com.sun.rmi.rmid.ExecPermission;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.rmi.log.LogHandler;
import sun.rmi.log.ReliableLog;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.PipeWriter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyFile;

public class Activation
implements Serializable,
Runnable {
    private static final long serialVersionUID = 2921265612698155191L;
    private static Registry registry;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private static int nextRestart;
    private static Object execPolicy;
    private static Method execPolicyMethod;
    private static final String execPolicyMethodName = "checkExecCommand";
    private static final Class[] execPolicyMethodParamTypes;
    private static boolean debugExec;
    private Hashtable idTable = new Hashtable(101);
    private Hashtable groupTable = new Hashtable(53);
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    private transient ReliableLog log;
    private transient int numUpdates = 0;
    private transient String[] command;
    private static final int snapshotInterval;
    private static final long execTimeout;
    private transient Activator activator;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private volatile transient boolean shuttingDown = false;
    private transient Object startupLock;
    private transient Thread shutdownHook;
    private static ResourceBundle resources;
    private static int[] sem_startgroup;
    static /* synthetic */ Class class$java$rmi$activation$ActivationGroupDesc;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$sun$rmi$server$ActivationGroupImpl;
    static /* synthetic */ Class class$sun$rmi$server$Activation$DefaultExecPolicy;

    private static int getInt(String string, int n2) {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n2));
    }

    private Activation() {
    }

    private static void startActivation(int n2, String string, String[] stringArray) throws Exception {
        ReliableLog reliableLog = new ReliableLog(string, new ActLogHandler());
        Activation activation = (Activation)reliableLog.recover();
        activation.init(n2, reliableLog, stringArray);
        activation.restartServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int n2, ReliableLog reliableLog, String[] stringArray) throws Exception {
        this.log = reliableLog;
        this.numUpdates = 0;
        this.shutdownHook = (Thread)AccessController.doPrivileged(new NewThreadAction(new ShutdownHook(), "RMID Shutdown Hook", false));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Object object = this.startupLock = new Object();
        synchronized (object) {
            this.activator = new ActivatorImpl(n2);
            this.activatorStub = (Activator)RemoteObject.toStub(this.activator);
            this.system = new ActivationSystemImpl(n2);
            this.systemStub = (ActivationSystem)RemoteObject.toStub(this.system);
            this.monitor = new ActivationMonitorImpl(n2);
            this.initCommand(stringArray);
            Naming.rebind("//:" + n2 + "/java.rmi.activation.ActivationSystem", this.system);
        }
        this.startupLock = null;
    }

    private void restartServices() {
        Enumeration enumeration = this.groupTable.keys();
        while (enumeration.hasMoreElements()) {
            ActivationGroupID activationGroupID = (ActivationGroupID)enumeration.nextElement();
            try {
                GroupEntry groupEntry = this.getGroupEntry(activationGroupID);
                groupEntry.restartServices();
            }
            catch (UnknownGroupException unknownGroupException) {
                System.err.println("\nrmid: unable to restart services");
                System.err.println("rmid: exception occurred:");
                unknownGroupException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() throws ActivationException {
        Object object = this.startupLock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
            }
        }
        if (this.shuttingDown) {
            throw new ActivationException("activation system is shutting down");
        }
    }

    private synchronized void shutdownAll() {
        Thread thread = null;
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "RMID Shutdown", false));
        thread.start();
    }

    private static void unexport(Remote remote) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(remote, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Activation.unexport(this.activator);
            Activation.unexport(this.system);
            Enumeration enumeration = this.groupTable.elements();
            while (enumeration.hasMoreElements()) {
                GroupEntry groupEntry = (GroupEntry)enumeration.nextElement();
                groupEntry.shutdown();
            }
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            Activation.unexport(this.monitor);
            try {
                this.log.close();
            }
            catch (IOException iOException) {
            }
            Object var4_4 = null;
            System.err.println(Activation.getTextResource("rmid.daemon.shutdown"));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            System.err.println(Activation.getTextResource("rmid.daemon.shutdown"));
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    private ActivationGroupID getGroupID(ActivationID activationID) throws UnknownObjectException {
        ActivationGroupID activationGroupID = (ActivationGroupID)this.idTable.get(activationID);
        if (activationGroupID == null) {
            throw new UnknownObjectException("unknown object: " + activationID);
        }
        return activationGroupID;
    }

    private GroupEntry getGroupEntry(ActivationGroupID activationGroupID) throws UnknownGroupException {
        GroupEntry groupEntry = (GroupEntry)this.groupTable.get(activationGroupID);
        if (groupEntry == null) {
            throw new UnknownGroupException("unknown group: " + activationGroupID);
        }
        return groupEntry;
    }

    private GroupEntry getGroupEntry(ActivationID activationID) throws UnknownGroupException, UnknownObjectException {
        return this.getGroupEntry(this.getGroupID(activationID));
    }

    private String[] activationArgs(ActivationGroupDesc activationGroupDesc) {
        String[] stringArray;
        Properties properties;
        ActivationGroupDesc.CommandEnvironment commandEnvironment = activationGroupDesc.getCommandEnvironment();
        ArrayList arrayList = new ArrayList();
        arrayList.add(commandEnvironment != null && commandEnvironment.getCommandPath() != null ? commandEnvironment.getCommandPath() : this.command[0]);
        if (commandEnvironment != null && commandEnvironment.getCommandOptions() != null) {
            arrayList.addAll(Arrays.asList(commandEnvironment.getCommandOptions()));
        }
        if ((properties = activationGroupDesc.getPropertyOverrides()) != null) {
            Enumeration enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                arrayList.add("-D" + (String)stringArray + "=" + properties.getProperty((String)stringArray));
            }
        }
        int n2 = 1;
        while (n2 < this.command.length) {
            arrayList.add(this.command[n2]);
            ++n2;
        }
        stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    private void checkArgs(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException, ActivationException {
        if (execPolicyMethod != null) {
            if (stringArray == null) {
                stringArray = this.activationArgs(activationGroupDesc);
            }
            Object[] objectArray = new Object[]{activationGroupDesc, stringArray};
            try {
                execPolicyMethod.invoke(execPolicy, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SecurityException) {
                    throw (SecurityException)throwable;
                }
                throw new ActivationException("checkExecCommand: unexpected exception", invocationTargetException);
            }
            catch (Exception exception) {
                throw new ActivationException("checkExecCommand: unexpected exception", exception);
            }
        }
    }

    private synchronized void addLogRecord(LogRecord logRecord) throws ActivationException {
        Exception exception = null;
        try {
            this.log.update(logRecord, true);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        try {
            if (++this.numUpdates >= snapshotInterval || exception != null) {
                this.log.snapshot(this);
                this.numUpdates = 0;
            }
            if (exception != null) {
                System.err.println("\nrmid: warning, could not apply log record update but snapshot succeeded.");
                System.err.println("\nrmid: state is consistent. update exception was: ");
                exception.printStackTrace();
            }
        }
        catch (Exception exception3) {
            System.err.println("\nrmid: could not update update or snapshot log file");
            System.err.println("rmid: the activation system is shutting down");
            if (exception != null) {
                System.err.println("rmid: exception occurred during log update:");
                exception.printStackTrace();
            }
            System.err.println("rmid: exception occurred during log snapshot:");
            exception3.printStackTrace();
            try {
                ((ActivationSystemImpl)this.system).shutdown();
            }
            catch (AccessException accessException) {
                // empty catch block
            }
            throw new ActivationException("rmid could not update its log file", exception);
        }
    }

    private void initCommand(String[] stringArray) {
        this.command = new String[stringArray.length + 2];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ((Activation)Activation.this).command[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                catch (Exception exception) {
                    System.err.println(Activation.getTextResource("rmid.unfound.java.home.property"));
                    ((Activation)Activation.this).command[0] = "java";
                }
                return null;
            }
        });
        System.arraycopy(stringArray, 0, this.command, 1, stringArray.length);
        this.command[this.command.length - 1] = "sun.rmi.server.ActivationGroupInit";
    }

    private static void bomb(String string) {
        System.err.println("rmid: " + string);
        System.err.println(MessageFormat.format(Activation.getTextResource("rmid.usage"), new String[]{"rmid"}));
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            Object[] objectArray;
            int n2 = 1098;
            String string = "log";
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals("-port")) {
                    if (n3 + 1 < stringArray.length) {
                        try {
                            n2 = Integer.parseInt(stringArray[++n3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Activation.bomb(Activation.getTextResource("rmid.syntax.port.badnumber"));
                        }
                    } else {
                        Activation.bomb(Activation.getTextResource("rmid.syntax.port.missing"));
                    }
                } else if (stringArray[n3].equals("-log")) {
                    if (n3 + 1 < stringArray.length) {
                        string = stringArray[++n3];
                    } else {
                        Activation.bomb(Activation.getTextResource("rmid.syntax.log.missing"));
                    }
                } else if (stringArray[n3].equals("-stop")) {
                    bl2 = true;
                } else if (stringArray[n3].startsWith("-C")) {
                    arrayList.add(stringArray[n3].substring(2));
                } else {
                    objectArray = new Object[]{stringArray[n3]};
                    Activation.bomb(MessageFormat.format(Activation.getTextResource("rmid.syntax.illegal.option"), objectArray));
                }
                ++n3;
            }
            objectArray = (Object[])AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.activation.debugExec"));
            debugExec = objectArray.booleanValue();
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.activation.execPolicy", null));
            if (string2 == null) {
                if (!bl2) {
                    DefaultExecPolicy.checkConfiguration();
                }
                string2 = "default";
            }
            if (!string2.equals("none")) {
                if (string2.equals("") || string2.equals("default")) {
                    string2 = (class$sun$rmi$server$Activation$DefaultExecPolicy == null ? (class$sun$rmi$server$Activation$DefaultExecPolicy = Activation.class$("sun.rmi.server.Activation$DefaultExecPolicy")) : class$sun$rmi$server$Activation$DefaultExecPolicy).getName();
                }
                try {
                    Class clazz = RMIClassLoader.loadClass(string2);
                    execPolicy = clazz.newInstance();
                    execPolicyMethod = clazz.getMethod(execPolicyMethodName, execPolicyMethodParamTypes);
                }
                catch (Exception exception) {
                    if (debugExec) {
                        System.err.println("rmid: exception obtaining exec policy");
                        exception.printStackTrace();
                    }
                    Activation.bomb(Activation.getTextResource("rmid.exec.policy.invalid"));
                }
            }
            if (bl2) {
                final int n4 = n2;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("java.rmi.activation.port", Integer.toString(n4));
                        return null;
                    }
                });
                ActivationSystem activationSystem = ActivationGroup.getSystem();
                activationSystem.shutdown();
                System.exit(0);
            }
            registry = LocateRegistry.createRegistry(n2);
            Activation.startActivation(n2, string, (String[])arrayList.toArray(new String[arrayList.size()]));
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            System.err.println(MessageFormat.format(Activation.getTextResource("rmid.unexpected.exception"), objectArray));
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.rmid.resources.rmid");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Pstartgroup() throws InterruptedException {
        int[] nArray = sem_startgroup;
        synchronized (nArray) {
            while (sem_startgroup[0] <= 0) {
                sem_startgroup.wait();
            }
            sem_startgroup[0] = sem_startgroup[0] - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Vstartgroup() {
        int[] nArray = sem_startgroup;
        synchronized (nArray) {
            sem_startgroup[0] = sem_startgroup[0] + 1;
            sem_startgroup.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nextRestart = 0;
        execPolicyMethodParamTypes = new Class[]{class$java$rmi$activation$ActivationGroupDesc == null ? (class$java$rmi$activation$ActivationGroupDesc = Activation.class$("java.rmi.activation.ActivationGroupDesc")) : class$java$rmi$activation$ActivationGroupDesc, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Activation.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        snapshotInterval = Activation.getInt("sun.rmi.activation.snapshotInterval", 200);
        execTimeout = Activation.getInt("sun.rmi.activation.execTimeout", 30000);
        resources = null;
        Integer n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.rmid.maxstartgroup", 3));
        int[] nArray = new int[]{n2};
        sem_startgroup = nArray;
    }

    public static class DefaultExecPolicy {
        public void checkExecCommand(ActivationGroupDesc activationGroupDesc, String[] stringArray) throws SecurityException {
            String string;
            Object object;
            Object object2;
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Properties properties = activationGroupDesc.getPropertyOverrides();
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    string = "-D" + (String)object + "=" + properties.getProperty((String)object);
                    DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission(string));
                }
            }
            if ((object2 = activationGroupDesc.getClassName()) != null && !((String)object2).equals((class$sun$rmi$server$ActivationGroupImpl == null ? (class$sun$rmi$server$ActivationGroupImpl = Activation.class$("sun.rmi.server.ActivationGroupImpl")) : class$sun$rmi$server$ActivationGroupImpl).getName()) || activationGroupDesc.getLocation() != null || activationGroupDesc.getData() != null) {
                throw new AccessControlException("access denied (custom group implementation not allowed)");
            }
            object = activationGroupDesc.getCommandEnvironment();
            if (object != null) {
                String[] stringArray2;
                string = ((ActivationGroupDesc.CommandEnvironment)object).getCommandPath();
                if (string != null) {
                    DefaultExecPolicy.checkPermission(permissionCollection, new ExecPermission(string));
                }
                if ((stringArray2 = ((ActivationGroupDesc.CommandEnvironment)object).getCommandOptions()) != null) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        DefaultExecPolicy.checkPermission(permissionCollection, new ExecOptionPermission(stringArray2[n2]));
                        ++n2;
                    }
                }
            }
        }

        static void checkConfiguration() {
            Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Policy.getPolicy();
                }
            });
            if (!(policy instanceof PolicyFile)) {
                return;
            }
            PermissionCollection permissionCollection = DefaultExecPolicy.getExecPermissions();
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = (Permission)enumeration.nextElement();
                if (!(permission instanceof AllPermission) && !(permission instanceof ExecPermission) && !(permission instanceof ExecOptionPermission)) continue;
                return;
            }
            System.err.println(Activation.getTextResource("rmid.exec.perms.inadequate"));
        }

        private static PermissionCollection getExecPermissions() {
            PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CodeSource codeSource = new CodeSource(null, null);
                    Policy policy = Policy.getPolicy();
                    if (policy != null) {
                        return policy.getPermissions(codeSource);
                    }
                    return new Permissions();
                }
            });
            return permissionCollection;
        }

        private static void checkPermission(PermissionCollection permissionCollection, Permission permission) throws AccessControlException {
            if (!permissionCollection.implies(permission)) {
                throw new AccessControlException("access denied " + permission.toString());
            }
        }
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID activationGroupID, long l2) {
            this.id = activationGroupID;
            this.inc = l2;
        }

        Object apply(Object object) {
            try {
                GroupEntry groupEntry = ((Activation)object).getGroupEntry(this.id);
                groupEntry.incarnation = this.inc;
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID activationGroupID) {
            this.id = activationGroupID;
        }

        Object apply(Object object) {
            GroupEntry groupEntry = (GroupEntry)((Activation)object).groupTable.remove(this.id);
            try {
                groupEntry.unregisterGroup(false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateGroupDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private ActivationID id;
        private ActivationDesc desc;

        LogUpdateDesc(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            Hashtable hashtable = ((Activation)object).groupTable;
            Activation activation = (Activation)object;
            activation.getClass();
            hashtable.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return object;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private ActivationID id;

        LogUnregisterObject(ActivationID activationID) {
            this.id = activationID;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).unregisterObject(this.id, false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private ActivationID id;
        private ActivationDesc desc;

        LogRegisterObject(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.desc.getGroupID()).registerObject(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogRegisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class ActLogHandler
    extends LogHandler {
        ActLogHandler() {
        }

        public Object initialSnapshot() {
            return new Activation();
        }

        public Object applyUpdate(Object object, Object object2) throws Exception {
            return ((LogRecord)object).apply(object2);
        }
    }

    private static class ObjectEntry
    implements Serializable {
        ActivationDesc desc;
        transient MarshalledObject stub = null;
        transient boolean removed = false;

        ObjectEntry(ActivationDesc activationDesc) {
            this.desc = activationDesc;
        }

        synchronized MarshalledObject activate(ActivationID activationID, boolean bl2, ActivationInstantiator activationInstantiator) throws RemoteException, ActivationException {
            MarshalledObject marshalledObject;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!bl2 && this.stub != null) {
                return this.stub;
            }
            this.stub = marshalledObject = activationInstantiator.newInstance(activationID, this.desc);
            return marshalledObject;
        }

        void reset() {
            this.stub = null;
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        static final int MAX_TRIES = 2;
        ActivationGroupDesc desc = null;
        ActivationGroupID groupID = null;
        long incarnation = 0L;
        HashMap objects = null;
        HashSet restartSet = null;
        transient ActivationInstantiator group = null;
        transient boolean pendingCreate = false;
        transient Process child = null;
        transient boolean removed = false;
        transient RestartThread restartThread = null;

        GroupEntry(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.groupID = activationGroupID;
            this.desc = activationGroupDesc;
            this.objects = new HashMap(11);
            this.restartSet = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void restartServices() {
            Iterator iterator = null;
            GroupEntry groupEntry = this;
            synchronized (groupEntry) {
                if (this.restartSet.size() == 0) {
                    return;
                }
                iterator = ((HashSet)this.restartSet.clone()).iterator();
            }
            while (iterator.hasNext()) {
                ActivationID activationID = (ActivationID)iterator.next();
                try {
                    this.activate(activationID, true);
                }
                catch (Exception exception) {
                    System.err.println("\nrmid: unable to restart service");
                    System.err.println("rmid: exception occurred: " + exception.getMessage());
                    exception.printStackTrace(System.err);
                }
            }
        }

        synchronized void activeGroup(ActivationInstantiator activationInstantiator, long l2) throws ActivationException, UnknownGroupException {
            if (this.child != null && !this.pendingCreate) {
                throw new ActivationException("group not being created");
            }
            if (this.incarnation != l2) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                throw new ActivationException("group already active");
            }
            this.group = activationInstantiator;
            this.pendingCreate = false;
            this.notifyAll();
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("Group removed");
            }
        }

        synchronized void registerObject(ActivationID activationID, ActivationDesc activationDesc, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.objects.put(activationID, new ObjectEntry(activationDesc));
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            }
            Activation.this.idTable.put(activationID, this.groupID);
            if (bl2) {
                Activation.this.addLogRecord(new LogRegisterObject(activationID, activationDesc));
            }
        }

        synchronized void unregisterObject(ActivationID activationID, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.remove(activationID);
            objectEntry.removed = true;
            if (objectEntry.desc.getRestartMode()) {
                this.restartSet.remove(activationID);
                if (this.restartSet.size() == 0) {
                    this.disposeRestartThread();
                }
            }
            Activation.this.idTable.remove(activationID);
            if (bl2) {
                Activation.this.addLogRecord(new LogUnregisterObject(activationID));
            }
        }

        synchronized void unregisterGroup(boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.removed = true;
            Iterator iterator = this.objects.keySet().iterator();
            while (iterator.hasNext()) {
                ActivationID activationID = (ActivationID)iterator.next();
                Activation.this.idTable.remove(activationID);
                ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
                objectEntry.removed = true;
            }
            this.objects.clear();
            this.restartSet.clear();
            this.disposeRestartThread();
            if (bl2) {
                Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
            }
            if (this.pendingCreate) {
                this.notifyAll();
            }
        }

        synchronized ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc, boolean bl2) throws UnknownObjectException, UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            ActivationDesc activationDesc2 = objectEntry.desc;
            objectEntry.desc = activationDesc;
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            } else {
                this.restartSet.remove(activationID);
            }
            if (bl2) {
                Activation.this.addLogRecord(new LogUpdateDesc(activationID, activationDesc));
            }
            return activationDesc2;
        }

        synchronized ActivationDesc getActivationDesc(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objectEntry.desc;
        }

        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, boolean bl2) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ActivationGroupDesc activationGroupDesc2 = this.desc;
            this.desc = activationGroupDesc;
            if (bl2) {
                Activation.this.addLogRecord(new LogUpdateGroupDesc(activationGroupID, activationGroupDesc));
            }
            return activationGroupDesc2;
        }

        synchronized void inactiveGroup(long l2) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != l2) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.disposeRestartThread();
            if (!this.pendingCreate) {
                this.reset();
            }
        }

        synchronized void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.stub = marshalledObject;
        }

        synchronized void inactiveObject(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.reset();
        }

        private synchronized void reset() {
            this.group = null;
            Iterator iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((ObjectEntry)iterator.next()).reset();
            }
        }

        private synchronized void resetAll() {
            this.reset();
            if (this.child != null) {
                this.child.destroy();
                this.child = null;
            }
        }

        void shutdownFast() {
            if (this.child != null) {
                this.child.destroy();
            }
        }

        synchronized void shutdown() {
            this.resetAll();
            this.disposeRestartThread();
        }

        private synchronized void disposeRestartThread() {
            if (this.restartThread != null) {
                this.restartThread.dispose();
                this.restartThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive exception aggregation
         */
        MarshalledObject activate(ActivationID activationID, boolean bl2) throws ActivationException {
            void var5_8;
            ObjectEntry objectEntry;
            GroupEntry groupEntry = this;
            synchronized (groupEntry) {
                objectEntry = (ObjectEntry)this.objects.get(activationID);
            }
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown " + activationID);
            }
            if (!bl2) {
                GroupEntry groupEntry2 = this;
                synchronized (groupEntry2) {
                    if (objectEntry.stub != null) {
                        MarshalledObject marshalledObject = objectEntry.stub;
                        return marshalledObject;
                    }
                }
            }
            Object var5_7 = null;
            Object var6_14 = null;
            int n2 = 2;
            while (n2 > 0) {
                long l2;
                boolean bl3;
                block24: {
                    ActivationInstantiator activationInstantiator;
                    bl3 = false;
                    GroupEntry groupEntry3 = this;
                    synchronized (groupEntry3) {
                        activationInstantiator = this.getInstantiator(this.groupID);
                        l2 = this.incarnation;
                    }
                    try {
                        return objectEntry.activate(activationID, bl2, activationInstantiator);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        bl3 = true;
                        if (var5_8 == null) {
                            NoSuchObjectException noSuchObjectException2 = noSuchObjectException;
                        }
                    }
                    catch (ConnectException connectException) {
                        bl3 = true;
                        if (var5_8 == null) {
                            ConnectException connectException2 = connectException;
                        }
                    }
                    catch (ConnectIOException connectIOException) {
                        bl3 = true;
                        if (var5_8 == null) {
                            ConnectIOException connectIOException2 = connectIOException;
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (var5_8 != null) break block24;
                        RemoteException remoteException2 = remoteException;
                    }
                }
                if (bl3) {
                    try {
                        bl3 = false;
                        Activation.this.monitor.inactiveGroup(this.groupID, l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                --n2;
            }
            throw new ActivationException("group creation failed after 2 tries", (Throwable)var5_8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized ActivationInstantiator getInstantiator(ActivationGroupID activationGroupID) throws UnknownGroupException, ActivationException {
            boolean bl2;
            block15: {
                this.checkRemoved();
                bl2 = false;
                boolean bl3 = false;
                if (this.group != null) {
                    return this.group;
                }
                try {
                    if (!this.pendingCreate) {
                        String[] stringArray = Activation.this.activationArgs(this.desc);
                        Activation.this.checkArgs(this.desc, stringArray);
                        this.resetAll();
                        this.pendingCreate = true;
                        try {
                            Object object;
                            try {
                                Activation.Pstartgroup();
                                bl2 = true;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (debugExec) {
                                object = new StringBuffer(stringArray[0]);
                                int n2 = 1;
                                while (true) {
                                    if (n2 >= stringArray.length) {
                                        System.err.println("rmid: debugExec: running \"" + ((StringBuffer)object).toString() + "\"");
                                        break;
                                    }
                                    ((StringBuffer)object).append(' ');
                                    ((StringBuffer)object).append(stringArray[n2]);
                                    ++n2;
                                }
                            }
                            this.child = Runtime.getRuntime().exec(stringArray);
                            ++this.incarnation;
                            this.ensureRestart();
                            object = this.child.getOutputStream();
                            MarshalOutputStream marshalOutputStream = new MarshalOutputStream((OutputStream)object);
                            marshalOutputStream.writeObject(activationGroupID);
                            marshalOutputStream.writeObject(this.desc);
                            marshalOutputStream.writeLong(this.incarnation);
                            marshalOutputStream.flush();
                            marshalOutputStream.close();
                            PipeWriter.plugTogetherPair(this.child.getInputStream(), System.out, this.child.getErrorStream(), System.err);
                            Activation.this.addLogRecord(new LogGroupIncarnation(activationGroupID, this.incarnation));
                        }
                        catch (IOException iOException) {
                            this.pendingCreate = false;
                            this.resetAll();
                            throw new ActivationException("unable to create activation group", iOException);
                        }
                    }
                    try {
                        this.wait(execTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.group == null) {
                        this.pendingCreate = false;
                        this.resetAll();
                        throw new ActivationException("timeout creating child process");
                    }
                    Object var8_11 = null;
                    if (!bl2) break block15;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (bl2) {
                        Activation.Vstartgroup();
                    }
                    bl2 = false;
                    throw throwable;
                }
                Activation.Vstartgroup();
            }
            bl2 = false;
            return this.group;
        }

        private synchronized void ensureRestart() {
            Thread thread = null;
            if (this.restartSet.size() > 0) {
                this.restartThread = new RestartThread(this.child, this.incarnation);
                thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this.restartThread, "RMID RestartObjects-" + ++nextRestart, true));
                this.restartThread.setThread(thread);
                thread.start();
            }
        }

        private class RestartThread
        implements Runnable {
            Process groupProcess;
            long groupIncarnation;
            boolean canInterrupt = true;
            boolean shouldQuit = false;
            Thread thread;

            RestartThread(Process process, long l2) {
                this.groupProcess = process;
                this.groupIncarnation = l2;
            }

            void setThread(Thread thread) {
                this.thread = thread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    GroupEntry groupEntry = GroupEntry.this;
                    synchronized (groupEntry) {
                        if (this.groupIncarnation == GroupEntry.this.incarnation) {
                            GroupEntry.this.reset();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                GroupEntry.this.restartServices();
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.thread.interrupt();
                }
            }
        }
    }

    private class ShutdownHook
    implements Runnable {
        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Activation.this.shuttingDown = true;
            Hashtable hashtable = Activation.this.groupTable;
            synchronized (hashtable) {
                Enumeration enumeration = Activation.this.groupTable.elements();
                while (enumeration.hasMoreElements()) {
                    GroupEntry groupEntry = (GroupEntry)enumeration.nextElement();
                    groupEntry.shutdownFast();
                }
            }
        }
    }

    class ActivationSystemImpl
    extends RemoteServer
    implements ActivationSystem {
        ActivationSystemImpl(int n2) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(4), n2);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerObject");
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            ActivationID activationID = new ActivationID(Activation.this.activatorStub);
            Activation.this.getGroupEntry(activationGroupID).registerObject(activationID, activationDesc, true);
            return activationID;
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterObject");
            ActivationGroupID activationGroupID = (ActivationGroupID)Activation.this.idTable.get(activationID);
            if (activationGroupID == null) {
                throw new UnknownObjectException("object not registered");
            }
            Activation.this.getGroupEntry(activationGroupID).unregisterObject(activationID, true);
        }

        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerGroup");
            Activation.this.checkArgs(activationGroupDesc, null);
            ActivationGroupID activationGroupID = new ActivationGroupID(Activation.this.systemStub);
            GroupEntry groupEntry = new GroupEntry(activationGroupID, activationGroupDesc);
            Activation.this.groupTable.put(activationGroupID, groupEntry);
            Activation.this.addLogRecord(new LogRegisterGroup(activationGroupID, activationGroupDesc));
            return activationGroupID;
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l2) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.activeGroup");
            Activation.this.getGroupEntry(activationGroupID).activeGroup(activationInstantiator, l2);
            return Activation.this.monitor;
        }

        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterGroup");
            GroupEntry groupEntry = (GroupEntry)Activation.this.groupTable.remove(activationGroupID);
            if (groupEntry == null) {
                throw new UnknownGroupException("unknown group: " + activationGroupID);
            }
            groupEntry.unregisterGroup(true);
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            if (!Activation.this.getGroupID(activationID).equals(activationDesc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            RegistryImpl.checkAccess("ActivationSystem.setActivationDesc");
            return Activation.this.getGroupEntry(activationID).setActivationDesc(activationID, activationDesc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationGroupDesc");
            Activation.this.checkArgs(activationGroupDesc, null);
            return Activation.this.getGroupEntry(activationGroupID).setActivationGroupDesc(activationGroupID, activationGroupDesc, true);
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationDesc");
            return Activation.this.getGroupEntry(activationID).getActivationDesc(activationID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationGroupDesc");
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)activationGroupID).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws AccessException {
            RegistryImpl.checkAccess("ActivationSystem.shutdown");
            Object object = Activation.this.startupLock;
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                }
            }
            Activation.this.shutdownAll();
        }
    }

    class ActivationMonitorImpl
    extends UnicastRemoteObject
    implements ActivationMonitor {
        ActivationMonitorImpl(int n2) throws RemoteException {
            super(n2);
        }

        public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("Activator.inactiveObject");
            try {
                Activation.this.getGroupEntry(activationID).inactiveObject(activationID);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }

        public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationSystem.activeObject");
            try {
                Activation.this.getGroupEntry(activationID).activeObject(activationID, marshalledObject);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }

        public void inactiveGroup(ActivationGroupID activationGroupID, long l2) throws UnknownGroupException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationMonitor.inactiveGroup");
            GroupEntry groupEntry = Activation.this.getGroupEntry(activationGroupID);
            groupEntry.inactiveGroup(l2);
        }
    }

    class ActivatorImpl
    extends RemoteServer
    implements Activator {
        ActivatorImpl(int n2) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(1), n2);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public MarshalledObject activate(ActivationID activationID, boolean bl2) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            return Activation.this.getGroupEntry(activationID).activate(activationID, bl2);
        }
    }
}

