/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.AccessController;
import sun.net.NetworkClient;
import sun.net.TransferProtocolClient;
import sun.net.smtp.SmtpPrintStream;
import sun.net.smtp.SmtpProtocolException;
import sun.security.action.GetPropertyAction;

public class SmtpClient
extends TransferProtocolClient {
    String mailhost;
    SmtpPrintStream message;

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    void issueCommand(String string, int n2) throws IOException {
        int n3;
        this.sendServer(string);
        while ((n3 = this.readServerResponse()) != n2) {
            if (n3 == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }

    private void toCanonical(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("rcpt to: " + string + "\r\n", 250);
        } else {
            this.issueCommand("rcpt to: <" + string + ">\r\n", 250);
        }
    }

    public void to(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        while (n4 < n3) {
            char c2 = string.charAt(n4);
            if (n6 > 0) {
                if (c2 == '(') {
                    ++n6;
                } else if (c2 == ')') {
                    --n6;
                }
                if (n6 == 0) {
                    if (n5 > n2) {
                        bl2 = true;
                    } else {
                        n2 = n4 + 1;
                    }
                }
            } else if (c2 == '(') {
                ++n6;
            } else if (c2 == '<') {
                n2 = n5 = n4 + 1;
            } else if (c2 == '>') {
                bl2 = true;
            } else if (c2 == ',') {
                if (n5 > n2) {
                    this.toCanonical(string.substring(n2, n5));
                }
                n2 = n4 + 1;
                bl2 = false;
            } else if (c2 > ' ' && !bl2) {
                n5 = n4 + 1;
            } else if (n2 == n4) {
                ++n2;
            }
            ++n4;
        }
        if (n5 > n2) {
            this.toCanonical(string.substring(n2, n5));
        }
    }

    public void from(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("mail from: " + string + "\r\n", 250);
        } else {
            this.issueCommand("mail from: <" + string + ">\r\n", 250);
        }
    }

    private void openServer(String string) throws IOException {
        this.mailhost = string;
        this.openServer(this.mailhost, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        try {
            this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(NetworkClient.encoding + " encoding not found");
        }
        return this.message;
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public SmtpClient(String string) throws IOException {
        if (string != null) {
            try {
                this.openServer(string);
                this.mailhost = string;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mailhost = (String)AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (this.mailhost != null) {
                this.openServer(this.mailhost);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mailhost = "localhost";
            this.openServer(this.mailhost);
        }
        catch (Exception exception) {
            this.mailhost = "mailhost";
            this.openServer(this.mailhost);
        }
    }

    public SmtpClient() throws IOException {
        this(null);
    }

    public String getMailHost() {
        return this.mailhost;
    }

    String getEncoding() {
        return NetworkClient.encoding;
    }
}

