/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.peer.ChoicePeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MChoiceMenu;

class MTinyChoicePeer
extends MCanvasPeer
implements ChoicePeer {
    MChoiceMenu menu;

    public MTinyChoicePeer(Choice choice) {
        super(choice);
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        Choice choice = (Choice)this.target;
        int n2 = 0;
        int n3 = choice.countItems();
        while (n3-- > 0) {
            n2 = Math.max(fontMetrics.stringWidth(choice.getItem(n3)), n2);
        }
        return new Dimension(n2 + 10 + 18, fontMetrics.getHeight() + 10);
    }

    public void paint(Graphics graphics) {
        Choice choice = (Choice)this.target;
        Dimension dimension = this.target.size();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        graphics.draw3DRect(dimension.width - 18, dimension.height / 2 - 3, 12, 6, true);
        graphics.setColor(Color.black);
        graphics.setFont(choice.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = choice.getSelectedItem();
        graphics.drawString(string, 5, (dimension.height + fontMetrics.getAscent()) / 2);
        this.target.paint(graphics);
    }

    protected void handleMouseDown(long l2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.target.isEnabled()) {
            return;
        }
        Dimension dimension = this.target.size();
        Choice choice = (Choice)this.target;
        String[] stringArray = new String[choice.countItems()];
        int n9 = 0;
        while (n9 < stringArray.length) {
            stringArray[n9] = choice.getItem(n9);
            ++n9;
        }
        Component component = this.target;
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        this.menu = new MChoiceMenu((Frame)component, this, n5, n6, dimension.width - 20, dimension.height, choice.getSelectedIndex(), stringArray);
        this.menu.show();
    }

    protected void handleMouseUp(long l2, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.target.isEnabled()) {
            return;
        }
        Choice choice = (Choice)this.target;
        choice.select(this.menu.selected);
        this.menu.hide();
        this.menu.dispose();
        this.menu = null;
        this.postEvent(new ItemEvent(choice, 701, choice.getSelectedItem(), 1));
    }

    protected void handleMouseDrag(long l2, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.target.isEnabled()) {
            return;
        }
        Rectangle rectangle = this.menu.bounds();
        Point point = new Point(n5 - rectangle.x, n6 - rectangle.y);
        this.menu.handleWindowEvent(new Event(this.target, l2, 506, point.x, point.y, 0, n7, null));
    }

    public void select(int n2) {
        this.target.repaint();
    }

    public void add(String string, int n2) {
        this.target.repaint();
    }

    public void remove(int n2) {
        System.out.println("Method remove(int) not implemented yet.");
    }

    public void removeAll() {
        System.out.println("Method removeAll() not implemented yet.");
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void addItem(String string, int n2) {
        this.add(string, n2);
    }
}

