/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    int majorAxis;
    int majorSpan;
    int minorSpan;
    boolean majorReqValid;
    boolean minorReqValid;
    SizeRequirements majorRequest;
    SizeRequirements minorRequest;
    boolean majorAllocValid;
    int[] majorOffsets;
    int[] majorSpans;
    boolean minorAllocValid;
    int[] minorOffsets;
    int[] minorSpans;
    Rectangle tempRect = new Rectangle();

    public BoxView(Element element, int n2) {
        super(element);
        this.majorAxis = n2;
        this.majorOffsets = new int[0];
        this.majorSpans = new int[0];
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = new int[0];
        this.minorSpans = new int[0];
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    public int getAxis() {
        return this.majorAxis;
    }

    public void setAxis(int n2) {
        boolean bl2 = n2 != this.majorAxis;
        this.majorAxis = n2;
        if (bl2) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int n2) {
        if (n2 == this.majorAxis) {
            this.majorAllocValid = false;
        } else {
            this.minorAllocValid = false;
        }
    }

    protected boolean isLayoutValid(int n2) {
        if (n2 == this.majorAxis) {
            return this.majorAllocValid;
        }
        return this.minorAllocValid;
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n2) {
        View view = this.getView(n2);
        view.paint(graphics, rectangle);
    }

    public void replace(int n2, int n3, View[] viewArray) {
        super.replace(n2, n3, viewArray);
        int n4 = viewArray != null ? viewArray.length : 0;
        this.majorOffsets = this.updateLayoutArray(this.majorOffsets, n2, n4);
        this.majorSpans = this.updateLayoutArray(this.majorSpans, n2, n4);
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = this.updateLayoutArray(this.minorOffsets, n2, n4);
        this.minorSpans = this.updateLayoutArray(this.minorSpans, n2, n4);
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    int[] updateLayoutArray(int[] nArray, int n2, int n3) {
        int n4 = this.getViewCount();
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        System.arraycopy(nArray, n2, nArray2, n2 + n3, n4 - n3 - n2);
        return nArray2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl2 = this.isLayoutValid(this.majorAxis);
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (bl2 && !this.isLayoutValid(this.majorAxis)) {
            Container container = this.getContainer();
            if (shape != null && container != null) {
                int n2 = documentEvent.getOffset();
                int n3 = this.getViewIndexAtPosition(n2);
                Rectangle rectangle = this.getInsideAllocation(shape);
                if (this.majorAxis == 0) {
                    rectangle.x += this.majorOffsets[n3];
                    rectangle.width -= this.majorOffsets[n3];
                } else {
                    rectangle.y += this.minorOffsets[n3];
                    rectangle.height -= this.minorOffsets[n3];
                }
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void preferenceChanged(View view, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = this.majorAxis == 0 ? bl2 : bl3;
        boolean bl6 = bl4 = this.majorAxis == 0 ? bl3 : bl2;
        if (bl5) {
            this.majorReqValid = false;
            this.majorAllocValid = false;
        }
        if (bl4) {
            this.minorReqValid = false;
            this.minorAllocValid = false;
        }
        super.preferenceChanged(view, bl2, bl3);
    }

    public int getResizeWeight(int n2) {
        this.checkRequests(n2);
        if (n2 == this.majorAxis ? this.majorRequest.preferred != this.majorRequest.minimum || this.majorRequest.preferred != this.majorRequest.maximum : this.minorRequest.preferred != this.minorRequest.minimum || this.minorRequest.preferred != this.minorRequest.maximum) {
            return 1;
        }
        return 0;
    }

    void setSpanOnAxis(int n2, float f2) {
        if (n2 == this.majorAxis) {
            if (this.majorSpan != (int)f2) {
                this.majorAllocValid = false;
            }
            if (!this.majorAllocValid) {
                this.majorSpan = (int)f2;
                this.checkRequests(this.majorAxis);
                this.layoutMajorAxis(this.majorSpan, n2, this.majorOffsets, this.majorSpans);
                this.majorAllocValid = true;
                this.updateChildSizes();
            }
        } else {
            if ((int)f2 != this.minorSpan) {
                this.minorAllocValid = false;
            }
            if (!this.minorAllocValid) {
                this.minorSpan = (int)f2;
                this.checkRequests(n2);
                this.layoutMinorAxis(this.minorSpan, n2, this.minorOffsets, this.minorSpans);
                this.minorAllocValid = true;
                this.updateChildSizes();
            }
        }
    }

    void updateChildSizes() {
        int n2 = this.getViewCount();
        if (this.majorAxis == 0) {
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                view.setSize(this.majorSpans[n3], this.minorSpans[n3]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                View view = this.getView(n4);
                view.setSize(this.minorSpans[n4], this.majorSpans[n4]);
                ++n4;
            }
        }
    }

    float getSpanOnAxis(int n2) {
        if (n2 == this.majorAxis) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    public void setSize(float f2, float f3) {
        this.layout((int)(f2 - (float)this.getLeftInset() - (float)this.getRightInset()), (int)(f3 - (float)this.getTopInset() - (float)this.getBottomInset()));
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n2 = this.getViewCount();
        int n3 = rectangle.x + this.getLeftInset();
        int n4 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n5 = 0;
        while (n5 < n2) {
            this.tempRect.x = n3 + this.getOffset(0, n5);
            this.tempRect.y = n4 + this.getOffset(1, n5);
            this.tempRect.width = this.getSpan(0, n5);
            this.tempRect.height = this.getSpan(1, n5);
            if (this.tempRect.intersects(rectangle2)) {
                this.paintChild(graphics, this.tempRect, n5);
            }
            ++n5;
        }
    }

    public Shape getChildAllocation(int n2, Shape shape) {
        if (shape != null) {
            Shape shape2 = super.getChildAllocation(n2, shape);
            if (shape2 != null && !this.isAllocationValid()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (rectangle.width == 0 && rectangle.height == 0) {
                    return null;
                }
            }
            return shape2;
        }
        return null;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n2, shape, bias);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f2, f3, shape, biasArray);
    }

    public float getAlignment(int n2) {
        this.checkRequests(n2);
        if (n2 == this.majorAxis) {
            return this.majorRequest.alignment;
        }
        return this.minorRequest.alignment;
    }

    public float getPreferredSpan(int n2) {
        float f2;
        this.checkRequests(n2);
        float f3 = f2 = n2 == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n2 == this.majorAxis) {
            return (float)this.majorRequest.preferred + f2;
        }
        return (float)this.minorRequest.preferred + f2;
    }

    public float getMinimumSpan(int n2) {
        float f2;
        this.checkRequests(n2);
        float f3 = f2 = n2 == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n2 == this.majorAxis) {
            return (float)this.majorRequest.minimum + f2;
        }
        return (float)this.minorRequest.minimum + f2;
    }

    public float getMaximumSpan(int n2) {
        float f2;
        this.checkRequests(n2);
        float f3 = f2 = n2 == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n2 == this.majorAxis) {
            return (float)this.majorRequest.maximum + f2;
        }
        return (float)this.minorRequest.maximum + f2;
    }

    protected boolean isAllocationValid() {
        return this.majorAllocValid && this.minorAllocValid;
    }

    protected boolean isBefore(int n2, int n3, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n2 < rectangle.x;
        }
        return n3 < rectangle.y;
    }

    protected boolean isAfter(int n2, int n3, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n2 > rectangle.width + rectangle.x;
        }
        return n3 > rectangle.height + rectangle.y;
    }

    protected View getViewAtPoint(int n2, int n3, Rectangle rectangle) {
        int n4 = this.getViewCount();
        if (this.majorAxis == 0) {
            if (n2 < rectangle.x + this.majorOffsets[0]) {
                this.childAllocation(0, rectangle);
                return this.getView(0);
            }
            int n5 = 0;
            while (n5 < n4) {
                if (n2 < rectangle.x + this.majorOffsets[n5]) {
                    this.childAllocation(n5 - 1, rectangle);
                    return this.getView(n5 - 1);
                }
                ++n5;
            }
            this.childAllocation(n4 - 1, rectangle);
            return this.getView(n4 - 1);
        }
        if (n3 < rectangle.y + this.majorOffsets[0]) {
            this.childAllocation(0, rectangle);
            return this.getView(0);
        }
        int n6 = 0;
        while (n6 < n4) {
            if (n3 < rectangle.y + this.majorOffsets[n6]) {
                this.childAllocation(n6 - 1, rectangle);
                return this.getView(n6 - 1);
            }
            ++n6;
        }
        this.childAllocation(n4 - 1, rectangle);
        return this.getView(n4 - 1);
    }

    protected void childAllocation(int n2, Rectangle rectangle) {
        rectangle.x += this.getOffset(0, n2);
        rectangle.y += this.getOffset(1, n2);
        rectangle.width = this.getSpan(0, n2);
        rectangle.height = this.getSpan(1, n2);
    }

    protected void layout(int n2, int n3) {
        this.setSpanOnAxis(0, n2);
        this.setSpanOnAxis(1, n3);
    }

    public int getWidth() {
        int n2 = this.majorAxis == 0 ? this.majorSpan : this.minorSpan;
        return n2 += this.getLeftInset() - this.getRightInset();
    }

    public int getHeight() {
        int n2 = this.majorAxis == 1 ? this.majorSpan : this.minorSpan;
        return n2 += this.getTopInset() - this.getBottomInset();
    }

    protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            nArray2[n5] = (int)view.getPreferredSpan(n3);
            l4 += (long)nArray2[n5];
            l2 = (long)((float)l2 + view.getMinimumSpan(n3));
            l3 = (long)((float)l3 + view.getMaximumSpan(n3));
            ++n5;
        }
        long l5 = (long)n2 - l4;
        float f2 = 0.0f;
        if (l5 != 0L) {
            float f3;
            float f4 = f3 = l5 > 0L ? (float)(l3 - l4) : (float)(l4 - l2);
            if (f3 == 0.0f) {
                f2 = 0.0f;
            } else {
                f2 = (float)l5 / f3;
                f2 = Math.min(f2, 1.0f);
                f2 = Math.max(f2, -1.0f);
            }
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            View view = this.getView(n7);
            nArray[n7] = n6;
            int n8 = f2 > 0.0f ? (int)view.getMaximumSpan(n3) - nArray2[n7] : nArray2[n7] - (int)view.getMinimumSpan(n3);
            float f5 = f2 * (float)n8;
            f5 = f5 < 0.0f ? (f5 -= 0.5f) : (f5 += 0.5f);
            int n9 = (int)f5;
            int n10 = n7;
            nArray2[n10] = nArray2[n10] + n9;
            n6 = (int)Math.min((long)n6 + (long)nArray2[n7], Integer.MAX_VALUE);
            ++n7;
        }
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            int n6 = (int)view.getMinimumSpan(n3);
            int n7 = (int)view.getMaximumSpan(n3);
            if (n7 < n2) {
                float f2 = view.getAlignment(n3);
                nArray[n5] = (int)((float)(n2 - n7) * f2);
                nArray2[n5] = n7;
            } else {
                nArray[n5] = 0;
                nArray2[n5] = Math.max(n6, n2);
            }
            ++n5;
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            f2 += view.getMinimumSpan(n2);
            f3 += view.getPreferredSpan(n2);
            f4 += view.getMaximumSpan(n2);
            ++n4;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        sizeRequirements.minimum = (int)f2;
        sizeRequirements.preferred = (int)f3;
        sizeRequirements.maximum = (int)f4;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        int n3 = 0;
        long l2 = 0L;
        int n4 = Integer.MAX_VALUE;
        int n5 = this.getViewCount();
        int n6 = 0;
        while (n6 < n5) {
            View view = this.getView(n6);
            n3 = Math.max((int)view.getMinimumSpan(n2), n3);
            l2 = Math.max((long)((int)view.getPreferredSpan(n2)), l2);
            n4 = Math.max((int)view.getMaximumSpan(n2), n4);
            ++n6;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
            sizeRequirements.alignment = 0.5f;
        }
        sizeRequirements.preferred = (int)l2;
        sizeRequirements.minimum = n3;
        sizeRequirements.maximum = n4;
        return sizeRequirements;
    }

    void checkRequests(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n2);
        }
        if (n2 == this.majorAxis) {
            if (!this.majorReqValid) {
                this.majorRequest = this.calculateMajorAxisRequirements(n2, this.majorRequest);
                this.majorReqValid = true;
            }
        } else if (!this.minorReqValid) {
            this.minorRequest = this.calculateMinorAxisRequirements(n2, this.minorRequest);
            this.minorReqValid = true;
        }
    }

    protected void baselineLayout(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = (int)((float)n2 * this.getAlignment(n3));
        int n5 = n2 - n4;
        int n6 = this.getViewCount();
        int n7 = 0;
        while (n7 < n6) {
            View view = this.getView(n7);
            float f2 = view.getAlignment(n3);
            int n8 = (int)view.getPreferredSpan(n3);
            int n9 = (int)((float)n8 * f2);
            int n10 = n8 - n9;
            if (n8 > n2) {
                if ((int)view.getMinimumSpan(n3) < n8) {
                    n9 = n4;
                    n10 = n5;
                } else if (view.getResizeWeight(n3) > 0 && view.getMaximumSpan(n3) != (float)n8) {
                    throw new Error("should not happen: " + view.getClass());
                }
            } else if (n8 < n2 && (int)view.getMaximumSpan(n3) > n8) {
                n9 = n4;
                n10 = n5;
            }
            nArray[n7] = n4 - n9;
            nArray2[n7] = n9 + n10;
            ++n7;
        }
    }

    protected SizeRequirements baselineRequirements(int n2, SizeRequirements sizeRequirements) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getViewCount();
        int n7 = 0;
        while (n7 < n6) {
            View view = this.getView(n7);
            int n8 = (int)view.getPreferredSpan(n2);
            int n9 = (int)(view.getAlignment(n2) * (float)n8);
            int n10 = n8 - n9;
            n3 = Math.max(n10, n3);
            n4 = Math.max(n9, n4);
            n5 += view.getResizeWeight(n2);
            ++n7;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.preferred = n3 + n4;
        if (n5 != 0) {
            sizeRequirements.maximum = Integer.MAX_VALUE;
            sizeRequirements.minimum = 0;
        } else {
            sizeRequirements.maximum = sizeRequirements.preferred;
            sizeRequirements.minimum = sizeRequirements.preferred;
        }
        sizeRequirements.alignment = sizeRequirements.preferred > 0 ? (float)n4 / (float)sizeRequirements.preferred : 0.5f;
        return sizeRequirements;
    }

    protected int getOffset(int n2, int n3) {
        int[] nArray = n2 == this.majorAxis ? this.majorOffsets : this.minorOffsets;
        return nArray[n3];
    }

    protected int getSpan(int n2, int n3) {
        int[] nArray = n2 == this.majorAxis ? this.majorSpans : this.minorSpans;
        return nArray[n3];
    }

    protected boolean flipEastAndWestAtEnds(int n2, Position.Bias bias) {
        View view;
        int n3;
        int n4;
        if (this.majorAxis == 1 && (n4 = this.getViewIndexAtPosition(n3 = bias == Position.Bias.Backward ? Math.max(0, n2 - 1) : n2)) != -1 && (view = this.getView(n4)) != null && view instanceof CompositeView) {
            return ((CompositeView)view).flipEastAndWestAtEnds(n2, bias);
        }
        return false;
    }
}

