/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.OutputStreamHook;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.rmi.CORBA.Util;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPOutputStream
extends OutputStreamHook {
    private static final byte kFormatVersionOne = 1;
    private OutputStream orbStream;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack classDescStack = new Stack();
    private Object[] writeObjectArglist = new Object[]{this};
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
    }

    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final void writeObjectDelegate(Object object) {
        Util.writeAbstractObject(this.orbStream, object);
    }

    public final void writeObjectOverride(Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleWriteObject(Object object) {
        Object object2 = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleWriteDepth;
        try {
            try {
                this.outputObject(object);
            }
            catch (IOException iOException) {
                if (this.abortIOException == null) {
                    this.abortIOException = iOException;
                }
                Object var6_5 = null;
                --this.simpleWriteDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
            }
            Object var6_4 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            throw throwable;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleWriteDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            IIOPOutputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPOutputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
        }
    }

    ObjectStreamField[] getFieldsNoCopy() {
        return this.currentClassDesc.getFieldsNoCopy();
    }

    public final void defaultWriteObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultWriteObjectDelegate");
            }
            ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
            if (objectStreamFieldArray.length > 0) {
                this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            }
        }
        catch (IOException iOException) {
            IIOPOutputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPOutputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean bl2) {
        return false;
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    public final void close() throws IOException {
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    protected final Object replaceObject(Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, n2, n3);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n2) throws IOException {
        try {
            this.orbStream.write_octet((byte)(n2 & 0xFF));
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl2) throws IOException {
        try {
            this.orbStream.write_boolean(bl2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n2) throws IOException {
        try {
            this.orbStream.write_octet((byte)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n2) throws IOException {
        try {
            this.orbStream.write_wchar((char)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeDouble(double d2) throws IOException {
        try {
            this.orbStream.write_double(d2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f2) throws IOException {
        try {
            this.orbStream.write_float(f2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n2) throws IOException {
        try {
            this.orbStream.write_long(n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l2) throws IOException {
        try {
            this.orbStream.write_longlong(l2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n2) throws IOException {
        try {
            this.orbStream.write_short((short)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream outputStream, String string) {
        outputStream.write_wstring(string);
    }

    public final void writeUTF(String string) throws IOException {
        try {
            this.internalWriteUTF(this.orbStream, string);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    private boolean checkSpecialClasses(Object object) throws IOException {
        if (object instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object object) throws IOException {
        if (object instanceof String) {
            this.orbStream.write_value((Serializable)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputObject(Object object) throws IOException {
        this.currentObject = object;
        Class clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            this.writeByte(1);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
        } else {
            int n2 = this.classDescStack.size();
            try {
                ObjectStreamClass objectStreamClass;
                while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = objectStreamClass;
                }
                do {
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.invokeObjectWriter(object, this.currentClassDesc.forClass());
                    } else {
                        this.defaultWriteObjectDelegate();
                    }
                    if (this.classDescStack.size() <= n2) break;
                } while ((this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.classDescStack.setSize(n2);
                throw throwable;
            }
            this.classDescStack.setSize(n2);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeObjectWriter(Object object, Class clazz) throws IOException {
        try {
            try {
                this.writeByte(1);
                this.writeBoolean(true);
                IIOPOutputStream.writeObject(object, clazz, this);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("invokeObjectWriter interal error");
            }
            catch (IllegalAccessException illegalAccessException) {
                Object var6_4 = null;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    void writeField(ObjectStreamField objectStreamField, Object object) throws IOException {
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                if (object == null) {
                    this.orbStream.write_octet((byte)0);
                    break;
                }
                this.orbStream.write_octet((Byte)object);
                break;
            }
            case 'C': {
                if (object == null) {
                    this.orbStream.write_wchar('\u0000');
                    break;
                }
                this.orbStream.write_wchar(((Character)object).charValue());
                break;
            }
            case 'F': {
                if (object == null) {
                    this.orbStream.write_float(0.0f);
                    break;
                }
                this.orbStream.write_float(((Float)object).floatValue());
                break;
            }
            case 'D': {
                if (object == null) {
                    this.orbStream.write_double(0.0);
                    break;
                }
                this.orbStream.write_double((Double)object);
                break;
            }
            case 'I': {
                if (object == null) {
                    this.orbStream.write_long(0);
                    break;
                }
                this.orbStream.write_long((Integer)object);
                break;
            }
            case 'J': {
                if (object == null) {
                    this.orbStream.write_longlong(0L);
                    break;
                }
                this.orbStream.write_longlong((Long)object);
                break;
            }
            case 'S': {
                if (object == null) {
                    this.orbStream.write_short((short)0);
                    break;
                }
                this.orbStream.write_short((Short)object);
                break;
            }
            case 'Z': {
                if (object == null) {
                    this.orbStream.write_boolean(false);
                    break;
                }
                this.orbStream.write_boolean((Boolean)object);
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectField(objectStreamField, object);
                break;
            }
            default: {
                throw new InvalidClassException(this.currentClassDesc.getName());
            }
        }
    }

    private void writeObjectField(ObjectStreamField objectStreamField, Object object) throws IOException {
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            Util.writeAny(this.orbStream, object);
        } else {
            Class clazz = objectStreamField.getType();
            int n2 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = IIOPOutputStream.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = IIOPOutputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n2 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    Util.writeRemoteObject(this.orbStream, object);
                    break;
                }
                case 1: {
                    Util.writeAbstractObject(this.orbStream, object);
                    break;
                }
                case 2: {
                    try {
                        this.orbStream.write_value((Serializable)object, clazz);
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        if (object instanceof Serializable) {
                            throw classCastException;
                        }
                        Utility.throwNotSerializableForCorba(object.getClass().getName());
                    }
                }
            }
        }
    }

    private void outputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        int n2 = 0;
        while (n2 < objectStreamFieldArray.length) {
            if (objectStreamFieldArray[n2].getField() == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[n2].getName());
            }
            switch (objectStreamFieldArray[n2].getTypeCode()) {
                case 'B': {
                    byte by = IIOPOutputStream.getByteFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_octet(by);
                    break;
                }
                case 'C': {
                    char c2 = IIOPOutputStream.getCharFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_wchar(c2);
                    break;
                }
                case 'F': {
                    float f2 = IIOPOutputStream.getFloatFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_float(f2);
                    break;
                }
                case 'D': {
                    double d2 = IIOPOutputStream.getDoubleFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_double(d2);
                    break;
                }
                case 'I': {
                    int n3 = IIOPOutputStream.getIntFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_long(n3);
                    break;
                }
                case 'J': {
                    long l2 = IIOPOutputStream.getLongFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_longlong(l2);
                    break;
                }
                case 'S': {
                    short s2 = IIOPOutputStream.getShortFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_short(s2);
                    break;
                }
                case 'Z': {
                    boolean bl2 = IIOPOutputStream.getBooleanFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.orbStream.write_boolean(bl2);
                    break;
                }
                case 'L': 
                case '[': {
                    Object object2 = IIOPOutputStream.getObjectFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz));
                    this.writeObjectField(objectStreamFieldArray[n2], object2);
                    break;
                }
                default: {
                    throw new InvalidClassException(clazz.getName());
                }
            }
            ++n2;
        }
    }

    private static native void throwExceptionType(Class var0, String var1);

    private static native Object getObjectFieldOpt(Object var0, long var1);

    private static native boolean getBooleanFieldOpt(Object var0, long var1);

    private static native byte getByteFieldOpt(Object var0, long var1);

    private static native char getCharFieldOpt(Object var0, long var1);

    private static native short getShortFieldOpt(Object var0, long var1);

    private static native int getIntFieldOpt(Object var0, long var1);

    private static native long getLongFieldOpt(Object var0, long var1);

    private static native float getFloatFieldOpt(Object var0, long var1);

    private static native double getDoubleFieldOpt(Object var0, long var1);

    private static native void writeObject(Object var0, Class var1, Object var2) throws InvocationTargetException, IllegalAccessException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

