/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry current;
    private int current_flags;
    private int avail;
    private int compressed_bytes;
    private boolean closed;

    private /* synthetic */ void finit$() {
        this.closed = false;
    }

    public ZipInputStream(InputStream in) {
        super(in, new Inflater(true));
        this.finit$();
    }

    public ZipEntry getNextEntry() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (this.current != null) {
            this.closeEntry();
        }
        if (this.in.read() != 80 || this.in.read() != 75) {
            return null;
        }
        int code = this.in.read();
        while (code == 1) {
            code = this.in.read();
            if (code != 2) {
                return null;
            }
            this.in.skip(16);
            int size = this.read4();
            this.in.skip(4);
            int fname_length = this.readu2();
            int extra_length = this.readu2();
            int fcomment_length = this.readu2();
            this.in.skip(12 + fname_length + extra_length + fcomment_length);
            if (this.in.read() != 80 || this.in.read() != 75) {
                return null;
            }
            code = this.in.read();
        }
        if (code == 5) {
            if (this.in.read() != 6) {
                return null;
            }
            this.in.skip(16);
            int comment_size = this.readu2();
            this.in.skip(comment_size);
            if (this.in.read() != 80 || this.in.read() != 75) {
                return null;
            }
            code = this.in.read();
        }
        if (code != 3 || this.in.read() != 4) {
            return null;
        }
        int ex_version = this.readu2();
        this.current_flags = this.readu2();
        int method = this.readu2();
        int modtime = this.readu2();
        int moddate = this.readu2();
        int crc = this.read4();
        int compressedSize = this.read4();
        int uncompressedSize = this.read4();
        int filenameLength = this.readu2();
        int extraLength = this.readu2();
        byte[] bname = new byte[filenameLength];
        this.readFully(bname);
        ZipEntry entry = this.createZipEntry(new String(bname, "8859_1"));
        if (extraLength > 0) {
            byte[] bextra = new byte[extraLength];
            this.readFully(bextra);
            entry.extra = bextra;
        }
        entry.compressedSize = compressedSize;
        entry.size = uncompressedSize;
        entry.crc = (long)crc & 0xFFFFFFFFL;
        entry.method = method;
        entry.time = ZipEntry.timeFromDOS(moddate, modtime);
        this.current = entry;
        this.avail = uncompressedSize;
        this.compressed_bytes = compressedSize;
        return entry;
    }

    protected void fill() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        int count = this.buf.length;
        if (count > this.compressed_bytes) {
            count = this.compressed_bytes;
        }
        this.len = this.in.read(this.buf, 0, count);
        if (this.len != -1) {
            this.compressed_bytes -= this.len;
            this.inf.setInput(this.buf, 0, this.len);
        }
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (len > this.avail) {
            len = this.avail;
        }
        if ((count = this.current.method == 8 ? super.read(b, off, len) : this.in.read(b, off, len)) == -1 || this.avail == 0) {
            this.inf.reset();
            count = -1;
        } else {
            this.avail -= count;
        }
        return count;
    }

    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (n > (long)this.avail) {
            n = this.avail;
        }
        long count = this.current.method == 8 ? super.skip(n) : this.in.skip(n);
        this.avail -= (int)count;
        return count;
    }

    public int available() {
        if (this.closed) {
            return 0;
        }
        return 1;
    }

    private void readFully(byte[] b) throws IOException {
        int count;
        int off = 0;
        for (int len = b.length; len > 0; len -= count) {
            count = this.in.read(b, off, len);
            if (count <= 0) {
                throw new EOFException(".zip archive ended prematurely");
            }
            off += count;
        }
    }

    private int readu2() throws IOException {
        int byte0 = this.in.read();
        int byte1 = this.in.read();
        if (byte0 < 0 || byte1 < 0) {
            throw new EOFException(".zip archive ended prematurely");
        }
        return (byte1 & 0xFF) << 8 | byte0 & 0xFF;
    }

    private int read4() throws IOException {
        int byte0 = this.in.read();
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        int byte3 = this.in.read();
        if (byte3 < 0) {
            throw new EOFException(".zip archive ended prematurely");
        }
        return ((byte3 & 0xFF) << 24) + ((byte2 & 0xFF) << 16) + ((byte1 & 0xFF) << 8) + (byte0 & 0xFF);
    }

    public void closeEntry() throws IOException {
        if (this.current != null) {
            if (this.avail > 0) {
                this.skip(this.avail);
            }
            if ((this.current_flags & 8) != 0) {
                int sig = this.read4();
                if (sig != 67324752) {
                    throw new ZipException("bad/missing magic number at end of .zip entry");
                }
                int crc = this.read4();
                int compressedSize = this.read4();
                int uncompressedSize = this.read4();
                if (this.current.compressedSize != (long)compressedSize || this.current.size != (long)uncompressedSize || this.current.crc != (long)crc) {
                    throw new ZipException("bad data descriptor at end of .zip entry");
                }
            }
            this.current = null;
            this.avail = 0;
        }
    }

    public void close() throws IOException {
        this.current = null;
        this.closed = true;
        super.close();
    }
}

