/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStore {
    private KeyStoreSpi keyStoreSpi;
    private Provider provider;
    private String type;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = type;
    }

    public static KeyStore getInstance(String type) throws KeyStoreException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty("KeyStore." + type);
            if (classname == null) continue;
            return KeyStore.getInstance(classname, type, p[i]);
        }
        throw new KeyStoreException(type);
    }

    public static KeyStore getInstance(String type, String provider) throws KeyStoreException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return KeyStore.getInstance(p.getProperty("KeyStore." + type), type, p);
    }

    private static KeyStore getInstance(String classname, String type, Provider provider) throws KeyStoreException {
        try {
            return new KeyStore((KeyStoreSpi)Class.forName(classname).newInstance(), provider, type);
        }
        catch (ClassNotFoundException cnfe) {
            throw new KeyStoreException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new KeyStoreException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new KeyStoreException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keyStoreSpi.engineGetKey(alias, password);
    }

    public final Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificateChain(alias);
    }

    public final Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificate(alias);
    }

    public final Date getCreationDate(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCreationDate(alias);
    }

    public final void setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(alias, key, password, chain);
    }

    public final void setKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(alias, key, chain);
    }

    public final void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.keyStoreSpi.engineSetCertificateEntry(alias, cert);
    }

    public final void deleteEntry(String alias) throws KeyStoreException {
        this.keyStoreSpi.engineDeleteEntry(alias);
    }

    public final Enumeration aliases() throws KeyStoreException {
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineContainsAlias(alias);
    }

    public final int size() throws KeyStoreException {
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineIsKeyEntry(alias);
    }

    public final boolean isCertificateEntry(String alias) throws KeyStoreException {
        return this.keyStoreSpi.engineIsCertificateEntry(alias);
    }

    public final String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificateAlias(cert);
    }

    public final void store(OutputStream stream, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineStore(stream, password);
    }

    public final void load(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(stream, password);
    }

    public static final String getDefaultType() {
        String tmp = Security.getProperty("keystore.type");
        if (tmp == null) {
            tmp = "jks";
        }
        return tmp;
    }
}

