/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

public class Socket {
    static SocketImplFactory factory;
    SocketImpl impl;

    protected Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
    }

    protected Socket(SocketImpl impl) throws SocketException {
        this.impl = impl;
    }

    public Socket(String host, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port, null, 0, true);
    }

    public Socket(InetAddress address, int port) throws IOException {
        this(address, port, null, 0, true);
    }

    public Socket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort, true);
    }

    public Socket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address, port, localAddr, localPort, true);
    }

    public Socket(String host, int port, boolean stream) throws IOException {
        this(InetAddress.getByName(host), port, null, 0, stream);
    }

    public Socket(InetAddress host, int port, boolean stream) throws IOException {
        this(host, port, null, 0, stream);
    }

    private Socket(InetAddress raddr, int rport, InetAddress laddr, int lport, boolean stream) throws IOException {
        this();
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(raddr.getHostName(), rport);
        }
        this.impl.create(stream);
        if (laddr != null) {
            this.impl.bind(laddr, lport);
        }
        if (raddr != null) {
            this.impl.connect(raddr, rport);
        }
    }

    public InetAddress getInetAddress() {
        if (this.impl != null) {
            return this.impl.getInetAddress();
        }
        return null;
    }

    public InetAddress getLocalAddress() {
        if (this.impl == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            addr = (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException e) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(addr.getHostName(), this.getLocalPort());
        }
        return addr;
    }

    public int getPort() {
        if (this.impl != null) {
            return this.impl.getPort();
        }
        return -1;
    }

    public int getLocalPort() {
        if (this.impl != null) {
            return this.impl.getLocalPort();
        }
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        if (this.impl != null) {
            return this.impl.getInputStream();
        }
        throw new IOException("Not connected");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.impl != null) {
            return this.impl.getOutputStream();
        }
        throw new IOException("Not connected");
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        this.impl.setOption(1, new Boolean(on));
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object on = this.impl.getOption(1);
        if (on instanceof Boolean) {
            return (Boolean)on;
        }
        throw new SocketException("Internal Error");
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("No socket created");
        }
        if (on) {
            if (linger < 0) {
                throw new IllegalArgumentException("SO_LINGER must be >= 0");
            }
            if (linger > 65535) {
                linger = 65535;
            }
            this.impl.setOption(128, new Integer(linger));
        } else {
            this.impl.setOption(128, new Boolean(false));
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object linger = this.impl.getOption(128);
        if (linger instanceof Integer) {
            return (Integer)linger;
        }
        return -1;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object timeout = this.impl.getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_SNDBUF value must be > 0");
        }
        this.impl.setOption(4097, new Integer(size));
    }

    public int getSendBufferSize() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object buf = this.impl.getOption(4097);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object buf = this.impl.getOption(4098);
        if (buf instanceof Integer) {
            return (Integer)buf;
        }
        throw new SocketException("Internal Error: Unexpected type");
    }

    public synchronized void close() throws IOException {
        if (this.impl != null) {
            this.impl.close();
        }
    }

    public String toString() {
        return "Socket " + this.impl;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("SocketImplFactory already defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        factory = fac;
    }
}

