/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public abstract class JarURLConnection
extends URLConnection {
    private final URL jarFileURL;
    protected URLConnection jarFileURLConnection;
    private final String element;
    static Hashtable conn_cache = new Hashtable();
    private Hashtable hdrHash;
    private Vector hdrVec;
    private boolean gotHeaders;

    private /* synthetic */ void finit$() {
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
        this.gotHeaders = false;
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.element;
    }

    public JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        this.finit$();
        String spec = url.getFile();
        int bang = spec.indexOf("!/", 0);
        if (bang == -1) {
            throw new MalformedURLException(url + ": No `!/' in spec.");
        }
        this.jarFileURL = new URL(spec.substring(0, bang));
        this.element = bang + 2 == spec.length() ? null : spec.substring(bang + 2);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.getUseCaches()) {
            this.jarFileURLConnection = (URLConnection)conn_cache.get(this.jarFileURL);
            if (this.jarFileURLConnection == null) {
                this.jarFileURLConnection = this.jarFileURL.openConnection();
                this.jarFileURLConnection.setUseCaches(true);
                this.jarFileURLConnection.connect();
                conn_cache.put(this.jarFileURL, this.jarFileURLConnection);
            }
        } else {
            this.jarFileURLConnection = this.jarFileURL.openConnection();
            this.jarFileURLConnection.connect();
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (this.element == null) {
            BufferedInputStream jar_is = new BufferedInputStream(this.jarFileURLConnection.getInputStream());
            return new JarInputStream(jar_is);
        }
        JarFile jarfile = null;
        try {
            jarfile = this.getJarFile();
        }
        catch (IOException x) {
            // empty catch block
        }
        if (jarfile != null) {
            return jarfile.getInputStream(jarfile.getEntry(this.element));
        }
        JarInputStream zis = new JarInputStream(this.jarFileURLConnection.getInputStream());
        ZipEntry ent = zis.getNextEntry();
        while (ent != null) {
            if (this.element.equals(ent.getName())) {
                int size = (int)ent.getSize();
                byte[] data = new byte[size];
                zis.read(data, 0, size);
                return new ByteArrayInputStream(data);
            }
            ent = zis.getNextEntry();
        }
        return null;
    }

    public JarEntry getJarEntry() throws IOException {
        JarFile jarfile = null;
        if (this.element == null) {
            return null;
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarEntry if doInput is false");
        }
        try {
            jarfile = this.getJarFile();
        }
        catch (IOException x) {
            // empty catch block
        }
        if (jarfile == null) {
            JarInputStream zis = new JarInputStream(this.jarFileURLConnection.getInputStream());
            ZipEntry ent = zis.getNextEntry();
            while (ent != null) {
                if (this.element.equals(ent.getName())) {
                    return new JarEntry(ent);
                }
                ent = zis.getNextEntry();
            }
        } else {
            return jarfile.getJarEntry(this.element);
        }
        return null;
    }

    public abstract JarFile getJarFile() throws IOException;

    public String getHeaderField(String name) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        return (String)this.hdrHash.get(name.toLowerCase());
    }

    public String getHeaderField(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return null;
    }

    private String getField(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(index + 1).trim();
        }
        return str;
    }

    private void getHeaders() throws IOException {
        if (this.gotHeaders) {
            return;
        }
        this.gotHeaders = true;
        this.connect();
        long len = this.element == null ? (long)this.jarFileURLConnection.getContentLength() : this.getJarEntry().getSize();
        String line = "Content-length: " + len;
        this.hdrVec.addElement(line);
        String key = this.getKey(line);
        this.hdrHash.put(key.toLowerCase(), Long.toString(len));
    }
}

