/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.io.Serializable;

public class TextField
extends TextComponent
implements Serializable {
    private static final long serialVersionUID = -2966288784432217853L;
    private int columns;
    private char echoChar;
    private ActionListener action_listeners;

    public TextField() {
        this("", 1);
    }

    public TextField(String text) {
        this(text, text.length());
    }

    public TextField(int columns) {
        this("", columns);
    }

    public TextField(String text, int columns) {
        super(text);
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + columns);
        }
        this.columns = columns;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        this.echoChar = echoChar;
        TextFieldPeer tfp = (TextFieldPeer)this.getPeer();
        if (tfp != null) {
            tfp.setEchoChar(echoChar);
        }
    }

    public void setEchoCharacter(char echoChar) {
        this.setEchoChar(echoChar);
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getColumns());
    }

    public Dimension getMinimumSize(int columns) {
        TextFieldPeer tfp = (TextFieldPeer)this.getPeer();
        if (tfp == null) {
            return null;
        }
        return tfp.getMinimumSize(columns);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize(this.getColumns());
    }

    public Dimension minimumSize(int columns) {
        return this.getMinimumSize(columns);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    public Dimension getPreferredSize(int columns) {
        TextFieldPeer tfp = (TextFieldPeer)this.getPeer();
        if (tfp == null) {
            return null;
        }
        return tfp.getPreferredSize(columns);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    public Dimension preferredSize(int columns) {
        return this.getPreferredSize(columns);
    }

    public void addNotify() {
        if (this.getPeer() != null) {
            return;
        }
        this.setPeer(this.getToolkit().createTextField(this));
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
        this.enableEvents(128);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    protected String paramString() {
        return this.getClass().getName() + "(columns=" + this.getColumns() + ",echoChar=" + this.getEchoChar();
    }
}

