/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EventListener;

public class Container
extends Component {
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    Dimension maxSize;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public int getComponentCount() {
        return this.ncomponents;
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        if (n < 0 || n >= this.ncomponents) {
            throw new ArrayIndexOutOfBoundsException("no such component");
        }
        return this.component[n];
    }

    public Component[] getComponents() {
        Component[] result = new Component[this.ncomponents];
        if (this.ncomponents > 0) {
            System.arraycopy(this.component, 0, result, 0, this.ncomponents);
        }
        return result;
    }

    public Insets getInsets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Insets insets() {
        return this.getInsets();
    }

    public Component add(Component comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    public Component add(String name, Component comp) {
        this.addImpl(comp, name, -1);
        return comp;
    }

    public Component add(Component comp, int index) {
        this.addImpl(comp, null, index);
        return comp;
    }

    public void add(Component comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    public void add(Component comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (index > this.ncomponents || index < 0 && index != -1 || comp instanceof Window || comp instanceof Container && ((Container)comp).isAncestorOf(this)) {
            throw new IllegalArgumentException();
        }
        if (comp.parent != null) {
            comp.parent.remove(comp);
        }
        comp.parent = this;
        if (this.peer != null) {
            comp.addNotify();
            if (comp.isLightweight()) {
                this.enableEvents(comp.eventMask);
            }
        }
        this.invalidate();
        if (this.component == null) {
            this.component = new Component[4];
        }
        if (this.ncomponents >= this.component.length) {
            int nl = this.component.length * 2;
            Component[] c = new Component[nl];
            System.arraycopy(this.component, 0, c, 0, this.ncomponents);
            this.component = c;
        }
        if (index == -1) {
            this.component[this.ncomponents++] = comp;
        } else {
            System.arraycopy(this.component, index, this.component, index + 1, this.ncomponents - index);
            this.component[index] = comp;
            ++this.ncomponents;
        }
        if (this.layoutMgr != null) {
            if (this.layoutMgr instanceof LayoutManager2) {
                LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
                lm2.addLayoutComponent(comp, constraints);
            } else if (constraints instanceof String) {
                this.layoutMgr.addLayoutComponent((String)constraints, comp);
            } else {
                this.layoutMgr.addLayoutComponent(null, comp);
            }
        }
        ContainerEvent ce = new ContainerEvent(this, 300, comp);
        this.getToolkit().getSystemEventQueue().postEvent(ce);
    }

    public void remove(int index) {
        Component r = this.component[index];
        r.removeNotify();
        System.arraycopy(this.component, index + 1, this.component, index, this.ncomponents - index - 1);
        this.component[--this.ncomponents] = null;
        this.invalidate();
        if (this.layoutMgr != null) {
            this.layoutMgr.removeLayoutComponent(r);
        }
        ContainerEvent ce = new ContainerEvent(this, 301, r);
        this.getToolkit().getSystemEventQueue().postEvent(ce);
    }

    public void remove(Component comp) {
        for (int i = 0; i < this.ncomponents; ++i) {
            if (this.component[i] != comp) continue;
            this.remove(i);
            break;
        }
    }

    public void removeAll() {
        while (this.ncomponents > 0) {
            this.remove(0);
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutMgr = mgr;
        this.invalidate();
    }

    public void doLayout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void layout() {
        this.doLayout();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        Container container = this;
        synchronized (container) {
            block3: {
                try {
                    if (this.isValid()) break block3;
                    this.validateTree();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    protected void validateTree() {
        if (this.valid) {
            return;
        }
        ContainerPeer cPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            cPeer = (ContainerPeer)this.peer;
            cPeer.beginValidate();
        }
        this.doLayout();
        for (int i = 0; i < this.ncomponents; ++i) {
            Component comp = this.component[i];
            if (comp.isValid()) continue;
            if (comp instanceof Container) {
                ((Container)comp).validateTree();
                continue;
            }
            this.component[i].validate();
        }
        this.valid = true;
        if (cPeer != null) {
            cPeer.endValidate();
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
    }

    public Dimension getPreferredSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.getLayoutAlignmentX(this);
        }
        return super.getAlignmentX();
    }

    public float getAlignmentY() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.getLayoutAlignmentY(this);
        }
        return super.getAlignmentY();
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        super.paint(g);
        this.visitChildren(g, GfxPaintVisitor.INSTANCE, true);
    }

    private void visitChildren(Graphics gfx, GfxVisitor visitor, boolean lightweightOnly) {
        for (int i = 0; i < this.ncomponents; ++i) {
            boolean applicable;
            Component comp = this.component[i];
            boolean bl = applicable = comp.isVisible() && (comp.isLightweight() || !lightweightOnly);
            if (!applicable) continue;
            this.visitChild(gfx, visitor, comp);
        }
    }

    private void visitChild(Graphics gfx, GfxVisitor visitor, Component comp) {
        Rectangle bounds = comp.getBounds();
        Rectangle clip = gfx.getClipBounds().intersection(bounds);
        if (clip.isEmpty()) {
            return;
        }
        Graphics gfx2 = gfx.create();
        gfx2.setClip(clip.x, clip.y, clip.width, clip.height);
        gfx2.translate(bounds.x, bounds.y);
        visitor.visit(comp, gfx2);
    }

    public void update(Graphics g) {
        super.update(g);
    }

    public void print(Graphics g) {
        super.print(g);
        this.visitChildren(g, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPrintAllVisitor.INSTANCE, true);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 301 && e.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    public synchronized void addContainerListener(ContainerListener l) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, l);
    }

    public synchronized void removeContainerListener(ContainerListener l) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Container.class$("java.awt.event.ContainerListener")) {
            return Component.getListenersImpl(listenerType, this.containerListener);
        }
        return super.getListeners(listenerType);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processContainerEvent(ContainerEvent e) {
        if (this.containerListener == null) {
            return;
        }
        switch (e.id) {
            case 300: {
                this.containerListener.componentAdded(e);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(e);
            }
        }
    }

    public void deliverEvent(Event e) {
    }

    public Component getComponentAt(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            int y2;
            int x2;
            if (!this.component[i].isVisible() || !this.component[i].contains(x2 = x - this.component[i].x, y2 = y - this.component[i].y)) continue;
            return this.component[i];
        }
        return this;
    }

    public Component locate(int x, int y) {
        return this.getComponentAt(x, y);
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public Component findComponentAt(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            if (!this.component[i].isVisible()) continue;
            int x2 = x - this.component[i].x;
            int y2 = y - this.component[i].y;
            if (this.component[i] instanceof Container) {
                Container k = (Container)this.component[i];
                Component r = k.findComponentAt(x2, y2);
                if (r == null) continue;
                return r;
            }
            if (!this.component[i].contains(x2, y2)) continue;
            return this.component[i];
        }
        return this;
    }

    public Component findComponentAt(Point p) {
        return this.findComponentAt(p.x, p.y);
    }

    public void addNotify() {
        this.addNotifyContainerChildren();
        super.addNotify();
    }

    private void addNotifyContainerChildren() {
        int i = this.ncomponents;
        while (--i >= 0) {
            this.component[i].addNotify();
            if (!this.component[i].isLightweight()) continue;
            this.enableEvents(this.component[i].eventMask);
        }
    }

    public void removeNotify() {
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].removeNotify();
        }
        super.removeNotify();
    }

    public boolean isAncestorOf(Component comp) {
        while (comp != null) {
            if (comp == this) {
                return true;
            }
            comp = comp.getParent();
        }
        return false;
    }

    protected String paramString() {
        String param = super.paramString();
        if (this.layoutMgr != null) {
            param = param + "," + this.layoutMgr.getClass().getName();
        }
        return param;
    }

    public void list(PrintStream out, int indent) {
        super.list(out, indent);
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].list(out, indent + 2);
        }
    }

    public void list(PrintWriter out, int indent) {
        super.list(out, indent);
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].list(out, indent + 2);
        }
    }

    Component findNextFocusComponent(Component child) {
        int end;
        int start;
        if (child != null) {
            for (start = 0; start < this.ncomponents && this.component[start] != child; ++start) {
            }
            end = start;
            if (end == 0) {
                end = this.ncomponents;
            }
            ++start;
        } else {
            start = 0;
            end = this.ncomponents;
        }
        for (int j = start; j != end; ++j) {
            if (j >= this.ncomponents) {
                if (this.parent != null) {
                    return this.parent.findNextFocusComponent(this);
                }
                j -= this.ncomponents;
            }
            if (this.component[j] instanceof Container) {
                Component c = this.component[j];
                if ((c = c.findNextFocusComponent(null)) == null) continue;
                return c;
            }
            if (!this.component[j].isFocusTraversable()) continue;
            return this.component[j];
        }
        return null;
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.printAll(gfx);
        }

        GfxPrintAllVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paintAll(gfx);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.print(gfx);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paint(gfx);
        }

        GfxPaintVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }
}

