#include <stdio.h>
#include <trace.h>

/***************************************************************************
 * 
 * Function:      gets
 *
 * Description:
 *    Read a string from the stdin file. The string is terminated by a '\n'
 *    character when read from the input. The newline character is not
 *    placed into the buffer. A nul character is appended.
 *
 * Entry:
 *    pszString   - Pointer to the input string
 *
 * Returns:
 *    A pointer to the string or NULL to indicate an error condition.
 */

char *gets (char *pszString)
    {
    int  nChar;
    char *pchNext = pszString;
/*
 *  Fetch the next character.
 */
    FUNC_ENTRY ("gets");
    nChar = getchar();
    for (;;)
        {
/*
 *  If the character is EOF then look for EOF on the first character.
 *  The EOF sequence is only returned when this is the first character.
 */
	if (nChar == EOF)
	    {
	    if (pchNext == pszString)
	        {
		pszString = NULL;
	        }
	    break;
	    }
/*
 *  A newline terminates the input sequence.
 */
	if (nChar == '\n')
	    {
	    break;
	    }
/*
 *  Store the next character and continue.
 */
	*pchNext++ = (char) nChar;
        }
/*
 *  Append the trailing nul to the string
 */
    *pchNext = '\0';
/*
 *  Return the pointer to the string or NULL for error.
 */
    FUNC_EXIT ("gets");
    return (pszString);
    }
