/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.khronos.org/registry/webgl/specs/latest/webgl.idl
 *
 * Copyright © 2012 Khronos Group
 */

 // AUTOGENERATED FILE -- DO NOT EDIT -- SEE Makefile
//
// WebGL IDL definitions scraped from the Khronos specification:
// https://www.khronos.org/registry/webgl/specs/latest/
//
// This IDL depends on the typed array specification defined at:
// https://www.khronos.org/registry/typedarray/specs/latest/typedarrays.idl

// XXXbz all sorts of forward declarations for things that are not new
// bindings yet.
interface Event;
interface HTMLCanvasElement;
interface HTMLImageElement;
interface HTMLVideoElement;
interface ImageData;
interface WebGLContextAttributes;
/*dictionary WebGLContextAttributes {
    boolean alpha = true;
    boolean depth = true;
    boolean stencil = false;
    boolean antialias = true;
    boolean premultipliedAlpha = true;
    boolean preserveDrawingBuffer = false;
    };*/

interface WebGLExtension;

interface WebGLBuffer;

interface WebGLFramebuffer;

interface WebGLProgram;

interface WebGLRenderbuffer;

interface WebGLShader;

interface WebGLTexture;

interface WebGLUniformLocation;

interface WebGLActiveInfo;

interface WebGLShaderPrecisionFormat;

interface WebGLRenderingContext {

    /* ClearBufferMask */
    const unsigned long DEPTH_BUFFER_BIT               = 0x00000100;
    const unsigned long STENCIL_BUFFER_BIT             = 0x00000400;
    const unsigned long COLOR_BUFFER_BIT               = 0x00004000;
    
    /* BeginMode */
    const unsigned long POINTS                         = 0x0000;
    const unsigned long LINES                          = 0x0001;
    const unsigned long LINE_LOOP                      = 0x0002;
    const unsigned long LINE_STRIP                     = 0x0003;
    const unsigned long TRIANGLES                      = 0x0004;
    const unsigned long TRIANGLE_STRIP                 = 0x0005;
    const unsigned long TRIANGLE_FAN                   = 0x0006;
    
    /* AlphaFunction (not supported in ES20) */
    /*      NEVER */
    /*      LESS */
    /*      EQUAL */
    /*      LEQUAL */
    /*      GREATER */
    /*      NOTEQUAL */
    /*      GEQUAL */
    /*      ALWAYS */
    
    /* BlendingFactorDest */
    const unsigned long ZERO                           = 0;
    const unsigned long ONE                            = 1;
    const unsigned long SRC_COLOR                      = 0x0300;
    const unsigned long ONE_MINUS_SRC_COLOR            = 0x0301;
    const unsigned long SRC_ALPHA                      = 0x0302;
    const unsigned long ONE_MINUS_SRC_ALPHA            = 0x0303;
    const unsigned long DST_ALPHA                      = 0x0304;
    const unsigned long ONE_MINUS_DST_ALPHA            = 0x0305;
    
    /* BlendingFactorSrc */
    /*      ZERO */
    /*      ONE */
    const unsigned long DST_COLOR                      = 0x0306;
    const unsigned long ONE_MINUS_DST_COLOR            = 0x0307;
    const unsigned long SRC_ALPHA_SATURATE             = 0x0308;
    /*      SRC_ALPHA */
    /*      ONE_MINUS_SRC_ALPHA */
    /*      DST_ALPHA */
    /*      ONE_MINUS_DST_ALPHA */
    
    /* BlendEquationSeparate */
    const unsigned long FUNC_ADD                       = 0x8006;
    const unsigned long BLEND_EQUATION                 = 0x8009;
    const unsigned long BLEND_EQUATION_RGB             = 0x8009;   /* same as BLEND_EQUATION */
    const unsigned long BLEND_EQUATION_ALPHA           = 0x883D;
    
    /* BlendSubtract */
    const unsigned long FUNC_SUBTRACT                  = 0x800A;
    const unsigned long FUNC_REVERSE_SUBTRACT          = 0x800B;
    
    /* Separate Blend Functions */
    const unsigned long BLEND_DST_RGB                  = 0x80C8;
    const unsigned long BLEND_SRC_RGB                  = 0x80C9;
    const unsigned long BLEND_DST_ALPHA                = 0x80CA;
    const unsigned long BLEND_SRC_ALPHA                = 0x80CB;
    const unsigned long CONSTANT_COLOR                 = 0x8001;
    const unsigned long ONE_MINUS_CONSTANT_COLOR       = 0x8002;
    const unsigned long CONSTANT_ALPHA                 = 0x8003;
    const unsigned long ONE_MINUS_CONSTANT_ALPHA       = 0x8004;
    const unsigned long BLEND_COLOR                    = 0x8005;
    
    /* Buffer Objects */
    const unsigned long ARRAY_BUFFER                   = 0x8892;
    const unsigned long ELEMENT_ARRAY_BUFFER           = 0x8893;
    const unsigned long ARRAY_BUFFER_BINDING           = 0x8894;
    const unsigned long ELEMENT_ARRAY_BUFFER_BINDING   = 0x8895;
    
    const unsigned long STREAM_DRAW                    = 0x88E0;
    const unsigned long STATIC_DRAW                    = 0x88E4;
    const unsigned long DYNAMIC_DRAW                   = 0x88E8;
    
    const unsigned long BUFFER_SIZE                    = 0x8764;
    const unsigned long BUFFER_USAGE                   = 0x8765;
    
    const unsigned long CURRENT_VERTEX_ATTRIB          = 0x8626;
    
    /* CullFaceMode */
    const unsigned long FRONT                          = 0x0404;
    const unsigned long BACK                           = 0x0405;
    const unsigned long FRONT_AND_BACK                 = 0x0408;
    
    /* DepthFunction */
    /*      NEVER */
    /*      LESS */
    /*      EQUAL */
    /*      LEQUAL */
    /*      GREATER */
    /*      NOTEQUAL */
    /*      GEQUAL */
    /*      ALWAYS */
    
    /* EnableCap */
    /* TEXTURE_2D */
    const unsigned long CULL_FACE                      = 0x0B44;
    const unsigned long BLEND                          = 0x0BE2;
    const unsigned long DITHER                         = 0x0BD0;
    const unsigned long STENCIL_TEST                   = 0x0B90;
    const unsigned long DEPTH_TEST                     = 0x0B71;
    const unsigned long SCISSOR_TEST                   = 0x0C11;
    const unsigned long POLYGON_OFFSET_FILL            = 0x8037;
    const unsigned long SAMPLE_ALPHA_TO_COVERAGE       = 0x809E;
    const unsigned long SAMPLE_COVERAGE                = 0x80A0;
    
    /* ErrorCode */
    const unsigned long NO_ERROR                       = 0;
    const unsigned long INVALID_ENUM                   = 0x0500;
    const unsigned long INVALID_VALUE                  = 0x0501;
    const unsigned long INVALID_OPERATION              = 0x0502;
    const unsigned long OUT_OF_MEMORY                  = 0x0505;
    
    /* FrontFaceDirection */
    const unsigned long CW                             = 0x0900;
    const unsigned long CCW                            = 0x0901;
    
    /* GetPName */
    const unsigned long LINE_WIDTH                     = 0x0B21;
    const unsigned long ALIASED_POINT_SIZE_RANGE       = 0x846D;
    const unsigned long ALIASED_LINE_WIDTH_RANGE       = 0x846E;
    const unsigned long CULL_FACE_MODE                 = 0x0B45;
    const unsigned long FRONT_FACE                     = 0x0B46;
    const unsigned long DEPTH_RANGE                    = 0x0B70;
    const unsigned long DEPTH_WRITEMASK                = 0x0B72;
    const unsigned long DEPTH_CLEAR_VALUE              = 0x0B73;
    const unsigned long DEPTH_FUNC                     = 0x0B74;
    const unsigned long STENCIL_CLEAR_VALUE            = 0x0B91;
    const unsigned long STENCIL_FUNC                   = 0x0B92;
    const unsigned long STENCIL_FAIL                   = 0x0B94;
    const unsigned long STENCIL_PASS_DEPTH_FAIL        = 0x0B95;
    const unsigned long STENCIL_PASS_DEPTH_PASS        = 0x0B96;
    const unsigned long STENCIL_REF                    = 0x0B97;
    const unsigned long STENCIL_VALUE_MASK             = 0x0B93;
    const unsigned long STENCIL_WRITEMASK              = 0x0B98;
    const unsigned long STENCIL_BACK_FUNC              = 0x8800;
    const unsigned long STENCIL_BACK_FAIL              = 0x8801;
    const unsigned long STENCIL_BACK_PASS_DEPTH_FAIL   = 0x8802;
    const unsigned long STENCIL_BACK_PASS_DEPTH_PASS   = 0x8803;
    const unsigned long STENCIL_BACK_REF               = 0x8CA3;
    const unsigned long STENCIL_BACK_VALUE_MASK        = 0x8CA4;
    const unsigned long STENCIL_BACK_WRITEMASK         = 0x8CA5;
    const unsigned long VIEWPORT                       = 0x0BA2;
    const unsigned long SCISSOR_BOX                    = 0x0C10;
    /*      SCISSOR_TEST */
    const unsigned long COLOR_CLEAR_VALUE              = 0x0C22;
    const unsigned long COLOR_WRITEMASK                = 0x0C23;
    const unsigned long UNPACK_ALIGNMENT               = 0x0CF5;
    const unsigned long PACK_ALIGNMENT                 = 0x0D05;
    const unsigned long MAX_TEXTURE_SIZE               = 0x0D33;
    const unsigned long MAX_VIEWPORT_DIMS              = 0x0D3A;
    const unsigned long SUBPIXEL_BITS                  = 0x0D50;
    const unsigned long RED_BITS                       = 0x0D52;
    const unsigned long GREEN_BITS                     = 0x0D53;
    const unsigned long BLUE_BITS                      = 0x0D54;
    const unsigned long ALPHA_BITS                     = 0x0D55;
    const unsigned long DEPTH_BITS                     = 0x0D56;
    const unsigned long STENCIL_BITS                   = 0x0D57;
    const unsigned long POLYGON_OFFSET_UNITS           = 0x2A00;
    /*      POLYGON_OFFSET_FILL */
    const unsigned long POLYGON_OFFSET_FACTOR          = 0x8038;
    const unsigned long TEXTURE_BINDING_2D             = 0x8069;
    const unsigned long SAMPLE_BUFFERS                 = 0x80A8;
    const unsigned long SAMPLES                        = 0x80A9;
    const unsigned long SAMPLE_COVERAGE_VALUE          = 0x80AA;
    const unsigned long SAMPLE_COVERAGE_INVERT         = 0x80AB;
    
    /* GetTextureParameter */
    /*      TEXTURE_MAG_FILTER */
    /*      TEXTURE_MIN_FILTER */
    /*      TEXTURE_WRAP_S */
    /*      TEXTURE_WRAP_T */
    
    const unsigned long COMPRESSED_TEXTURE_FORMATS     = 0x86A3;
    
    /* HintMode */
    const unsigned long DONT_CARE                      = 0x1100;
    const unsigned long FASTEST                        = 0x1101;
    const unsigned long NICEST                         = 0x1102;
    
    /* HintTarget */
    const unsigned long GENERATE_MIPMAP_HINT            = 0x8192;
    
    /* DataType */
    const unsigned long BYTE                           = 0x1400;
    const unsigned long UNSIGNED_BYTE                  = 0x1401;
    const unsigned long SHORT                          = 0x1402;
    const unsigned long UNSIGNED_SHORT                 = 0x1403;
    const unsigned long INT                            = 0x1404;
    const unsigned long UNSIGNED_INT                   = 0x1405;
    const unsigned long FLOAT                          = 0x1406;
    
    /* PixelFormat */
    const unsigned long DEPTH_COMPONENT                = 0x1902;
    const unsigned long ALPHA                          = 0x1906;
    const unsigned long RGB                            = 0x1907;
    const unsigned long RGBA                           = 0x1908;
    const unsigned long LUMINANCE                      = 0x1909;
    const unsigned long LUMINANCE_ALPHA                = 0x190A;
    
    /* PixelType */
    /*      UNSIGNED_BYTE */
    const unsigned long UNSIGNED_SHORT_4_4_4_4         = 0x8033;
    const unsigned long UNSIGNED_SHORT_5_5_5_1         = 0x8034;
    const unsigned long UNSIGNED_SHORT_5_6_5           = 0x8363;
    
    /* Shaders */
    const unsigned long FRAGMENT_SHADER                  = 0x8B30;
    const unsigned long VERTEX_SHADER                    = 0x8B31;
    const unsigned long MAX_VERTEX_ATTRIBS               = 0x8869;
    const unsigned long MAX_VERTEX_UNIFORM_VECTORS       = 0x8DFB;
    const unsigned long MAX_VARYING_VECTORS              = 0x8DFC;
    const unsigned long MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D;
    const unsigned long MAX_VERTEX_TEXTURE_IMAGE_UNITS   = 0x8B4C;
    const unsigned long MAX_TEXTURE_IMAGE_UNITS          = 0x8872;
    const unsigned long MAX_FRAGMENT_UNIFORM_VECTORS     = 0x8DFD;
    const unsigned long SHADER_TYPE                      = 0x8B4F;
    const unsigned long DELETE_STATUS                    = 0x8B80;
    const unsigned long LINK_STATUS                      = 0x8B82;
    const unsigned long VALIDATE_STATUS                  = 0x8B83;
    const unsigned long ATTACHED_SHADERS                 = 0x8B85;
    const unsigned long ACTIVE_UNIFORMS                  = 0x8B86;
    const unsigned long ACTIVE_ATTRIBUTES                = 0x8B89;
    const unsigned long SHADING_LANGUAGE_VERSION         = 0x8B8C;
    const unsigned long CURRENT_PROGRAM                  = 0x8B8D;
    
    /* StencilFunction */
    const unsigned long NEVER                          = 0x0200;
    const unsigned long LESS                           = 0x0201;
    const unsigned long EQUAL                          = 0x0202;
    const unsigned long LEQUAL                         = 0x0203;
    const unsigned long GREATER                        = 0x0204;
    const unsigned long NOTEQUAL                       = 0x0205;
    const unsigned long GEQUAL                         = 0x0206;
    const unsigned long ALWAYS                         = 0x0207;
    
    /* StencilOp */
    /*      ZERO */
    const unsigned long KEEP                           = 0x1E00;
    const unsigned long REPLACE                        = 0x1E01;
    const unsigned long INCR                           = 0x1E02;
    const unsigned long DECR                           = 0x1E03;
    const unsigned long INVERT                         = 0x150A;
    const unsigned long INCR_WRAP                      = 0x8507;
    const unsigned long DECR_WRAP                      = 0x8508;
    
    /* StringName */
    const unsigned long VENDOR                         = 0x1F00;
    const unsigned long RENDERER                       = 0x1F01;
    const unsigned long VERSION                        = 0x1F02;
    
    /* TextureMagFilter */
    const unsigned long NEAREST                        = 0x2600;
    const unsigned long LINEAR                         = 0x2601;
    
    /* TextureMinFilter */
    /*      NEAREST */
    /*      LINEAR */
    const unsigned long NEAREST_MIPMAP_NEAREST         = 0x2700;
    const unsigned long LINEAR_MIPMAP_NEAREST          = 0x2701;
    const unsigned long NEAREST_MIPMAP_LINEAR          = 0x2702;
    const unsigned long LINEAR_MIPMAP_LINEAR           = 0x2703;
    
    /* TextureParameterName */
    const unsigned long TEXTURE_MAG_FILTER             = 0x2800;
    const unsigned long TEXTURE_MIN_FILTER             = 0x2801;
    const unsigned long TEXTURE_WRAP_S                 = 0x2802;
    const unsigned long TEXTURE_WRAP_T                 = 0x2803;
    
    /* TextureTarget */
    const unsigned long TEXTURE_2D                     = 0x0DE1;
    const unsigned long TEXTURE                        = 0x1702;
    
    const unsigned long TEXTURE_CUBE_MAP               = 0x8513;
    const unsigned long TEXTURE_BINDING_CUBE_MAP       = 0x8514;
    const unsigned long TEXTURE_CUBE_MAP_POSITIVE_X    = 0x8515;
    const unsigned long TEXTURE_CUBE_MAP_NEGATIVE_X    = 0x8516;
    const unsigned long TEXTURE_CUBE_MAP_POSITIVE_Y    = 0x8517;
    const unsigned long TEXTURE_CUBE_MAP_NEGATIVE_Y    = 0x8518;
    const unsigned long TEXTURE_CUBE_MAP_POSITIVE_Z    = 0x8519;
    const unsigned long TEXTURE_CUBE_MAP_NEGATIVE_Z    = 0x851A;
    const unsigned long MAX_CUBE_MAP_TEXTURE_SIZE      = 0x851C;
    
    /* TextureUnit */
    const unsigned long TEXTURE0                       = 0x84C0;
    const unsigned long TEXTURE1                       = 0x84C1;
    const unsigned long TEXTURE2                       = 0x84C2;
    const unsigned long TEXTURE3                       = 0x84C3;
    const unsigned long TEXTURE4                       = 0x84C4;
    const unsigned long TEXTURE5                       = 0x84C5;
    const unsigned long TEXTURE6                       = 0x84C6;
    const unsigned long TEXTURE7                       = 0x84C7;
    const unsigned long TEXTURE8                       = 0x84C8;
    const unsigned long TEXTURE9                       = 0x84C9;
    const unsigned long TEXTURE10                      = 0x84CA;
    const unsigned long TEXTURE11                      = 0x84CB;
    const unsigned long TEXTURE12                      = 0x84CC;
    const unsigned long TEXTURE13                      = 0x84CD;
    const unsigned long TEXTURE14                      = 0x84CE;
    const unsigned long TEXTURE15                      = 0x84CF;
    const unsigned long TEXTURE16                      = 0x84D0;
    const unsigned long TEXTURE17                      = 0x84D1;
    const unsigned long TEXTURE18                      = 0x84D2;
    const unsigned long TEXTURE19                      = 0x84D3;
    const unsigned long TEXTURE20                      = 0x84D4;
    const unsigned long TEXTURE21                      = 0x84D5;
    const unsigned long TEXTURE22                      = 0x84D6;
    const unsigned long TEXTURE23                      = 0x84D7;
    const unsigned long TEXTURE24                      = 0x84D8;
    const unsigned long TEXTURE25                      = 0x84D9;
    const unsigned long TEXTURE26                      = 0x84DA;
    const unsigned long TEXTURE27                      = 0x84DB;
    const unsigned long TEXTURE28                      = 0x84DC;
    const unsigned long TEXTURE29                      = 0x84DD;
    const unsigned long TEXTURE30                      = 0x84DE;
    const unsigned long TEXTURE31                      = 0x84DF;
    const unsigned long ACTIVE_TEXTURE                 = 0x84E0;
    
    /* TextureWrapMode */
    const unsigned long REPEAT                         = 0x2901;
    const unsigned long CLAMP_TO_EDGE                  = 0x812F;
    const unsigned long MIRRORED_REPEAT                = 0x8370;
    
    /* Uniform Types */
    const unsigned long FLOAT_VEC2                     = 0x8B50;
    const unsigned long FLOAT_VEC3                     = 0x8B51;
    const unsigned long FLOAT_VEC4                     = 0x8B52;
    const unsigned long INT_VEC2                       = 0x8B53;
    const unsigned long INT_VEC3                       = 0x8B54;
    const unsigned long INT_VEC4                       = 0x8B55;
    const unsigned long BOOL                           = 0x8B56;
    const unsigned long BOOL_VEC2                      = 0x8B57;
    const unsigned long BOOL_VEC3                      = 0x8B58;
    const unsigned long BOOL_VEC4                      = 0x8B59;
    const unsigned long FLOAT_MAT2                     = 0x8B5A;
    const unsigned long FLOAT_MAT3                     = 0x8B5B;
    const unsigned long FLOAT_MAT4                     = 0x8B5C;
    const unsigned long SAMPLER_2D                     = 0x8B5E;
    const unsigned long SAMPLER_CUBE                   = 0x8B60;
    
    /* Vertex Arrays */
    const unsigned long VERTEX_ATTRIB_ARRAY_ENABLED        = 0x8622;
    const unsigned long VERTEX_ATTRIB_ARRAY_SIZE           = 0x8623;
    const unsigned long VERTEX_ATTRIB_ARRAY_STRIDE         = 0x8624;
    const unsigned long VERTEX_ATTRIB_ARRAY_TYPE           = 0x8625;
    const unsigned long VERTEX_ATTRIB_ARRAY_NORMALIZED     = 0x886A;
    const unsigned long VERTEX_ATTRIB_ARRAY_POINTER        = 0x8645;
    const unsigned long VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F;
    
    /* Shader Source */
    const unsigned long COMPILE_STATUS                 = 0x8B81;
    
    /* Shader Precision-Specified Types */
    const unsigned long LOW_FLOAT                      = 0x8DF0;
    const unsigned long MEDIUM_FLOAT                   = 0x8DF1;
    const unsigned long HIGH_FLOAT                     = 0x8DF2;
    const unsigned long LOW_INT                        = 0x8DF3;
    const unsigned long MEDIUM_INT                     = 0x8DF4;
    const unsigned long HIGH_INT                       = 0x8DF5;
    
    /* Framebuffer Object. */
    const unsigned long FRAMEBUFFER                    = 0x8D40;
    const unsigned long RENDERBUFFER                   = 0x8D41;
    
    const unsigned long RGBA4                          = 0x8056;
    const unsigned long RGB5_A1                        = 0x8057;
    const unsigned long RGB565                         = 0x8D62;
    const unsigned long DEPTH_COMPONENT16              = 0x81A5;
    const unsigned long STENCIL_INDEX                  = 0x1901;
    const unsigned long STENCIL_INDEX8                 = 0x8D48;
    const unsigned long DEPTH_STENCIL                  = 0x84F9;
    
    const unsigned long RENDERBUFFER_WIDTH             = 0x8D42;
    const unsigned long RENDERBUFFER_HEIGHT            = 0x8D43;
    const unsigned long RENDERBUFFER_INTERNAL_FORMAT   = 0x8D44;
    const unsigned long RENDERBUFFER_RED_SIZE          = 0x8D50;
    const unsigned long RENDERBUFFER_GREEN_SIZE        = 0x8D51;
    const unsigned long RENDERBUFFER_BLUE_SIZE         = 0x8D52;
    const unsigned long RENDERBUFFER_ALPHA_SIZE        = 0x8D53;
    const unsigned long RENDERBUFFER_DEPTH_SIZE        = 0x8D54;
    const unsigned long RENDERBUFFER_STENCIL_SIZE      = 0x8D55;
    
    const unsigned long FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE           = 0x8CD0;
    const unsigned long FRAMEBUFFER_ATTACHMENT_OBJECT_NAME           = 0x8CD1;
    const unsigned long FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL         = 0x8CD2;
    const unsigned long FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3;
    
    const unsigned long COLOR_ATTACHMENT0              = 0x8CE0;
    const unsigned long DEPTH_ATTACHMENT               = 0x8D00;
    const unsigned long STENCIL_ATTACHMENT             = 0x8D20;
    const unsigned long DEPTH_STENCIL_ATTACHMENT       = 0x821A;
    
    const unsigned long NONE                           = 0;
    
    const unsigned long FRAMEBUFFER_COMPLETE                      = 0x8CD5;
    const unsigned long FRAMEBUFFER_INCOMPLETE_ATTACHMENT         = 0x8CD6;
    const unsigned long FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7;
    const unsigned long FRAMEBUFFER_INCOMPLETE_DIMENSIONS         = 0x8CD9;
    const unsigned long FRAMEBUFFER_UNSUPPORTED                   = 0x8CDD;
    
    const unsigned long FRAMEBUFFER_BINDING            = 0x8CA6;
    const unsigned long RENDERBUFFER_BINDING           = 0x8CA7;
    const unsigned long MAX_RENDERBUFFER_SIZE          = 0x84E8;
    
    const unsigned long INVALID_FRAMEBUFFER_OPERATION  = 0x0506;
    
    /* WebGL-specific enums */
    const unsigned long UNPACK_FLIP_Y_WEBGL            = 0x9240;
    const unsigned long UNPACK_PREMULTIPLY_ALPHA_WEBGL = 0x9241;
    const unsigned long CONTEXT_LOST_WEBGL             = 0x9242;
    const unsigned long UNPACK_COLORSPACE_CONVERSION_WEBGL = 0x9243;
    const unsigned long BROWSER_DEFAULT_WEBGL          = 0x9244;

    readonly attribute HTMLCanvasElement canvas;
    readonly attribute long drawingBufferWidth;
    readonly attribute long drawingBufferHeight;

    [WebGLHandlesContextLoss] WebGLContextAttributes getContextAttributes();
    [WebGLHandlesContextLoss] boolean isContextLost();
    
    sequence<DOMString>? getSupportedExtensions();
    // XXXbz In the spec, this is "object?"; I'm making it
    // WebGLExtension? just for ease of implementation.
    WebGLExtension? getExtension(DOMString name);

    void activeTexture(unsigned long texture);
    void attachShader(WebGLProgram? program, WebGLShader? shader);
    void bindAttribLocation(WebGLProgram? program, unsigned long index, DOMString name);
    void bindBuffer(unsigned long target, WebGLBuffer? buffer);
    void bindFramebuffer(unsigned long target, WebGLFramebuffer? framebuffer);
    void bindRenderbuffer(unsigned long target, WebGLRenderbuffer? renderbuffer);
    void bindTexture(unsigned long target, WebGLTexture? texture);
    void blendColor(float red, float green, float blue, float alpha);
    void blendEquation(unsigned long mode);
    void blendEquationSeparate(unsigned long modeRGB, unsigned long modeAlpha);
    void blendFunc(unsigned long sfactor, unsigned long dfactor);
    void blendFuncSeparate(unsigned long srcRGB, unsigned long dstRGB, 
                           unsigned long srcAlpha, unsigned long dstAlpha);

    void bufferData(unsigned long target, long long size, unsigned long usage);
    void bufferData(unsigned long target, ArrayBufferView data, unsigned long usage);
    void bufferData(unsigned long target, ArrayBuffer? data, unsigned long usage);
    void bufferSubData(unsigned long target, long long offset, ArrayBufferView data);
    void bufferSubData(unsigned long target, long long offset, ArrayBuffer? data);

    [WebGLHandlesContextLoss] unsigned long checkFramebufferStatus(unsigned long target);
    void clear(unsigned long mask);
    void clearColor(float red, float green, float blue, float alpha);
    void clearDepth(float depth);
    void clearStencil(long s);
    void colorMask(boolean red, boolean green, boolean blue, boolean alpha);
    void compileShader(WebGLShader? shader);

    void compressedTexImage2D(unsigned long target, long level, unsigned long internalformat,
                              long width, long height, long border,
                              ArrayBufferView data);
    void compressedTexSubImage2D(unsigned long target, long level,
                                 long xoffset, long yoffset,
                                 long width, long height, unsigned long format,
                                 ArrayBufferView data);

    void copyTexImage2D(unsigned long target, long level, unsigned long internalformat, 
                        long x, long y, long width, long height, 
                        long border);
    void copyTexSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                           long x, long y, long width, long height);

    WebGLBuffer? createBuffer();
    WebGLFramebuffer? createFramebuffer();
    WebGLProgram? createProgram();
    WebGLRenderbuffer? createRenderbuffer();
    WebGLShader? createShader(unsigned long type);
    WebGLTexture? createTexture();

    void cullFace(unsigned long mode);

    void deleteBuffer(WebGLBuffer? buffer);
    void deleteFramebuffer(WebGLFramebuffer? framebuffer);
    void deleteProgram(WebGLProgram? program);
    void deleteRenderbuffer(WebGLRenderbuffer? renderbuffer);
    void deleteShader(WebGLShader? shader);
    void deleteTexture(WebGLTexture? texture);

    void depthFunc(unsigned long func);
    void depthMask(boolean flag);
    void depthRange(float zNear, float zFar);
    void detachShader(WebGLProgram? program, WebGLShader? shader);
    void disable(unsigned long cap);
    void disableVertexAttribArray(unsigned long index);
    void drawArrays(unsigned long mode, long first, long count);
    void drawElements(unsigned long mode, long count, unsigned long type, long long offset);

    void enable(unsigned long cap);
    void enableVertexAttribArray(unsigned long index);
    void finish();
    void flush();
    void framebufferRenderbuffer(unsigned long target, unsigned long attachment, 
                                 unsigned long renderbuffertarget, 
                                 WebGLRenderbuffer? renderbuffer);
    void framebufferTexture2D(unsigned long target, unsigned long attachment, unsigned long textarget, 
                              WebGLTexture? texture, long level);
    void frontFace(unsigned long mode);

    void generateMipmap(unsigned long target);

    WebGLActiveInfo? getActiveAttrib(WebGLProgram? program, unsigned long index);
    WebGLActiveInfo? getActiveUniform(WebGLProgram? program, unsigned long index);
    sequence<WebGLShader>? getAttachedShaders(WebGLProgram? program);

    [WebGLHandlesContextLoss] long getAttribLocation(WebGLProgram? program, DOMString name);

    any getBufferParameter(unsigned long target, unsigned long pname);
    any getParameter(unsigned long pname);

    [WebGLHandlesContextLoss] unsigned long getError();

    any getFramebufferAttachmentParameter(unsigned long target, unsigned long attachment, 
                                          unsigned long pname);
    any getProgramParameter(WebGLProgram? program, unsigned long pname);
    DOMString? getProgramInfoLog(WebGLProgram? program);
    any getRenderbufferParameter(unsigned long target, unsigned long pname);
    any getShaderParameter(WebGLShader? shader, unsigned long pname);
    WebGLShaderPrecisionFormat? getShaderPrecisionFormat(unsigned long shadertype, unsigned long precisiontype);
    DOMString? getShaderInfoLog(WebGLShader? shader);

    DOMString? getShaderSource(WebGLShader? shader);

    any getTexParameter(unsigned long target, unsigned long pname);

    any getUniform(WebGLProgram? program, WebGLUniformLocation? location);

    WebGLUniformLocation? getUniformLocation(WebGLProgram? program, DOMString name);

    any getVertexAttrib(unsigned long index, unsigned long pname);

    [WebGLHandlesContextLoss] long long getVertexAttribOffset(unsigned long index, unsigned long pname);

    void hint(unsigned long target, unsigned long mode);
    [WebGLHandlesContextLoss] boolean isBuffer(WebGLBuffer? buffer);
    [WebGLHandlesContextLoss] boolean isEnabled(unsigned long cap);
    [WebGLHandlesContextLoss] boolean isFramebuffer(WebGLFramebuffer? framebuffer);
    [WebGLHandlesContextLoss] boolean isProgram(WebGLProgram? program);
    [WebGLHandlesContextLoss] boolean isRenderbuffer(WebGLRenderbuffer? renderbuffer);
    [WebGLHandlesContextLoss] boolean isShader(WebGLShader? shader);
    [WebGLHandlesContextLoss] boolean isTexture(WebGLTexture? texture);
    void lineWidth(float width);
    void linkProgram(WebGLProgram? program);
    void pixelStorei(unsigned long pname, long param);
    void polygonOffset(float factor, float units);

    void readPixels(long x, long y, long width, long height, 
                    unsigned long format, unsigned long type, ArrayBufferView? pixels);

    void renderbufferStorage(unsigned long target, unsigned long internalformat, 
                             long width, long height);
    void sampleCoverage(float value, boolean invert);
    void scissor(long x, long y, long width, long height);

    void shaderSource(WebGLShader? shader, DOMString source);

    void stencilFunc(unsigned long func, long ref, unsigned long mask);
    void stencilFuncSeparate(unsigned long face, unsigned long func, long ref, unsigned long mask);
    void stencilMask(unsigned long mask);
    void stencilMaskSeparate(unsigned long face, unsigned long mask);
    void stencilOp(unsigned long fail, unsigned long zfail, unsigned long zpass);
    void stencilOpSeparate(unsigned long face, unsigned long fail, unsigned long zfail, unsigned long zpass);

    void texImage2D(unsigned long target, long level, unsigned long internalformat, 
                    long width, long height, long border, unsigned long format, 
                    unsigned long type, ArrayBufferView? pixels);
    void texImage2D(unsigned long target, long level, unsigned long internalformat,
                    unsigned long format, unsigned long type, ImageData? pixels);
    void texImage2D(unsigned long target, long level, unsigned long internalformat,
                    unsigned long format, unsigned long type, HTMLImageElement image); // May throw DOMException
    void texImage2D(unsigned long target, long level, unsigned long internalformat,
                    unsigned long format, unsigned long type, HTMLCanvasElement canvas); // May throw DOMException
    void texImage2D(unsigned long target, long level, unsigned long internalformat,
                    unsigned long format, unsigned long type, HTMLVideoElement video); // May throw DOMException

    void texParameterf(unsigned long target, unsigned long pname, float param);
    void texParameteri(unsigned long target, unsigned long pname, long param);

    void texSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                       long width, long height, 
                       unsigned long format, unsigned long type, ArrayBufferView? pixels);
    void texSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                       unsigned long format, unsigned long type, ImageData? pixels);
    void texSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                       unsigned long format, unsigned long type, HTMLImageElement image); // May throw DOMException
    void texSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                       unsigned long format, unsigned long type, HTMLCanvasElement canvas); // May throw DOMException
    void texSubImage2D(unsigned long target, long level, long xoffset, long yoffset, 
                       unsigned long format, unsigned long type, HTMLVideoElement video); // May throw DOMException

    void uniform1f(WebGLUniformLocation? location, float x);
    void uniform1fv(WebGLUniformLocation? location, Float32Array v);
    void uniform1fv(WebGLUniformLocation? location, sequence<float> v);
    void uniform1i(WebGLUniformLocation? location, long x);
    void uniform1iv(WebGLUniformLocation? location, Int32Array v);
    void uniform1iv(WebGLUniformLocation? location, sequence<long> v);
    void uniform2f(WebGLUniformLocation? location, float x, float y);
    void uniform2fv(WebGLUniformLocation? location, Float32Array v);
    void uniform2fv(WebGLUniformLocation? location, sequence<float> v);
    void uniform2i(WebGLUniformLocation? location, long x, long y);
    void uniform2iv(WebGLUniformLocation? location, Int32Array v);
    void uniform2iv(WebGLUniformLocation? location, sequence<long> v);
    void uniform3f(WebGLUniformLocation? location, float x, float y, float z);
    void uniform3fv(WebGLUniformLocation? location, Float32Array v);
    void uniform3fv(WebGLUniformLocation? location, sequence<float> v);
    void uniform3i(WebGLUniformLocation? location, long x, long y, long z);
    void uniform3iv(WebGLUniformLocation? location, Int32Array v);
    void uniform3iv(WebGLUniformLocation? location, sequence<long> v);
    void uniform4f(WebGLUniformLocation? location, float x, float y, float z, float w);
    void uniform4fv(WebGLUniformLocation? location, Float32Array v);
    void uniform4fv(WebGLUniformLocation? location, sequence<float> v);
    void uniform4i(WebGLUniformLocation? location, long x, long y, long z, long w);
    void uniform4iv(WebGLUniformLocation? location, Int32Array v);
    void uniform4iv(WebGLUniformLocation? location, sequence<long> v);

    void uniformMatrix2fv(WebGLUniformLocation? location, boolean transpose, 
                          Float32Array value);
    void uniformMatrix2fv(WebGLUniformLocation? location, boolean transpose, 
                          sequence<float> value);
    void uniformMatrix3fv(WebGLUniformLocation? location, boolean transpose, 
                          Float32Array value);
    void uniformMatrix3fv(WebGLUniformLocation? location, boolean transpose, 
                          sequence<float> value);
    void uniformMatrix4fv(WebGLUniformLocation? location, boolean transpose, 
                          Float32Array value);
    void uniformMatrix4fv(WebGLUniformLocation? location, boolean transpose, 
                          sequence<float> value);

    void useProgram(WebGLProgram? program);
    void validateProgram(WebGLProgram? program);

    void vertexAttrib1f(unsigned long indx, float x);
    void vertexAttrib1fv(unsigned long indx, Float32Array values);
    void vertexAttrib1fv(unsigned long indx, sequence<float> values);
    void vertexAttrib2f(unsigned long indx, float x, float y);
    void vertexAttrib2fv(unsigned long indx, Float32Array values);
    void vertexAttrib2fv(unsigned long indx, sequence<float> values);
    void vertexAttrib3f(unsigned long indx, float x, float y, float z);
    void vertexAttrib3fv(unsigned long indx, Float32Array values);
    void vertexAttrib3fv(unsigned long indx, sequence<float> values);
    void vertexAttrib4f(unsigned long indx, float x, float y, float z, float w);
    void vertexAttrib4fv(unsigned long indx, Float32Array values);
    void vertexAttrib4fv(unsigned long indx, sequence<float> values);
    void vertexAttribPointer(unsigned long indx, long size, unsigned long type, 
                             boolean normalized, long stride, long long offset);

    void viewport(long x, long y, long width, long height);
};

/*[Constructor(DOMString type, optional WebGLContextEventInit eventInit)]
interface WebGLContextEvent : Event {
    readonly attribute DOMString statusMessage;
    };*/

// EventInit is defined in the DOM4 specification.
/*dictionary WebGLContextEventInit : EventInit {
    DOMString statusMessage;
    };*/
