/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import openlink.util.Vector;
import openlink.util.VectorOfDouble;
import openlink.util.VectorOfFloat;
import openlink.util.VectorOfLong;
import virtuoso.jdbc3.VirtuosoBlob;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExtendedString;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoOutputStream;
import virtuoso.jdbc3.VirtuosoRdfBox;

class VirtuosoInputStream
extends BufferedInputStream {
    private VirtuosoConnection connection;
    private byte[] tmp = new byte[16];
    private static final int DefaultBufferSize = 2048;
    static final int SPERDAY = 86400;
    static final int GREG_JDAYS = 577737;
    static final int GREG_LAST_DAY = 14;
    static final int GREG_FIRST_DAY = 5;
    static final int GREG_MONTH = 10;
    static final int GREG_YEAR = 1582;
    static final int DAY_LAST = 365;
    static final int DAY_MIN = 1;
    static final int MONTH_MIN = 1;
    static final int MONTH_MAX = 12;
    static final int MONTH_LAST = 31;
    static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new IOException("Connection to the server lost");
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            throw new IOException("Connection to the server lost");
        }
        return n3;
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, InputStream inputStream) throws IOException {
        this(virtuosoConnection, inputStream, 2048);
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, InputStream inputStream, int n) throws IOException {
        super(inputStream, n);
        this.connection = virtuosoConnection;
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, Socket socket) throws IOException {
        this(virtuosoConnection, socket.getInputStream());
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, Socket socket, int n) throws IOException {
        this(virtuosoConnection, socket.getInputStream(), n);
    }

    protected boolean isClosed() {
        return this.in == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object read_object() throws IOException, EOFException, VirtuosoException {
        int n = this.read();
        try {
            switch (n) {
                case 180: {
                    return new Short(0);
                }
                case 204: {
                    return null;
                }
                case 193: 
                case 196: {
                    int n2 = this.readint();
                    Object[] objectArray = new Object[n2];
                    for (int i = 0; i < n2; ++i) {
                        objectArray[i] = this.read_object();
                    }
                    Vector vector = new Vector(objectArray);
                    return vector;
                }
                case 209: {
                    int n3 = this.readint();
                    Object[] objectArray = new Object[n3];
                    for (int i = 0; i < n3; ++i) {
                        objectArray[i] = new Long(this.readlongint());
                    }
                    VectorOfLong vectorOfLong = new VectorOfLong(objectArray);
                    return vectorOfLong;
                }
                case 194: {
                    int n4 = this.readint();
                    Object[] objectArray = new Object[n4];
                    for (int i = 0; i < n4; ++i) {
                        objectArray[i] = new Long(this.readlongint());
                    }
                    VectorOfLong vectorOfLong = new VectorOfLong(objectArray);
                    return vectorOfLong;
                }
                case 195: {
                    int n5 = this.readint();
                    Object[] objectArray = new Object[n5];
                    for (int i = 0; i < n5; ++i) {
                        objectArray[i] = new Double(this.readdouble());
                    }
                    VectorOfDouble vectorOfDouble = new VectorOfDouble(objectArray);
                    return vectorOfDouble;
                }
                case 202: {
                    int n6 = this.readint();
                    Object[] objectArray = new Object[n6];
                    for (int i = 0; i < n6; ++i) {
                        objectArray[i] = new Float(this.readfloat());
                    }
                    VectorOfFloat vectorOfFloat = new VectorOfFloat(objectArray);
                    return vectorOfFloat;
                }
                case 226: {
                    int n7 = this.readlongint();
                    byte[] byArray = new byte[n7];
                    for (int i = this.read(byArray, 0, n7); i != n7; i += this.read(byArray, i, n7 - i)) {
                    }
                    return this.convByte2UTF(byArray);
                }
                case 225: {
                    int n8 = this.readshortint();
                    byte[] byArray = new byte[n8];
                    for (int i = this.read(byArray, 0, n8); i != n8; i += this.read(byArray, i, n8 - i)) {
                    }
                    return this.convByte2UTF(byArray);
                }
                case 182: 
                case 183: 
                case 187: {
                    int n9 = this.readlongint();
                    byte[] byArray = new byte[n9];
                    for (int i = this.read(byArray, 0, n9); i != n9; i += this.read(byArray, i, n9 - i)) {
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(byArray);
                    }
                    return this.convByte2Ascii(byArray);
                }
                case 207: {
                    int n10 = this.readlongint();
                    Object object = this.read_object();
                    VirtuosoExtendedString virtuosoExtendedString = new VirtuosoExtendedString((String)object, n10);
                    return virtuosoExtendedString;
                }
                case 223: {
                    int n11 = this.readlongint();
                    byte[] byArray = new byte[n11];
                    for (int i = this.read(byArray, 0, n11); i != n11; i += this.read(byArray, i, n11 - i)) {
                    }
                    return byArray;
                }
                case 181: 
                case 184: 
                case 186: {
                    int n12 = this.readshortint();
                    byte[] byArray = new byte[n12];
                    for (int i = this.read(byArray, 0, n12); i != n12; i += this.read(byArray, i, n12 - i)) {
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(byArray);
                    }
                    return this.convByte2Ascii(byArray);
                }
                case 222: {
                    int n13 = this.readshortint();
                    byte[] byArray = new byte[n13];
                    for (int i = this.read(byArray, 0, n13); i != n13; i += this.read(byArray, i, n13 - i)) {
                    }
                    return byArray;
                }
                case 190: {
                    Float f = new Float(this.readfloat());
                    return f;
                }
                case 191: {
                    Double d = new Double(this.readdouble());
                    return d;
                }
                case 188: {
                    int n14 = this.readshortint();
                    if (n14 > 127) {
                        n14 -= 256;
                    }
                    Short s = new Short((short)n14);
                    return s;
                }
                case 189: {
                    Integer n15 = new Integer(this.readlongint());
                    return n15;
                }
                case 128: 
                case 129: 
                case 208: 
                case 210: 
                case 211: {
                    Object object = this.readDate(n);
                    return object;
                }
                case 126: 
                case 133: {
                    VirtuosoBlob virtuosoBlob = new VirtuosoBlob(this.connection, this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.read_object(), n);
                    return virtuosoBlob;
                }
                case 219: {
                    BigDecimal bigDecimal = this.readNumeric();
                    return bigDecimal;
                }
                case 254: {
                    Object object = this.readObject();
                    return object;
                }
                case 185: {
                    int n16 = this.read();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while (true) {
                        int n17;
                        int n18;
                        if ((n18 = this.read()) != 182 && n18 != 181) {
                            throw new VirtuosoException("Invalid data (tag=" + n18 + ") in deserializing a string session", "42000", -9);
                        }
                        int n19 = n17 = n18 == 182 ? this.readlongint() : this.read();
                        if (n17 <= 0) break;
                        byte[] byArray = new byte[n17];
                        for (int i = this.read(byArray, 0, n17); i != n17; i += this.read(byArray, i, n17 - i)) {
                        }
                        byteArrayOutputStream.write(byArray, 0, n17);
                    }
                    String string = byteArrayOutputStream.toString((n16 & 1) != 0 ? "UTF-8" : "8859_1");
                    return string;
                }
                case 243: {
                    Integer n20 = new Integer(this.readlongint());
                    return n20;
                }
                case 244: 
                case 247: {
                    Long l = new Long(this.readlong());
                    return l;
                }
                case 246: {
                    VirtuosoRdfBox virtuosoRdfBox = this.readRdfBox();
                    return virtuosoRdfBox;
                }
            }
            throw new VirtuosoException("Tag " + n + " not defined.", -9);
        }
        catch (ClassCastException classCastException) {
            if (VirtuosoFuture.rpc_log != null) {
                PrintStream printStream = VirtuosoFuture.rpc_log;
                synchronized (printStream) {
                    VirtuosoFuture.rpc_log.println("(conn " + this.connection.hashCode() + ") **** runtime " + classCastException.getClass().getName() + " encountered while reading tag " + n);
                    classCastException.printStackTrace(VirtuosoFuture.rpc_log);
                }
            }
            throw new Error(classCastException.getClass().getName() + ":" + classCastException.getMessage());
        }
    }

    private final String convByte2UTF(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = byArray.length;
        char[] cArray = new char[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3 && (n = byArray[n2] & 0xFF) <= 127; ++n2) {
            cArray[n4++] = (char)n;
        }
        block6: while (n2 < n3) {
            n = byArray[n2] & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n4++] = (char)n;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n3) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n2);
                    }
                    cArray[n4++] = (char)((n & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n2 += 3) > n3) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n2 - 1));
                    }
                    cArray[n4++] = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n2);
        }
        return new String(cArray, 0, n4);
    }

    private final String convByte2Ascii(byte[] byArray) throws IOException {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray, 0, n);
    }

    private int readint() throws IOException {
        return this.read() == 188 ? this.readshortint() : this.readlongint();
    }

    private int readshortint() throws IOException {
        return this.read();
    }

    private short readshort() throws IOException {
        for (int i = this.read(this.tmp, 0, 2); i != 2; i += this.read(this.tmp, i, 2 - i)) {
        }
        int n = (this.tmp[0] & 0xFF) << 8;
        return (short)(n | this.tmp[1] & 0xFF);
    }

    private int readlongint() throws IOException {
        for (int i = this.read(this.tmp, 0, 4); i != 4; i += this.read(this.tmp, i, 4 - i)) {
        }
        int n = (this.tmp[0] & 0xFF) << 24;
        n |= (this.tmp[1] & 0xFF) << 16;
        return (n |= (this.tmp[2] & 0xFF) << 8) | this.tmp[3] & 0xFF;
    }

    private long readlong() throws IOException {
        for (int i = this.read(this.tmp, 0, 8); i != 8; i += this.read(this.tmp, i, 8 - i)) {
        }
        long l = ((long)this.tmp[0] & 0xFFL) << 56;
        l |= ((long)this.tmp[1] & 0xFFL) << 48;
        l |= ((long)this.tmp[2] & 0xFFL) << 40;
        l |= ((long)this.tmp[3] & 0xFFL) << 32;
        l |= ((long)this.tmp[4] & 0xFFL) << 24;
        l |= ((long)this.tmp[5] & 0xFFL) << 16;
        return (l |= ((long)this.tmp[6] & 0xFFL) << 8) | (long)this.tmp[7] & 0xFFL;
    }

    private float readfloat() throws IOException {
        return Float.intBitsToFloat(this.readlongint());
    }

    private double readdouble() throws IOException {
        return Double.longBitsToDouble(this.readlong());
    }

    private BigDecimal readNumeric() throws IOException, VirtuosoException {
        int n = this.readshortint();
        int n2 = 0;
        byte[] byArray = new byte[n + 2];
        byte[] byArray2 = new byte[n << 1];
        if (byArray != null && byArray2 != null) {
            byArray[0] = -37;
            byArray[1] = (byte)n;
            for (int i = this.read(byArray, 2, n); i != n; i += this.read(byArray, i + 2, n - i)) {
            }
        } else {
            return null;
        }
        byArray2[0] = 48;
        int n3 = byArray[3] << 1;
        int n4 = byArray[1] - byArray[3] - 2 << 1;
        boolean bl = (byArray[2] & 1) == 1;
        boolean bl2 = (byArray[2] & 0x18) == 24;
        switch (byArray[2] & 0x18) {
            case 8: {
                return new BigDecimal(Double.NaN);
            }
            case 16: {
                if (bl) {
                    return new BigDecimal(Double.NEGATIVE_INFINITY);
                }
                return new BigDecimal(Double.POSITIVE_INFINITY);
            }
        }
        int n5 = 4;
        int n6 = 2 + byArray[1];
        if ((byArray[2] & 4) == 4) {
            byArray2[n2++] = (byte)((byArray[n5++] & 0xF) + 48);
            --n3;
        }
        if ((byArray[2] & 2) == 2) {
            --n4;
        }
        while (n5 < n6) {
            if (n2 == n3) {
                byArray2[n2++] = 46;
            }
            byArray2[n2++] = (byte)((byArray[n5] >> 4 & 0xF) + 48);
            if (n2 == n3) {
                byArray2[n2++] = 46;
            }
            byArray2[n2++] = (byte)((byArray[n5++] & 0xF) + 48);
        }
        BigDecimal bigDecimal = new BigDecimal((bl ? "-" : "") + new String(byArray2, 0, n5 != 4 ? n2 - ((byArray[2] & 2) == 2 ? 1 : 0) : 1));
        return bigDecimal;
    }

    private VirtuosoRdfBox readRdfBox() throws IOException, VirtuosoException {
        Object object;
        int n = this.read();
        boolean bl = false;
        long l = 0L;
        if (0 != (n & 0x10)) {
            throw new VirtuosoException("Invalid rdf box received", "42000", -17);
        }
        if (0 != (n & 0x40)) {
            int n2 = this.readshortint();
            byte[] byArray = new byte[n2];
            for (int i = this.read(byArray, 0, n2); i != n2; i += this.read(byArray, i, n2 - i)) {
            }
            object = this.connection.charset_utf8 ? this.convByte2UTF(byArray) : this.convByte2Ascii(byArray);
        } else {
            object = this.read_object();
        }
        if (0 != (n & 1)) {
            l = 0 != (n & 0x20) ? this.readlong() : (long)this.readlongint();
        }
        if (0 != (n & 2)) {
            bl = true;
        }
        short s = 0 != (n & 8) ? (short)this.readshort() : (short)257;
        short s2 = 0 != (n & 4) ? (short)this.readshort() : (short)257;
        VirtuosoRdfBox virtuosoRdfBox = new VirtuosoRdfBox(this.connection, object, bl, s, s2, l);
        return virtuosoRdfBox;
    }

    private Object readObject() throws IOException, VirtuosoException {
        int n = this.readlongint();
        Object object = this.read_object();
        if (object instanceof String) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes("8859_1"));
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    private Object readDate(int n) throws IOException {
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = this.read() << 16 | this.read() << 8 | this.read();
        int n4 = this.read();
        int n5 = this.read();
        int n6 = n5 >> 2;
        int n7 = (n5 & 3) << 4;
        n5 = this.read();
        int n8 = n7 | n5 >> 4;
        int n9 = (n5 & 0xF) << 16 | this.read() << 8 | this.read();
        int[] nArray = new int[]{this.read(), this.read()};
        int n10 = (nArray[0] & 7) << 8 | nArray[1];
        int n11 = nArray[0] >> 5;
        if ((nArray[0] & 4) != 0) {
            n2 = nArray[0] & 7;
            n2 |= 0xF8;
        } else {
            n2 = nArray[0] & 3;
        }
        n10 = n2 << 8 | nArray[1];
        if (n10 > Short.MAX_VALUE) {
            n10 -= 65536;
        }
        if (n10 != 0) {
            int n12 = VirtuosoInputStream.time_to_sec(0, n4, n6, n8);
            if ((n12 += 60 * n10) < 0) {
                n3 -= 1 + -n12 / 86400;
                if ((n12 %= 86400) == 0) {
                    ++n3;
                }
                n12 = 86400 + n12;
            } else {
                n3 += n12 / 86400;
                n12 %= 86400;
            }
            int n13 = n12 / 86400;
            n4 = (n12 - n13 * 86400) / 3600;
            n6 = (n12 - n13 * 86400 - n4 * 60 * 60) / 60;
            n8 = n12 % 60;
        }
        VirtuosoInputStream.num2date(n3, gregorianCalendar);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n6);
        gregorianCalendar.set(13, n8);
        switch (n11) {
            case 2: {
                return new Date(gregorianCalendar.getTime().getTime());
            }
            case 3: {
                return new Time(gregorianCalendar.getTime().getTime());
            }
        }
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTime().getTime());
        timestamp.setNanos(n9 * 1000);
        return timestamp;
    }

    static int time_to_sec(int n, int n2, int n3, int n4) {
        return n * 86400 + n2 * 60 * 60 + n3 * 60 + n4;
    }

    public static void num2date(int n, Calendar calendar) {
        double d;
        int n2;
        if (n > 577737) {
            n += 10;
        }
        int n3 = (double)(n2 = (int)(d = (double)n / 365.25)) != d ? n2 + 1 : n2--;
        if (n > 577737) {
            n -= n3 / 400 - 3;
            d = (double)(n += n3 / 100 - 15) / 365.25;
            n2 = (int)d;
            if ((n3 = (double)n2 != d ? n2 + 1 : n2--) % 400 != 0 && n3 % 100 == 0) {
                --n;
            }
        }
        n2 = n - (int)((double)n2 * 365.25);
        if (n3 > 1582 && n3 % 400 != 0 && n3 % 100 == 0 && n2 < n3 / 100 - 15 - (n3 / 400 - 3)) {
            ++n2;
        }
        calendar.set(1, n3);
        VirtuosoInputStream.yearday2date(n2, VirtuosoOutputStream.days_in_february(n3) == 29, calendar);
    }

    static void yearday2date(int n, boolean bl, Calendar calendar) {
        int n2;
        boolean bl2;
        if (n > 365 + (bl ? 1 : 0) || n < 1) {
            return;
        }
        boolean bl3 = bl2 = bl && n > 59;
        if (bl2) {
            --n;
        }
        for (n2 = 1; n2 < 12; ++n2) {
            if ((n -= days_in_month[n2 - 1]) > 0) continue;
            n += days_in_month[n2 - 1];
            break;
        }
        int n3 = n2;
        int n4 = n;
        if (bl2 && n3 == 2 && n4 == 28) {
            ++n4;
        }
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
    }
}

