/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import virtuoso.javax.OPLMessage_x;

public abstract class BaseRowSet
implements RowSet,
Serializable {
    private static final long serialVersionUID = 5374661472998522423L;
    protected static final int ev_CursorMoved = 1;
    protected static final int ev_RowChanged = 2;
    protected static final int ev_RowSetChanged = 3;
    private String command;
    private String url;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rsType = 1004;
    private int rsConcurrency = 1008;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private boolean readOnly = true;
    private boolean escapeProcessing = true;
    private int txn_isolation = 2;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    private Map map = null;
    private LinkedList listeners = new LinkedList();
    private ArrayList params = new ArrayList();

    public void close() throws SQLException {
        this.clearParameters();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowSetListener(RowSetListener rowSetListener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(rowSetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowSetListener(RowSetListener rowSetListener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(rowSetListener);
        }
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public int getTransactionIsolation() {
        return this.txn_isolation;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public Map getTypeMap() throws SQLException {
        return this.map;
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = array;
        parameter.jType = 0;
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 3;
        parameter.length = n2;
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = bigDecimal;
        parameter.jType = 0;
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 4;
        parameter.length = n2;
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = blob;
        parameter.jType = 0;
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Boolean(bl);
        parameter.jType = 0;
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Byte(by);
        parameter.jType = 0;
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = byArray;
        parameter.jType = 0;
    }

    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = reader;
        parameter.jType = 6;
        parameter.length = n2;
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = clob;
        parameter.jType = 0;
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = date;
        parameter.jType = 0;
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = date;
        parameter.jType = 7;
        parameter.cal = calendar;
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Double(d);
        parameter.jType = 0;
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Float(f);
        parameter.jType = 0;
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Integer(n2);
        parameter.jType = 0;
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Long(l);
        parameter.jType = 0;
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = ref;
        parameter.jType = 0;
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Short(s);
        parameter.jType = 0;
    }

    public synchronized void setString(int n, String string) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = string;
        parameter.jType = 0;
    }

    public synchronized void setURL(int n, URL uRL) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = uRL;
        parameter.jType = 0;
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = time;
        parameter.jType = 0;
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = time;
        parameter.jType = 8;
        parameter.cal = calendar;
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = timestamp;
        parameter.jType = 0;
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = timestamp;
        parameter.jType = 0;
        parameter.cal = calendar;
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 5;
        parameter.length = n2;
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = null;
        parameter.jType = 10;
        parameter.sqlType = n2;
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = null;
        parameter.jType = 11;
        parameter.sqlType = n2;
        parameter.typeName = string;
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
        parameter.sqlType = n2;
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
        parameter.sqlType = n2;
        parameter.scale = n3;
    }

    public synchronized void setCommand(String string) throws SQLException {
        this.command = new String(string);
        this.params.clear();
    }

    public void setConcurrency(int n) throws SQLException {
        this.rsConcurrency = n;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSource = string != null ? new String(string) : null;
        this.url = null;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDir = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string != null ? new String(string) : null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.txn_isolation = n;
    }

    public void setType(int n) throws SQLException {
        this.rsType = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.map = map;
    }

    public void setUrl(String string) throws SQLException {
        this.url = string != null ? new String(string) : null;
        this.dataSource = null;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string != null ? new String(string) : null;
    }

    protected void notifyListener(int n) {
        if (!this.listeners.isEmpty()) {
            LinkedList linkedList = (LinkedList)this.listeners.clone();
            RowSetEvent rowSetEvent = new RowSetEvent(this);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                switch (n) {
                    case 1: {
                        ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
                        break;
                    }
                    case 2: {
                        ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
                        break;
                    }
                    case 3: {
                        ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
                    }
                }
            }
            linkedList.clear();
        }
    }

    protected Parameter getParam(int n) throws SQLException {
        if (n < 1) {
            throw OPLMessage_x.makeExceptionV(12, String.valueOf(n));
        }
        int n2 = this.params.size();
        if (--n < n2) {
            return (Parameter)this.params.get(n);
        }
        while (n2 < n) {
            this.params.add(new Parameter());
            ++n2;
        }
        Parameter parameter = new Parameter();
        this.params.add(parameter);
        return parameter;
    }

    protected class Parameter {
        protected Object value;
        protected int sqlType = 12;
        protected String typeName;
        protected int scale;
        protected int length;
        protected Calendar cal;
        protected int jType = 0;
        protected static final int jObject = 0;
        protected static final int jObject_1 = 1;
        protected static final int jObject_2 = 2;
        protected static final int jAsciiStream = 3;
        protected static final int jBinaryStream = 4;
        protected static final int jUnicodeStream = 5;
        protected static final int jCharacterStream = 6;
        protected static final int jDateWithCalendar = 7;
        protected static final int jTimeWithCalendar = 8;
        protected static final int jTimestampWithCalendar = 9;
        protected static final int jNull_1 = 10;
        protected static final int jNull_2 = 11;

        protected Parameter() {
        }
    }
}

