/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class ConjunctiveConstraintSplitter
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new ConstraintVisitor(tupleExpr));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstraintVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public ConstraintVisitor(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        @Override
        public void meet(Filter filter) {
            super.meet(filter);
            ArrayList<ValueExpr> conjunctiveConstraints = new ArrayList<ValueExpr>(16);
            this.getConjunctiveConstraints(filter.getCondition(), conjunctiveConstraints);
            TupleExpr filterArg = filter.getArg();
            for (int i = conjunctiveConstraints.size() - 1; i >= 1; --i) {
                Filter newFilter = new Filter(filterArg, (ValueExpr)conjunctiveConstraints.get(i));
                filterArg = newFilter;
            }
            filter.setCondition((ValueExpr)conjunctiveConstraints.get(0));
            filter.setArg(filterArg);
        }

        protected void getConjunctiveConstraints(ValueExpr valueExpr, List<ValueExpr> conjunctiveConstraints) {
            if (valueExpr instanceof And) {
                And and = (And)valueExpr;
                this.getConjunctiveConstraints(and.getLeftArg(), conjunctiveConstraints);
                this.getConjunctiveConstraints(and.getRightArg(), conjunctiveConstraints);
            } else {
                conjunctiveConstraints.add(valueExpr);
            }
        }
    }
}

