/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.xml;

import info.aduna.xml.SimpleSAXListener;
import info.aduna.xml.XMLReaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser {
    private XMLReader xmlReader;
    private SimpleSAXListener listener;
    private boolean preserveWhitespace = false;

    public SimpleSAXParser(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public SimpleSAXParser() throws SAXException {
        this(XMLReaderFactory.createXMLReader());
    }

    public void setListener(SimpleSAXListener listener) {
        this.listener = listener;
    }

    public SimpleSAXListener getListener() {
        return this.listener;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.parse(in);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(InputStream in) throws SAXException, IOException {
        this.parse(new InputSource(in));
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this.parse(new InputSource(reader));
    }

    private synchronized void parse(InputSource inputSource) throws SAXException, IOException {
        this.xmlReader.setContentHandler(new SimpleSAXDefaultHandler());
        this.xmlReader.parse(inputSource);
    }

    class SimpleSAXDefaultHandler
    extends DefaultHandler {
        private StringBuilder charBuf = new StringBuilder(512);
        private String deferredStartTag = null;
        private Map<String, String> deferredAttributes = null;

        public void startDocument() throws SAXException {
            SimpleSAXParser.this.listener.startDocument();
        }

        public void endDocument() throws SAXException {
            SimpleSAXParser.this.listener.endDocument();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.deferredStartTag != null) {
                this.reportDeferredStartElement();
            }
            this.deferredStartTag = qName;
            int attCount = attributes.getLength();
            if (attCount == 0) {
                this.deferredAttributes = Collections.emptyMap();
            } else {
                this.deferredAttributes = new LinkedHashMap<String, String>(attCount * 2);
                for (int i = 0; i < attCount; ++i) {
                    this.deferredAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this.charBuf.setLength(0);
        }

        private void reportDeferredStartElement() throws SAXException {
            SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, "");
            this.deferredStartTag = null;
            this.deferredAttributes = null;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.deferredStartTag != null) {
                String text = this.charBuf.toString();
                if (!SimpleSAXParser.this.preserveWhitespace) {
                    text = text.trim();
                }
                SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, text);
                this.deferredStartTag = null;
                this.deferredAttributes = null;
            }
            SimpleSAXParser.this.listener.endTag(qName);
            this.charBuf.setLength(0);
        }
    }
}

