/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.net;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentType {
    public static final String CHARSET_KEY = "charset";
    private String mimeType;
    private Map<String, String> parameterMap = new HashMap<String, String>(4);

    public static String getMimeType(String contentType) {
        ContentType ct = new ContentType(contentType);
        return ct.getMimeType();
    }

    public ContentType(String contentType) {
        this.processContentType(contentType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getParameter(String key) {
        return this.parameterMap.get(key.toLowerCase());
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public String getCharset() {
        return this.getParameter(CHARSET_KEY);
    }

    private void processContentType(String contentType) {
        int semiColonIdx = contentType.indexOf(59);
        if (semiColonIdx == -1) {
            this.mimeType = contentType.trim();
        } else {
            this.mimeType = contentType.substring(0, semiColonIdx).trim();
            int nextSemiColonIdx = contentType.indexOf(59, semiColonIdx + 1);
            while (nextSemiColonIdx != -1) {
                this.processParameter(contentType.substring(semiColonIdx + 1, nextSemiColonIdx));
                semiColonIdx = nextSemiColonIdx;
                nextSemiColonIdx = contentType.indexOf(59, semiColonIdx + 1);
            }
            this.processParameter(contentType.substring(semiColonIdx + 1));
        }
    }

    private void processParameter(String param) {
        int equalsIdx = param.indexOf(61);
        if (equalsIdx >= 1) {
            String key = param.substring(0, equalsIdx).trim().toLowerCase();
            String value = param.substring(equalsIdx + 1).trim();
            this.parameterMap.put(key, value);
        } else if (!this.parameterMap.containsKey(CHARSET_KEY)) {
            this.parameterMap.put(CHARSET_KEY, param.trim());
        }
    }
}

