/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import info.aduna.io.IOUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static URL getURL(String resourceName) {
        Class<?> caller;
        URL result = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (result == null && (result = (caller = ResourceUtil.getCaller()).getResource(resourceName)) == null && (result = caller.getClassLoader().getResource(resourceName)) == null) {
            result = ClassLoader.getSystemResource(resourceName);
        }
        return result;
    }

    public static Set<URL> getURLs(String resourceName) throws IOException {
        HashSet<URL> result = new HashSet<URL>();
        ResourceUtil.addAll(result, Thread.currentThread().getContextClassLoader().getResources(resourceName));
        Class<?> caller = ResourceUtil.getCaller();
        ResourceUtil.addAll(result, caller.getClassLoader().getResources(resourceName));
        ResourceUtil.addAll(result, ClassLoader.getSystemResources(resourceName));
        return result;
    }

    private static void addAll(Set<URL> result, Enumeration<URL> urls) {
        if (urls != null) {
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
    }

    public static InputStream getInputStream(String resourceName) {
        Class<?> caller;
        InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (result == null && (result = (caller = ResourceUtil.getCaller()).getResourceAsStream(resourceName)) == null && (result = caller.getClassLoader().getResourceAsStream(resourceName)) == null) {
            result = ClassLoader.getSystemResourceAsStream(resourceName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String resourceName) throws IOException {
        String result = null;
        InputStream in = ResourceUtil.getInputStream(resourceName);
        if (in != null) {
            try {
                result = IOUtil.readString(in);
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static ImageIcon getImageIcon(String resourceName) {
        ImageIcon result = null;
        URL resourceURL = ResourceUtil.getURL(resourceName);
        if (resourceURL != null) {
            result = new ImageIcon(resourceURL);
        }
        return result;
    }

    public static BufferedImage getImage(String resourceName) {
        BufferedImage result = null;
        URL url = ResourceUtil.getURL(resourceName);
        try {
            result = ImageIO.read(url);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String resourceName) throws IOException {
        Properties result = null;
        URL resourceURL = ResourceUtil.getURL(resourceName);
        if (resourceURL != null) {
            InputStream in = resourceURL.openStream();
            result = new Properties();
            try {
                result.load(in);
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static void resourceToFile(String resourceName, File output) throws IOException {
        output.getParentFile().mkdirs();
        InputStream in = ResourceUtil.class.getResourceAsStream(resourceName);
        FileOutputStream out = new FileOutputStream(output);
        IOUtil.transfer(in, out);
    }

    private static Class<?> getCaller() {
        Class result = ResourceUtil.class;
        Class<?>[] callStack = CallerResolver.INSTANCE.getClassContext();
        if (callStack.length > 0) {
            for (int index = 0; index < callStack.length && (result == ResourceUtil.class || result == CallerResolver.class); ++index) {
                result = callStack[index];
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CallerResolver
    extends SecurityManager {
        private static final CallerResolver INSTANCE;

        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }

        static {
            try {
                INSTANCE = new CallerResolver();
            }
            catch (SecurityException se) {
                throw new RuntimeException("Could not create CallerResolver: " + se);
            }
        }
    }
}

