/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElementInstance.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElementInstance);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGElementInstanceTableValues[50] =
{
    { "correspondingElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceCorrespondingElement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "correspondingUseElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceCorrespondingUseElement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "parentNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceParentNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "childNodes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceChildNodes), (intptr_t)0 THUNK_GENERATOR(0) },
    { "firstChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceFirstChild), (intptr_t)0 THUNK_GENERATOR(0) },
    { "lastChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceLastChild), (intptr_t)0 THUNK_GENERATOR(0) },
    { "previousSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstancePreviousSibling), (intptr_t)0 THUNK_GENERATOR(0) },
    { "nextSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceNextSibling), (intptr_t)0 THUNK_GENERATOR(0) },
    { "onabort", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnabort), (intptr_t)setJSSVGElementInstanceOnabort THUNK_GENERATOR(0) },
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnblur), (intptr_t)setJSSVGElementInstanceOnblur THUNK_GENERATOR(0) },
    { "onchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnchange), (intptr_t)setJSSVGElementInstanceOnchange THUNK_GENERATOR(0) },
    { "onclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnclick), (intptr_t)setJSSVGElementInstanceOnclick THUNK_GENERATOR(0) },
    { "oncontextmenu", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncontextmenu), (intptr_t)setJSSVGElementInstanceOncontextmenu THUNK_GENERATOR(0) },
    { "ondblclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndblclick), (intptr_t)setJSSVGElementInstanceOndblclick THUNK_GENERATOR(0) },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnerror), (intptr_t)setJSSVGElementInstanceOnerror THUNK_GENERATOR(0) },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnfocus), (intptr_t)setJSSVGElementInstanceOnfocus THUNK_GENERATOR(0) },
    { "oninput", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOninput), (intptr_t)setJSSVGElementInstanceOninput THUNK_GENERATOR(0) },
    { "onkeydown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeydown), (intptr_t)setJSSVGElementInstanceOnkeydown THUNK_GENERATOR(0) },
    { "onkeypress", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeypress), (intptr_t)setJSSVGElementInstanceOnkeypress THUNK_GENERATOR(0) },
    { "onkeyup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeyup), (intptr_t)setJSSVGElementInstanceOnkeyup THUNK_GENERATOR(0) },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnload), (intptr_t)setJSSVGElementInstanceOnload THUNK_GENERATOR(0) },
    { "onmousedown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousedown), (intptr_t)setJSSVGElementInstanceOnmousedown THUNK_GENERATOR(0) },
    { "onmousemove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousemove), (intptr_t)setJSSVGElementInstanceOnmousemove THUNK_GENERATOR(0) },
    { "onmouseout", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseout), (intptr_t)setJSSVGElementInstanceOnmouseout THUNK_GENERATOR(0) },
    { "onmouseover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseover), (intptr_t)setJSSVGElementInstanceOnmouseover THUNK_GENERATOR(0) },
    { "onmouseup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseup), (intptr_t)setJSSVGElementInstanceOnmouseup THUNK_GENERATOR(0) },
    { "onmousewheel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousewheel), (intptr_t)setJSSVGElementInstanceOnmousewheel THUNK_GENERATOR(0) },
    { "onbeforecut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforecut), (intptr_t)setJSSVGElementInstanceOnbeforecut THUNK_GENERATOR(0) },
    { "oncut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncut), (intptr_t)setJSSVGElementInstanceOncut THUNK_GENERATOR(0) },
    { "onbeforecopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforecopy), (intptr_t)setJSSVGElementInstanceOnbeforecopy THUNK_GENERATOR(0) },
    { "oncopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncopy), (intptr_t)setJSSVGElementInstanceOncopy THUNK_GENERATOR(0) },
    { "onbeforepaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforepaste), (intptr_t)setJSSVGElementInstanceOnbeforepaste THUNK_GENERATOR(0) },
    { "onpaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnpaste), (intptr_t)setJSSVGElementInstanceOnpaste THUNK_GENERATOR(0) },
    { "ondragenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragenter), (intptr_t)setJSSVGElementInstanceOndragenter THUNK_GENERATOR(0) },
    { "ondragover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragover), (intptr_t)setJSSVGElementInstanceOndragover THUNK_GENERATOR(0) },
    { "ondragleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragleave), (intptr_t)setJSSVGElementInstanceOndragleave THUNK_GENERATOR(0) },
    { "ondrop", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndrop), (intptr_t)setJSSVGElementInstanceOndrop THUNK_GENERATOR(0) },
    { "ondragstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragstart), (intptr_t)setJSSVGElementInstanceOndragstart THUNK_GENERATOR(0) },
    { "ondrag", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndrag), (intptr_t)setJSSVGElementInstanceOndrag THUNK_GENERATOR(0) },
    { "ondragend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragend), (intptr_t)setJSSVGElementInstanceOndragend THUNK_GENERATOR(0) },
    { "onreset", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnreset), (intptr_t)setJSSVGElementInstanceOnreset THUNK_GENERATOR(0) },
    { "onresize", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnresize), (intptr_t)setJSSVGElementInstanceOnresize THUNK_GENERATOR(0) },
    { "onscroll", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnscroll), (intptr_t)setJSSVGElementInstanceOnscroll THUNK_GENERATOR(0) },
    { "onsearch", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnsearch), (intptr_t)setJSSVGElementInstanceOnsearch THUNK_GENERATOR(0) },
    { "onselect", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnselect), (intptr_t)setJSSVGElementInstanceOnselect THUNK_GENERATOR(0) },
    { "onselectstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnselectstart), (intptr_t)setJSSVGElementInstanceOnselectstart THUNK_GENERATOR(0) },
    { "onsubmit", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnsubmit), (intptr_t)setJSSVGElementInstanceOnsubmit THUNK_GENERATOR(0) },
    { "onunload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnunload), (intptr_t)setJSSVGElementInstanceOnunload THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGElementInstanceTable = { 137, 127, JSSVGElementInstanceTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGElementInstanceConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGElementInstanceConstructorTable = { 1, 0, JSSVGElementInstanceConstructorTableValues, 0 };
class JSSVGElementInstanceConstructor : public DOMConstructorObject {
public:
    JSSVGElementInstanceConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGElementInstanceConstructor::s_info = { "SVGElementInstanceConstructor", &DOMConstructorObject::s_info, &JSSVGElementInstanceConstructorTable, 0 };

JSSVGElementInstanceConstructor::JSSVGElementInstanceConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGElementInstancePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGElementInstanceConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceConstructorTable, this, propertyName, slot);
}

bool JSSVGElementInstanceConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstanceConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGElementInstancePrototypeTableValues[4] =
{
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGElementInstancePrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGElementInstancePrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGElementInstancePrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGElementInstancePrototypeTable = { 8, 7, JSSVGElementInstancePrototypeTableValues, 0 };
const ClassInfo JSSVGElementInstancePrototype::s_info = { "SVGElementInstancePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSSVGElementInstancePrototypeTable, 0 };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstance>(exec, globalObject);
}

bool JSSVGElementInstancePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, slot);
}

bool JSSVGElementInstancePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGElementInstance::s_info = { "SVGElementInstance", &JSDOMWrapper::s_info, &JSSVGElementInstanceTable, 0 };

JSSVGElementInstance::JSSVGElementInstance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElementInstance> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGElementInstance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGElementInstancePrototype(exec->globalData(), globalObject, JSSVGElementInstancePrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSSVGElementInstance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, slot);
}

bool JSSVGElementInstance::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, descriptor);
}

JSValue jsSVGElementInstanceCorrespondingElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingElement()));
    return result;
}


JSValue jsSVGElementInstanceCorrespondingUseElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingUseElement()));
    return result;
}


JSValue jsSVGElementInstanceParentNode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->parentNode()));
    return result;
}


JSValue jsSVGElementInstanceChildNodes(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->childNodes()));
    return result;
}


JSValue jsSVGElementInstanceFirstChild(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->firstChild()));
    return result;
}


JSValue jsSVGElementInstanceLastChild(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->lastChild()));
    return result;
}


JSValue jsSVGElementInstancePreviousSibling(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->previousSibling()));
    return result;
}


JSValue jsSVGElementInstanceNextSibling(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nextSibling()));
    return result;
}


JSValue jsSVGElementInstanceOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnblur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncontextmenu(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndblclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnfocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOninput(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeydown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeypress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeyup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousedown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousemove(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseout(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousewheel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforecut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforecopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforepaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnpaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragenter(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragleave(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndrop(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndrag(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnreset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnresize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnscroll(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnsearch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnselect(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnselectstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnsubmit(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnunload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGElementInstance* domObject = static_cast<JSSVGElementInstance*>(asObject(slotBase));
    return JSSVGElementInstance::getConstructor(exec, domObject->globalObject());
}

void JSSVGElementInstance::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGElementInstance, Base>(exec, propertyName, value, &JSSVGElementInstanceTable, this, slot);
}

void setJSSVGElementInstanceOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnabort(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnblur(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnchange(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnclick(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOncontextmenu(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndblclick(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnerror(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnfocus(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOninput(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnkeydown(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnkeypress(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnkeyup(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnload(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmousedown(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmousemove(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmouseout(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmouseover(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmouseup(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnmousewheel(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnbeforecut(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOncut(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnbeforecopy(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOncopy(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnbeforepaste(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnpaste(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndragenter(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndragover(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndragleave(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndrop(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndragstart(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndrag(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOndragend(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnreset(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnresize(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnscroll(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnsearch(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnselect(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnselectstart(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnsubmit(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (correspondingElementWrapper.isObject())
        imp->setOnunload(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


JSValue JSSVGElementInstance::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementInstanceConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwVMTypeError(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (!correspondingElementWrapper.isObject())
        return JSValue::encode(jsUndefined());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), asObject(correspondingElementWrapper), false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwVMTypeError(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), imp->correspondingElement());
    if (!correspondingElementWrapper.isObject())
        return JSValue::encode(jsUndefined());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), asObject(correspondingElementWrapper), false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwVMTypeError(exec);
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    ExceptionCode ec = 0;
    Event* event(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGElementInstance* impl)
{
    return wrap<JSSVGElementInstance>(exec, globalObject, impl);
}

SVGElementInstance* toSVGElementInstance(JSC::JSValue value)
{
    return value.inherits(&JSSVGElementInstance::s_info) ? static_cast<JSSVGElementInstance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
