/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PROGRESS_TAG)

#include "JSHTMLProgressElement.h"

#include "HTMLFormElement.h"
#include "HTMLProgressElement.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLProgressElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLProgressElementTableValues[7] =
{
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementValue), (intptr_t)setJSHTMLProgressElementValue THUNK_GENERATOR(0) },
    { "max", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementMax), (intptr_t)setJSHTMLProgressElementMax THUNK_GENERATOR(0) },
    { "position", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementPosition), (intptr_t)0 THUNK_GENERATOR(0) },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementForm), (intptr_t)0 THUNK_GENERATOR(0) },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementLabels), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLProgressElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLProgressElementTable = { 16, 15, JSHTMLProgressElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLProgressElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLProgressElementConstructorTable = { 1, 0, JSHTMLProgressElementConstructorTableValues, 0 };
class JSHTMLProgressElementConstructor : public DOMConstructorObject {
public:
    JSHTMLProgressElementConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLProgressElementConstructor::s_info = { "HTMLProgressElementConstructor", &DOMConstructorObject::s_info, &JSHTMLProgressElementConstructorTable, 0 };

JSHTMLProgressElementConstructor::JSHTMLProgressElementConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLProgressElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLProgressElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLProgressElementConstructor, JSDOMWrapper>(exec, &JSHTMLProgressElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLProgressElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLProgressElementConstructor, JSDOMWrapper>(exec, &JSHTMLProgressElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLProgressElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLProgressElementPrototypeTable = { 1, 0, JSHTMLProgressElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLProgressElementPrototype::s_info = { "HTMLProgressElementPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSHTMLProgressElementPrototypeTable, 0 };

JSObject* JSHTMLProgressElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLProgressElement>(exec, globalObject);
}

const ClassInfo JSHTMLProgressElement::s_info = { "HTMLProgressElement", &JSHTMLElement::s_info, &JSHTMLProgressElementTable, 0 };

JSHTMLProgressElement::JSHTMLProgressElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLProgressElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLProgressElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLProgressElementPrototype(exec->globalData(), globalObject, JSHTMLProgressElementPrototype::createStructure(exec->globalData(), JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLProgressElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLProgressElement, Base>(exec, &JSHTMLProgressElementTable, this, propertyName, slot);
}

bool JSHTMLProgressElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLProgressElement, Base>(exec, &JSHTMLProgressElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLProgressElementValue(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->value());
    return result;
}


JSValue jsHTMLProgressElementMax(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->max());
    return result;
}


JSValue jsHTMLProgressElementPosition(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->position());
    return result;
}


JSValue jsHTMLProgressElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}


JSValue jsHTMLProgressElementLabels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->labels()));
    return result;
}


JSValue jsHTMLProgressElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLProgressElement* domObject = static_cast<JSHTMLProgressElement*>(asObject(slotBase));
    return JSHTMLProgressElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLProgressElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLProgressElement, Base>(exec, propertyName, value, &JSHTMLProgressElementTable, this, slot);
}

void setJSHTMLProgressElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(thisObject);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setValue(value.toNumber(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLProgressElementMax(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLProgressElement* castedThis = static_cast<JSHTMLProgressElement*>(thisObject);
    HTMLProgressElement* imp = static_cast<HTMLProgressElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setMax(value.toNumber(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSHTMLProgressElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLProgressElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(PROGRESS_TAG)
