/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDirectoryReaderSync.h"

#include "DirectoryReaderSync.h"
#include "EntryArraySync.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEntryArraySync.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDirectoryReaderSync);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryReaderSyncTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDirectoryReaderSyncConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryReaderSyncTable = { 2, 1, JSDirectoryReaderSyncTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryReaderSyncConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryReaderSyncConstructorTable = { 1, 0, JSDirectoryReaderSyncConstructorTableValues, 0 };
class JSDirectoryReaderSyncConstructor : public DOMConstructorObject {
public:
    JSDirectoryReaderSyncConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDirectoryReaderSyncConstructor::s_info = { "DirectoryReaderSyncConstructor", &DOMConstructorObject::s_info, &JSDirectoryReaderSyncConstructorTable, 0 };

JSDirectoryReaderSyncConstructor::JSDirectoryReaderSyncConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDirectoryReaderSyncPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDirectoryReaderSyncConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDirectoryReaderSyncConstructor, JSDOMWrapper>(exec, &JSDirectoryReaderSyncConstructorTable, this, propertyName, slot);
}

bool JSDirectoryReaderSyncConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDirectoryReaderSyncConstructor, JSDOMWrapper>(exec, &JSDirectoryReaderSyncConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDirectoryReaderSyncPrototypeTableValues[2] =
{
    { "readEntries", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryReaderSyncPrototypeFunctionReadEntries), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDirectoryReaderSyncPrototypeTable = { 2, 1, JSDirectoryReaderSyncPrototypeTableValues, 0 };
static const HashTable* getJSDirectoryReaderSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDirectoryReaderSyncPrototypeTable);
}

const ClassInfo JSDirectoryReaderSyncPrototype::s_info = { "DirectoryReaderSyncPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSDirectoryReaderSyncPrototypeTable };

JSObject* JSDirectoryReaderSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDirectoryReaderSync>(exec, globalObject);
}

bool JSDirectoryReaderSyncPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDirectoryReaderSyncPrototypeTable(exec), this, propertyName, slot);
}

bool JSDirectoryReaderSyncPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDirectoryReaderSyncPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSDirectoryReaderSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDirectoryReaderSyncTable);
}

const ClassInfo JSDirectoryReaderSync::s_info = { "DirectoryReaderSync", &JSDOMWrapper::s_info, 0, getJSDirectoryReaderSyncTable };

JSDirectoryReaderSync::JSDirectoryReaderSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DirectoryReaderSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSDirectoryReaderSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDirectoryReaderSyncPrototype(exec->globalData(), globalObject, JSDirectoryReaderSyncPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSDirectoryReaderSync::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDirectoryReaderSync, Base>(exec, getJSDirectoryReaderSyncTable(exec), this, propertyName, slot);
}

bool JSDirectoryReaderSync::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDirectoryReaderSync, Base>(exec, getJSDirectoryReaderSyncTable(exec), this, propertyName, descriptor);
}

JSValue jsDirectoryReaderSyncConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDirectoryReaderSync* domObject = static_cast<JSDirectoryReaderSync*>(asObject(slotBase));
    return JSDirectoryReaderSync::getConstructor(exec, domObject->globalObject());
}

JSValue JSDirectoryReaderSync::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDirectoryReaderSyncConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDirectoryReaderSyncPrototypeFunctionReadEntries(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryReaderSync::s_info))
        return throwVMTypeError(exec);
    JSDirectoryReaderSync* castedThis = static_cast<JSDirectoryReaderSync*>(asObject(thisValue));
    DirectoryReaderSync* imp = static_cast<DirectoryReaderSync*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->readEntries(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DirectoryReaderSync* impl)
{
    return wrap<JSDirectoryReaderSync>(exec, globalObject, impl);
}

DirectoryReaderSync* toDirectoryReaderSync(JSC::JSValue value)
{
    return value.inherits(&JSDirectoryReaderSync::s_info) ? static_cast<JSDirectoryReaderSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
