/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import java.util.Date;
import org.gnu.pilotlink.Record;

public class FTB3TripRecord
extends Record {
    private String startLocation;
    private String destLocation;
    private Date startTime;
    private Date arrivalTime;
    private boolean priv;
    private boolean storno;
    private String note;
    private long startMileage;
    private long endMileage;
    private long carID;
    private boolean isCost;
    private double sum;
    private double fuel;
    private double fuelCost;
    private long[] cat;
    private double[] cost;

    public FTB3TripRecord() {
    }

    public FTB3TripRecord(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public FTB3TripRecord(Record record) {
        super(record);
    }

    @Override
    public byte[] getBuffer() {
        byte[] byArray = new byte[65535];
        Record.setStringAt(byArray, this.startLocation, 40);
        Record.setStringAt(byArray, this.destLocation, 104);
        Record.setDateTimeAt(byArray, this.startTime, 18, 22);
        Record.setDateTimeAt(byArray, this.arrivalTime, 20, 24);
        Record.setStringAt(byArray, this.note, 168);
        Record.setLongAt(byArray, this.startMileage * 10L, 26);
        Record.setLongAt(byArray, this.carID, 10);
        if (!this.priv) {
            byArray[257] = 1;
        }
        if (this.storno) {
            byArray[258] = 1;
        }
        if (this.isCost) {
            Record.setLongAt(byArray, 0L, 30);
            this.isCost = true;
            Record.setDoubleAt(byArray, this.sum, 40);
            Record.setDoubleAt(byArray, this.fuel, 48);
            Record.setDoubleAt(byArray, this.fuelCost, 56);
            for (int i = 0; i < 4; ++i) {
                Record.setLongAt(byArray, this.cat[i], 64 + i * 4);
                FTB3TripRecord.setDoubleAt(byArray, this.cost[i], 80 + i * 8);
            }
        } else {
            Record.setLongAt(byArray, this.endMileage * 10L, 30);
        }
        return byArray;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.cat = new long[4];
        this.cost = new double[4];
        this.startLocation = Record.getStringAt(byArray, 40);
        this.destLocation = Record.getStringAt(byArray, 104);
        this.startTime = Record.getDateTimeAt(byArray, 18, 22);
        this.arrivalTime = Record.getDateTimeAt(byArray, 20, 24);
        this.note = Record.getStringAt(byArray, 168);
        this.startMileage = Record.getLongAt(byArray, 26) / 10L;
        this.endMileage = Record.getLongAt(byArray, 30) / 10L;
        this.carID = Record.getLongAt(byArray, 10);
        this.priv = byArray[257] == 0;
        boolean bl = this.storno = byArray[258] == 1;
        if (this.endMileage == 0L) {
            this.isCost = true;
            this.sum = Record.getDoubleAt(byArray, 40);
            this.fuel = Record.getDoubleAt(byArray, 48);
            this.fuelCost = Record.getDoubleAt(byArray, 56);
            for (int i = 0; i < 4; ++i) {
                this.cat[i] = Record.getLongAt(byArray, 64 + i * 4);
                this.cost[i] = FTB3TripRecord.getDoubleAt(byArray, 80 + i * 8);
            }
        }
        this.setSize(byArray.length);
    }

    public Date getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(Date date) {
        this.arrivalTime = date;
    }

    public long getCarID() {
        return this.carID;
    }

    public void setCarID(long l) {
        this.carID = l;
        this.setSize(this.getBuffer().length);
    }

    public long[] getCat() {
        return this.cat;
    }

    public void setCat(long[] lArray) {
        this.cat = lArray;
        this.setSize(this.getBuffer().length);
    }

    public double[] getCost() {
        return this.cost;
    }

    public void setCost(double[] dArray) {
        this.cost = dArray;
        this.setSize(this.getBuffer().length);
    }

    public String getDestLocation() {
        return this.destLocation;
    }

    public void setDestLocation(String string) {
        this.destLocation = string;
        this.setSize(this.getBuffer().length);
    }

    public long getEndMileage() {
        return this.endMileage;
    }

    public void setEndMileage(long l) {
        this.endMileage = l;
        this.setSize(this.getBuffer().length);
    }

    public double getFuel() {
        return this.fuel;
    }

    public void setFuel(double d) {
        this.fuel = d;
        this.setSize(this.getBuffer().length);
    }

    public double getFuelCost() {
        return this.fuelCost;
    }

    public void setFuelCost(float f) {
        this.fuelCost = f;
        this.setSize(this.getBuffer().length);
    }

    public boolean isCost() {
        return this.isCost;
    }

    public void setCost(boolean bl) {
        this.isCost = bl;
        this.setSize(this.getBuffer().length);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
        this.setSize(this.getBuffer().length);
    }

    public boolean isPriv() {
        return this.priv;
    }

    public void setPriv(boolean bl) {
        this.priv = bl;
        this.setSize(this.getBuffer().length);
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(String string) {
        this.startLocation = string;
        this.setSize(this.getBuffer().length);
    }

    public long getStartMileage() {
        return this.startMileage;
    }

    public void setStartMileage(long l) {
        this.startMileage = l;
        this.setSize(this.getBuffer().length);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
        this.setSize(this.getBuffer().length);
    }

    public boolean isStorno() {
        return this.storno;
    }

    public void setStorno(boolean bl) {
        this.storno = bl;
        this.setSize(this.getBuffer().length);
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double d) {
        this.sum = d;
        this.setSize(this.getBuffer().length);
    }

    public String toString() {
        String string = "";
        string = this.isCost ? "cost " + this.getSum() : "trip " + this.getStartLocation() + " (" + this.getStartMileage() + "km) ->" + this.getDestLocation() + "(" + this.getEndMileage() + ")";
        return string;
    }
}

