.\" Converted with mdoc2man 0.2
.\" from NiH: zip_source_function.mdoc,v 1.17 2006/12/16 10:12:58 wiz Exp 
.\" $NiH: zip_source_function.mdoc,v 1.17 2006/12/16 10:12:58 wiz Exp $
.\"
.\" zip_source_function.mdoc \-- create data source from function
.\" Copyright (C) 2004-2006 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SOURCE_FUNCTION 3 "March 4, 2007" NiH
.SH "NAME"
zip_source_function \- create data source from function
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
struct zip_source *
zip_source_function(struct zip *archive, zip_source_callback fn, void *userdata);
.SH "DESCRIPTION"
The function
zip_source_function
creates a zip source from the user-provided function
\fBfn,\fR
which must be of the following type:
.Bd \-literal
typedef ssize_t (*zip_source_callback)(void *state,
    void *data, size_t len, enum zip_source_cmd cmd);
.Ed
.PP
When called by the library, the first argument is the
\fBuserdata\fR
argument supplied to
zip_source_function.
The next two arguments are a buffer
\fBdata\fR
of size
\fBlen\fR
when data is expected to be returned, or else
\fBNULL\fR
and 0.
The last argument,
\fBcmd,\fR
specifies which action the function should perform:
.RS
.TP 21
\fBZIP_SOURCE_OPEN\fR
Prepare for reading.
Return 0 on success, \-1 on error.
.TP 21
\fBZIP_SOURCE_READ\fR
Read data into the buffer
\fBdata\fR
of size
\fBlen.\fR
Return the number of bytes placed into
\fBdata\fR
on success, \-1 on error.
.TP 21
\fBZIP_SOURCE_CLOSE\fR
Reading is done.
.TP 21
\fBZIP_SOURCE_STAT\fR
Get meta information for the input data.
\fBdata\fR
points to a struct zip_stat, which should be filled in.
(See
zip_stat_init(3). )
Usually, for uncompressed data, after
zip_stat_init(3),
only the mtime and size struct members will need to be set.
Return sizeof(struct zip_stat) on success, \-1 on error.
.TP 21
\fBZIP_SOURCE_ERROR\fR
Get error information.
\fBdata\fR
points to an array of two ints, which should be filled with the libzip
error code and the corresponding system error code for the error that
occurred.
See
zip_errors(3)
for details on the error codes.
Return return(2 * sizeof(int)).
.TP 21
\fBZIP_SOURCE_FREE\fR
Clean up and free all resources.
Return 0.
.RE
.PP
The library will always issue
\fBZIP_SOURCE_OPEN\fR
before issuing
\fBZIP_SOURCE_READ.\fR
When it no longer wishes to read from this source, it will issue
\fBZIP_SOURCE_CLOSE.\fR
If the library wishes to read the data again, it will issue
\fBZIP_SOURCE_OPEN\fR
a second time.
If the function is unable to provide the data again, it should
return \-1.
.PP
\fBZIP_SOURCE_STAT\fR
can be issued at any time.
\fBZIP_SOURCE_ERROR\fR
will only be issued in response to the function
returning \-1.
\fBZIP_SOURCE_FREE\fR
will be the last command issued.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_source_function
fails if:
.RS
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_buffer(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_zip(3),
zip_stat_init(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
