/*
 *  ----------------------------------------------------------------------------
 *  This file was automatically generated by SWIG (http://www.swig.org).
 *  Version: 1.3.19
 *
 *  Do not make changes to this file unless you know what you are doing--modify
 *  the SWIG interface file instead.
 *  -----------------------------------------------------------------------------
 */
package com.sleepycat.db;

/**
 *  The Db handle is the handle for a Berkeley DB database, which may
 *  or may not be part of a database environment.</p> <p>
 *
 *  The handle should not be closed while any other handle that refers
 *  to the database is in use; for example, database handles must not
 *  be closed while cursor handles into the database remain open, or
 *  transactions that include operations on the database have not yet
 *  been committed or aborted. Once the {@link
 *  com.sleepycat.db.Db#close Db.close}, {@link
 *  com.sleepycat.db.Db#remove Db.remove}, or {@link
 *  com.sleepycat.db.Db#rename Db.rename} methods are called, the
 *  handle may not be accessed again, regardless of the method's
 *  return.</p>
 */
public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;


    protected Db(long cPtr, boolean cMemoryOwn) {
        swigCMemOwn = cMemoryOwn;
        swigCPtr = cPtr;
    }


    protected Db() {
        this(0, false);
    }


    protected void delete() {
        if (swigCPtr != 0 && swigCMemOwn) {
            swigCMemOwn = false;
        }
        swigCPtr = 0;
    }


    protected static long getCPtr(Db obj) {
        return (obj == null) ? 0 : obj.swigCPtr;
    }


    final static int GIGABYTE = 1 << 30;
    // Internally, the JNI layer creates a global reference to each Db,
    // which can potentially be different to this.  We keep a copy here so
    // we can clean up after destructors.
    private Object db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    private DbAppendRecno append_recno_handler;
    private DbBtreeCompare bt_compare_handler;
    private DbBtreePrefix bt_prefix_handler;
    private DbDupCompare dup_compare_handler;
    private DbFeedbackHandler db_feedback_handler;
    private DbHash h_hash_handler;
    private DbSecondaryKeyCreate seckey_create_handler;


    // Called by the Db constructor
    private void initialize(DbEnv dbenv) {
        if (dbenv == null) {
            private_dbenv = true;
            dbenv = db_java.getDbEnv0(this);
            dbenv.initialize();
        }
        this.dbenv = dbenv;
        db_ref = db_java.initDbRef0(this, this);
    }


    private void cleanup() {
        swigCPtr = 0;
        db_java.deleteRef0(db_ref);
        db_ref = null;
        if (private_dbenv) {
            dbenv.cleanup();
        }
        dbenv = null;
    }


    /**
     *  The Db.close method flushes any cached database information to
     *  disk, closes any open cursors, frees any allocated resources,
     *  and closes any underlying files.</p> <p>
     *
     *  The {@link com.sleepycat.db.Db Db} handle should not be closed
     *  while any other handle that refers to it is not yet closed;
     *  for example, database handles must not be closed while cursor
     *  handles into the database remain open, or transactions that
     *  include operations on the database have not yet been committed
     *  or aborted. Specifically, this includes {@link
     *  com.sleepycat.db.Dbc Dbc} and {@link com.sleepycat.db.DbTxn
     *  DbTxn} handles.</p> <p>
     *
     *  Because key/data pairs are cached in memory, failing to sync
     *  the file with the Db.close or {@link com.sleepycat.db.Db#sync
     *  Db.sync} method may result in inconsistent or lost
     *  information.</p> <p>
     *
     *  When called on a database that is the primary database for a
     *  secondary index, the primary database should be closed only
     *  after all secondary indices which reference it have been
     *  closed.</p> <p>
     *
     *  When multiple threads are using the {@link com.sleepycat.db.Db
     *  Db} concurrently, only a single thread may call the Db.close
     *  method.</p> <p>
     *
     *  The {@link com.sleepycat.db.Db Db} handle may not be accessed
     *  again after Db.close is called, regardless of its return.</p>
     *
     * @param  flags                      must be set to 0 or by
     *      bitwise inclusively <b>OR</b> 'ing together one or more of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOSYNC Db.DB_NOSYNC}
     *        <p>
     *
     *        Do not flush cached information to disk. The {@link
     *        com.sleepycat.db.Db#DB_NOSYNC <code>Db.DB_NOSYNC</code>}
     *        flag is a dangerous option. It should be set only if the
     *        application is doing logging (with transactions) so that
     *        the database is recoverable after a system or
     *        application crash, or if the database is always
     *        generated from scratch after any system or application
     *        crash. <p>
     *
     *        <b>It is important to understand that flushing cached
     *        information to disk only minimizes the window of
     *        opportunity for corrupted data.</b> Although unlikely,
     *        it is possible for database corruption to happen if a
     *        system or application crash occurs while writing data to
     *        the database. To ensure that database corruption never
     *        occurs, applications must either: use transactions and
     *        logging with automatic recovery; use logging and
     *        application-specific recovery; or edit a copy of the
     *        database, and once all applications using the database
     *        have successfully called Db.close, atomically replace
     *        the original database with the updated copy.</p> </li>
     *
     *      </ul>
     *
     * @throws  IllegalArgumentException  The Db.close method will
     *      fail and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     */
    public synchronized void close(int flags) throws DbException {
        try {
            close0(flags);
        } finally {
            cleanup();
        }
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getDbEnv()}
     */
    public DbEnv get_env() throws DbException {
        return getDbEnv();
    }


    /**
     *  The Db.getDbEnv method returns the handle for the database
     *  environment underlying the database.</p> <p>
     *
     *  The Db.getDbEnv method may be called at any time during the
     *  life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getDbEnv method returns the handle
     *      for the database environment underlying the database.</p>
     */
    public DbEnv getDbEnv() throws DbException {
        return dbenv;
    }


    private final void handle_append_recno(Dbt data, int recno)
             throws DbException {
        append_recno_handler.dbAppendRecno(this, data, recno);
    }


    private final int handle_bt_compare(Dbt dbt1, Dbt dbt2) {
        return bt_compare_handler.compare(this, dbt1, dbt2);
    }


    private final int handle_bt_prefix(Dbt dbt1, Dbt dbt2) {
        return bt_prefix_handler.prefix(this, dbt1, dbt2);
    }


    private final void handle_db_feedback(int opcode, int percent) {
        db_feedback_handler.feedback(this, opcode, percent);
    }


    private final int handle_dup_compare(Dbt dbt1, Dbt dbt2) {
        return dup_compare_handler.compareDuplicates(this, dbt1, dbt2);
    }


    private final int handle_h_hash(byte[] data, int len) {
        return h_hash_handler.hash(this, data, len);
    }


    private final int handle_seckey_create(Dbt key, Dbt data, Dbt result)
             throws DbException {
        return seckey_create_handler.secondaryKeyCreate(
                this, key, data, result);
    }


    /**
     *  The {@link com.sleepycat.db.Db#isEncrypted Db.isEncrypted}
     *  method returns false if the underlying database files are
     *  encrypted and true if they are not.</p> <p>
     *
     *  The {@link com.sleepycat.db.Db#isEncrypted Db.isEncrypted}
     *  method may not be called before the {@link
     *  com.sleepycat.db.Db#open Db.open} method has been called.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The {@link com.sleepycat.db.Db#isEncrypted
     *      Db.isEncrypted} method returns false if the underlying
     *      database files are encrypted and true if they are not.</p>
     */
    public boolean isEncrypted() throws DbException {
        return (get_encrypt_flags() != 0);
    }


    /**
     *  The Db.open method opens the database represented by the <b>
     *  file</b> and <b>database</b> parameters for both reading and
     *  writing.</p> <p>
     *
     *  The currently supported Berkeley DB file formats (or <i>access
     *  methods</i> ) are Btree, Hash, Queue, and Recno. The Btree
     *  format is a representation of a sorted, balanced tree
     *  structure. The Hash format is an extensible, dynamic hashing
     *  scheme. The Queue format supports fast access to fixed-length
     *  records accessed sequentially or by logical record number. The
     *  Recno format supports fixed- or variable-length records,
     *  accessed sequentially or by logical record number, and
     *  optionally backed by a flat text file.</p> <p>
     *
     *  Storage and retrieval for the Berkeley DB access methods are
     *  based on key/data pairs; see {@link com.sleepycat.db.Dbt Dbt}
     *  for more information.</p> <p>
     *
     *  Calling Db.open is a relatively expensive operation, and
     *  maintaining a set of open databases will normally be
     *  preferable to repeatedly opening and closing the database for
     *  each new query.</p> <h3>Environment Variables</h3> <p>
     *
     *  If the database was opened within a database environment, the
     *  environment variable <b>DB_HOME</b> may be used as the path of
     *  the database environment home.</p> <p>
     *
     *  Db.open is affected by any database directory specified using
     *  the {@link com.sleepycat.db.DbEnv#setDataDir DbEnv.setDataDir}
     *  method, or by setting the "set_data_dir" string in the
     *  environment's <b>DB_CONFIG</b> file.</p> <p>
     *
     *  If the <b>file</b> and <b>dbenv</b> parameters to Db.open are
     *  null, the environment variable <b>TMPDIR</b> may be used as a
     *  directory in which to create temporary backing files
     *
     * @param  database                    optional, and allows
     *      applications to have multiple databases in a single file.
     *      Although no <b>database</b> parameter needs to be
     *      specified, it is an error to attempt to open a second
     *      database in a <b>file</b> that was not initially created
     *      using a <b>database</b> name. Further, the <b>database</b>
     *      parameter is not supported by the Queue format. Finally,
     *      when opening multiple databases in the same physical file,
     *      it is important to consider locking and memory cache
     *      issues; see <a href="{@docRoot}/../ref/am/opensub.html">
     *      Opening multiple databases in a single file</a> for more
     *      information. <p>
     *
     *      In-memory databases never intended to be preserved on disk
     *      may be created by setting both the <b>file</b> and <b>
     *      database</b> parameters to null. Note that in-memory
     *      databases can only ever be shared by sharing the single
     *      database handle that created them, in circumstances where
     *      doing so is safe.</p>
     * @param  file                        used as the name of an
     *      underlying file that will be used to back the database.
     *      <p>
     *
     *      In-memory databases never intended to be preserved on disk
     *      may be created by setting both the <b>file</b> and <b>
     *      database</b> parameters to null. Note that in-memory
     *      databases can only ever be shared by sharing the single
     *      database handle that created them, in circumstances where
     *      doing so is safe.</p>
     * @param  flags                       must be set to 0 or by
     *      bitwise inclusively <b>OR</b> 'ing together one or more of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.open call within a transaction. If the
     *        call succeeds, the open operation will be recoverable.
     *        If the call fails, no database will have been created.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CREATE Db.DB_CREATE}
     *        <p>
     *
     *        Create the database. If the database does not already
     *        exist and the <code>Db.DB_CREATE</code> flag is not
     *        specified, the Db.open will fail. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        Support dirty reads; that is, read operations on the
     *        database may request the return of modified but not yet
     *        committed data. This flag must be specified on all
     *        {@link com.sleepycat.db.Db Db} handles used to perform
     *        dirty reads or database updates, otherwise requests for
     *        dirty reads may not be honored and the read may block.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_EXCL Db.DB_EXCL}<p>
     *
     *        Return an error if the database already exists. The
     *        <code>Db.DB_EXCL</code> flag is only meaningful when
     *        specified with the <code>Db.DB_CREATE</code> flag. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOMMAP Db.DB_NOMMAP}
     *        <p>
     *
     *        Do not map this database into process memory (see the
     *        {@link com.sleepycat.db.DbEnv#setMemoryPoolMapSize
     *        DbEnv.setMemoryPoolMapSize} method for further
     *        information). </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RDONLY Db.DB_RDONLY}
     *        <p>
     *
     *        Open the database for reading only. Any attempt to
     *        modify items in the database will fail, regardless of
     *        the actual permissions of any underlying files. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD}
     *        <p>
     *
     *        Cause the {@link com.sleepycat.db.Db Db} handle returned
     *        by Db.open to be <i>free-threaded</i> ; that is, usable
     *        by multiple threads within a single address space. <p>
     *
     *        Threading is always assumed in the Java API, so no
     *        special flags are required, and Berkeley DB functions
     *        will always behave as if the {@link
     *        com.sleepycat.db.Db#DB_THREAD <code>Db.DB_THREAD</code>}
     *        flag was specified.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TRUNCATE
     *        Db.DB_TRUNCATE}<p>
     *
     *        Physically truncate the underlying file, discarding all
     *        previous databases it might have held. Underlying
     *        filesystem primitives are used to implement this flag.
     *        For this reason, it is applicable only to the file and
     *        cannot be used to discard databases within a file. <p>
     *
     *        The <code>Db.DB_TRUNCATE</code> flag cannot be lock or
     *        transaction-protected, and it is an error to specify it
     *        in a locking or transaction-protected environment.</p>
     *        </li>
     *      </ul>
     *
     * @param  mode                        On UNIX systems or in
     *      IEEE/ANSI Std 1003.1 (POSIX) environments, all files
     *      created by the database open are created with mode <b>mode
     *      </b> (as described in <b>chmod</b> (2)) and modified by
     *      the process' umask value at the time of creation (see <b>
     *      umask</b> (2)). If <b>mode</b> is 0, the database open
     *      will use a default mode of readable and writable by both
     *      owner and group. On Windows systems, the mode parameter is
     *      ignored. The group ownership of created files is based on
     *      the system and directory defaults, and is not further
     *      specified by Berkeley DB.
     * @param  txnid                       If the operation is to be
     *      transaction-protected, (other than by specifying the
     *      Db.DB_AUTO_COMMIT flag), the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null. Note that transactionally protected
     *      operations on a {@link com.sleepycat.db.Db Db} handle
     *      requires the {@link com.sleepycat.db.Db Db} handle itself
     *      be transactionally protected during its open.
     * @param  type                        must be set to one of
     *      Db.DB_BTREE, Db.DB_HASH, Db.DB_QUEUE, Db.DB_RECNO, or
     *      Db.DB_UNKNOWN. If <b>type</b> is Db.DB_UNKNOWN, the
     *      database must already exist and Db.open will automatically
     *      determine its type. The {@link
     *      com.sleepycat.db.Db#getDbType Db.getDbType} method may be
     *      used to determine the underlying type of databases opened
     *      using Db.DB_UNKNOWN.
     * @throws  DbException                The Db.open method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> The database cannot be opened without being first
     *      upgraded.
     *      <li> Db.DB_CREATE and Db.DB_EXCL were specified and the
     *      database exists.
     *      <li> A nonexistent <b>re_source</b> file was specified.
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.open method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.open method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  FileNotFoundException      If the file or directory
     *      does not exist, the Db.open method will fail and throw a
     *      FileNotFoundException exception.
     * @throws  IllegalArgumentException   The Db.open method will
     *      fail and throw a IllegalArgumentException exception if an
     *      unknown database type, page size, hash function, pad byte,
     *      byte order, or a flag value or parameter that is
     *      incompatible with the specified database was specified;
     *      the {@link com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD}
     *      flag was specified and fast mutexes are not available for
     *      this architecture; the {@link
     *      com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD} flag was
     *      specified to Db.open, but was not specified to the {@link
     *      com.sleepycat.db.DbEnv#open DbEnv.open} call for the
     *      environment in which the {@link com.sleepycat.db.Db Db}
     *      handle was created; a backing flat text file was specified
     *      with either the {@link com.sleepycat.db.Db#DB_THREAD
     *      Db.DB_THREAD} flag or the provided database environment
     *      supports transaction processing; or if an invalid flag
     *      value or parameter was specified.
     */
    public void open(DbTxn txnid, String file, String database, int type, int flags, int mode) throws DbException, java.io.FileNotFoundException,

            DbDeadlockException, DbLockNotGrantedException {
        /*
         *  Java is always threaded
         */
        flags |= Db.DB_THREAD;
        open0(txnid, file, database, type, flags, mode);
    }


    /**
     * @deprecated    Replaced in Berkeley DB 4.2 by {@link
     *      #get(DbTxn,Dbt,Dbt,Dbt,int)}
     */
    public int pget(DbTxn txnid, Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {

        return get(txnid, key, pkey, data, flags);
    }


    /**
     *  The Db.remove method removes the database specified by the <b>
     *  file</b> and <b>database</b> parameters. If no <b>database</b>
     *  is specified, the underlying file represented by <b>file</b>
     *  is removed, incidentally removing all of the databases it
     *  contained.</p> <p>
     *
     *  Applications should never remove databases with open {@link
     *  com.sleepycat.db.Db Db} handles, or in the case of removing a
     *  file, when any database in the file has an open handle. For
     *  example, some architectures do not permit the removal of files
     *  with open system handles. On these architectures, attempts to
     *  remove databases currently in use by any thread of control in
     *  the system will fail.</p> <p>
     *
     *  The Db.remove method may not be called after calling the
     *  {@link com.sleepycat.db.Db#open Db.open} method on any {@link
     *  com.sleepycat.db.Db Db} handle. If the {@link
     *  com.sleepycat.db.Db#open Db.open} method has already been
     *  called on a {@link com.sleepycat.db.Db Db} handle, close the
     *  existing handle and create a new one before calling Db.remove.
     *  </p> <p>
     *
     *  The {@link com.sleepycat.db.Db Db} handle may not be accessed
     *  again after Db.remove is called, regardless of its return.</p>
     *  <h3>Environment Variables</h3> <p>
     *
     *  If the database was opened within a database environment, the
     *  environment variable <b>DB_HOME</b> may be used as the path of
     *  the database environment home.</p> <p>
     *
     *  Db.remove is affected by any database directory specified
     *  using the {@link com.sleepycat.db.DbEnv#setDataDir
     *  DbEnv.setDataDir} method, or by setting the "set_data_dir"
     *  string in the environment's <b>DB_CONFIG</b> file.</p>
     *
     * @param  database                   the database to be removed.
     * @param  file                       the physical file which
     *      contains the database(s) to be removed.
     * @param  flags                      currently unused, and must
     *      be set to 0.
     * @throws  DbException               The Db.remove method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> An attempt was made to remove the underlying file and
     *      a database in the file was currently open.
     * @throws  IllegalArgumentException  The Db.remove method will
     *      fail and throw a IllegalArgumentException exception if
     *      Db.remove called after {@link com.sleepycat.db.Db#open
     *      Db.open} was called; or if an invalid flag value or
     *      parameter was specified.
     * @throws  FileNotFoundException     If the file or directory
     *      does not exist, the Db.remove method will fail and throw a
     *      FileNotFoundException exception.
     */
    public synchronized void remove(String file, String database, int flags) throws DbException, java.io.FileNotFoundException {

        try {
            remove0(file, database, flags);
        } finally {
            cleanup();
        }
    }


    /**
     *  The Db.rename method renames the database specified by the <b>
     *  file</b> and <b>database</b> parameters to <b>newname</b> . If
     *  no <b>database</b> is specified, the underlying file
     *  represented by <b>file</b> is renamed, incidentally renaming
     *  all of the databases it contained.</p> <p>
     *
     *  Applications should not rename databases that are currently in
     *  use. If an underlying file is being renamed and logging is
     *  currently enabled in the database environment, no database in
     *  the file may be open when the Db.rename method is called. In
     *  particular, some architectures do not permit renaming files
     *  with open handles. On these architectures, attempts to rename
     *  databases that are currently in use by any thread of control
     *  in the system will fail.</p> <p>
     *
     *  The Db.rename method may not be called after calling the
     *  {@link com.sleepycat.db.Db#open Db.open} method on any {@link
     *  com.sleepycat.db.Db Db} handle. If the {@link
     *  com.sleepycat.db.Db#open Db.open} method has already been
     *  called on a {@link com.sleepycat.db.Db Db} handle, close the
     *  existing handle and create a new one before calling Db.rename.
     *  </p> <p>
     *
     *  The {@link com.sleepycat.db.Db Db} handle may not be accessed
     *  again after Db.rename is called, regardless of its return.</p>
     *  <h3>Environment Variables</h3> <p>
     *
     *  If the database was opened within a database environment, the
     *  environment variable <b>DB_HOME</b> may be used as the path of
     *  the database environment home.</p> <p>
     *
     *  Db.rename is affected by any database directory specified
     *  using the {@link com.sleepycat.db.DbEnv#setDataDir
     *  DbEnv.setDataDir} method, or by setting the "set_data_dir"
     *  string in the environment's <b>DB_CONFIG</b> file.</p>
     *
     * @param  database                   the database to be removed.
     * @param  file                       the physical file which
     *      contains the database(s) to be removed.
     * @param  flags                      currently unused, and must
     *      be set to 0.
     * @param  newname                    the new name of the database
     *      or file.
     * @throws  DbException               The Db.rename method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> An attempt was made to rename the underlying file and
     *      a database in the file was currently open.
     * @throws  IllegalArgumentException  The Db.rename method will
     *      fail and throw a IllegalArgumentException exception if
     *      Db.rename called after {@link com.sleepycat.db.Db#open
     *      Db.open} was called; or if an invalid flag value or
     *      parameter was specified.
     * @throws  FileNotFoundException     If the file or directory
     *      does not exist, the Db.rename method will fail and throw a
     *      FileNotFoundException exception.
     */
    public synchronized void rename(String file, String database, String newname, int flags) throws DbException, java.io.FileNotFoundException {

        try {
            rename0(file, database, newname, flags);
        } finally {
            cleanup();
        }
    }


    /**
     *  The Db.verify method verifies the integrity of all databases
     *  in the file specified by the <b>file</b> parameter, and
     *  optionally outputs the databases' key/data pairs to the file
     *  stream specified by the <b>outfile</b> parameter.</p> <p>
     *
     *  <b>The Db.verify method does not perform any locking, even in
     *  Berkeley DB environments that are configured with a locking
     *  subsystem. As such, it should only be used on files that are
     *  not being modified by another thread of control.</b> </p> <p>
     *
     *  The Db.verify method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. </p> <p>
     *
     *  The {@link com.sleepycat.db.Db Db} handle may not be accessed
     *  again after Db.verify is called, regardless of its return.</p>
     *  <h3>Environment Variables</h3> <p>
     *
     *  If the database was opened within a database environment, the
     *  environment variable <b>DB_HOME</b> may be used as the path of
     *  the database environment home.</p> <p>
     *
     *  Db.verify is affected by any database directory specified
     *  using the {@link com.sleepycat.db.DbEnv#setDataDir
     *  DbEnv.setDataDir} method, or by setting the "set_data_dir"
     *  string in the environment's <b>DB_CONFIG</b> file.</p>
     *
     * @param  database                   the database in <b>file</b>
     *      on which the database checks for btree and duplicate sort
     *      order and for hashing are to be performed. See the
     *      Db.DB_ORDERCHKONLY flag for more information. <p>
     *
     *      The database parameter must be set to null except when the
     *      Db.DB_ORDERCHKONLY flag is set.</p>
     * @param  file                       the physical file in which
     *      the databases to be verified are found.
     * @param  flags                      must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SALVAGE
     *        Db.DB_SALVAGE}<p>
     *
     *        Write the key/data pairs from all databases in the file
     *        to the file stream named in the <b>outfile</b>
     *        parameter. The output format is the same as that
     *        specified for the <a href="{@docRoot}/../utility/db_dump.html">
     *        db_dump</a> utility, and can be used as input for the <a
     *        href="{@docRoot}/../utility/db_load.html">db_load</a>
     *        utility. <p>
     *
     *        Because the key/data pairs are output in page order as
     *        opposed to the sort order used by <a
     *        href="{@docRoot}/../utility/db_dump.html">db_dump</a> ,
     *        using Db.verify to dump key/data pairs normally produces
     *        less than optimal loads for Btree databases.</p> </li>
     *
     *      </ul>
     *      In addition, the following flags may be set by bitwise
     *      inclusively <b>OR</b> 'ing them into the <b>flags</b>
     *      parameter:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AGGRESSIVE
     *        Db.DB_AGGRESSIVE}<p>
     *
     *        Output <b>all</b> the key/data pairs in the file that
     *        can be found. By default, Db.verify does not assume
     *        corruption. For example, if a key/data pair on a page is
     *        marked as deleted, it is not then written to the output
     *        file. When <code>Db.DB_AGGRESSIVE</code> is specified,
     *        corruption is assumed, and any key/data pair that can be
     *        found is written. In this case, key/data pairs that are
     *        corrupted or have been deleted may appear in the output
     *        (even if the file being salvaged is in no way corrupt),
     *        and the output will almost certainly require editing
     *        before being loaded into a database. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PRINTABLE
     *        Db.DB_PRINTABLE}<p>
     *
     *        When using the <code>Db.DB_SALVAGE</code> flag, if
     *        characters in either the key or data items are printing
     *        characters (as defined by <b>isprint</b> (3)), use
     *        printing characters to represent them. This flag permits
     *        users to use standard text editors and tools to modify
     *        the contents of databases or selectively remove data
     *        from salvager output. <p>
     *
     *        Note: different systems may have different notions about
     *        what characters are considered <i>printing characters
     *        </i>, and databases dumped in this manner may be less
     *        portable to external systems.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOORDERCHK
     *        Db.DB_NOORDERCHK}<p>
     *
     *        Skip the database checks for btree and duplicate sort
     *        order and for hashing. <p>
     *
     *        The Db.verify method normally verifies that btree keys
     *        and duplicate items are correctly sorted, and hash keys
     *        are correctly hashed. If the file being verified
     *        contains multiple databases using differing sorting or
     *        hashing algorithms, some of them must necessarily fail
     *        database verification because only one sort order or
     *        hash function can be specified before Db.verify is
     *        called. To verify files with multiple databases having
     *        differing sorting orders or hashing functions, first
     *        perform verification of the file as a whole by using the
     *        <code>Db.DB_NOORDERCHK</code> flag, and then
     *        individually verify the sort order and hashing function
     *        for each database in the file using the <code>Db.DB_ORDERCHKONLY</code>
     *        flag.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ORDERCHKONLY
     *        Db.DB_ORDERCHKONLY}<p>
     *
     *        Perform the database checks for btree and duplicate sort
     *        order and for hashing, skipped by <code>Db.DB_NOORDERCHK</code>
     *        . <p>
     *
     *        When this flag is specified, a <b>database</b> parameter
     *        should also be specified, indicating the database in the
     *        physical file which is to be checked. This flag is only
     *        safe to use on databases that have already successfully
     *        been verified using Db.verify with the <code>Db.DB_NOORDERCHK</code>
     *        flag set.</p> </li>
     *      </ul>
     *
     * @param  outfile                    an optional file stream to
     *      which the databases' key/data pairs are written.
     * @throws  FileNotFoundException     If the file or directory
     *      does not exist, the Db.verify method will fail and throw a
     *      FileNotFoundException exception.
     * @throws  IllegalArgumentException  The Db.verify method will
     *      fail and throw a IllegalArgumentException exception if
     *      Db.verify was called after {@link com.sleepycat.db.Db#open
     *      Db.open}; or if an invalid flag value or parameter was
     *      specified.
     */
    public synchronized void verify(String file, String database, java.io.OutputStream outfile, int flags) throws DbException, java.io.FileNotFoundException {

        try {
            verify0(file, database, outfile, flags);
        } finally {
            cleanup();
        }
    }


    /**
     * @deprecated    Replaced in Berkeley DB 4.2 by {@link
     *      #setCacheSize(long,int)}
     */
    public void set_cachesize(int gbytes, int bytes, int ncache) throws DbException {

        set_cachesize((long) gbytes * Db.GIGABYTE + bytes, ncache);
    }


    /**
     * @deprecated    Replaced in Berkeley DB 4.2 by {@link
     *      #setErrorHandler(DbErrorHandler)}
     */
    public void set_errcall(DbErrcall db_errcall_fcn) {
        final DbErrcall ferrcall = db_errcall_fcn;
        try {
            dbenv.setErrorHandler(
                new DbErrorHandler() {
                    public void error(String prefix, String str) {
                        ferrcall.errcall(prefix, str);
                    }
                });
        } catch (DbException dbe) {
            // setErrorHandler throws an exception,
            // but set_errcall does not.
            // If it does happen, report it.
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }

    }


    /**
     *  When an error occurs in the Berkeley DB library, an exception
     *  is thrown. In some cases, however, the <b>errno</b> value may
     *  be insufficient to completely describe the cause of the error,
     *  especially during initial application debugging. <p>
     *
     *  The {@link com.sleepycat.db.DbEnv#setErrorHandler
     *  DbEnv.setErrorHandler} and Db.setOnError methods are used to
     *  enhance the mechanism for reporting error messages to the
     *  application. The {@link com.sleepycat.db.DbEnv#setErrorHandler
     *  DbEnv.setErrorHandler} and Db.setOnError methods must be
     *  called with a single object parameter. The object's class must
     *  implement the DbErrorHandler interface.</p> <p>
     *
     *  In some cases, when an error occurs, Berkeley DB will invoke
     *  the object's errcall() method with two parameters; the first
     *  is the prefix string (as previously set by {@link
     *  com.sleepycat.db.Db#setErrorPrefix Db.setErrorPrefix} or
     *  {@link com.sleepycat.db.DbEnv#setErrorPrefix
     *  DbEnv.setErrorPrefix}), the second will be an error message
     *  string. It is up to this method to display the message in an
     *  appropriate manner.</p> <p>
     *
     *  Alternatively, you can use the {@link
     *  com.sleepycat.db.DbEnv#setErrorStream DbEnv.setErrorStream}
     *  and {@link com.sleepycat.db.Db#setErrorStream
     *  Db.setErrorStream} methods to display the additional
     *  information via an output stream. You should not mix these
     *  approaches.</p> <p>
     *
     *  This error-logging enhancement does not slow performance or
     *  significantly increase application size, and may be run during
     *  normal operation as well as during application debugging.</p>
     *  <p>
     *
     *  For {@link com.sleepycat.db.Db Db} handles opened inside of
     *  Berkeley DB environments, calling the Db.setOnError method
     *  affects the entire environment and is equivalent to calling
     *  the {@link com.sleepycat.db.DbEnv#setErrorHandler
     *  DbEnv.setErrorHandler} method.</p> <p>
     *
     *  The Db.setOnError method may be called at any time during the
     *  life of the application.</p>
     *
     * @param  db_errcall_fcn  the application-specified error
     *      reporting function. The function takes two parameters: <p>
     *
     *      The <b>errpfx</b> parameter is the prefix string (as
     *      previously set by {@link com.sleepycat.db.Db#setErrorPrefix
     *      Db.setErrorPrefix} or {@link
     *      com.sleepycat.db.DbEnv#setErrorPrefix
     *      DbEnv.setErrorPrefix}). <p>
     *
     *      The <b>msg</b> parameter is the error message string.
     * @throws  DbException    Signals that an exception of some sort
     *      has occurred.
     */
    public void setErrorHandler(DbErrorHandler db_errcall_fcn) throws DbException {
        dbenv.setErrorHandler(db_errcall_fcn);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getErrorPrefix()}
     */
    public String get_errpfx() {
        return getErrorPrefix();
    }


    /**
     *  The Db.getErrorPrefix method returns the error prefix.</p> <p>
     *
     *  The Db.getErrorPrefix method may be called at any time during
     *  the life of the application.</p>
     *
     * @return    The Db.getErrorPrefix method returns the error
     *      prefix.</p>
     */
    public String getErrorPrefix() {
        return dbenv.get_errpfx();
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setErrorPrefix(String)}
     */
    public void set_errpfx(String errpfx) {
        setErrorPrefix(errpfx);
    }


    /**
     *  Set the prefix string that appears before error messages
     *  issued by Berkeley DB.</p> <p>
     *
     *  For {@link com.sleepycat.db.Db Db} handles opened inside of
     *  Berkeley DB environments, calling the Db.setErrorPrefix method
     *  affects the entire environment and is equivalent to calling
     *  the {@link com.sleepycat.db.DbEnv#setErrorPrefix
     *  DbEnv.setErrorPrefix} method.</p> <p>
     *
     *  The Db.setErrorPrefix method may be called at any time during
     *  the life of the application.</p>
     *
     * @param  errpfx  the application-specified error prefix for
     *      additional error messages.
     */
    public void setErrorPrefix(String errpfx) {
        dbenv.set_errpfx(errpfx);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setErrorStream(java.io.OutputStream)}
     */
    public void set_error_stream(java.io.OutputStream stream) {
        setErrorStream(stream);
    }


    /**
     *  When an error occurs in the Berkeley DB library, an exception
     *  is thrown. In some cases, however, the error information known
     *  to the Java layer may be insufficient to completely describe
     *  the cause of the error, especially during initial application
     *  debugging.</p> <p>
     *
     *  The {@link com.sleepycat.db.DbEnv#setErrorStream
     *  DbEnv.setErrorStream} and Db.setErrorStream methods are used
     *  to enhance the mechanism for reporting error messages to the
     *  application by setting a OutputStream to be used for
     *  displaying additional Berkeley DB error messages. In some
     *  cases, when an error occurs, Berkeley DB will output an
     *  additional error message to the specified stream.</p> <p>
     *
     *  The error message will consist of the prefix string and a
     *  colon ("<b>:</b> ") (if a prefix string was previously
     *  specified using {@link com.sleepycat.db.DbEnv#setErrorPrefix
     *  DbEnv.setErrorPrefix}), an error string, and a trailing
     *  &lt;newline&gt; character.</p> <p>
     *
     *  Alternatively, you can use the {@link
     *  com.sleepycat.db.DbEnv#setErrorHandler DbEnv.setErrorHandler}
     *  method to capture the additional error information in a way
     *  that does not use output streams. You should not mix these
     *  approaches. </p> <p>
     *
     *  This error-logging enhancement does not slow performance or
     *  significantly increase application size, and may be run during
     *  normal operation as well as during application debugging.</p>
     *  <p>
     *
     *  For {@link com.sleepycat.db.Db Db} handles opened inside of
     *  Berkeley DB environments, calling the Db.setErrorStream method
     *  affects the entire environment and is equivalent to calling
     *  the {@link com.sleepycat.db.DbEnv#setErrorStream
     *  DbEnv.setErrorStream} method.</p>
     *
     * @param  stream  the application-specified output stream to be
     *      used for additional error information.
     */
    public void setErrorStream(java.io.OutputStream stream) {
        dbenv.set_error_stream(stream);
    }


    /**
     * @deprecated    Replaced in Berkeley DB 4.2 by {@link
     *      #setFeedbackHandler(DbFeedbackHandler)}
     */
    public void set_feedback(DbFeedback feedback) throws DbException {
        final DbFeedback ffeedback = feedback;
        setFeedbackHandler(
            new DbFeedbackHandler() {
                public void feedback(Db db, int opcode, int percent) {
                    ffeedback.feedback(db, opcode, percent);
                }
            });
    }


    /**
     *  Errors can occur in the Berkeley DB library where the only
     *  solution is to shut down the application and run recovery (for
     *  example, if Berkeley DB is unable to allocate heap memory). In
     *  such cases, the Berkeley DB methods will throw a {@link
     *  com.sleepycat.db.DbRunRecoveryException
     *  DbRunRecoveryException}. It is often easier to simply exit the
     *  application when such errors occur rather than gracefully
     *  return up the stack. The Db.setPanic method specifies a
     *  function to be called when {@link
     *  com.sleepycat.db.DbRunRecoveryException
     *  DbRunRecoveryException} is about to be thrown from a Berkeley
     *  DB method.</p> <p>
     *
     *  For {@link com.sleepycat.db.Db Db} handles opened inside of
     *  Berkeley DB environments, calling the Db.setPanic method
     *  affects the entire environment and is equivalent to calling
     *  the {@link com.sleepycat.db.DbEnv#setPanicHandler
     *  DbEnv.setPanicHandler} method.</p> <p>
     *
     *  The Db.setPanic method may be called at any time during the
     *  life of the application.</p>
     *
     * @param  db_panic_fcn  the application-specified function called
     *      in the case of a database environment panic. The function
     *      takes two arguments: <p>
     *
     *      The <b>dbenv</b> parameter is the enclosing database
     *      environment handle. <p>
     *
     *      The <b>e</b> parameter is the DbException that would have
     *      been thrown to the calling method.
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     */
    public void setPanicHandler(DbPanicHandler db_panic_fcn) throws DbException {
        dbenv.setPanicHandler(db_panic_fcn);
    }


    // Don't remove these - special comments used by s_java to add constants
    // BEGIN-JAVA-SPECIAL-CONSTANTS
    /*
     *  DO NOT EDIT: automatically built by dist/s_java_const.
     */
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_BTREE = 1;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #associate(DbTxn,Db,DbSecondaryKeyCreate,int)
     *    associate(DbTxn,Db,DbSecondaryKeyCreate,int)}</li>
     *    <li> {@link com.sleepycat.db.DbSecondaryKeyCreate#secondaryKeyCreate(Db,Dbt,Dbt,Dbt)
     *    DbSecondaryKeyCreate.secondaryKeyCreate(Db,Dbt,Dbt,Dbt)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_DONOTINDEX = -30999;
    public final static int DB_FILEOPEN = -30998;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_HASH = 2;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #delete(DbTxn,Dbt,int) delete(DbTxn,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#delete(int)
     *    Dbc.delete(int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_KEYEMPTY = -30997;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_KEYEXIST = -30996;
    public final static int DB_LOCK_DEADLOCK = -30995;
    public final static int DB_LOCK_NOTGRANTED = -30994;
    public final static int DB_NOSERVER = -30993;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setRpcServer(DbClient,String,long,long,int)
     *    DbEnv.setRpcServer(DbClient,String,long,long,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_NOSERVER_HOME = -30992;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setRpcServer(DbClient,String,long,long,int)
     *    DbEnv.setRpcServer(DbClient,String,long,long,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_NOSERVER_ID = -30991;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #delete(DbTxn,Dbt,int) delete(DbTxn,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOTFOUND = -30990;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_OLD_VERSION = -30989;
    public final static int DB_PAGE_NOTFOUND = -30988;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_QUEUE = 4;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RECNO = 3;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_DUPMASTER = -30987;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #associate(DbTxn,Db,DbSecondaryKeyCreate,int)
     *    associate(DbTxn,Db,DbSecondaryKeyCreate,int)}</li>
     *    <li> {@link #cursor(DbTxn,int) cursor(DbTxn,int)}</li>
     *    <li> {@link #delete(DbTxn,Dbt,int) delete(DbTxn,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *    <li> {@link #keyRange(DbTxn,Dbt,DbKeyRange,int)
     *    keyRange(DbTxn,Dbt,DbKeyRange,int)}</li>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #stat(int) stat(int)}</li>
     *    <li> {@link #sync(int) sync(int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#count(int) Dbc.count(int)}
     *    </li>
     *    <li> {@link com.sleepycat.db.Dbc#delete(int)
     *    Dbc.delete(int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#dup(int) Dbc.dup(int)}</li>
     *
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_HANDLE_DEAD = -30986;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_HOLDELECTION = -30985;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_NEWMASTER = -30983;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_NEWSITE = -30982;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_OUTDATED = -30980;
    public final static int DB_RUNRECOVERY = -30978;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #delete(DbTxn,Dbt,int) delete(DbTxn,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#delete(int)
     *    Dbc.delete(int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SECONDARY_BAD = -30977;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setAppDispatch(DbAppDispatch)
     *    DbEnv.setAppDispatch(DbAppDispatch)}</li>
     *    <li> {@link com.sleepycat.db.DbAppDispatch#appDispatch(DbEnv,Dbt,DbLsn,int)
     *    DbAppDispatch.appDispatch(DbEnv,Dbt,DbLsn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_ABORT = 0;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setAppDispatch(DbAppDispatch)
     *    DbEnv.setAppDispatch(DbAppDispatch)}</li>
     *    <li> {@link com.sleepycat.db.DbAppDispatch#appDispatch(DbEnv,Dbt,DbLsn,int)
     *    DbAppDispatch.appDispatch(DbEnv,Dbt,DbLsn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_APPLY = 1;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setAppDispatch(DbAppDispatch)
     *    DbEnv.setAppDispatch(DbAppDispatch)}</li>
     *    <li> {@link com.sleepycat.db.DbAppDispatch#appDispatch(DbEnv,Dbt,DbLsn,int)
     *    DbAppDispatch.appDispatch(DbEnv,Dbt,DbLsn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_BACKWARD_ROLL = 3;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setAppDispatch(DbAppDispatch)
     *    DbEnv.setAppDispatch(DbAppDispatch)}</li>
     *    <li> {@link com.sleepycat.db.DbAppDispatch#appDispatch(DbEnv,Dbt,DbLsn,int)
     *    DbAppDispatch.appDispatch(DbEnv,Dbt,DbLsn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_FORWARD_ROLL = 4;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setAppDispatch(DbAppDispatch)
     *    DbEnv.setAppDispatch(DbAppDispatch)}</li>
     *    <li> {@link com.sleepycat.db.DbAppDispatch#appDispatch(DbEnv,Dbt,DbLsn,int)
     *    DbAppDispatch.appDispatch(DbEnv,Dbt,DbLsn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_PRINT = 8;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_UNKNOWN = 5;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERIFY_BAD = -30976;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_AFTER;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_AGGRESSIVE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_APPEND;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#logArchive(int)
     *    DbEnv.logArchive(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ARCH_ABS;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#logArchive(int)
     *    DbEnv.logArchive(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ARCH_DATA;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#logArchive(int)
     *    DbEnv.logArchive(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ARCH_LOG;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#logArchive(int)
     *    DbEnv.logArchive(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ARCH_REMOVE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #associate(DbTxn,Db,DbSecondaryKeyCreate,int)
     *    associate(DbTxn,Db,DbSecondaryKeyCreate,int)}</li>
     *    <li> {@link #delete(DbTxn,Dbt,int) delete(DbTxn,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #truncate(DbTxn,int) truncate(DbTxn,int)}</li>
     *
     *    <li> {@link com.sleepycat.db.DbEnv#dbRemove(DbTxn,String,String,int)
     *    DbEnv.dbRemove(DbTxn,String,String,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#dbRename(DbTxn,String,String,String,int)
     *    DbEnv.dbRename(DbTxn,String,String,String,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_AUTO_COMMIT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_BEFORE;
    public final static int DB_CACHED_COUNTS;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_CDB_ALLDB;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_CHKSUM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_CONSUME;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_CONSUME_WAIT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #associate(DbTxn,Db,DbSecondaryKeyCreate,int)
     *    associate(DbTxn,Db,DbSecondaryKeyCreate,int)}</li>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_CREATE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_CURRENT;
    public final static int DB_CXX_NO_EXCEPTIONS;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbt#setFlags(int)
     *    Dbt.setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DBT_MALLOC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbt#setFlags(int)
     *    Dbt.setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DBT_PARTIAL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbt#setFlags(int)
     *    Dbt.setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DBT_REALLOC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbt#setFlags(int)
     *    Dbt.setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DBT_USERMEM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_DIRECT_DB;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_DIRECT_LOG;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #cursor(DbTxn,int) cursor(DbTxn,int)}</li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnBegin(DbTxn,int)
     *    DbEnv.txnBegin(DbTxn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DIRTY_READ;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_DUP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *    <li> {@link #upgrade(String,int) upgrade(String,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_DUPSORT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setReplicationTransport(int,DbRepTransport)
     *    DbEnv.setReplicationTransport(int,DbRepTransport)}</li>
     *    <li> {@link com.sleepycat.db.DbRepTransport#send(DbEnv,Dbt,Dbt,DbLsn,int,int)
     *    DbRepTransport.send(DbEnv,Dbt,Dbt,DbLsn,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_EID_BROADCAST;
    public final static int DB_EID_INVALID;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ENCRYPT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setEncrypted(String,int)
     *    setEncrypted(String,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#setEncrypted(String,int)
     *    DbEnv.setEncrypted(String,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ENCRYPT_AES;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_EXCL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #stat(int) stat(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_FAST_STAT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnRecover(int,int)
     *    DbEnv.txnRecover(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_FIRST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#logPut(DbLsn,Dbt,int)
     *    DbEnv.logPut(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_FLUSH;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#remove(String,int)
     *    DbEnv.remove(String,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnCheckpoint(int,int,int)
     *    DbEnv.txnCheckpoint(int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_FORCE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_GET_BOTH;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_GET_BOTH_RANGE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_GET_RECNO;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_CDB;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_LOCK;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_LOG;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_MPOOL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_REP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_INIT_TXN;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_JOINENV;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_JOIN_ITEM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *  </ul>
     *
     */
    public final static int DB_JOIN_NOSORT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_KEYFIRST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_KEYLAST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LAST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCKDOWN;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_DEFAULT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_EXPIRE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_GET;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_GET_TIMEOUT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_IREAD;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_IWR;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_IWRITE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_MAXLOCKS;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_MINLOCKS;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_MINWRITE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockGet(int,int,Dbt,int)
     *    DbEnv.lockGet(int,int,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_NOWAIT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_OLDEST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_PUT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_PUT_ALL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_PUT_OBJ;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_RANDOM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_READ;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_TIMEOUT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockVector(int,int,DbLockRequest[],int,int)
     *    DbEnv.lockVector(int,int,DbLockRequest[],int,int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_LOCK_WRITE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setLockDetect(int)
     *    DbEnv.setLockDetect(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#lockDetect(int,int)
     *    DbEnv.lockDetect(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOCK_YOUNGEST;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_LOG_AUTOREMOVE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setFlags(int,boolean)
     *    DbMpoolFile.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_MPOOL_NOFILE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_MULTIPLE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_MULTIPLE_KEY;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnRecover(int,int)
     *    DbEnv.txnRecover(int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NEXT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NEXT_DUP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NEXT_NODUP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link com.sleepycat.db.Dbc#put(Dbt,Dbt,int)
     *    Dbc.put(Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NODUPDATA;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOLOCKING;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOMMAP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOORDERCHK;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #put(DbTxn,Dbt,Dbt,int) put(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_NOOVERWRITE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOPANIC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #close(int) close(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_NOSYNC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_ORDERCHKONLY;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_OVERWRITE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_PANIC_ENVIRONMENT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#dup(int) Dbc.dup(int)}</li>
     *
     *  </ul>
     *
     */
    public final static int DB_POSITION;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PREV;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PREV_NODUP;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRINTABLE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setPriority(int)
     *    DbMpoolFile.setPriority(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIORITY_DEFAULT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setPriority(int)
     *    DbMpoolFile.setPriority(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIORITY_HIGH;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setPriority(int)
     *    DbMpoolFile.setPriority(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIORITY_LOW;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setPriority(int)
     *    DbMpoolFile.setPriority(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIORITY_VERY_HIGH;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbMpoolFile#setPriority(int)
     *    DbMpoolFile.setPriority(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIORITY_VERY_LOW;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_PRIVATE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RDONLY;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RECNUM;
    public final static int DB_RECORDCOUNT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#setFeedbackHandler(DbEnvFeedbackHandler)
     *    DbEnv.setFeedbackHandler(DbEnvFeedbackHandler)}</li>
     *    <li> {@link com.sleepycat.db.DbEnvFeedbackHandler#feedback(DbEnv,int,int)
     *    DbEnvFeedbackHandler.feedback(DbEnv,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RECOVER;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RECOVER_FATAL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_REGION_INIT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RENUMBER;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationStart(Dbt,int)
     *    DbEnv.replicationStart(Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_CLIENT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_ISPERM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationStart(Dbt,int)
     *    DbEnv.replicationStart(Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_LOGSONLY;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationStart(Dbt,int)
     *    DbEnv.replicationStart(Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_MASTER;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setReplicationTransport(int,DbRepTransport)
     *    DbEnv.setReplicationTransport(int,DbRepTransport)}</li>
     *    <li> {@link com.sleepycat.db.DbRepTransport#send(DbEnv,Dbt,Dbt,DbLsn,int,int)
     *    DbRepTransport.send(DbEnv,Dbt,Dbt,DbLsn,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_NOBUFFER;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)
     *    DbEnv.replicationProcessMessage(Dbt,Dbt,DbEnv.RepProcessMessage,DbLsn)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_REP_NOTPERM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setReplicationTransport(int,DbRepTransport)
     *    DbEnv.setReplicationTransport(int,DbRepTransport)}</li>
     *    <li> {@link com.sleepycat.db.DbRepTransport#send(DbEnv,Dbt,Dbt,DbLsn,int,int)
     *    DbRepTransport.send(DbEnv,Dbt,Dbt,DbLsn,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_PERMANENT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationElect(int,int,int)
     *    DbEnv.replicationElect(int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REP_UNAVAIL;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_REVSPLITOFF;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link #join(Dbc[],int) join(Dbc[],int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_RMW;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#DbEnv(int) DbEnv(int)}
     *    </li>
     *  </ul>
     *
     */
    public final static int DB_RPCCLIENT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #verify(String,String,java.io.OutputStream,int)
     *    verify(String,String,java.io.OutputStream,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SALVAGE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.DbLogc#get(DbLsn,Dbt,int)
     *    DbLogc.get(DbLsn,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SET;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setTimeout(long,int)
     *    DbEnv.setTimeout(long,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#getTimeout(int)
     *    DbEnv.getTimeout(int)}</li>
     *    <li> {@link com.sleepycat.db.DbTxn#setTimeout(long,int)
     *    DbTxn.setTimeout(long,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SET_LOCK_TIMEOUT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SET_RANGE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,int) get(DbTxn,Dbt,Dbt,int)}
     *    </li>
     *    <li> {@link #get(DbTxn,Dbt,Dbt,Dbt,int)
     *    get(DbTxn,Dbt,Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,int)}</li>
     *    <li> {@link com.sleepycat.db.Dbc#get(Dbt,Dbt,Dbt,int)
     *    Dbc.get(Dbt,Dbt,Dbt,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SET_RECNO;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setTimeout(long,int)
     *    DbEnv.setTimeout(long,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#getTimeout(int)
     *    DbEnv.getTimeout(int)}</li>
     *    <li> {@link com.sleepycat.db.DbTxn#setTimeout(long,int)
     *    DbTxn.setTimeout(long,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SET_TXN_TIMEOUT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SNAPSHOT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#lockStat(int)
     *    DbEnv.lockStat(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#logStat(int)
     *    DbEnv.logStat(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#memoryPoolStat(int)
     *    DbEnv.memoryPoolStat(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#memoryPoolFileStat(int)
     *    DbEnv.memoryPoolFileStat(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#replicationStat(int)
     *    DbEnv.replicationStat(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnStat(int)
     *    DbEnv.txnStat(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_STAT_CLEAR;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_SYSTEM_MEM;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_THREAD;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_TIME_NOTGRANTED;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #open(DbTxn,String,String,int,int,int)
     *    open(DbTxn,String,String,int,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TRUNCATE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#txnBegin(DbTxn,int)
     *    DbEnv.txnBegin(DbTxn,int)}</li>
     *    <li> {@link com.sleepycat.db.DbTxn#commit(int)
     *    DbTxn.commit(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_NOSYNC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFlags(int) setFlags(int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_NOT_DURABLE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#txnBegin(DbTxn,int)
     *    DbEnv.txnBegin(DbTxn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_NOWAIT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#txnBegin(DbTxn,int)
     *    DbEnv.txnBegin(DbTxn,int)}</li>
     *    <li> {@link com.sleepycat.db.DbTxn#commit(int)
     *    DbTxn.commit(int)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_SYNC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_TXN_WRITE_NOSYNC;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFeedbackHandler(DbFeedbackHandler)
     *    setFeedbackHandler(DbFeedbackHandler)}</li>
     *    <li> {@link com.sleepycat.db.DbFeedbackHandler#feedback(Db,int,int)
     *    DbFeedbackHandler.feedback(Db,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_UPGRADE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#remove(String,int)
     *    DbEnv.remove(String,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_USE_ENVIRON;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#open(String,int,int)
     *    DbEnv.open(String,int,int)}</li>
     *    <li> {@link com.sleepycat.db.DbEnv#remove(String,int)
     *    DbEnv.remove(String,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_USE_ENVIRON_ROOT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setVerbose(int,boolean)
     *    DbEnv.setVerbose(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERB_CHKPOINT;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setVerbose(int,boolean)
     *    DbEnv.setVerbose(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERB_DEADLOCK;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setVerbose(int,boolean)
     *    DbEnv.setVerbose(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERB_RECOVERY;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setVerbose(int,boolean)
     *    DbEnv.setVerbose(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERB_REPLICATION;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setVerbose(int,boolean)
     *    DbEnv.setVerbose(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERB_WAITSFOR;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #setFeedbackHandler(DbFeedbackHandler)
     *    setFeedbackHandler(DbFeedbackHandler)}</li>
     *    <li> {@link com.sleepycat.db.DbFeedbackHandler#feedback(Db,int,int)
     *    DbFeedbackHandler.feedback(Db,int,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_VERIFY;
    public final static int DB_VERSION_MAJOR;
    public final static int DB_VERSION_MINOR;
    public final static int DB_VERSION_PATCH;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #cursor(DbTxn,int) cursor(DbTxn,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_WRITECURSOR;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link #Db(DbEnv,int) Db(DbEnv,int)}</li>
     *  </ul>
     *
     */
    public final static int DB_XA_CREATE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbTxn#prepare(byte[])
     *    DbTxn.prepare(byte[])}</li>
     *  </ul>
     *
     */
    public final static int DB_XIDDATASIZE;
    /**
     *  A constant used to configure the system. It is used in the
     *  following locations:
     *  <ul>
     *    <li> {@link com.sleepycat.db.DbEnv#setFlags(int,boolean)
     *    DbEnv.setFlags(int,boolean)}</li>
     *  </ul>
     *
     */
    public final static int DB_YIELDCPU;
    // END-JAVA-SPECIAL-CONSTANTS

    static {
        // BEGIN-JAVA-CONSTANT-INITIALIZATION
        /*
         *  DO NOT EDIT: automatically built by dist/s_java_const.
         */
        DB_AFTER = DbConstants.DB_AFTER;
        DB_AGGRESSIVE = DbConstants.DB_AGGRESSIVE;
        DB_APPEND = DbConstants.DB_APPEND;
        DB_ARCH_ABS = DbConstants.DB_ARCH_ABS;
        DB_ARCH_DATA = DbConstants.DB_ARCH_DATA;
        DB_ARCH_LOG = DbConstants.DB_ARCH_LOG;
        DB_ARCH_REMOVE = DbConstants.DB_ARCH_REMOVE;
        DB_AUTO_COMMIT = DbConstants.DB_AUTO_COMMIT;
        DB_BEFORE = DbConstants.DB_BEFORE;
        DB_CACHED_COUNTS = DbConstants.DB_CACHED_COUNTS;
        DB_CDB_ALLDB = DbConstants.DB_CDB_ALLDB;
        DB_CHKSUM = DbConstants.DB_CHKSUM;
        DB_CONSUME = DbConstants.DB_CONSUME;
        DB_CONSUME_WAIT = DbConstants.DB_CONSUME_WAIT;
        DB_CREATE = DbConstants.DB_CREATE;
        DB_CURRENT = DbConstants.DB_CURRENT;
        DB_CXX_NO_EXCEPTIONS = DbConstants.DB_CXX_NO_EXCEPTIONS;
        DB_DBT_MALLOC = DbConstants.DB_DBT_MALLOC;
        DB_DBT_PARTIAL = DbConstants.DB_DBT_PARTIAL;
        DB_DBT_REALLOC = DbConstants.DB_DBT_REALLOC;
        DB_DBT_USERMEM = DbConstants.DB_DBT_USERMEM;
        DB_DIRECT_DB = DbConstants.DB_DIRECT_DB;
        DB_DIRECT_LOG = DbConstants.DB_DIRECT_LOG;
        DB_DIRTY_READ = DbConstants.DB_DIRTY_READ;
        DB_DUP = DbConstants.DB_DUP;
        DB_DUPSORT = DbConstants.DB_DUPSORT;
        DB_EID_BROADCAST = DbConstants.DB_EID_BROADCAST;
        DB_EID_INVALID = DbConstants.DB_EID_INVALID;
        DB_ENCRYPT = DbConstants.DB_ENCRYPT;
        DB_ENCRYPT_AES = DbConstants.DB_ENCRYPT_AES;
        DB_EXCL = DbConstants.DB_EXCL;
        DB_FAST_STAT = DbConstants.DB_FAST_STAT;
        DB_FIRST = DbConstants.DB_FIRST;
        DB_FLUSH = DbConstants.DB_FLUSH;
        DB_FORCE = DbConstants.DB_FORCE;
        DB_GET_BOTH = DbConstants.DB_GET_BOTH;
        DB_GET_BOTH_RANGE = DbConstants.DB_GET_BOTH_RANGE;
        DB_GET_RECNO = DbConstants.DB_GET_RECNO;
        DB_INIT_CDB = DbConstants.DB_INIT_CDB;
        DB_INIT_LOCK = DbConstants.DB_INIT_LOCK;
        DB_INIT_LOG = DbConstants.DB_INIT_LOG;
        DB_INIT_MPOOL = DbConstants.DB_INIT_MPOOL;
        DB_INIT_REP = DbConstants.DB_INIT_REP;
        DB_INIT_TXN = DbConstants.DB_INIT_TXN;
        DB_JOINENV = DbConstants.DB_JOINENV;
        DB_JOIN_ITEM = DbConstants.DB_JOIN_ITEM;
        DB_JOIN_NOSORT = DbConstants.DB_JOIN_NOSORT;
        DB_KEYFIRST = DbConstants.DB_KEYFIRST;
        DB_KEYLAST = DbConstants.DB_KEYLAST;
        DB_LAST = DbConstants.DB_LAST;
        DB_LOCKDOWN = DbConstants.DB_LOCKDOWN;
        DB_LOCK_DEFAULT = DbConstants.DB_LOCK_DEFAULT;
        DB_LOCK_EXPIRE = DbConstants.DB_LOCK_EXPIRE;
        DB_LOCK_GET = DbConstants.DB_LOCK_GET;
        DB_LOCK_GET_TIMEOUT = DbConstants.DB_LOCK_GET_TIMEOUT;
        DB_LOCK_IREAD = DbConstants.DB_LOCK_IREAD;
        DB_LOCK_IWR = DbConstants.DB_LOCK_IWR;
        DB_LOCK_IWRITE = DbConstants.DB_LOCK_IWRITE;
        DB_LOCK_MAXLOCKS = DbConstants.DB_LOCK_MAXLOCKS;
        DB_LOCK_MINLOCKS = DbConstants.DB_LOCK_MINLOCKS;
        DB_LOCK_MINWRITE = DbConstants.DB_LOCK_MINWRITE;
        DB_LOCK_NOWAIT = DbConstants.DB_LOCK_NOWAIT;
        DB_LOCK_OLDEST = DbConstants.DB_LOCK_OLDEST;
        DB_LOCK_PUT = DbConstants.DB_LOCK_PUT;
        DB_LOCK_PUT_ALL = DbConstants.DB_LOCK_PUT_ALL;
        DB_LOCK_PUT_OBJ = DbConstants.DB_LOCK_PUT_OBJ;
        DB_LOCK_RANDOM = DbConstants.DB_LOCK_RANDOM;
        DB_LOCK_READ = DbConstants.DB_LOCK_READ;
        DB_LOCK_TIMEOUT = DbConstants.DB_LOCK_TIMEOUT;
        DB_LOCK_WRITE = DbConstants.DB_LOCK_WRITE;
        DB_LOCK_YOUNGEST = DbConstants.DB_LOCK_YOUNGEST;
        DB_LOG_AUTOREMOVE = DbConstants.DB_LOG_AUTOREMOVE;
        DB_MPOOL_NOFILE = DbConstants.DB_MPOOL_NOFILE;
        DB_MULTIPLE = DbConstants.DB_MULTIPLE;
        DB_MULTIPLE_KEY = DbConstants.DB_MULTIPLE_KEY;
        DB_NEXT = DbConstants.DB_NEXT;
        DB_NEXT_DUP = DbConstants.DB_NEXT_DUP;
        DB_NEXT_NODUP = DbConstants.DB_NEXT_NODUP;
        DB_NODUPDATA = DbConstants.DB_NODUPDATA;
        DB_NOLOCKING = DbConstants.DB_NOLOCKING;
        DB_NOMMAP = DbConstants.DB_NOMMAP;
        DB_NOORDERCHK = DbConstants.DB_NOORDERCHK;
        DB_NOOVERWRITE = DbConstants.DB_NOOVERWRITE;
        DB_NOPANIC = DbConstants.DB_NOPANIC;
        DB_NOSYNC = DbConstants.DB_NOSYNC;
        DB_ORDERCHKONLY = DbConstants.DB_ORDERCHKONLY;
        DB_OVERWRITE = DbConstants.DB_OVERWRITE;
        DB_PANIC_ENVIRONMENT = DbConstants.DB_PANIC_ENVIRONMENT;
        DB_POSITION = DbConstants.DB_POSITION;
        DB_PREV = DbConstants.DB_PREV;
        DB_PREV_NODUP = DbConstants.DB_PREV_NODUP;
        DB_PRINTABLE = DbConstants.DB_PRINTABLE;
        DB_PRIORITY_DEFAULT = DbConstants.DB_PRIORITY_DEFAULT;
        DB_PRIORITY_HIGH = DbConstants.DB_PRIORITY_HIGH;
        DB_PRIORITY_LOW = DbConstants.DB_PRIORITY_LOW;
        DB_PRIORITY_VERY_HIGH = DbConstants.DB_PRIORITY_VERY_HIGH;
        DB_PRIORITY_VERY_LOW = DbConstants.DB_PRIORITY_VERY_LOW;
        DB_PRIVATE = DbConstants.DB_PRIVATE;
        DB_RDONLY = DbConstants.DB_RDONLY;
        DB_RECNUM = DbConstants.DB_RECNUM;
        DB_RECORDCOUNT = DbConstants.DB_RECORDCOUNT;
        DB_RECOVER = DbConstants.DB_RECOVER;
        DB_RECOVER_FATAL = DbConstants.DB_RECOVER_FATAL;
        DB_REGION_INIT = DbConstants.DB_REGION_INIT;
        DB_RENUMBER = DbConstants.DB_RENUMBER;
        DB_REP_CLIENT = DbConstants.DB_REP_CLIENT;
        DB_REP_ISPERM = DbConstants.DB_REP_ISPERM;
        DB_REP_LOGSONLY = DbConstants.DB_REP_LOGSONLY;
        DB_REP_MASTER = DbConstants.DB_REP_MASTER;
        DB_REP_NOBUFFER = DbConstants.DB_REP_NOBUFFER;
        DB_REP_NOTPERM = DbConstants.DB_REP_NOTPERM;
        DB_REP_PERMANENT = DbConstants.DB_REP_PERMANENT;
        DB_REP_UNAVAIL = DbConstants.DB_REP_UNAVAIL;
        DB_REVSPLITOFF = DbConstants.DB_REVSPLITOFF;
        DB_RMW = DbConstants.DB_RMW;
        DB_RPCCLIENT = DbConstants.DB_RPCCLIENT;
        DB_SALVAGE = DbConstants.DB_SALVAGE;
        DB_SET = DbConstants.DB_SET;
        DB_SET_LOCK_TIMEOUT = DbConstants.DB_SET_LOCK_TIMEOUT;
        DB_SET_RANGE = DbConstants.DB_SET_RANGE;
        DB_SET_RECNO = DbConstants.DB_SET_RECNO;
        DB_SET_TXN_TIMEOUT = DbConstants.DB_SET_TXN_TIMEOUT;
        DB_SNAPSHOT = DbConstants.DB_SNAPSHOT;
        DB_STAT_CLEAR = DbConstants.DB_STAT_CLEAR;
        DB_SYSTEM_MEM = DbConstants.DB_SYSTEM_MEM;
        DB_THREAD = DbConstants.DB_THREAD;
        DB_TIME_NOTGRANTED = DbConstants.DB_TIME_NOTGRANTED;
        DB_TRUNCATE = DbConstants.DB_TRUNCATE;
        DB_TXN_NOSYNC = DbConstants.DB_TXN_NOSYNC;
        DB_TXN_NOT_DURABLE = DbConstants.DB_TXN_NOT_DURABLE;
        DB_TXN_NOWAIT = DbConstants.DB_TXN_NOWAIT;
        DB_TXN_SYNC = DbConstants.DB_TXN_SYNC;
        DB_TXN_WRITE_NOSYNC = DbConstants.DB_TXN_WRITE_NOSYNC;
        DB_UPGRADE = DbConstants.DB_UPGRADE;
        DB_USE_ENVIRON = DbConstants.DB_USE_ENVIRON;
        DB_USE_ENVIRON_ROOT = DbConstants.DB_USE_ENVIRON_ROOT;
        DB_VERB_CHKPOINT = DbConstants.DB_VERB_CHKPOINT;
        DB_VERB_DEADLOCK = DbConstants.DB_VERB_DEADLOCK;
        DB_VERB_RECOVERY = DbConstants.DB_VERB_RECOVERY;
        DB_VERB_REPLICATION = DbConstants.DB_VERB_REPLICATION;
        DB_VERB_WAITSFOR = DbConstants.DB_VERB_WAITSFOR;
        DB_VERIFY = DbConstants.DB_VERIFY;
        DB_VERSION_MAJOR = DbConstants.DB_VERSION_MAJOR;
        DB_VERSION_MINOR = DbConstants.DB_VERSION_MINOR;
        DB_VERSION_PATCH = DbConstants.DB_VERSION_PATCH;
        DB_WRITECURSOR = DbConstants.DB_WRITECURSOR;
        DB_XA_CREATE = DbConstants.DB_XA_CREATE;
        DB_XIDDATASIZE = DbConstants.DB_XIDDATASIZE;
        DB_YIELDCPU = DbConstants.DB_YIELDCPU;
        // END-JAVA-CONSTANT-INITIALIZATION
    }


    /**
     *  The constructor creates a Db object that is the handle for a
     *  Berkeley DB database. The constructor allocates memory
     *  internally; calling the {@link com.sleepycat.db.Db#close
     *  Db.close}, {@link com.sleepycat.db.Db#remove Db.remove} or
     *  {@link com.sleepycat.db.Db#rename Db.rename} methods will free
     *  that memory.</p>
     *
     * @param  dbenv         If no <b>dbenv</b> value is specified,
     *      the database is standalone; that is, it is not part of any
     *      Berkeley DB environment. <p>
     *
     *      If a <b>dbenv</b> value is specified, the database is
     *      created within the specified Berkeley DB environment. The
     *      database access methods automatically make calls to the
     *      other subsystems in Berkeley DB based on the enclosing
     *      environment. For example, if the environment has been
     *      configured to use locking, the access methods will
     *      automatically acquire the correct locks when reading and
     *      writing pages of the database.</p>
     * @param  flags         must be set to 0 or by bitwise
     *      inclusively <b>OR</b> 'ing together one or more of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_XA_CREATE
     *        Db.DB_XA_CREATE}<p>
     *
     *        Instead of creating a standalone database, create a
     *        database intended to be accessed via applications
     *        running under a X/Open conformant Transaction Manager.
     *        The database will be opened in the environment specified
     *        by the OPENINFO parameter of the GROUPS section of the
     *        ubbconfig file. See the <a
     *        href="{@docRoot}/../ref/xa/intro.html">XA Resource
     *        Manager</a> chapter in the Reference Guide for more
     *        information. </li>
     *      </ul>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     */
    public Db(DbEnv dbenv, int flags) throws DbException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbenv), flags), true);
        initialize(dbenv);
    }


    public void associate(DbTxn txnid, Db secondary, DbSecondaryKeyCreate callback, int flags) throws DbException {
        db_javaJNI.Db_associate(swigCPtr, DbTxn.getCPtr(txnid), Db.getCPtr(secondary), (secondary.seckey_create_handler = callback), flags);
    }


    int close0(int flags) {
        return db_javaJNI.Db_close0(swigCPtr, flags);
    }


    /**
     *  The Db.cursor method returns a created database cursor.
     *
     * @param  flags                      must be set to 0 or by
     *      bitwise inclusively <b>OR</b> 'ing together one or more of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        All read operations performed by the cursor may return
     *        modified but not yet committed data. Silently ignored if
     *        the {@link com.sleepycat.db.Db#DB_DIRTY_READ <code>Db.DB_DIRTY_READ</code>
     *        } flag was not specified when the underlying database
     *        was opened. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_WRITECURSOR
     *        Db.DB_WRITECURSOR}<p>
     *
     *        Specify that the cursor will be used to update the
     *        database. The underlying database environment must have
     *        been opened using the {@link
     *        com.sleepycat.db.Db#DB_INIT_CDB <code>Db.DB_INIT_CDB</code>
     *        } flag. </li>
     *      </ul>
     *
     * @param  txnid                      If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null. To transaction-protect cursor operations,
     *      cursors must be opened and closed within the context of a
     *      transaction, and the <b>txnid</b> parameter specifies the
     *      transaction context in which the cursor may be used.
     * @throws  DbException               The Db.cursor method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Db.cursor method will
     *      fail and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     * @return                            The Db.cursor method throws
     *      an exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public Dbc cursor(DbTxn txnid, int flags) throws DbException {
        long cPtr = db_javaJNI.Db_cursor(swigCPtr, DbTxn.getCPtr(txnid), flags);
        return (cPtr == 0) ? null : new Dbc(cPtr, false);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #delete(DbTxn,Dbt,int)}
     */
    public int del(DbTxn txnid, Dbt key, int flags) throws DbException {
        return delete(txnid, key, flags);
    }


    /**
     *  The Db.delete method removes key/data pairs from the database.
     *  The key/data pair associated with the specified <b>key</b> is
     *  discarded from the database. In the presence of duplicate key
     *  values, all records associated with the designated key will be
     *  discarded.</p> <p>
     *
     *  When called on a database that has been made into a secondary
     *  index using the {@link com.sleepycat.db.Db#associate
     *  Db.associate} method, the Db.delete method deletes the
     *  key/data pair from the primary database and all secondary
     *  indices.</p>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.delete call within a transaction. If the
     *        call succeeds, changes made by the operation will be
     *        recoverable. If the call fails, the operation will have
     *        made no changes. </li>
     *      </ul>
     *
     * @param  txnid                       If the operation is to be
     *      transaction-protected, (other than by specifying the
     *      Db.DB_AUTO_COMMIT flag), the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null.
     * @throws  DbException                The Db.delete method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors: An attempt was made to modify a read-only
     *      database.
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.delete method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.delete method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.delete method will
     *      fail and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     * @return
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Db.delete method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the specified key is
     *        not in the database. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Db.delete method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if the database is a
     *        Queue or Recno database and the specified key exists,
     *        but was never explicitly created by the application or
     *        was later deleted. </li>
     *      </ul>
     *      Unless otherwise specified, the Db.delete method throws an
     *      exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public int delete(DbTxn txnid, Dbt key, int flags) throws DbException {
        return db_javaJNI.Db_del(swigCPtr, DbTxn.getCPtr(txnid), key, flags);
    }


    /**
     *  The {@link com.sleepycat.db.DbEnv#err DbEnv.err}, {@link
     *  com.sleepycat.db.DbEnv#errx DbEnv.errx}, Db.err and Db.errx
     *  methods provide error-messaging functionality for applications
     *  written using the Berkeley DB library.</p> <p>
     *
     *  The {@link com.sleepycat.db.DbEnv#err DbEnv.err} method
     *  constructs an error message consisting of the following
     *  elements:</p> <blockquote> <p>
     *
     *  If no error callback function has been set using the {@link
     *  com.sleepycat.db.DbEnv#setErrorHandler DbEnv.setErrorHandler}
     *  method, any prefix string specified using the {@link
     *  com.sleepycat.db.DbEnv#setErrorPrefix DbEnv.setErrorPrefix}
     *  method, followed by two separating characters: a colon and a
     *  &lt;space&gt; character. <p>
     *
     *  <p>
     *
     *  Two separating characters: a colon and a &lt;space&gt;
     *  character. <p>
     *
     *  The standard system or Berkeley DB library error string
     *  associated with the <b>error</b> value, as returned by the
     *  {@link com.sleepycat.db.DbEnv#strerror DbEnv.strerror} method.
     *  </blockquote> <p>
     *
     *  This constructed error message is then handled as follows:</p>
     *  <blockquote><p>
     *
     *  If an error callback function has been set (see {@link
     *  com.sleepycat.db.Db#setErrorHandler Db.setErrorHandler} and
     *  {@link com.sleepycat.db.DbEnv#setErrorHandler
     *  DbEnv.setErrorHandler}), that function is called with two
     *  parameters: any prefix string specified (see {@link
     *  com.sleepycat.db.Db#setErrorPrefix Db.setErrorPrefix} and
     *  {@link com.sleepycat.db.DbEnv#setErrorPrefix
     *  DbEnv.setErrorPrefix}) and the error message.</p> <p>
     *
     *  If an OutputStream has been set (see {@link
     *  com.sleepycat.db.DbEnv#setErrorStream DbEnv.setErrorStream}
     *  and {@link com.sleepycat.db.Db#setErrorStream
     *  Db.setErrorStream}), the error message is written to that
     *  stream.</p> <p>
     *
     *  If none of these output options has been configured, the error
     *  message is written to System.err, the standard error output
     *  stream.</p> </blockquote>
     *
     * @param  error    the error value for which the {@link
     *      com.sleepycat.db.DbEnv#err DbEnv.err} and Db.err methods
     *      will display a explanatory string.
     * @param  message  an error message to display.
     */
    public void err(int error, String message) {
        db_javaJNI.Db_err(swigCPtr, error, message);
    }


    /**
     *  The {@link com.sleepycat.db.DbEnv#errx DbEnv.errx} and Db.errx
     *  methods perform identically to the {@link
     *  com.sleepycat.db.DbEnv#err DbEnv.err} and Db.err methods,
     *  except that they do not append the final separator characters
     *  and standard error string to the error message.</p>
     *
     * @param  error    the error value for which the {@link
     *      com.sleepycat.db.DbEnv#err DbEnv.err} and Db.err methods
     *      will display a explanatory string.
     * @param  message  an error message to display.
     */
    public void errx(String message) {
        db_javaJNI.Db_errx(swigCPtr, message);
    }


    /**
     *  The Db.get method retrieves key/data pairs from the database.
     *  The byte array and length of the data associated with the
     *  specified <b>key</b> are returned in the structure to which
     *  <b>data</b> refers.</p> <p>
     *
     *  In the presence of duplicate key values, Db.get will return
     *  the first data item for the designated key. Duplicates are
     *  sorted by insert order, except where this order has been
     *  overridden by cursor operations. <b>Retrieval of duplicates
     *  requires the use of cursor operations.</b> See {@link
     *  com.sleepycat.db.Dbc#get Dbc.get} for details.</p> <p>
     *
     *  When called on a database that has been made into a secondary
     *  index using the {@link com.sleepycat.db.Db#associate
     *  Db.associate} method, the Db.get method returns the key from
     *  the secondary index and the data item from the primary
     *  database. In addition, the second method signature returns the
     *  key from the primary database. In databases that are not
     *  secondary indices, the second method signature will always
     *  fail.</p>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to 0 or one of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CONSUME
     *        Db.DB_CONSUME}<p>
     *
     *        Return the record number and data from the available
     *        record closest to the head of the queue, and delete the
     *        record. The cursor will be positioned on the deleted
     *        record. The record number will be returned in <b>key</b>
     *        , as described in {@link com.sleepycat.db.Dbt Dbt}. The
     *        data will be returned in the <b>data</b> parameter. A
     *        record is available if it is not deleted and is not
     *        currently locked. The underlying database must be of
     *        type Queue for <code>Db.DB_CONSUME</code> to be
     *        specified. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CONSUME_WAIT
     *        Db.DB_CONSUME_WAIT}<p>
     *
     *        The <code>Db.DB_CONSUME_WAIT</code> flag is the same as
     *        the <code>Db.DB_CONSUME</code> flag, except that if the
     *        Queue database is empty, the thread of control will wait
     *        until there is data in the queue before returning. The
     *        underlying database must be of type Queue for <code>Db.DB_CONSUME_WAIT</code>
     *        to be specified. <p>
     *
     *        If lock or transaction timeouts have been specified, the
     *        Db.get method with the <code>Db.DB_CONSUME_WAIT</code>
     *        flag may return <a href="{@docRoot}/../ref/program/errorret.html#DB_LOCK_NOTGRANTED">
     *        <code>Db.DB_LOCK_NOTGRANTED</code></a> . This failure,
     *        by itself, does not require the enclosing transaction be
     *        aborted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH
     *        Db.DB_GET_BOTH}<p>
     *
     *        Retrieve the key/data pair only if both the key and data
     *        match the arguments. <p>
     *
     *        When used with the second method signature version of
     *        this method on a secondary index handle, return the
     *        secondary key/primary key/data tuple only if both the
     *        primary and secondary keys match the arguments. It is an
     *        error to use the <code>Db.DB_GET_BOTH</code> flag with
     *        the first method signature version of this method and a
     *        secondary index handle.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RECNO
     *        Db.DB_SET_RECNO}<p>
     *
     *        Retrieve the specified numbered key/data pair from a
     *        database. Upon return, both the <b>key</b> and <b>data
     *        </b> items will have been filled in. <p>
     *
     *        The <b>data</b> field of the specified <b>key</b> must
     *        be a byte array large enough to hold a logical record
     *        number (that is, an int). This record number determines
     *        the record to be retrieved. <p>
     *
     *        For <code>Db.DB_SET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the DB_RECNUM flag.</p> </p>
     *        </li>
     *      </ul>
     *      In addition, the following flags may be set by bitwise
     *      inclusively <b>OR</b> 'ing them into the <b>flags</b>
     *      parameter:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.get call within a transaction. If the
     *        call succeeds, changes made by the operation will be
     *        recoverable. If the call fails, the operation will have
     *        made no changes. This flag may only be specified with
     *        the <code>Db.DB_CONSUME</code> and <code>Db.DB_CONSUME_WAIT</code>
     *        flags. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        Read modified but not yet committed data. Silently
     *        ignored if the {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        <code>Db.DB_DIRTY_READ</code>} flag was not specified
     *        when the underlying database was opened. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE
     *        Db.DB_MULTIPLE}<p>
     *
     *        Return multiple data items in the buffer to which the
     *        <b>data</b> parameter refers. <p>
     *
     *        In the case of Btree or Hash databases, all of the data
     *        items associated with the specified key are entered into
     *        the buffer. In the case of Queue or Recno databases, all
     *        of the data items in the database, starting at, and
     *        subsequent to, the specified key, are entered into the
     *        buffer.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE</code> flag may only be used
     *        alone, or with the <code>Db.DB_GET_BOTH</code> and
     *        <code>Db.DB_SET_RECNO</code> options. The <code>Db.DB_MULTIPLE</code>
     *        flag may not be used when accessing databases made into
     *        secondary indices using the {@link
     *        com.sleepycat.db.Db#associate Db.associate} method.</p>
     *        <p>
     *
     *        See {@link com.sleepycat.db.DbMultipleDataIterator
     *        DbMultipleDataIterator} for more information.</p> </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RMW Db.DB_RMW}<p>
     *
     *        Acquire write locks instead of read locks when doing the
     *        retrieval. Setting this flag can eliminate deadlock
     *        during a read-modify-write cycle by acquiring the write
     *        lock during the read part of the cycle so that another
     *        thread of control acquiring a read lock for the same
     *        item, in its own read-modify-write cycle, will not
     *        result in deadlock. <p>
     *
     *        Because the Db.get method will not hold locks across
     *        Berkeley DB calls in non-transactional operations, the
     *        {@link com.sleepycat.db.Db#DB_RMW <code>Db.DB_RMW</code>
     *        } flag to the Db.get call is meaningful only in the
     *        presence of transactions.</p> </li>
     *      </ul>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  pkey                        the return key from the
     *      primary database.
     * @param  txnid                       If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null.
     * @throws  DbException                The Db.get method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.get method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.get method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  DbLockNotGrantedException  If the Db.DB_CONSUME_WAIT
     *      flag was specified, lock or transaction timers were
     *      configured and the lock could not be granted before the
     *      wait-time expired, the Db.get method will fail and throw a
     *      {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.get method will fail
     *      and throw a IllegalArgumentException exception if a record
     *      number of 0 was specified; the {@link
     *      com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD} flag was
     *      specified to the {@link com.sleepycat.db.Db#open Db.open}
     *      method and none of the {@link
     *      com.sleepycat.db.Db#DB_DBT_MALLOC Db.DB_DBT_MALLOC},
     *      {@link com.sleepycat.db.Db#DB_DBT_REALLOC
     *      Db.DB_DBT_REALLOC} or {@link
     *      com.sleepycat.db.Db#DB_DBT_USERMEM Db.DB_DBT_USERMEM}
     *      flags were set in the {@link com.sleepycat.db.Dbt Dbt};
     *      the second method signature was called with a {@link
     *      com.sleepycat.db.Db Db} handle that does not refer to a
     *      secondary index; or if an invalid flag value or parameter
     *      was specified.
     * @throws  DbMemoryException          If the requested item could
     *      not be returned due to insufficient memory, the Db.get
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     * @return
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Db.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the specified key is
     *        not in the database. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Db.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if the database is a
     *        Queue or Recno database and the specified key exists,
     *        but was never explicitly created by the application or
     *        was later deleted. </li>
     *      </ul>
     *      Unless otherwise specified, the Db.get method throws an
     *      exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public int get(DbTxn txnid, Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_get__SWIG_0(swigCPtr, DbTxn.getCPtr(txnid), key, data, flags);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #isByteSwapped()}
     */
    public boolean get_byteswapped() throws DbException {
        return isByteSwapped();
    }


    /**
     *  The Db.isByteSwapped method returns false if the underlying
     *  database files were created on an architecture of the same
     *  byte order as the current one, and true if they were not (that
     *  is, big-endian on a little-endian machine, or vice versa).
     *  This information may be used to determine whether application
     *  data needs to be adjusted for this architecture or not.</p>
     *  <p>
     *
     *  The Db.isByteSwapped method may not be called before the
     *  {@link com.sleepycat.db.Db#open Db.open} method has been
     *  called.</p>
     *
     * @throws  IllegalArgumentException  The Db.isByteSwapped method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called before {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     * @return                            The Db.isByteSwapped method
     *      returns false if the underlying database files were
     *      created on an architecture of the same byte order as the
     *      current one, and true if they were not.</p>
     */
    public boolean isByteSwapped() throws DbException {
        return db_javaJNI.Db_get_byteswapped(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getCacheSize()}
     */
    public long get_cachesize() throws DbException {
        return getCacheSize();
    }


    /**
     *  The Db.getCacheSize method returns the size of the cache.</p>
     *  <p>
     *
     *  The Db.getCacheSize method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getCacheSize method returns the
     *      size of the cache.</p>
     */
    public long getCacheSize() throws DbException {
        return db_javaJNI.Db_get_cachesize(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getCacheSizeNcache()}
     */
    public int get_cachesize_ncache() throws DbException {
        return getCacheSizeNcache();
    }


    /**
     *  The DbEnv.getCacheSizeNcache method returns the number of
     *  caches.</p> <p>
     *
     *  The DbEnv.getCacheSizeNcache method may be called at any time
     *  during the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The DbEnv.getCacheSizeNcache method
     *      returns the number of caches.</p>
     */
    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.Db_get_cachesize_ncache(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getFileName()}
     */
    public String get_filename() throws DbException {
        return getFileName();
    }


    /**
     *  The Db.getFileName method returns the current filename.</p>
     *  <p>
     *
     *  The Db.getFileName method may be called at any time during the
     *  life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getFileName method returns the
     *      current filename.</p>
     */
    public String getFileName() throws DbException {
        return db_javaJNI.Db_get_filename(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getDatabaseName()}
     */
    public String get_dbname() throws DbException {
        return getDatabaseName();
    }


    /**
     *  The Db.getDatabaseName method returns the current database
     *  name.</p> <p>
     *
     *  The Db.getDatabaseName method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getDatabaseName method returns the
     *      current database name.</p>
     */
    public String getDatabaseName() throws DbException {
        return db_javaJNI.Db_get_dbname(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getEncryptFlags()}
     */
    public int get_encrypt_flags() throws DbException {
        return getEncryptFlags();
    }


    /**
     *  The Db.getEncryptFlags method returns the encryption flags.
     *  </p> <p>
     *
     *  The Db.getEncryptFlags method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getEncryptFlags method returns the
     *      encryption flags.</p>
     */
    public int getEncryptFlags() throws DbException {
        return db_javaJNI.Db_get_encrypt_flags(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getFlags()}
     */
    public int get_flags() throws DbException {
        return getFlags();
    }


    /**
     *  The Db.getFlags method returns the current flags.</p> <p>
     *
     *  The Db.getFlags method may be called at any time during the
     *  life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getFlags method returns the
     *      current flags.</p>
     */
    public int getFlags() throws DbException {
        return db_javaJNI.Db_get_flags(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getByteOrder()}
     */
    public int get_lorder() throws DbException {
        return getByteOrder();
    }


    /**
     *  The Db.getByteOrder method returns the database byte order; a
     *  byte order of 4,321 indicates a big endian order, and a byte
     *  order of 1,234 indicates a little endian order.</p> <p>
     *
     *  The Db.getByteOrder method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getByteOrder method returns the
     *      database byte order; a byte order of 4,321 indicates a big
     *      endian order, and a byte order of 1,234 indicates a little
     *      endian order.</p>
     */
    public int getByteOrder() throws DbException {
        return db_javaJNI.Db_get_lorder(swigCPtr);
    }


    /**
     *  The Db.get_mpf method returns the handle for the cache file
     *  underlying the database.</p> <p>
     *
     *  The Db.get_mpf method may be called at any time during the
     *  life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.get_mpf method returns the handle
     *      for the cache file underlying the database.</p>
     */
    public DbMpoolFile get_mpf() throws DbException {
        long cPtr = db_javaJNI.Db_get_mpf(swigCPtr);
        return (cPtr == 0) ? null : new DbMpoolFile(cPtr, false);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getOpenFlags()}
     */
    public int get_open_flags() throws DbException {
        return getOpenFlags();
    }


    /**
     *  The Db.getOpenFlags method returns the current open method
     *  flags.</p> <p>
     *
     *  The Db.getOpenFlags method may not be called before the
     *  Db.open method has been called.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getOpenFlags method returns the
     *      current open method flags.</p>
     */
    public int getOpenFlags() throws DbException {
        return db_javaJNI.Db_get_open_flags(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getPageSize()}
     */
    public int get_pagesize() throws DbException {
        return getPageSize();
    }


    /**
     *  The Db.getPageSize method returns the page size.</p> <p>
     *
     *  The Db.getPageSize method may be called at any time during the
     *  life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getPageSize method returns the
     *      page size.</p>
     */
    public int getPageSize() throws DbException {
        return db_javaJNI.Db_get_pagesize(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getBtreeMinKey()}
     */
    public int get_bt_minkey() throws DbException {
        return getBtreeMinKey();
    }


    /**
     *  The Db.getBtreeMinKey method returns the minimum number of
     *  key/data pairs intended to be stored on any single Btree leaf
     *  page.</p> <p>
     *
     *  The Db.getBtreeMinKey method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getBtreeMinKey method returns the
     *      minimum number of key/data pairs intended to be stored on
     *      any single Btree leaf page.</p>
     */
    public int getBtreeMinKey() throws DbException {
        return db_javaJNI.Db_get_bt_minkey(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getHashFillFactor()}
     */
    public int get_h_ffactor() throws DbException {
        return getHashFillFactor();
    }


    /**
     *  The Db.getHashFillFactor method returns the hash table
     *  density.</p> <p>
     *
     *  The Db.getHashFillFactor method may be called at any time
     *  during the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getHashFillFactor method returns
     *      the hash table density.</p>
     */
    public int getHashFillFactor() throws DbException {
        return db_javaJNI.Db_get_h_ffactor(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getHashNumElements()}
     */
    public int get_h_nelem() throws DbException {
        return getHashNumElements();
    }


    /**
     *  The Db.getHashNumElements method returns the estimate of the
     *  final size of the hash table.</p> <p>
     *
     *  The Db.getHashNumElements method may be called at any time
     *  during the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getHashNumElements method returns
     *      the estimate of the final size of the hash table.</p>
     */
    public int getHashNumElements() throws DbException {
        return db_javaJNI.Db_get_h_nelem(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getRecordDelimiter()}
     */
    public int get_re_delim() throws DbException {
        return getRecordDelimiter();
    }


    /**
     *  The Db.getRecordDelimiter method returns the delimiting byte.
     *  </p> <p>
     *
     *  The Db.getRecordDelimiter method may be called at any time
     *  during the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getRecordDelimiter method returns
     *      the delimiting byte.</p>
     */
    public int getRecordDelimiter() throws DbException {
        return db_javaJNI.Db_get_re_delim(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getRecordLength()}
     */
    public int get_re_len() throws DbException {
        return getRecordLength();
    }


    /**
     *  The Db.getRecordLength method returns the record length.</p>
     *  <p>
     *
     *  The Db.getRecordLength method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getRecordLength method returns the
     *      record length.</p>
     */
    public int getRecordLength() throws DbException {
        return db_javaJNI.Db_get_re_len(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getRecordPad()}
     */
    public int get_re_pad() throws DbException {
        return getRecordPad();
    }


    /**
     *  The Db.getRecordPad method returns the pad character.</p> <p>
     *
     *  The Db.getRecordPad method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getRecordPad method returns the
     *      pad character.</p>
     */
    public int getRecordPad() throws DbException {
        return db_javaJNI.Db_get_re_pad(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getRecordSource()}
     */
    public String get_re_source() throws DbException {
        return getRecordSource();
    }


    /**
     *  The Db.getRecordSource method returns the source file.</p> <p>
     *
     *  The Db.getRecordSource method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getRecordSource method returns the
     *      source file.</p>
     */
    public String getRecordSource() throws DbException {
        return db_javaJNI.Db_get_re_source(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getQueueExtentSize()}
     */
    public int get_q_extentsize() throws DbException {
        return getQueueExtentSize();
    }


    /**
     *  The Db.getQueueExtentSize method returns the number of pages
     *  in an extent.</p> <p>
     *
     *  The Db.getQueueExtentSize method may be called at any time
     *  during the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.getQueueExtentSize method returns
     *      the number of pages in an extent.</p>
     */
    public int getQueueExtentSize() throws DbException {
        return db_javaJNI.Db_get_q_extentsize(swigCPtr);
    }


    public int get_flags_raw() throws DbException {
        return db_javaJNI.Db_get_flags_raw(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #isTransactional()}
     */
    public boolean get_transactional() throws DbException {
        return isTransactional();
    }


    /**
     *  The Db.isTransactional method returns true if the {@link
     *  com.sleepycat.db.Db Db} handle has been opened in a
     *  transactional mode.</p> <p>
     *
     *  The Db.isTransactional method may be called at any time during
     *  the life of the application.</p>
     *
     * @throws  DbException  Signals that an exception of some sort
     *      has occurred.
     * @return               The Db.isTransactional method returns
     *      true if the {@link com.sleepycat.db.Db Db} handle has been
     *      opened in a transactional mode.</p>
     */
    public boolean isTransactional() throws DbException {
        return db_javaJNI.Db_get_transactional(swigCPtr);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #getDbType()}
     */
    public int get_type() throws DbException {
        return getDbType();
    }


    /**
     *  The Db.getDbType method returns the type of the underlying
     *  access method (and file format). The type value is one of
     *  Db.DB_BTREE, Db.DB_HASH, Db.DB_RECNO, or Db.DB_QUEUE. This
     *  value may be used to determine the type of the database after
     *  a return from {@link com.sleepycat.db.Db#open Db.open} with
     *  the <b>type</b> parameter set to Db.DB_UNKNOWN.</p> <p>
     *
     *  The Db.getDbType method may not be called before the {@link
     *  com.sleepycat.db.Db#open Db.open} method has been called.</p>
     *
     * @throws  IllegalArgumentException  The Db.getDbType method will
     *      fail and throw a IllegalArgumentException exception if the
     *      method was called before {@link com.sleepycat.db.Db#open
     *      Db.open} was called; or if an invalid flag value or
     *      parameter was specified.
     * @return                            The Db.getDbType method
     *      returns the type of the underlying access method (and file
     *      format).</p>
     */
    public int getDbType() throws DbException {
        return db_javaJNI.Db_get_type(swigCPtr);
    }


    /**
     *  The Db.join method creates a specialized join cursor for use
     *  in performing equality or natural joins on secondary indices.
     *  For information on how to organize your data to use this
     *  functionality, see <a href="{@docRoot}/../ref/am/join.html">
     *  Equality join</a> .</p> <p>
     *
     *  The Db.join method method is called using the {@link
     *  com.sleepycat.db.Db Db} handle of the primary database.</p>
     *  <p>
     *
     *  The join cursor supports only the {@link
     *  com.sleepycat.db.Dbc#get Dbc.get} and <b>dbc_close</b> cursor
     *  functions:</p> <p>
     *
     *  Iterates over the values associated with the keys to which
     *  each item in <b>curslist</b> was initialized. Any data value
     *  that appears in all items specified by the <b>curslist</b>
     *  parameter is then used as a key into the <b>primary</b> , and
     *  the key/data pair found in the <b>primary</b> is returned. The
     *  <b>flags</b> parameter must be set to 0 or the following
     *  value: In addition, the following flag may be set by bitwise
     *  inclusively <b>OR</b> 'ing it into the <b>flags</b> parameter:
     *  Close the returned cursor and release all resources. (Closing
     *  the cursors in <b>curslist</b> is the responsibility of the
     *  caller.)
     *
     * @param  curslist                   The <b>curslist</b>
     *      parameter contains a null terminated array of cursors.
     *      Each cursor must have been initialized to refer to the key
     *      on which the underlying database should be joined.
     *      Typically, this initialization is done by a {@link
     *      com.sleepycat.db.Dbc#get Dbc.get} call with the {@link
     *      com.sleepycat.db.Db#DB_SET Db.DB_SET} flag specified. Once
     *      the cursors have been passed as part of a <b>curslist</b>
     *      , they should not be accessed or modified until the newly
     *      created join cursor has been closed, or else inconsistent
     *      results may be returned. <p>
     *
     *      Joined values are retrieved by doing a sequential
     *      iteration over the first cursor in the <b>curslist</b>
     *      parameter, and a nested iteration over each secondary
     *      cursor in the order they are specified in the <b>curslist
     *      </b> parameter. This requires database traversals to
     *      search for the current datum in all the cursors after the
     *      first. For this reason, the best join performance normally
     *      results from sorting the cursors from the one that refers
     *      to the least number of data items to the one that refers
     *      to the most. By default, Db.join does this sort on behalf
     *      of its caller.</p> <p>
     *
     *      For the returned join cursor to be used in a
     *      transaction-protected manner, the cursors listed in <b>
     *      curslist</b> must have been created within the context of
     *      the same transaction.</p>
     * @param  flags                      must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_JOIN_NOSORT
     *        Db.DB_JOIN_NOSORT}<p>
     *
     *        Do not sort the cursors based on the number of data
     *        items to which they refer. If the data are structured so
     *        that cursors with many data items also share many common
     *        elements, higher performance will result from listing
     *        those cursors before cursors with fewer data items; that
     *        is, a sort order other than the default. The <code>Db.DB_JOIN_NOSORT</code>
     *        flag permits applications to perform join optimization
     *        prior to calling Db.join. </li>
     *      </ul>
     *
     * @throws  DbException               The Db.join method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Db.join method will fail
     *      and throw a IllegalArgumentException exception if cursor
     *      methods other than {@link com.sleepycat.db.Dbc#get
     *      Dbc.get} or {@link com.sleepycat.db.Dbc#close Dbc.close}
     *      were called; or if an invalid flag value or parameter was
     *      specified.
     * @return                            The Db.join method throws an
     *      exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public Dbc join(Dbc[] curslist, int flags) throws DbException {
        long cPtr = db_javaJNI.Db_join(swigCPtr, curslist, flags);
        return (cPtr == 0) ? null : new Dbc(cPtr, true);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #keyRange(DbTxn,Dbt,DbKeyRange,int)}
     */
    public void key_range(DbTxn txnid, Dbt key, DbKeyRange key_range, int flags) throws DbException {
        keyRange(txnid, key, key_range, flags);
    }


    /**
     *  The Db.keyRange method returns an estimate of the proportion
     *  of keys that are less than, equal to, and greater than the
     *  specified key. The underlying database must be of type Btree.
     *  </p> <p>
     *
     *  The Db.keyRange method fills in a DbKeyRange object. The
     *  following data fields are available from the DbKeyRange
     *  object:</p> Values are in the range of 0 to 1; for example, if
     *  the field <b>less</b> is 0.05, 5% of the keys in the database
     *  are less than the <b>key</b> parameter. The value for <b>equal
     *  </b> will be zero if there is no matching key, and will be
     *  non-zero otherwise.</p>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  key_range                   The estimates are returned
     *      in the <b>key_range</b> parameter, which contains three
     *      elements of type double: <b>less</b> , <b>equal</b> , and
     *      <b>greater</b> . Values are in the range of 0 to 1; for
     *      example, if the field <b>less</b> is 0.05, 5% of the keys
     *      in the database are less than the <b>key</b> parameter.
     *      The value for <b>equal</b> will be zero if there is no
     *      matching key, and will be non-zero otherwise.
     * @param  txnid                       If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null. The Db.keyRange method does not retain
     *      the locks it acquires for the life of the transaction, so
     *      estimates may not be repeatable.
     * @param  flags                       currently unused, and must
     *      be set to 0.
     * @throws  DbException                The Db.keyRange method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.keyRange method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.keyRange method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.keyRange method will
     *      fail and throw a IllegalArgumentException exception if the
     *      underlying database was not of type Btree; or if an
     *      invalid flag value or parameter was specified.
     */
    public void keyRange(DbTxn txnid, Dbt key, DbKeyRange key_range, int flags) throws DbException {
        db_javaJNI.Db_key_range(swigCPtr, DbTxn.getCPtr(txnid), key, key_range, flags);
    }


    void open0(DbTxn txnid, String file, String database, int type, int flags, int mode) {
        db_javaJNI.Db_open0(swigCPtr, DbTxn.getCPtr(txnid), file, database, type, flags, mode);
    }


    /**
     *  The Db.get method retrieves key/data pairs from the database.
     *  The byte array and length of the data associated with the
     *  specified <b>key</b> are returned in the structure to which
     *  <b>data</b> refers.</p> <p>
     *
     *  In the presence of duplicate key values, Db.get will return
     *  the first data item for the designated key. Duplicates are
     *  sorted by insert order, except where this order has been
     *  overridden by cursor operations. <b>Retrieval of duplicates
     *  requires the use of cursor operations.</b> See {@link
     *  com.sleepycat.db.Dbc#get Dbc.get} for details.</p> <p>
     *
     *  When called on a database that has been made into a secondary
     *  index using the {@link com.sleepycat.db.Db#associate
     *  Db.associate} method, the Db.get method returns the key from
     *  the secondary index and the data item from the primary
     *  database. In addition, the second method signature returns the
     *  key from the primary database. In databases that are not
     *  secondary indices, the second method signature will always
     *  fail.</p>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to 0 or one of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CONSUME
     *        Db.DB_CONSUME}<p>
     *
     *        Return the record number and data from the available
     *        record closest to the head of the queue, and delete the
     *        record. The cursor will be positioned on the deleted
     *        record. The record number will be returned in <b>key</b>
     *        , as described in {@link com.sleepycat.db.Dbt Dbt}. The
     *        data will be returned in the <b>data</b> parameter. A
     *        record is available if it is not deleted and is not
     *        currently locked. The underlying database must be of
     *        type Queue for <code>Db.DB_CONSUME</code> to be
     *        specified. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CONSUME_WAIT
     *        Db.DB_CONSUME_WAIT}<p>
     *
     *        The <code>Db.DB_CONSUME_WAIT</code> flag is the same as
     *        the <code>Db.DB_CONSUME</code> flag, except that if the
     *        Queue database is empty, the thread of control will wait
     *        until there is data in the queue before returning. The
     *        underlying database must be of type Queue for <code>Db.DB_CONSUME_WAIT</code>
     *        to be specified. <p>
     *
     *        If lock or transaction timeouts have been specified, the
     *        Db.get method with the <code>Db.DB_CONSUME_WAIT</code>
     *        flag may return <a href="{@docRoot}/../ref/program/errorret.html#DB_LOCK_NOTGRANTED">
     *        <code>Db.DB_LOCK_NOTGRANTED</code></a> . This failure,
     *        by itself, does not require the enclosing transaction be
     *        aborted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH
     *        Db.DB_GET_BOTH}<p>
     *
     *        Retrieve the key/data pair only if both the key and data
     *        match the arguments. <p>
     *
     *        When used with the second method signature version of
     *        this method on a secondary index handle, return the
     *        secondary key/primary key/data tuple only if both the
     *        primary and secondary keys match the arguments. It is an
     *        error to use the <code>Db.DB_GET_BOTH</code> flag with
     *        the first method signature version of this method and a
     *        secondary index handle.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RECNO
     *        Db.DB_SET_RECNO}<p>
     *
     *        Retrieve the specified numbered key/data pair from a
     *        database. Upon return, both the <b>key</b> and <b>data
     *        </b> items will have been filled in. <p>
     *
     *        The <b>data</b> field of the specified <b>key</b> must
     *        be a byte array large enough to hold a logical record
     *        number (that is, an int). This record number determines
     *        the record to be retrieved. <p>
     *
     *        For <code>Db.DB_SET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the DB_RECNUM flag.</p> </p>
     *        </li>
     *      </ul>
     *      In addition, the following flags may be set by bitwise
     *      inclusively <b>OR</b> 'ing them into the <b>flags</b>
     *      parameter:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.get call within a transaction. If the
     *        call succeeds, changes made by the operation will be
     *        recoverable. If the call fails, the operation will have
     *        made no changes. This flag may only be specified with
     *        the <code>Db.DB_CONSUME</code> and <code>Db.DB_CONSUME_WAIT</code>
     *        flags. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        Read modified but not yet committed data. Silently
     *        ignored if the {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        <code>Db.DB_DIRTY_READ</code>} flag was not specified
     *        when the underlying database was opened. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE
     *        Db.DB_MULTIPLE}<p>
     *
     *        Return multiple data items in the buffer to which the
     *        <b>data</b> parameter refers. <p>
     *
     *        In the case of Btree or Hash databases, all of the data
     *        items associated with the specified key are entered into
     *        the buffer. In the case of Queue or Recno databases, all
     *        of the data items in the database, starting at, and
     *        subsequent to, the specified key, are entered into the
     *        buffer.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE</code> flag may only be used
     *        alone, or with the <code>Db.DB_GET_BOTH</code> and
     *        <code>Db.DB_SET_RECNO</code> options. The <code>Db.DB_MULTIPLE</code>
     *        flag may not be used when accessing databases made into
     *        secondary indices using the {@link
     *        com.sleepycat.db.Db#associate Db.associate} method.</p>
     *        <p>
     *
     *        See {@link com.sleepycat.db.DbMultipleDataIterator
     *        DbMultipleDataIterator} for more information.</p> </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RMW Db.DB_RMW}<p>
     *
     *        Acquire write locks instead of read locks when doing the
     *        retrieval. Setting this flag can eliminate deadlock
     *        during a read-modify-write cycle by acquiring the write
     *        lock during the read part of the cycle so that another
     *        thread of control acquiring a read lock for the same
     *        item, in its own read-modify-write cycle, will not
     *        result in deadlock. <p>
     *
     *        Because the Db.get method will not hold locks across
     *        Berkeley DB calls in non-transactional operations, the
     *        {@link com.sleepycat.db.Db#DB_RMW <code>Db.DB_RMW</code>
     *        } flag to the Db.get call is meaningful only in the
     *        presence of transactions.</p> </li>
     *      </ul>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  pkey                        the return key from the
     *      primary database.
     * @param  txnid                       If the operation is to be
     *      transaction-protected, the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null.
     * @throws  DbException                The Db.get method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.get method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.get method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  DbLockNotGrantedException  If the Db.DB_CONSUME_WAIT
     *      flag was specified, lock or transaction timers were
     *      configured and the lock could not be granted before the
     *      wait-time expired, the Db.get method will fail and throw a
     *      {@link com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.get method will fail
     *      and throw a IllegalArgumentException exception if a record
     *      number of 0 was specified; the {@link
     *      com.sleepycat.db.Db#DB_THREAD Db.DB_THREAD} flag was
     *      specified to the {@link com.sleepycat.db.Db#open Db.open}
     *      method and none of the {@link
     *      com.sleepycat.db.Db#DB_DBT_MALLOC Db.DB_DBT_MALLOC},
     *      {@link com.sleepycat.db.Db#DB_DBT_REALLOC
     *      Db.DB_DBT_REALLOC} or {@link
     *      com.sleepycat.db.Db#DB_DBT_USERMEM Db.DB_DBT_USERMEM}
     *      flags were set in the {@link com.sleepycat.db.Dbt Dbt};
     *      the second method signature was called with a {@link
     *      com.sleepycat.db.Db Db} handle that does not refer to a
     *      secondary index; or if an invalid flag value or parameter
     *      was specified.
     * @throws  DbMemoryException          If the requested item could
     *      not be returned due to insufficient memory, the Db.get
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     * @return
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Db.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the specified key is
     *        not in the database. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Db.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if the database is a
     *        Queue or Recno database and the specified key exists,
     *        but was never explicitly created by the application or
     *        was later deleted. </li>
     *      </ul>
     *      Unless otherwise specified, the Db.get method throws an
     *      exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public int get(DbTxn txnid, Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_get__SWIG_1(swigCPtr, DbTxn.getCPtr(txnid), key, pkey, data, flags);
    }


    /**
     *  The Db.put method stores key/data pairs in the database. The
     *  default behavior of the Db.put function is to enter the new
     *  key/data pair, replacing any previously existing key if
     *  duplicates are disallowed, or adding a duplicate data item if
     *  duplicates are allowed. If the database supports duplicates,
     *  the Db.put method adds the new data value at the end of the
     *  duplicate set. If the database supports sorted duplicates, the
     *  new data value is inserted at the correct sorted location.</p>
     *
     * @param  flags                       must be set to 0 or one of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_APPEND Db.DB_APPEND}
     *        <p>
     *
     *        Append the key/data pair to the end of the database. For
     *        the <code>Db.DB_APPEND</code> flag to be specified, the
     *        underlying database must be a Queue or Recno database.
     *        The record number allocated to the record is returned in
     *        the specified <b>key</b> . <p>
     *
     *        There is a minor behavioral difference between the Recno
     *        and Queue access methods for the <code>Db.DB_APPEND</code>
     *        flag. If a transaction enclosing a Db.put operation with
     *        the <code>Db.DB_APPEND</code> flag aborts, the record
     *        number may be decremented (and later reallocated by a
     *        subsequent <code>Db.DB_APPEND</code> operation) by the
     *        Recno access method, but will not be decremented or
     *        reallocated by the Queue access method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NODUPDATA
     *        Db.DB_NODUPDATA}<p>
     *
     *        In the case of the Btree and Hash access methods, enter
     *        the new key/data pair only if it does not already appear
     *        in the database. <p>
     *
     *        The <code>Db.DB_NODUPDATA</code> flag may only be
     *        specified if the underlying database has been configured
     *        to support sorted duplicates. The <code>Db.DB_NODUPDATA</code>
     *        flag may not be specified to the Queue or Recno access
     *        methods.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOOVERWRITE
     *        Db.DB_NOOVERWRITE}<p>
     *
     *        Enter the new key/data pair only if the key does not
     *        already appear in the database. The Db.put method call
     *        with the <code>Db.DB_NOOVERWRITE</code> flag set will
     *        fail if the key already exists in the database, even if
     *        the database supports duplicates. </li>
     *      </ul>
     *      In addition, the following flag may be set by bitwise
     *      inclusively <b>OR</b> 'ing it into the <b>flags</b>
     *      parameter:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.put call within a transaction. If the
     *        call succeeds, changes made by the operation will be
     *        recoverable. If the call fails, the operation will have
     *        made no changes. </li>
     *      </ul>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  txnid                       If the operation is to be
     *      transaction-protected, (other than by specifying the
     *      Db.DB_AUTO_COMMIT flag), the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null.
     * @throws  DbException                The Db.put method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> An attempt was made to modify a read-only database. A
     *      btree exceeded the maximum btree depth (255).
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.put method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.put method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.put method will fail
     *      and throw a IllegalArgumentException exception if a record
     *      number of 0 was specified; an attempt was made to add a
     *      record to a fixed-length database that was too large to
     *      fit; an attempt was made to do a partial put; an attempt
     *      was made to add a record to a secondary index; or if an
     *      invalid flag value or parameter was specified.
     * @return                             Unless otherwise specified,
     *      the Db.put method throws an exception that encapsulates a
     *      non-zero error value on failure. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEXIST DB_KEYEXIST}
     *        <p>
     *
     *        The Db.put method will return {@link
     *        com.sleepycat.db.Db#DB_KEYEXIST <code>Db.DB_KEYEXIST</code>
     *        } if <code>Db.DB_NODUPDATA</code> is set and the
     *        key/data pair already appears in the database. </li>
     *
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEXIST DB_KEYEXIST}
     *        <p>
     *
     *        The Db.put method will return {@link
     *        com.sleepycat.db.Db#DB_KEYEXIST <code>Db.DB_KEYEXIST</code>
     *        } if <code>Db.DB_NOOVERWRITE</code> is set and the key
     *        already appears in the database. </li>
     *      </ul>
     *      </p>
     */
    public int put(DbTxn txnid, Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_put(swigCPtr, DbTxn.getCPtr(txnid), key, data, flags);
    }


    void remove0(String file, String database, int flags) {
        db_javaJNI.Db_remove0(swigCPtr, file, database, flags);
    }


    void rename0(String file, String database, String newname, int flags) {
        db_javaJNI.Db_rename0(swigCPtr, file, database, newname, flags);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setAppendRecno(DbAppendRecno)}
     */
    public void set_append_recno(DbAppendRecno db_append_recno_fcn) throws DbException {
        setAppendRecno(db_append_recno_fcn);
    }


    public void setAppendRecno(DbAppendRecno db_append_recno_fcn) throws DbException {
        db_javaJNI.Db_set_append_recno(swigCPtr, (append_recno_handler = db_append_recno_fcn));
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setBtreeCompare(DbBtreeCompare)}
     */
    public void set_bt_compare(DbBtreeCompare bt_compare_fcn) throws DbException {
        setBtreeCompare(bt_compare_fcn);
    }


    public void setBtreeCompare(DbBtreeCompare bt_compare_fcn) throws DbException {
        db_javaJNI.Db_set_bt_compare(swigCPtr, (bt_compare_handler = bt_compare_fcn));
    }


    public void set_bt_maxkey(int maxkey) throws DbException {
        db_javaJNI.Db_set_bt_maxkey(swigCPtr, maxkey);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setBtreeMinKey(int)}
     */
    public void set_bt_minkey(int bt_minkey) throws DbException {
        setBtreeMinKey(bt_minkey);
    }


    /**
     *  Set the minimum number of key/data pairs intended to be stored
     *  on any single Btree leaf page.</p> <p>
     *
     *  This value is used to determine if key or data items will be
     *  stored on overflow pages instead of Btree leaf pages. For more
     *  information on the specific algorithm used, see <a
     *  href="{@docRoot}/../ref/am_conf/bt_minkey.html">Minimum keys
     *  per page</a> . The <b>bt_minkey</b> value specified must be at
     *  least 2; if <b>bt_minkey</b> is not explicitly set, a value of
     *  2 is used.</p> <p>
     *
     *  The Db.setBtreeMinKey method configures a database, not only
     *  operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setBtreeMinKey method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setBtreeMinKey will be ignored. </p> <hr
     *  size=1 noshade> <h3>Description: Db.getBtreeMinKey</h3>
     *
     * @param  bt_minkey                  the minimum number of
     *      key/data pairs intended to be stored on any single Btree
     *      leaf page.
     * @throws  IllegalArgumentException  The Db.setBtreeMinKey method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setBtreeMinKey(int bt_minkey) throws DbException {
        db_javaJNI.Db_set_bt_minkey(swigCPtr, bt_minkey);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setBtreePrefix(DbBtreePrefix)}
     */
    public void set_bt_prefix(DbBtreePrefix bt_prefix_fcn) throws DbException {
        setBtreePrefix(bt_prefix_fcn);
    }


    public void setBtreePrefix(DbBtreePrefix bt_prefix_fcn) throws DbException {
        db_javaJNI.Db_set_bt_prefix(swigCPtr, (bt_prefix_handler = bt_prefix_fcn));
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setCacheSize(long,int)}
     */
    public void set_cachesize(long bytes, int ncache) throws DbException {
        setCacheSize(bytes, ncache);
    }


    /**
     *  Set the size of the shared memory buffer pool -- that is, the
     *  cache. The cache should be the size of the normal working data
     *  set of the application, with some small amount of additional
     *  memory for unusual situations. (Note: the working set is not
     *  the same as the number of pages accessed simultaneously, and
     *  is usually much larger.)</p> <p>
     *
     *  The default cache size is 256KB, and may not be specified as
     *  less than 20KB. Any cache size less than 500MB is
     *  automatically increased by 25% to account for buffer pool
     *  overhead; cache sizes larger than 500MB are used as specified.
     *  The current maximum size of a single cache is 4GB. (All sizes
     *  are in powers-of-two, that is, 256KB is 2^32 not 256,000.) For
     *  information on tuning the Berkeley DB cache size, see <a
     *  href="{@docRoot}/../ref/am_conf/cachesize.html">Selecting a
     *  cache size</a> .</p> <p>
     *
     *  It is possible to specify caches to Berkeley DB larger than
     *  4GB and/or large enough they cannot be allocated contiguously
     *  on some architectures. For example, some releases of Solaris
     *  limit the amount of memory that may be allocated contiguously
     *  by a process. If <b>ncache</b> is 0 or 1, the cache will be
     *  allocated contiguously in memory. If it is greater than 1, the
     *  cache will be broken up into <b>ncache</b> equally sized,
     *  separate pieces of memory.</p> <p>
     *
     *  Because databases opened within Berkeley DB environments use
     *  the cache specified to the environment, it is an error to
     *  attempt to set a cache in a database created within an
     *  environment.</p> <p>
     *
     *  The Db.setCacheSize method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. </p>
     *
     * @param  bytes                      The size of the cache in
     *      bytes.
     * @param  ncache                     the number of caches to
     *      create.
     * @throws  IllegalArgumentException  The Db.setCacheSize method
     *      will fail and throw a IllegalArgumentException exception
     *      if the specified cache size was impossibly small; called
     *      in a database environment; the method was called after
     *      {@link com.sleepycat.db.Db#open Db.open} was called; or if
     *      an invalid flag value or parameter was specified.
     */
    public void setCacheSize(long bytes, int ncache) throws DbException {
        db_javaJNI.Db_set_cachesize(swigCPtr, bytes, ncache);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setDuplicateCompare(DbDupCompare)}
     */
    public void set_dup_compare(DbDupCompare dup_compare_fcn) throws DbException {
        setDuplicateCompare(dup_compare_fcn);
    }


    public void setDuplicateCompare(DbDupCompare dup_compare_fcn) throws DbException {
        db_javaJNI.Db_set_dup_compare(swigCPtr, (dup_compare_handler = dup_compare_fcn));
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setEncrypted(String,int)}
     */
    public void set_encrypt(String passwd, int flags) throws DbException {
        setEncrypted(passwd, flags);
    }


    /**
     *  Set the password used by the Berkeley DB library to perform
     *  encryption and decryption.</p> <p>
     *
     *  Because databases opened within Berkeley DB environments use
     *  the password specified to the environment, it is an error to
     *  attempt to set a password in a database created within an
     *  environment.</p> <p>
     *
     *  The Db.setEncrypted method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. </p>
     *
     * @param  flags                      must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ENCRYPT_AES
     *        Db.DB_ENCRYPT_AES}<p>
     *
     *        Use the Rijndael/AES (also known as the Advanced
     *        Encryption Standard and Federal Information Processing
     *        Standard (FIPS) 197) algorithm for encryption or
     *        decryption. </li>
     *      </ul>
     *
     * @param  passwd                     the password used to perform
     *      encryption and decryption.
     * @throws  DbException               The Db.setEncrypted method
     *      may fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> Cryptography is not available in this Berkeley DB
     *      release.
     * @throws  IllegalArgumentException  The Db.setEncrypted method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setEncrypted(String passwd, int flags) throws DbException {
        db_javaJNI.Db_set_encrypt(swigCPtr, passwd, flags);
    }


    public void setFeedbackHandler(DbFeedbackHandler db_feedback_fcn) throws DbException {
        db_javaJNI.Db_setFeedbackHandler(swigCPtr, (db_feedback_handler = db_feedback_fcn));
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setFlags(int)}
     */
    public void set_flags(int flags) throws DbException {
        setFlags(flags);
    }


    /**
     *  Configure a database. Calling Db.setFlags is additive; there
     *  is no way to clear flags.</p> <p>
     *
     *  The Db.setFlags method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. </p>
     *
     * @param  flags                      must be set to 0 or by
     *      bitwise inclusively <b>OR</b> 'ing together one or more of
     *      the following values: <h3>General</h3> <p>
     *
     *      The following flags may be specified for any Berkeley DB
     *      access method:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CHKSUM Db.DB_CHKSUM}
     *        <p>
     *
     *        Do checksum verification of pages read into the cache
     *        from the backing filestore. Berkeley DB uses the SHA1
     *        Secure Hash Algorithm if encryption is configured and a
     *        general hash algorithm if it is not. <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_CHKSUM</code>
     *        flag only affects the specified {@link
     *        com.sleepycat.db.Db Db} handle (and any other Berkeley
     *        DB handles opened within the scope of that handle).</p>
     *        <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_CHKSUM flag will be ignored.</p> If creating
     *        additional databases in a file, the checksum behavior
     *        specified must be consistent with the existing databases
     *        in the file or an error will be returned. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_ENCRYPT
     *        Db.DB_ENCRYPT}<p>
     *
     *        Encrypt the database using the cryptographic password
     *        specified to the {@link com.sleepycat.db.DbEnv#setEncrypted
     *        DbEnv.setEncrypted} or {@link
     *        com.sleepycat.db.Db#setEncrypted Db.setEncrypted}
     *        methods. <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_ENCRYPT</code>
     *        flag only affects the specified {@link
     *        com.sleepycat.db.Db Db} handle (and any other Berkeley
     *        DB handles opened within the scope of that handle).</p>
     *        <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_ENCRYPT flag must be the same as the existing
     *        database or an error will be returned. </p> If creating
     *        additional databases in a file, the encryption behavior
     *        specified must be consistent with the existing databases
     *        in the file or an error will be returned. <p>
     *
     *        Encrypted databases are not portable between machines of
     *        different byte orders, that is, encrypted databases
     *        created on big-endian machines cannot be read on
     *        little-endian machines, and vice versa.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_TXN_NOT_DURABLE
     *        Db.DB_TXN_NOT_DURABLE}<p>
     *
     *        If set, Berkeley DB will not write log records for this
     *        database. This means that updates of this database
     *        exhibit the ACI (atomicity, consistency, and isolation)
     *        properties, but not D (durability); that is, database
     *        integrity will be maintained, but if the application or
     *        system fails, integrity will not persist. The database
     *        file must be verified and/or restored from backup after
     *        a failure. In order to ensure integrity after
     *        application shut down, the database handles must be
     *        closed without specifying {@link
     *        com.sleepycat.db.Db#DB_NOSYNC <code>Db.DB_NOSYNC</code>
     *        }, or all database changes must be flushed from the
     *        database environment cache using the {@link
     *        com.sleepycat.db.DbEnv#txnCheckpoint
     *        DbEnv.txnCheckpoint} method. All database handles for a
     *        single physical file must set <code>Db.DB_TXN_NOT_DURABLE</code>
     *        , including database handles for different databases in
     *        a physical file. <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_TXN_NOT_DURABLE</code>
     *        flag only affects the specified {@link
     *        com.sleepycat.db.Db Db} handle (and any other Berkeley
     *        DB handles opened within the scope of that handle).</p>
     *        </li>
     *      </ul>
     *      <h3>Btree</h3> <p>
     *
     *      The following flags may be specified for the Btree access
     *      method:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DUP Db.DB_DUP}<p>
     *
     *        Permit duplicate data items in the database; that is,
     *        insertion when the key of the key/data pair being
     *        inserted already exists in the database will be
     *        successful. The ordering of duplicates in the database
     *        is determined by the order of insertion, unless the
     *        ordering is otherwise specified by use of a cursor
     *        operation. <p>
     *
     *        The <code>Db.DB_DUPSORT</code> flag is preferred to
     *        <code>Db.DB_DUP</code> for performance reasons. The
     *        <code>Db.DB_DUP</code> flag should only be used by
     *        applications wanting to order duplicate data items
     *        manually.</p> <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_DUP</code> flag
     *        affects the database, including all threads of control
     *        accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the DB_DUP
     *        flag must be the same as the existing database or an
     *        error will be returned. </p> <p>
     *
     *        It is an error to specify both <code>Db.DB_DUP</code>
     *        and <code>Db.DB_RECNUM</code>.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DUPSORT
     *        Db.DB_DUPSORT}<p>
     *
     *        Permit duplicate data items in the database; that is,
     *        insertion when the key of the key/data pair being
     *        inserted already exists in the database will be
     *        successful. The ordering of duplicates in the database
     *        is determined by the duplicate comparison function. A
     *        default lexical comparison will be used. It is an error
     *        to specify both <code>Db.DB_DUPSORT</code> and <code>Db.DB_RECNUM</code>
     *        . <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_DUPSORT</code>
     *        flag affects the database, including all threads of
     *        control accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_DUPSORT flag must be the same as the existing
     *        database or an error will be returned. </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RECNUM Db.DB_RECNUM}
     *        <p>
     *
     *        Support retrieval from the Btree using record numbers.
     *        For more information, see the {@link
     *        com.sleepycat.db.Db#DB_SET_RECNO <code>Db.DB_SET_RECNO</code>
     *        } flag to the {@link com.sleepycat.db.Db#get Db.get} and
     *        {@link com.sleepycat.db.Dbc#get Dbc.get} methods. <p>
     *
     *        Logical record numbers in Btree databases are mutable in
     *        the face of record insertion or deletion. See the <code>Db.DB_RENUMBER</code>
     *        flag in the Recno access method information for further
     *        discussion.</p> <p>
     *
     *        Maintaining record counts within a Btree introduces a
     *        serious point of contention, namely the page locations
     *        where the record counts are stored. In addition, the
     *        entire database must be locked during both insertions
     *        and deletions, effectively single-threading the database
     *        for those operations. Specifying <code>Db.DB_RECNUM</code>
     *        can result in serious performance degradation for some
     *        applications and data sets.</p> <p>
     *
     *        It is an error to specify both <code>Db.DB_DUP</code>
     *        and <code>Db.DB_RECNUM</code>.</p> <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_RECNUM</code>
     *        flag affects the database, including all threads of
     *        control accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_RECNUM flag must be the same as the existing database
     *        or an error will be returned. </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_REVSPLITOFF
     *        Db.DB_REVSPLITOFF}<p>
     *
     *        Turn off reverse splitting in the Btree. As pages are
     *        emptied in a database, the Berkeley DB Btree
     *        implementation attempts to coalesce empty pages into
     *        higher-level pages in order to keep the database as
     *        small as possible and minimize search time. This can
     *        hurt performance in applications with cyclical data
     *        demands; that is, applications where the database grows
     *        and shrinks repeatedly. For example, because Berkeley DB
     *        does page-level locking, the maximum level of
     *        concurrency in a database of two pages is far smaller
     *        than that in a database of 100 pages, so a database that
     *        has shrunk to a minimal size can cause severe
     *        deadlocking when a new cycle of data insertion begins.
     *        <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_REVSPLITOFF</code>
     *        flag only affects the specified {@link
     *        com.sleepycat.db.Db Db} handle (and any other Berkeley
     *        DB handles opened within the scope of that handle).</p>
     *        </li>
     *      </ul>
     *      <h3>Hash</h3> <p>
     *
     *      The following flags may be specified for the Hash access
     *      method:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DUP Db.DB_DUP}<p>
     *
     *        Permit duplicate data items in the database; that is,
     *        insertion when the key of the key/data pair being
     *        inserted already exists in the database will be
     *        successful. The ordering of duplicates in the database
     *        is determined by the order of insertion, unless the
     *        ordering is otherwise specified by use of a cursor
     *        operation. <p>
     *
     *        The <code>Db.DB_DUPSORT</code> flag is preferred to
     *        <code>Db.DB_DUP</code> for performance reasons. The
     *        <code>Db.DB_DUP</code> flag should only be used by
     *        applications wanting to order duplicate data items
     *        manually.</p> <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_DUP</code> flag
     *        affects the database, including all threads of control
     *        accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the DB_DUP
     *        flag must be the same as the existing database or an
     *        error will be returned. </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DUPSORT
     *        Db.DB_DUPSORT}<p>
     *
     *        Permit duplicate data items in the database; that is,
     *        insertion when the key of the key/data pair being
     *        inserted already exists in the database will be
     *        successful. The ordering of duplicates in the database
     *        is determined by the duplicate comparison function. A
     *        default lexical comparison will be used. It is an error
     *        to specify both <code>Db.DB_DUPSORT</code> and <code>Db.DB_RECNUM</code>
     *        . <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_DUPSORT</code>
     *        flag affects the database, including all threads of
     *        control accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_DUPSORT flag must be the same as the existing
     *        database or an error will be returned. </p> </li>
     *      </ul>
     *      <h3>Queue</h3> <p>
     *
     *      There are no additional flags that may be specified for
     *      the Queue access method.</p> <h3>Recno</h3> <p>
     *
     *      The following flags may be specified for the Recno access
     *      method:</p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RENUMBER
     *        Db.DB_RENUMBER}<p>
     *
     *        Specifying the <code>Db.DB_RENUMBER</code> flag causes
     *        the logical record numbers to be mutable, and change as
     *        records are added to and deleted from the database. For
     *        example, the deletion of record number 4 causes records
     *        numbered 5 and greater to be renumbered downward by one.
     *        If a cursor was positioned to record number 4 before the
     *        deletion, it will refer to the new record number 4, if
     *        any such record exists, after the deletion. If a cursor
     *        was positioned after record number 4 before the
     *        deletion, it will be shifted downward one logical
     *        record, continuing to refer to the same record as it did
     *        before. <p>
     *
     *        Using the {@link com.sleepycat.db.Db#put Db.put} or
     *        {@link com.sleepycat.db.Dbc#put Dbc.put} interfaces to
     *        create new records will cause the creation of multiple
     *        records if the record number is more than one greater
     *        than the largest record currently in the database. For
     *        example, creating record 28, when record 25 was
     *        previously the last record in the database, will create
     *        records 26 and 27 as well as 28. Attempts to retrieve
     *        records that were created in this manner will result in
     *        an error return of <a href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> .</p> <p>
     *
     *        If a created record is not at the end of the database,
     *        all records following the new record will be
     *        automatically renumbered upward by one. For example, the
     *        creation of a new record numbered 8 causes records
     *        numbered 8 and greater to be renumbered upward by one.
     *        If a cursor was positioned to record number 8 or greater
     *        before the insertion, it will be shifted upward one
     *        logical record, continuing to refer to the same record
     *        as it did before.</p> <p>
     *
     *        For these reasons, concurrent access to a Recno database
     *        with the <code>Db.DB_RENUMBER</code> flag specified may
     *        be largely meaningless, although it is supported.</p>
     *        <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_RENUMBER</code>
     *        flag affects the database, including all threads of
     *        control accessing the database.</p> <p>
     *
     *        If the database already exists when {@link
     *        com.sleepycat.db.Db#open Db.open} is called, the
     *        DB_RENUMBER flag must be the same as the existing
     *        database or an error will be returned. </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SNAPSHOT
     *        Db.DB_SNAPSHOT}<p>
     *
     *        This flag specifies that any specified <b>re_source</b>
     *        file be read in its entirety when {@link
     *        com.sleepycat.db.Db#open Db.open} is called. If this
     *        flag is not specified, the <b>re_source</b> file may be
     *        read lazily. <p>
     *
     *        Calling Db.setFlags with the <code>Db.DB_SNAPSHOT</code>
     *        flag only affects the specified {@link
     *        com.sleepycat.db.Db Db} handle (and any other Berkeley
     *        DB handles opened within the scope of that handle).</p>
     *        </li>
     *      </ul>
     *
     * @throws  IllegalArgumentException  The Db.setFlags method will
     *      fail and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     */
    public void setFlags(int flags) throws DbException {
        db_javaJNI.Db_set_flags(swigCPtr, flags);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setHashFillFactor(int)}
     */
    public void set_h_ffactor(int h_ffactor) throws DbException {
        setHashFillFactor(h_ffactor);
    }


    /**
     *  Set the desired density within the hash table. If no value is
     *  specified, the fill factor will be selected dynamically as
     *  pages are filled.</p> <p>
     *
     *  The Db.setHashFillFactor method configures a database, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setHashFillFactor method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setHashFillFactor will be ignored. </p> The
     *  density is an approximation of the number of keys allowed to
     *  accumulate in any one bucket, determining when the hash table
     *  grows or shrinks. If you know the average sizes of the keys
     *  and data in your data set, setting the fill factor can enhance
     *  performance. A reasonable rule computing fill factor is to set
     *  it to the following:</p> <blockquote><pre>(pagesize - 32) / (average_key_size + average_data_size + 8)</pre>
     *  </blockquote>
     *
     * @param  h_ffactor                  the desired density within
     *      the hash table.
     * @throws  IllegalArgumentException  The Db.setHashFillFactor
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setHashFillFactor(int h_ffactor) throws DbException {
        db_javaJNI.Db_set_h_ffactor(swigCPtr, h_ffactor);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setHash(DbHash)}
     */
    public void set_h_hash(DbHash h_hash_fcn) throws DbException {
        setHash(h_hash_fcn);
    }


    public void setHash(DbHash h_hash_fcn) throws DbException {
        db_javaJNI.Db_set_h_hash(swigCPtr, (h_hash_handler = h_hash_fcn));
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setHashNumElements(int)}
     */
    public void set_h_nelem(int h_nelem) throws DbException {
        setHashNumElements(h_nelem);
    }


    /**
     *  Set an estimate of the final size of the hash table.</p> <p>
     *
     *  In order for the estimate to be used when creating the
     *  database, the {@link com.sleepycat.db.Db#setHashFillFactor
     *  Db.setHashFillFactor} method must also be called. If the
     *  estimate or fill factor are not set or are set too low, hash
     *  tables will still expand gracefully as keys are entered,
     *  although a slight performance degradation may be noticed.</p>
     *  <p>
     *
     *  The Db.setHashNumElements method configures a database, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setHashNumElements method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setHashNumElements will be ignored. </p>
     *
     * @param  h_nelem                    an estimate of the final
     *      size of the hash table.
     * @throws  IllegalArgumentException  The Db.setHashNumElements
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setHashNumElements(int h_nelem) throws DbException {
        db_javaJNI.Db_set_h_nelem(swigCPtr, h_nelem);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setByteOrder(int)}
     */
    public void set_lorder(int lorder) throws DbException {
        setByteOrder(lorder);
    }


    /**
     *  Set the byte order for integers in the stored database
     *  metadata. The host byte order of the machine where the
     *  Berkeley DB library was compiled will be used if no byte order
     *  is set.</p> <p>
     *
     *  <b>The access methods provide no guarantees about the byte
     *  ordering of the application data stored in the database, and
     *  applications are responsible for maintaining any necessary
     *  ordering.</b> </p> <p>
     *
     *  The Db.setByteOrder method configures a database, not only
     *  operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setByteOrder method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. If the
     *  database already exists when {@link com.sleepycat.db.Db#open
     *  Db.open} is called, the information specified to
     *  Db.setByteOrder will be ignored. </p> If creating additional
     *  databases in a single physical file, information specified to
     *  Db.setByteOrder will be ignored and the byte order of the
     *  existing databases will be used.
     *
     * @param  lorder                     The <b>lorder</b> parameter
     *      should represent the byte order as an integer; for
     *      example, big endian order is the number 4,321, and little
     *      endian order is the number 1,234.
     * @throws  IllegalArgumentException  The Db.setByteOrder method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setByteOrder(int lorder) throws DbException {
        db_javaJNI.Db_set_lorder(swigCPtr, lorder);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setPageSize(long)}
     */
    public void set_pagesize(long pagesize) throws DbException {
        setPageSize(pagesize);
    }


    /**
     *  Set the size of the pages used to hold items in the database,
     *  in bytes. The minimum page size is 512 bytes, the maximum page
     *  size is 64K bytes, and the page size must be a power-of-two.
     *  If the page size is not explicitly set, one is selected based
     *  on the underlying filesystem I/O block size. The automatically
     *  selected size has a lower limit of 512 bytes and an upper
     *  limit of 16K bytes.</p> <p>
     *
     *  For information on tuning the Berkeley DB page size, see <a
     *  href="{@docRoot}/../ref/am_conf/pagesize.html">Selecting a
     *  page size</a> .</p> <p>
     *
     *  The Db.setPageSize method configures a database, not only
     *  operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setPageSize method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. If the
     *  database already exists when {@link com.sleepycat.db.Db#open
     *  Db.open} is called, the information specified to
     *  Db.setPageSize will be ignored. </p> If creating additional
     *  databases in a file, the page size specified must be
     *  consistent with the existing databases in the file or an error
     *  will be returned.
     *
     * @param  pagesize                   The <b>pagesize</b>
     *      parameter sets the database page size.
     * @throws  IllegalArgumentException  The Db.setPageSize method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setPageSize(long pagesize) throws DbException {
        db_javaJNI.Db_set_pagesize(swigCPtr, pagesize);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setRecordDelimiter(int)}
     */
    public void set_re_delim(int re_delim) throws DbException {
        setRecordDelimiter(re_delim);
    }


    /**
     *  Set the delimiting byte used to mark the end of a record in
     *  the backing source file for the Recno access method.</p> <p>
     *
     *  This byte is used for variable length records if the <b>
     *  re_source</b> file is specified. If the <b>re_source</b> file
     *  is specified and no delimiting byte was specified,
     *  &lt;newline&gt; characters (that is, ASCII 0x0a) are
     *  interpreted as end-of-record markers.</p> <p>
     *
     *  The Db.setRecordDelimiter method configures a database, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setRecordDelimiter method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setRecordDelimiter will be ignored. </p>
     *
     * @param  re_delim                   the delimiting byte used to
     *      mark the end of a record.
     * @throws  IllegalArgumentException  The Db.setRecordDelimiter
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setRecordDelimiter(int re_delim) throws DbException {
        db_javaJNI.Db_set_re_delim(swigCPtr, re_delim);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setRecordLength(int)}
     */
    public void set_re_len(int re_len) throws DbException {
        setRecordLength(re_len);
    }


    /**
     *  For the Queue access method, specify that the records are of
     *  length <b>re_len</b> . For the Queue access method, the record
     *  length must be enough smaller than the database's page size
     *  that at least one record plus the database page's metadata
     *  information can fit on each database page.</p> <p>
     *
     *  For the Recno access method, specify that the records are
     *  fixed-length, not byte-delimited, and are of length <b>re_len
     *  </b>.</p> <p>
     *
     *  Any records added to the database that are less than <b>re_len
     *  </b> bytes long are automatically padded (see {@link
     *  com.sleepycat.db.Db#setRecordPad Db.setRecordPad} for more
     *  information).</p> <p>
     *
     *  Any attempt to insert records into the database that are
     *  greater than <b>re_len</b> bytes long will cause the call to
     *  fail immediately and return an error.</p> <p>
     *
     *  The Db.setRecordLength method configures a database, not only
     *  operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setRecordLength method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setRecordLength will be ignored. </p>
     *
     * @param  re_len                     the length of a Queue or
     *      Recno database record, in bytes.
     * @throws  IllegalArgumentException  The Db.setRecordLength
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setRecordLength(int re_len) throws DbException {
        db_javaJNI.Db_set_re_len(swigCPtr, re_len);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setRecordPad(int)}
     */
    public void set_re_pad(int re_pad) throws DbException {
        setRecordPad(re_pad);
    }


    /**
     *  Set the padding character for short, fixed-length records for
     *  the Queue and Recno access methods.</p> <p>
     *
     *  If no pad character is specified, &lt;space&gt; characters
     *  (that is, ASCII 0x20) are used for padding.</p> <p>
     *
     *  The Db.setRecordPad method configures a database, not only
     *  operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setRecordPad method may not be called after the {@link
     *  com.sleepycat.db.Db#open Db.open} method is called. If the
     *  database already exists when {@link com.sleepycat.db.Db#open
     *  Db.open} is called, the information specified to
     *  Db.setRecordPad will be ignored. </p>
     *
     * @param  re_pad                     the pad character for
     *      fixed-length records for the Queue and Recno access
     *      methods.
     * @throws  IllegalArgumentException  The Db.setRecordPad method
     *      will fail and throw a IllegalArgumentException exception
     *      if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setRecordPad(int re_pad) throws DbException {
        db_javaJNI.Db_set_re_pad(swigCPtr, re_pad);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setRecordSource(String)}
     */
    public void set_re_source(String source) throws DbException {
        setRecordSource(source);
    }


    /**
     *  Set the underlying source file for the Recno access method.
     *  The purpose of the <b>source</b> value is to provide fast
     *  access and modification to databases that are normally stored
     *  as flat text files.</p> <p>
     *
     *  The <b>source</b> parameter specifies an underlying flat text
     *  database file that is read to initialize a transient record
     *  number index. In the case of variable length records, the
     *  records are separated, as specified by {@link
     *  com.sleepycat.db.Db#setRecordDelimiter Db.setRecordDelimiter}.
     *  For example, standard UNIX byte stream files can be
     *  interpreted as a sequence of variable length records separated
     *  by &lt;newline&gt; characters.</p> <p>
     *
     *  In addition, when cached data would normally be written back
     *  to the underlying database file (for example, the {@link
     *  com.sleepycat.db.Db#close Db.close} or {@link
     *  com.sleepycat.db.Db#sync Db.sync} methods are called), the
     *  in-memory copy of the database will be written back to the <b>
     *  source</b> file.</p> <p>
     *
     *  By default, the backing source file is read lazily; that is,
     *  records are not read from the file until they are requested by
     *  the application. <b>If multiple processes (not threads) are
     *  accessing a Recno database concurrently, and are either
     *  inserting or deleting records, the backing source file must be
     *  read in its entirety before more than a single process
     *  accesses the database, and only that process should specify
     *  the backing source file as part of the {@link
     *  com.sleepycat.db.Db#open Db.open} call. See the {@link
     *  com.sleepycat.db.Db#DB_SNAPSHOT Db.DB_SNAPSHOT} flag for more
     *  information.</b> </p> <p>
     *
     *  <b>Reading and writing the backing source file specified by
     *  <b>source</b> cannot be transaction-protected because it
     *  involves filesystem operations that are not part of the Db
     *  transaction methodology.</b> For this reason, if a temporary
     *  database is used to hold the records, it is possible to lose
     *  the contents of the <b>source</b> file, for example, if the
     *  system crashes at the right instant. If a file is used to hold
     *  the database, normal database recovery on that file can be
     *  used to prevent information loss, although it is still
     *  possible that the contents of <b>source</b> will be lost if
     *  the system crashes.</p> <p>
     *
     *  The <b>source</b> file must already exist (but may be
     *  zero-length) when {@link com.sleepycat.db.Db#open Db.open} is
     *  called.</p> <p>
     *
     *  It is not an error to specify a read-only <b>source</b> file
     *  when creating a database, nor is it an error to modify the
     *  resulting database. However, any attempt to write the changes
     *  to the backing source file using either the {@link
     *  com.sleepycat.db.Db#sync Db.sync} or {@link
     *  com.sleepycat.db.Db#close Db.close} methods will fail, of
     *  course. Specify the {@link com.sleepycat.db.Db#DB_NOSYNC
     *  Db.DB_NOSYNC} flag to the {@link com.sleepycat.db.Db#close
     *  Db.close} method to stop it from attempting to write the
     *  changes to the backing file; instead, they will be silently
     *  discarded.</p> <p>
     *
     *  For all of the previous reasons, the <b>source</b> field is
     *  generally used to specify databases that are read-only for
     *  Berkeley DB applications; and that are either generated on the
     *  fly by software tools or modified using a different mechanism
     *  -- for example, a text editor.</p> <p>
     *
     *  The Db.setRecordSource method configures operations performed
     *  using the specified {@link com.sleepycat.db.Db Db} handle, not
     *  all operations performed on the underlying database.</p> <p>
     *
     *  The Db.setRecordSource method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setRecordSource must be the same as that
     *  historically used to create the database or corruption can
     *  occur.</p>
     *
     * @param  source                     The backing flat text
     *      database file for a Recno database.
     * @throws  IllegalArgumentException  The Db.setRecordSource
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setRecordSource(String source) throws DbException {
        db_javaJNI.Db_set_re_source(swigCPtr, source);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #setQueueExtentSize(int)}
     */
    public void set_q_extentsize(int extentsize) throws DbException {
        setQueueExtentSize(extentsize);
    }


    /**
     *  Set the size of the extents used to hold pages in a Queue
     *  database, specified as a number of pages. Each extent is
     *  created as a separate physical file. If no extent size is set,
     *  the default behavior is to create only a single underlying
     *  database file.</p> <p>
     *
     *  For information on tuning the extent size, see <a
     *  href="{@docRoot}/../ref/am_conf/extentsize.html">Selecting a
     *  extent size</a> .</p> <p>
     *
     *  The Db.setQueueExtentSize method configures a database, not
     *  only operations performed using the specified {@link
     *  com.sleepycat.db.Db Db} handle.</p> <p>
     *
     *  The Db.setQueueExtentSize method may not be called after the
     *  {@link com.sleepycat.db.Db#open Db.open} method is called. If
     *  the database already exists when {@link
     *  com.sleepycat.db.Db#open Db.open} is called, the information
     *  specified to Db.setQueueExtentSize will be ignored. </p>
     *
     * @param  extentsize                 the number of pages in a
     *      Queue database extent.
     * @throws  IllegalArgumentException  The Db.setQueueExtentSize
     *      method will fail and throw a IllegalArgumentException
     *      exception if the method was called after {@link
     *      com.sleepycat.db.Db#open Db.open} was called; or if an
     *      invalid flag value or parameter was specified.
     */
    public void setQueueExtentSize(int extentsize) throws DbException {
        db_javaJNI.Db_set_q_extentsize(swigCPtr, extentsize);
    }


    /**
     *  The Db.stat method creates a statistical structure and fills
     *  it with statistics for the database.</p> <p>
     *
     *  If the Db.DB_FAST_STAT flag has not been specified, the
     *  Db.stat method will access some of or all the pages in the
     *  database, incurring a severe performance penalty as well as
     *  possibly flushing the underlying buffer pool.</p> <p>
     *
     *  In the presence of multiple threads or processes accessing an
     *  active database, the information returned by Db.stat may be
     *  out-of-date.</p> <p>
     *
     *  If the database was not opened read-only and the
     *  Db.DB_FAST_STAT flag was not specified, the cached key and
     *  record numbers will be updated after the statistical
     *  information has been gathered.</p> <p>
     *
     *  The Db.stat method cannot be transaction-protected. For this
     *  reason, it should be called in a thread of control that has no
     *  open cursors or active transactions.</p> <h3>Hash Statistics
     *  </h3> <p>
     *
     *  In the case of a Hash database, the statistics are returned in
     *  an instance of DbHashStat. The data fields are available from
     *  DbHashStat: </p> <h3>Btree and Recno Statistics</h3> <p>
     *
     *  In the case of a Btree or Recno database, the statistics are
     *  returned in an instance of DbBtreeStat. The data fields are
     *  available from DbBtreeStat: </p> <h3>Queue Statistics</h3> <p>
     *
     *  In the case of a Queue database, the statistics are returned
     *  in an instance of DbQueueStat. The data fields are available
     *  from DbQueueStat: </p> For convenience, the DbBtreeStat,
     *  DbHashStat and DbQueueStat classes have a toString method that
     *  lists all their data fields.</p>
     *
     * @param  flags                      must be set to 0 or one of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FAST_STAT
     *        Db.DB_FAST_STAT}<p>
     *
     *        Return only the values which do not require traversal of
     *        the database. <p>
     *
     *        Among other things, this flag makes it possible for
     *        applications to request key and record counts without
     *        incurring the performance penalty of traversing the
     *        entire database. If the underlying database is of type
     *        Recno, or of type Btree and the database was created
     *        with the {@link com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>
     *        } flag, the count of keys will be exact. Otherwise, the
     *        count of keys will be the value saved the last time the
     *        database was traversed, or 0 if no count of keys has
     *        ever been made. If the underlying database is of type
     *        Recno, the count of data items will be exact, otherwise,
     *        the count of data items will be the value saved the last
     *        time the database was traversed, or 0 if no count of
     *        data items has ever been done.</p> </li>
     *      </ul>
     *
     * @throws  DbException               The Db.stat method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Db.stat method will fail
     *      and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     * @return                            In the case of a Hash
     *      database, the statistics are returned in an instance of
     *      DbHashStat. In the case of a Btree or Recno database, the
     *      statistics are returned in an instance of DbBtreeStat. In
     *      the case of a Queue database, the statistics are returned
     *      in an instance of DbQueueStat.</p>
     */
    public Object stat(int flags) throws DbException {
        return db_javaJNI.Db_stat(swigCPtr, flags);
    }


    /**
     *  The Db.sync method flushes any cached information to disk.</p>
     *  <p>
     *
     *  If the database is in memory only, the Db.sync method has no
     *  effect and will always succeed.</p> <p>
     *
     *  <b>It is important to understand that flushing cached
     *  information to disk only minimizes the window of opportunity
     *  for corrupted data.</b> Although unlikely, it is possible for
     *  database corruption to happen if a system or application crash
     *  occurs while writing data to the database. To ensure that
     *  database corruption never occurs, applications must either:
     *  use transactions and logging with automatic recovery; use
     *  logging and application-specific recovery; or edit a copy of
     *  the database, and once all applications using the database
     *  have successfully called {@link com.sleepycat.db.Db#close
     *  Db.close}, atomically replace the original database with the
     *  updated copy.</p>
     *
     * @param  flags                      currently unused, and must
     *      be set to 0.
     * @throws  DbException               The Db.sync method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Db.sync method will fail
     *      and throw a IllegalArgumentException exception if an
     *      invalid flag value or parameter was specified.
     */
    public void sync(int flags) throws DbException {
        db_javaJNI.Db_sync(swigCPtr, flags);
    }


    /**
     *  The Db.truncate method empties the database, discarding all
     *  records it contains. The number of records discarded from the
     *  database is returned.</p> <p>
     *
     *  It is an error to call the Db.truncate method on a database
     *  with open cursors.</p>
     *
     * @param  flags                       must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AUTO_COMMIT
     *        Db.DB_AUTO_COMMIT}<p>
     *
     *        Enclose the Db.truncate call within a transaction. If
     *        the call succeeds, changes made by the operation will be
     *        recoverable. If the call fails, the operation will have
     *        made no changes. </li>
     *      </ul>
     *
     * @param  txnid                       If the operation is to be
     *      transaction-protected, (other than by specifying the
     *      Db.DB_AUTO_COMMIT flag), the <b>txnid</b> parameter is a
     *      transaction handle returned from {@link
     *      com.sleepycat.db.DbEnv#txnBegin DbEnv.txnBegin};
     *      otherwise, null.
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Db.truncate method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Db.truncate method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Db.truncate method will
     *      fail and throw a IllegalArgumentException exception if
     *      there are open cursors in the database; or if an invalid
     *      flag value or parameter was specified.
     * @return                             The Db.truncate method
     *      returns the number of records discarded from the database.
     *      </p>
     */
    public int truncate(DbTxn txnid, int flags) throws DbException {
        return db_javaJNI.Db_truncate(swigCPtr, DbTxn.getCPtr(txnid), flags);
    }


    /**
     *  The Db.upgrade method upgrades all of the databases included
     *  in the file <b>file</b> , if necessary. If no upgrade is
     *  necessary, Db.upgrade always returns success.</p> <p>
     *
     *  <b>Database upgrades are done in place and are destructive.
     *  For example, if pages need to be allocated and no disk space
     *  is available, the database may be left corrupted. Backups
     *  should be made before databases are upgraded. See <a
     *  href="{@docRoot}/../ref/am/upgrade.html">Upgrading databases
     *  </a> for more information.</b> </p> <p>
     *
     *  Unlike all other database operations, Db.upgrade may only be
     *  done on a system with the same byte-order as the database.</p>
     *  <h3>Environment Variables</h3> <p>
     *
     *  If the database was opened within a database environment, the
     *  environment variable <b>DB_HOME</b> may be used as the path of
     *  the database environment home.</p> <p>
     *
     *  Db.upgrade is affected by any database directory specified
     *  using the {@link com.sleepycat.db.DbEnv#setDataDir
     *  DbEnv.setDataDir} method, or by setting the "set_data_dir"
     *  string in the environment's <b>DB_CONFIG</b> file.</p>
     *
     * @param  file                       the physical file containing
     *      the databases to be upgraded.
     * @param  flags                      must be set to 0 or the
     *      following value:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DUPSORT
     *        Db.DB_DUPSORT}<p>
     *
     *        <b>This flag is only meaningful when upgrading databases
     *        from releases before the Berkeley DB 3.1 release.</b>
     *        <p>
     *
     *        As part of the upgrade from the Berkeley DB 3.0 release
     *        to the 3.1 release, the on-disk format of duplicate data
     *        items changed. To correctly upgrade the format requires
     *        applications to specify whether duplicate data items in
     *        the database are sorted or not. Specifying the <code>Db.DB_DUPSORT</code>
     *        flag informs Db.upgrade that the duplicates are sorted;
     *        otherwise they are assumed to be unsorted. Incorrectly
     *        specifying the value of this flag may lead to database
     *        corruption.</p> <p>
     *
     *        Further, because the Db.upgrade method upgrades a
     *        physical file (including all the databases it contains),
     *        it is not possible to use Db.upgrade to upgrade files in
     *        which some of the databases it includes have sorted
     *        duplicate data items, and some of the databases it
     *        includes have unsorted duplicate data items. If the file
     *        does not have more than a single database, if the
     *        databases do not support duplicate data items, or if all
     *        of the databases that support duplicate data items
     *        support the same style of duplicates (either sorted or
     *        unsorted), Db.upgrade will work correctly as long as the
     *        <code>Db.DB_DUPSORT</code> flag is correctly specified.
     *        Otherwise, the file cannot be upgraded using Db.upgrade;
     *        it must be upgraded manually by dumping and reloading
     *        the databases.</p> </li>
     *      </ul>
     *
     * @throws  DbException               The Db.upgrade method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> The database cannot be upgraded by this version of
     *      the Berkeley DB software.
     * @throws  IllegalArgumentException  The Db.upgrade method will
     *      fail and throw a IllegalArgumentException exception if the
     *      database is not in the same byte-order as the system; or
     *      if an invalid flag value or parameter was specified.
     */
    public void upgrade(String file, int flags) throws DbException {
        db_javaJNI.Db_upgrade(swigCPtr, file, flags);
    }


    void verify0(String file, String database, java.io.OutputStream outfile, int flags) {
        db_javaJNI.Db_verify0(swigCPtr, file, database, outfile, flags);
    }

}
